/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostFactory;
import com.kingdee.eas.ncm.bill.client.AbstractBoPInvSFPCostListUI;
import com.kingdee.eas.ncm.bill.client.BoPInvSFPCostDataGenerateUI;
import com.kingdee.eas.ncm.bill.client.BoPInvSFPCostEditUI;
import com.kingdee.eas.ncm.bill.client.BoPInvSFPCostFilterUI;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BoPInvSFPCostListUI
extends AbstractBoPInvSFPCostListUI {
    private static final Logger logger = CoreUIObject.getLogger(BoPInvSFPCostListUI.class);
    private static final String qtyCol = "qty";
    private static final String amountCol = "amount";
    private static final String entQtyCol = "entrys.qty";
    private static final String entPriceCol = "entrys.price";
    private static final String entAmountCol = "entrys.amount";
    private BoPInvSFPCostFilterUI filterUI;
    private CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));

    public void onLoad() throws Exception {
        super.onLoad();
        String[] a = new String[]{qtyCol, amountCol, entQtyCol, entPriceCol, entAmountCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])a, (String)"%{###,###,###.##########}f");
        this.btnGenerate.setEnabled(true);
        this.btnGenerate.setVisible(true);
        this.btnGenerate.setIcon(EASResource.getIcon((String)"imgTbtn_createcatalog"));
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            while (rowSet.next()) {
                int precision = rowSet.getInt("baseCurrency.precision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)amountCol, (IRowSet)rowSet);
                BDCMUtils.iniColumnsPrecision((int)precision, (String)entAmountCol, (IRowSet)rowSet);
                precision = rowSet.getInt("baseUnit.qtyPrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)qtyCol, (IRowSet)rowSet);
                precision = rowSet.getInt("unit.qtyPrecision");
                if (precision == 0) {
                    precision = 2;
                }
                BDCMUtils.iniColumnsPrecision((int)precision, (String)entQtyCol, (IRowSet)rowSet);
                precision = rowSet.getInt("costItem.pricePrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)entPriceCol, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "bizDate", "billStatus", "companyOrg.name", "calculatePeriod.number", "product.number", "product.name", "product.model", "lot", "product.baseUnit.name", qtyCol, amountCol, "costObject.number", "costObject.name", "description", "creator.name", "createTime", "auditor.name", "auditTime", "lastUpdateUser.name", "lastUpdateTime"};
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        dialog.setProcessor((IProcessor)cmcq);
        return dialog;
    }

    protected String getEditUIName() {
        return BoPInvSFPCostEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BoPInvSFPCostFactory.getRemoteInstance();
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "BoPInvSFPCost";
        param.alias = "\u5e93\u5b58\u534a\u4ea7\u54c1\u6210\u672c\u7ed3\u6784";
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            dp.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.ncm.bill.app.BoPInvSFPCostExportQuery"));
            dp.putContextParam((Object)"mainQuery", (Object)this.mainQuery);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.setMainOrgContext(this.getMainOrgContext());
        dc.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "BoPInvSFPCost";
        param.alias = "\u5e93\u5b58\u534a\u4ea7\u54c1\u6210\u672c\u7ed3\u6784";
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.ncm.bill.app.BoPInvSFPCostExportQuery"));
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
        int curPre = this.currency.getPrecision();
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell(entQtyCol), (int)2);
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell(entAmountCol), (int)curPre);
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("BoPInvSFPCost_Audit");
        }
        super.auditAction_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    @Override
    protected void btnGenerate_actionPerformed(ActionEvent e) throws Exception {
        super.btnGenerate_actionPerformed(e);
        this.checkAuditPermission("BoPInvSFPCost_Generate");
        HashMap<String, String> listenerParam = new HashMap<String, String>();
        listenerParam.put("companyId", this.currentCompany.getId().toString());
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        listenerParam.put("userId", user.getId().toString());
        BoPInvSFPCostDataGenerateUI.showGenWizardUI((CoreUIObject)this, listenerParam);
        if (listenerParam.get("OK").equals(String.valueOf(false))) {
            return;
        }
        genProgressHintListener listener = new genProgressHintListener();
        ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, listenerParam);
        Map genResultInfo = (Map)listenerParam.get("GenResultInfo");
        if (genResultInfo != null && Boolean.valueOf((String)genResultInfo.get("isNeedRefresh")).booleanValue()) {
            this.refreshList();
        }
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new BoPInvSFPCostFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean isEnableMultiOrgSupport() {
        return false;
    }

    private static final class genProgressHintListener
    implements ProgressHintListener {
        private genProgressHintListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("companyId"));
            Assert.that((boolean)param.containsKey("userId"));
            Assert.that((boolean)param.containsKey("EstimateSchemeID"));
            Assert.that((boolean)param.containsKey("isCoverExists"));
            Map ret = null;
            try {
                ret = BoPInvSFPCostFactory.getRemoteInstance().generateData(param);
            }
            catch (EASBizException e) {
                MsgBox.showInfo((String)e.getMessage());
            }
            finally {
                param.put("GenResultInfo", ret);
            }
        }
    }
}

