/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialCostCollection;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostEntryFactory;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostEntryInfo;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostInfo;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostMatDetailCollection;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostMatDetailFactory;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostMatDetailInfo;
import com.kingdee.eas.ncm.bill.client.AbstractBoPInvSFPCostMatDetailUI;
import com.kingdee.eas.ncm.common.RecoveryModelEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.RecoveryUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BoPInvSFPCostMatDetailUI
extends AbstractBoPInvSFPCostMatDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(BoPInvSFPCostMatDetailUI.class);
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.currentCompany.getId().toString();
    private int amoountPrecision = 0;

    public void onLoad() throws Exception {
        this.initCustomedVariable();
        super.onLoad();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddline.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveline.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionSave.setEnabled(true);
        Boolean btnIsEnable = (Boolean)this.getUIContext().get("btnIsEnable");
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        this.amoountPrecision = currency == null ? 2 : currency.getPrecision();
        this.initEntry();
        this.loadFields();
        if (this.kDTable1.getRowCount() < 1) {
            this.addLine(this.kDTable1);
        }
        if ("VIEW".equals((String)this.getUIContext().get("operState")) || !btnIsEnable.booleanValue()) {
            this.actionSave.setEnabled(false);
            this.btnAddline.setEnabled(false);
            this.btnRemoveline.setEnabled(false);
            this.kDTable1.setEditable(false);
        }
        KDTableHelper.downArrowAutoAddRow((KDTable)this.kDTable1, (boolean)true, null);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.loadTable((String)this.getUIContext().get("parent"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadTable(String parentid) throws Exception {
        String osql = "SELECT parent.id, id, batchNo, Qty, Price, amount,   seq, material.model,material.pricePrecision ,material.name, material.number, material.id, material.baseUnit.name,material.baseUnit.QtyPrecision WHERE parent.id = '" + parentid + "'";
        BoPInvSFPCostMatDetailCollection coll = BoPInvSFPCostMatDetailFactory.getRemoteInstance().getBoPInvSFPCostMatDetailCollection(osql);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BoPInvSFPCostMatDetailInfo obj = coll.get(i);
                IRow row = this.kDTable1.addRow();
                row.setUserObject((Object)obj);
                if (obj.getMaterial() == null) continue;
                row.getCell("materialid").setValue((Object)obj.getMaterial());
                row.getCell("materialname").setValue((Object)obj.getMaterial().getName());
                row.getCell("model").setValue((Object)obj.getMaterial().getModel());
                row.getCell("baseUnit").setValue((Object)obj.getMaterial().getBaseUnit().getName());
                String osql2 = "SELECT mateial.id, company.id, accountType WHERE mateial.id = '" + obj.getMaterial().getId().toString() + "' AND company.id = '" + this.companyID + "'";
                MaterialCompanyInfoInfo comInfo = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoInfo(osql2);
                if (!comInfo.getAccountType().equals((Object)AccountType.SPECIAL_ACCT)) {
                    row.getCell("batchNo").getStyleAttributes().setLocked(true);
                } else {
                    row.getCell("batchNo").getStyleAttributes().setLocked(false);
                }
                row.getCell("batchNo").setValue((Object)obj.getBatchNo());
                String sql = "select where material.id = '" + obj.getMaterial().getId().toString() + "' and measureUnit.id = '" + obj.getMaterial().getBaseUnit().getId().toString() + "' ";
                MultiMeasureUnitCollection multUnitColl = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(sql);
                int qtyPrecision = 8;
                if (multUnitColl != null && multUnitColl.size() > 0) {
                    qtyPrecision = multUnitColl.get(0).getQtyPrecision();
                }
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("Qty"), (int)qtyPrecision);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("Price"), (int)obj.getMaterial().getPricePrecision());
                row.getCell("Qty").setValue((Object)obj.getQty());
                row.getCell("Price").setValue((Object)obj.getPrice());
                row.getCell("amount").setValue((Object)obj.getAmount());
            }
        }
    }

    private void initCustomedVariable() throws Exception {
        BoPInvSFPCostInfo info = (BoPInvSFPCostInfo)this.getUIContext().get("INFO");
        this.company.setText(info.getCompanyOrg().getName());
        this.txtProductNumber.setText(info.getProduct().getNumber());
        this.txtProductName.setText(info.getProduct().getName());
        this.txtModel.setText(info.getProduct().getModel());
        CostItemInfo ci = (CostItemInfo)this.getUIContext().get("costItem.number");
        this.txtCostItemNumber.setText(ci.getNumber());
        this.txtCostitemName.setText(ci.getName());
    }

    protected void initEntry() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.getColumn("id").getStyleAttributes().setHided(true);
        KDBizPromptBox prmtMaterial = new KDBizPromptBox();
        ExtendParser parserCostObject = new ExtendParser(prmtMaterial);
        prmtMaterial.setCommitParser((IParser)parserCostObject);
        prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
        if (RecoveryModelEnum.ByStep.equals((Object)RecoveryUtils.getRecoveryModel(null, (String)this.companyID))) {
            BDCMClientUtils.filterF7((KDBizPromptBox)prmtMaterial, (String)"orgUnit.id", (Object)this.companyID);
        } else if (RecoveryUtils.isRevertAllProduct(null, (String)this.companyID)) {
            BDCMClientUtils.filterF7((KDBizPromptBox)prmtMaterial, (String)"orgUnit.id", (Object)this.companyID);
            BDCMClientUtils.filterF7((KDBizPromptBox)prmtMaterial, (String)"FIInfo.calculateType", (Object)2, (CompareType)CompareType.NOTEQUALS);
        } else {
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("orgUnit.id", (Object)this.companyID);
            filter.appendFilterItem("FIInfo.calculateType", (Object)0);
            filter.appendFilterItem("FIInfo.calculateType", (Object)1);
            EntityViewInfo mcevi = new EntityViewInfo();
            FilterInfo mcFilter = new FilterInfo();
            mcFilter.appendFilterItem("orgUnit.id", (Object)this.companyID);
            mcFilter.appendFilterItem("isParticipateReduct", (Object)Boolean.FALSE);
            IMaterialCost mc = MaterialCostFactory.getRemoteInstance();
            mcevi.setFilter(mcFilter);
            MaterialCostCollection mcColl = mc.getMaterialCostCollection(mcevi);
            int mcSize = mcColl.size();
            if (mcSize > 0) {
                HashSet<String> mcMaterialIDSet = new HashSet<String>(mcSize);
                for (int i = 0; i < mcSize; ++i) {
                    mcMaterialIDSet.add(mcColl.get(i).getMaterial().getId().toString());
                }
                filter.appendFilterItem("FIInfo.calculateType", (Object)2);
                filter.getFilterItems().add(new FilterItemInfo("material.id", mcMaterialIDSet, CompareType.INCLUDE));
                filter.setMaskString("#0 and ( #1 or #2 or (#3 and #4) ) ");
            } else {
                filter.setMaskString("#0 and ( #1 or #2)");
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            prmtMaterial.setEntityViewInfo(evi);
        }
        prmtMaterial.setVisible(true);
        prmtMaterial.setEditable(true);
        prmtMaterial.setDisplayFormat("$number$");
        prmtMaterial.setEditFormat("$number$");
        prmtMaterial.setCommitFormat("$number$");
        ObjectValueRender avrCostObject = new ObjectValueRender();
        avrCostObject.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kDTable1.getColumn("materialid").setRenderer((IBasicRender)avrCostObject);
        prmtMaterial.setRequired(true);
        prmtMaterial.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BoPInvSFPCostMatDetailUI.this.fillCellAfterBillSelectedRelation(eventObj);
            }
        });
        this.kDTable1.getColumn("materialid").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMaterial));
        KDFormattedTextField txtQty = new KDFormattedTextField();
        txtQty.setDataType(1);
        txtQty.setPrecision(4);
        txtQty.setNegatived(false);
        txtQty.setHorizontalAlignment(4);
        this.kDTable1.getColumn("Qty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtQty));
        KDFormattedTextField txtPrice = new KDFormattedTextField();
        txtPrice.setDataType(1);
        txtPrice.setPrecision(2);
        txtPrice.setNegatived(false);
        txtPrice.setHorizontalAlignment(4);
        this.kDTable1.getColumn("Price").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPrice));
        this.kDTable1.getColumn("Price").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtAmount = new KDFormattedTextField();
        txtAmount.setDataType(1);
        txtAmount.setPrecision(this.amoountPrecision);
        txtAmount.setNegatived(false);
        txtAmount.setHorizontalAlignment(4);
        this.kDTable1.getColumn("amount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmount));
        this.kDTable1.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTable1.getColumn("amount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amoountPrecision));
    }

    public static void showMatDetaiUI(CoreUIObject ui, CoreBaseInfo info, String entryID, CostItemInfo ci, String operType, boolean btnIsEnable) throws Exception {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"INFO", (Object)info);
            uiContext.put((Object)"parent", (Object)entryID);
            uiContext.put((Object)"costItem.number", (Object)ci);
            uiContext.put((Object)"operState", (Object)operType);
            uiContext.put((Object)"btnIsEnable", (Object)btnIsEnable);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BoPInvSFPCostMatDetailUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BoPInvSFPCostMatDetailFactory.getRemoteInstance();
    }

    protected FilterInfo getCostObjectFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID));
        return filter;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        BoPInvSFPCostMatDetailCollection coll = null;
        if (this.kDTable1.getRowCount() > 0) {
            coll = this.storeFieldofDetail();
            BoPInvSFPCostMatDetailFactory.getRemoteInstance().addnewColl((String)this.getUIContext().get("parent"), coll);
        } else {
            String oql = "SELECT id,parent.id WHERE parent.id = '" + (String)this.getUIContext().get("parent") + "'";
            BoPInvSFPCostMatDetailFactory.getRemoteInstance().delete(oql);
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    public BoPInvSFPCostMatDetailCollection storeFieldofDetail() throws Exception {
        BoPInvSFPCostEntryInfo entryInfo = BoPInvSFPCostEntryFactory.getRemoteInstance().getBoPInvSFPCostEntryInfo((IObjectPK)new ObjectUuidPK((String)this.getUIContext().get("parent")));
        this.kDTable1.getEditManager().stopEditing();
        int rowCount = this.kDTable1.getRowCount();
        BoPInvSFPCostMatDetailCollection Col = null;
        HashMap<String, String> infoMap = new HashMap<String, String>();
        if (rowCount > 0) {
            Col = new BoPInvSFPCostMatDetailCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.kDTable1.getRow(i);
                if (row.getCell("materialid").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"22_BoPInvSFPCostMatDetailUI"));
                    SysUtil.abort();
                } else if (row.getCell("materialid").getValue() != null && row.getCell("materialid").getValue() instanceof MaterialInfo) {
                    String materialID = "";
                    String materialLot = "";
                    materialID = ((MaterialInfo)row.getCell("materialid").getValue()).getId().toString();
                    if (row.getCell("batchNo").getValue() != null) {
                        materialLot = row.getCell("batchNo").getValue().toString();
                    }
                    if (row.getCell("materialid").getValue() instanceof MaterialInfo && infoMap.containsKey(materialID + materialLot)) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"23_BoPInvSFPCostMatDetailUI"));
                        SysUtil.abort();
                    }
                }
                if (row.getCell("Qty").getValue() == null || ((BigDecimal)row.getCell("Qty").getValue()).compareTo(SysConstant.BIGZERO) <= 0) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"24_BoPInvSFPCostMatDetailUI"));
                    SysUtil.abort();
                }
                if (row.getCell("Price").getValue() == null || ((BigDecimal)row.getCell("Price").getValue()).compareTo(SysConstant.BIGZERO) < 0) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"25_BoPInvSFPCostMatDetailUI"));
                    SysUtil.abort();
                }
                if (((BigDecimal)row.getCell("Qty").getValue()).add((BigDecimal)row.getCell("Price").getValue()).add((BigDecimal)row.getCell("amount").getValue()).compareTo(SysConstant.BIGZERO) == 0) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"26_BoPInvSFPCostMatDetailUI"));
                    SysUtil.abort();
                }
                BoPInvSFPCostMatDetailInfo Info = new BoPInvSFPCostMatDetailInfo();
                Info.setAmount(NCMUtils.getBigDecimal((Object)row.getCell("amount").getValue()));
                if (row.getCell("batchNo").getValue() != null) {
                    Info.setBatchNo(row.getCell("batchNo").getValue().toString());
                }
                Info.setMaterial((MaterialInfo)row.getCell("materialid").getValue());
                Info.setQty(NCMUtils.getBigDecimal((Object)row.getCell("Qty").getValue()));
                Info.setPrice(NCMUtils.getBigDecimal((Object)row.getCell("Price").getValue()));
                Info.setParent(entryInfo);
                Col.add(Info);
                if (row.getCell("materialid").getValue() == null || !(row.getCell("materialid").getValue() instanceof MaterialInfo)) continue;
                String materialID = "";
                String materialLot = "";
                materialID = ((MaterialInfo)row.getCell("materialid").getValue()).getId().toString();
                if (row.getCell("batchNo").getValue() != null) {
                    materialLot = row.getCell("batchNo").getValue().toString();
                }
                infoMap.put(materialID + materialLot, materialID + materialLot);
            }
        }
        return Col;
    }

    @Override
    protected void btnAddline_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddline_actionPerformed(e);
        this.addLine(this.kDTable1);
    }

    protected void addLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        IRow row = table.addRow();
        row.getCell("Qty").setValue((Object)SysConstant.BIGZERO);
        row.getCell("Price").setValue((Object)SysConstant.BIGZERO);
        row.getCell("amount").setValue((Object)SysConstant.BIGZERO);
    }

    @Override
    protected void btnRemoveline_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveline_actionPerformed(e);
        int index = this.kDTable1.getSelectManager().getActiveRowIndex();
        if (index < 0 || index >= this.kDTable1.getRowCount()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"27_BoPInvSFPCostMatDetailUI"));
            return;
        }
        this.kDTable1.removeRow(index);
    }

    @Override
    protected void kDTable1_editStopped(KDTEditEvent e) throws Exception {
        super.kDTable1_editStopped(e);
        String column = this.kDTable1.getColumnKey(e.getColIndex());
        int row = e.getRowIndex();
        if ("Qty".equals(column) || "Price".equals(column)) {
            BigDecimal qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kDTable1, (int)row, (String)"Qty");
            BigDecimal price = BDCMClientUtils.castToBigDecimal((KDTable)this.kDTable1, (int)row, (String)"Price");
            BigDecimal amount = qty.multiply(price);
            amount = amount.setScale(this.amoountPrecision, 2);
            this.kDTable1.getCell(row, "amount").setValue((Object)amount);
        } else if ("amount".equals(column)) {
            BigDecimal qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kDTable1, (int)row, (String)"Qty");
            if (BDCMUtils.equalsZero((BigDecimal)qty)) {
                return;
            }
            BigDecimal amount = BDCMClientUtils.castToBigDecimal((KDTable)this.kDTable1, (int)row, (String)"amount");
            BigDecimal price = amount.divide(qty, 4);
            this.kDTable1.getCell(row, "Price").setValue((Object)price);
        }
    }

    protected void fillCellAfterBillSelectedRelation(DataChangeEvent eventObj) {
        int rowIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kDTable1.getRow(rowIndex);
        BoPInvSFPCostMatDetailUI.clearCells(this.kDTable1, rowIndex, new String[]{"materialname", "model", "baseUnit"});
        if (eventObj.getNewValue() instanceof MaterialInfo) {
            try {
                MaterialInfo materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)eventObj.getNewValue()).getId().toString()));
                if (materialInfo != null) {
                    curRow.getCell("materialname").setValue((Object)materialInfo.getName());
                    if (materialInfo.getBaseUnit() != null) {
                        MeasureUnitInfo unitinfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId().toString()));
                        curRow.getCell("baseUnit").setValue((Object)unitinfo.getName());
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("Qty"), (int)unitinfo.getQtyPrecision());
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("Price"), (int)materialInfo.getPricePrecision());
                    }
                    curRow.getCell("model").setValue((Object)materialInfo.getModel());
                    String osql = "SELECT mateial.id, company.id, accountType WHERE mateial.id = '" + materialInfo.getId().toString() + "' AND company.id = '" + this.companyID + "'";
                    MaterialCompanyInfoInfo comInfo = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoInfo(osql);
                    if (!comInfo.getAccountType().equals((Object)AccountType.SPECIAL_ACCT)) {
                        BoPInvSFPCostMatDetailUI.clearCells(this.kDTable1, rowIndex, new String[]{"batchNo"});
                        curRow.getCell("batchNo").getStyleAttributes().setLocked(true);
                    } else {
                        curRow.getCell("batchNo").getStyleAttributes().setLocked(false);
                    }
                }
            }
            catch (EASBizException e1) {
                this.handUIException(e1);
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        }
    }

    public static void clearCells(KDTable kdt, int rowIndex, String[] colNames) {
        IRow row = kdt.getRow(rowIndex);
        if (colNames != null) {
            int n = colNames.length;
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(colNames[i]);
                cell.setValue(null);
            }
        } else {
            int n = kdt.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(i);
                cell.setValue(null);
            }
        }
    }
}

