/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.ByProductUnitCostCollection;
import com.kingdee.eas.ncm.bill.ByProductUnitCostFactory;
import com.kingdee.eas.ncm.bill.ByProductUnitCostInfo;
import com.kingdee.eas.ncm.bill.IByProductUnitCost;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.client.AbstractByProductUnitCostListUI;
import com.kingdee.eas.ncm.bill.client.AssignStandardDataFilterUI;
import com.kingdee.eas.ncm.bill.client.ByProductUnitCostFilterUI;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ByProductUnitCostListUI
extends AbstractByProductUnitCostListUI {
    private static final Logger logger = CoreUIObject.getLogger(ByProductUnitCostListUI.class);
    private static final String Col_ID = "id";
    private static final String Col_Coef = "unitCost";
    private static final String Col_IsDirty = "isDirty";
    private static final String Col_CompanyName = "company.name";
    private static final String Col_CompanyNumber = "company.number";
    private static final String Col_MaterialNumber = "material.number";
    private static final String Col_MaterialName = "material.name";
    private static final String Col_MaterialModel = "material.model";
    private static final String Col_CostItemNumber = "costItem.number";
    private static final String Col_CostItemName = "costItem.name";
    private ArrayList deletePkList = new ArrayList();
    private final ArrayList addObjList = new ArrayList();
    private KDBizPromptBox prmtMaterial = null;
    private KDBizPromptBox prmtCostItem = null;
    private boolean history = false;
    private static final int FirstRowIndex = 0;
    private CompanyOrgUnitInfo _company;
    private PeriodInfo _currPeriod;
    private final FillListener fillListener = new FillListener();
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
                try {
                    if (!ByProductUnitCostListUI.this.history) {
                        ByProductUnitCostListUI.this.progressDoRemoveLine();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    ByProductUnitCostListUI.this.handUIException(e);
                }
            } else if (arg0.getKeyCode() == 10) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }
    };
    private CommonQueryDialog dialog = null;
    private AssignStandardDataFilterUI filterUI = null;

    public ByProductUnitCostListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    ByProductUnitCostListUI.this.tblMain_editStarting(e);
                }
                catch (Exception exc) {
                    ByProductUnitCostListUI.this.handUIException(exc);
                }
            }

            public void editStarted(KDTEditEvent e) {
                try {
                    ByProductUnitCostListUI.this.tblMain_editStarted(e);
                }
                catch (Exception exc) {
                    ByProductUnitCostListUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    ByProductUnitCostListUI.this.tblMain_editStopped(e);
                }
                catch (Exception exc) {
                    ByProductUnitCostListUI.this.handUIException(exc);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this._company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        this._currPeriod = NCMUtils.GetCurrentPeriod(null, (String)this._company.getId().toString());
        super.onLoad();
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
    }

    public void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        if (this.history) {
            this.actionAddline.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionImportData.setEnabled(false);
            this.actionBatchSet.setEnabled(false);
            this.actionGen.setEnabled(false);
        } else {
            this.actionAddline.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionImportData.setEnabled(true);
            this.actionBatchSet.setEnabled(true);
            this.actionGen.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCopyTo.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionSignature.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkflowList.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionAddline.setVisible(true);
        this.actionAddline.setEnabled(true);
        this.actionInsertLine.setVisible(true);
        this.actionInsertLine.setEnabled(true);
        this.actionAddline.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_insert"));
        this.menuWorkFlow.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuItemSendSmsMessage.setVisible(false);
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionGen.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_createcatalog"));
        this.actionBatchSet.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.actionSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setTextIconDisStyle((short)2);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.formatEntryTable();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.formatEntryTable();
    }

    private void formatEntryTable() {
        KDFormattedTextField txtCoef = new KDFormattedTextField();
        txtCoef.setDataType(1);
        txtCoef.setPrecision(4);
        txtCoef.setHorizontalAlignment(4);
        txtCoef.setDecimalSeparatorAlwaysShown(true);
        txtCoef.setRemoveingZeroInDispaly(true);
        this.tblMain.getColumn(Col_Coef).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCoef));
        this.tblMain.getColumn(Col_Coef).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)4));
        this.tblMain.getColumn(Col_Coef).setRequired(true);
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    public void tblMain_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (!e.isCancel()) {
            if (this.tblMain.getColumnIndex(Col_MaterialNumber) == colIndex) {
                this.filtExsitMaterial(rowIndex);
            }
            if (this.tblMain.getColumnIndex(Col_CostItemNumber) == colIndex) {
                this.filtExsitCostItem(rowIndex);
            }
        }
    }

    public void tblMain_editStarted(KDTEditEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ByProductUnitCostFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return Col_ID;
    }

    protected IObjectValue createNewData() {
        ByProductUnitCostInfo objectValue = new ByProductUnitCostInfo();
        return objectValue;
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(1);
        KDTableHelper.releaseTab((JComponent)this.tblMain);
    }

    @Override
    public void actionBatchSet_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchSet_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        if (rowCount > 0) {
            int curRow = this.tblMain.getSelectManager().getActiveRowIndex();
            if (curRow < 0) {
                curRow = 0;
            }
            ICell first = this.tblMain.getRow(curRow).getCell(Col_Coef);
            BigDecimal firstValue = null;
            firstValue = first.getValue() instanceof BigDecimal ? (BigDecimal)first.getValue() : BigDecimal.valueOf(0L);
            for (int i = curRow + 1; i < rowCount; ++i) {
                IRow row = this.tblMain.getRow(i);
                ICell coef = row.getCell(Col_Coef);
                ICell isDirty = row.getCell(Col_IsDirty);
                coef.setValue((Object)firstValue);
                isDirty.setValue((Object)String.valueOf(true));
                this.actionSave.setEnabled(true);
            }
        }
    }

    @Override
    public void actionGen_actionPerformed(ActionEvent e) throws Exception {
        super.actionGen_actionPerformed(e);
        this.checkMustToSave();
        HashMap<String, Object> listenerParam = new HashMap<String, Object>();
        listenerParam.put("company", this._company);
        listenerParam.put("period", this._currPeriod);
        genProgressHintListener listener = new genProgressHintListener();
        ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, listenerParam);
        this.refreshList();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.innerDoRemoveLine();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkValidData();
        super.actionSave_actionPerformed(e);
        try {
            this.updateDataSetting();
            this.refreshList();
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)ex.getMessage(), (int)8188);
            SysUtil.abort();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkMustToSave();
        super.actionQuery_actionPerformed(e);
    }

    private void progressDoRemoveLine() throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            DeleteProgressHintListener listener = new DeleteProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, null);
        }
    }

    private void innerDoRemoveLine() throws Exception {
        this.checkSelected();
        this.removeLine(this.tblMain);
        this.tblMain.reLayoutAndPaint();
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                int i;
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                if (8 == selectBlock.getMode()) {
                    for (i = 0; i < table.getRowCount(); ++i) {
                        indexSet.add(i);
                    }
                    continue;
                }
                for (i = top; i <= bottom; ++i) {
                    indexSet.add(i);
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            table.setRefresh(false);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                ObjectSingleKey opk = new ObjectSingleKey(Col_ID, table.getRow(rowIndex).getCell(Col_ID).getValue());
                if (opk.getKeyValue(opk.getKeyFields()[0]) != null) {
                    this.deletePkList.add(opk);
                }
                this.actionSave.setEnabled(true);
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            table.setRefresh(true);
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0, 0, 0);
            } else {
                this.actionRemoveLine.setEnabled(false);
                this.actionBatchSet.setEnabled(false);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    private void checkMustToSave() throws Exception {
        if (this.CheckDirty()) {
            int ret = MsgBox.showConfirm3((String)NCMClientUtils.getNcmBillResource((String)"CHECK_DIRTY"));
            if (ret == 0) {
                try {
                    IPermission iPer = PermissionFactory.getRemoteInstance();
                    iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString())), (IObjectPK)new ObjectUuidPK(this._company.getId().toString()), "ByProdUnitCost_Save");
                    this.updateDataSetting();
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)e.getMessage(), (int)8188);
                    SysUtil.abort();
                }
                catch (EASBizException e1) {
                    logger.error((Object)"", (Throwable)e1);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)e1.getMessage(), (int)8188);
                    SysUtil.abort();
                }
            } else if (ret == 2) {
                SysUtil.abort();
            }
        }
    }

    private boolean CheckDirty() {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            return false;
        }
        if (this.addObjList.size() > 0 || this.deletePkList.size() > 0) {
            return true;
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell isDirty = row.getCell(Col_IsDirty);
            if (isDirty.getValue() == null || !isDirty.getValue().toString().equals(String.valueOf(true))) continue;
            return true;
        }
        return false;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor test = super.getQueryExecutor(queryPK, viewInfo);
        return test;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev.getSorter().size() == 0) {
            SorterItemCollection sort = ev.getSorter();
            sort.add(new SorterItemInfo(Col_CompanyName));
            sort.add(new SorterItemInfo(Col_MaterialNumber));
            sort.add(new SorterItemInfo(Col_CostItemNumber));
        }
        this.history = false;
        if (this.filterUI != null && this.filterUI.getFilterParam().isHistory()) {
            this.history = true;
        }
        try {
            String period = this._currPeriod.getId().toString();
            FilterInfo filter = new FilterInfo();
            if (!this.history) {
                filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)period));
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this._company.getId().toString()));
            try {
                ev.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.tblMain.getColumn(Col_Coef).getStyleAttributes().setLocked(this.history);
        super.beforeExcutQuery(ev);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
        this.tblMain.addKeyListener(this.keyListener);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkMustToSave();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
            if (this.getFilterUI() != null) {
                this.dialog.addUserPanel((KDPanel)this.getFilterUI());
            }
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", (Object)"ByProductUnitCostQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new ByProductUnitCostFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int colMaterialIndex = this.tblMain.getCell(e.getRowIndex(), Col_MaterialNumber).getColumnIndex();
        if (e.getValue() instanceof MaterialInfo) {
            MaterialInfo materialInfo = (MaterialInfo)e.getValue();
            this.tblMain.getCell(e.getRowIndex(), Col_MaterialName).setValue((Object)materialInfo.getName());
            this.tblMain.getCell(e.getRowIndex(), Col_MaterialModel).setValue((Object)materialInfo.getModel());
            this.actionSave.setEnabled(true);
        } else if (e.getValue() == null && e.getColIndex() == colMaterialIndex) {
            this.tblMain.getCell(e.getRowIndex(), Col_MaterialName).setValue((Object)"");
        }
        int colCostItemIndex = this.tblMain.getCell(e.getRowIndex(), Col_CostItemNumber).getColumnIndex();
        if (e.getValue() instanceof CostItemInfo) {
            CostItemInfo costItemInfo = (CostItemInfo)e.getValue();
            this.tblMain.getCell(e.getRowIndex(), Col_CostItemName).setValue((Object)costItemInfo.getName());
            this.actionSave.setEnabled(true);
        } else if (e.getValue() == null && e.getColIndex() == colCostItemIndex) {
            this.tblMain.getCell(e.getRowIndex(), Col_CostItemName).setValue((Object)"");
        }
        if (e.getColIndex() == this.tblMain.getColumnIndex(Col_Coef)) {
            ICell cell = this.tblMain.getRow(e.getRowIndex()).getCell(Col_IsDirty);
            if (e.getOldValue() != e.getValue()) {
                cell.setValue((Object)String.valueOf(true));
                this.actionSave.setEnabled(true);
            }
        }
        super.tblMain_editStopped(e);
    }

    private void updateDataSetting() throws EASBizException, BOSException, Exception {
        this.checkValidData();
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0 && this.deletePkList.isEmpty()) {
            return;
        }
        HashMap<Object, BigDecimal> data = new HashMap<Object, BigDecimal>();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell id = row.getCell(Col_ID);
            ICell coef = row.getCell(Col_Coef);
            ICell isDirty = row.getCell(Col_IsDirty);
            BigDecimal value = null;
            if (!isDirty.getValue().toString().equals(String.valueOf(true))) continue;
            if (coef.getValue() instanceof BigDecimal && id.getValue() != null) {
                value = (BigDecimal)coef.getValue();
                data.put(id.getValue(), value);
            }
            if ((value == null || value.compareTo(BigDecimal.valueOf(0L)) < 0) && id.getValue() != null) {
                throw new NcmBillException(NcmBillException.CHECK_UNITCOST_LESSTHAN_ZERO);
            }
            if (id.getValue() == null) {
                ByProductUnitCostInfo byProductUnitCostInfo = new ByProductUnitCostInfo();
                byProductUnitCostInfo.setId(BOSUuid.create((BOSObjectType)byProductUnitCostInfo.getBOSType()));
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)row.getCell(Col_CompanyNumber).getValue();
                byProductUnitCostInfo.setCompany(companyInfo);
                MaterialInfo materialInfo = (MaterialInfo)row.getCell(Col_MaterialNumber).getValue();
                byProductUnitCostInfo.setMaterial(materialInfo);
                CostItemInfo costItemInfo = (CostItemInfo)row.getCell(Col_CostItemNumber).getValue();
                byProductUnitCostInfo.setCostItem(costItemInfo);
                byProductUnitCostInfo.setUnitCost((BigDecimal)coef.getValue());
                this.addObjList.add(byProductUnitCostInfo);
            }
            isDirty.setValue((Object)String.valueOf(false));
        }
        ByProductUnitCostFactory.getRemoteInstance().UpdateCoefSetting(data, this.deletePkList, this.addObjList);
        this.addObjList.clear();
        this.deletePkList.clear();
    }

    protected void checkValidData() throws Exception {
        int rowCount = this.tblMain.getRowCount();
        int colMaterialIndex = 0;
        int colCostItemIndex = 0;
        if (rowCount > 0) {
            colMaterialIndex = this.tblMain.getCell(0, Col_MaterialNumber).getColumnIndex();
            colCostItemIndex = this.tblMain.getCell(0, Col_CostItemNumber).getColumnIndex();
        }
        for (int i = 0; i < rowCount; ++i) {
            Object Material = this.tblMain.getCell(i, Col_MaterialNumber).getValue();
            Object CostItem = this.tblMain.getCell(i, Col_CostItemNumber).getValue();
            if (Material == null) {
                this.tblMain.getEditManager().editCellAt(i, colMaterialIndex);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"28_ByProductUnitCostListUI"));
                SysUtil.abort();
            }
            if (CostItem != null) continue;
            this.tblMain.getEditManager().editCellAt(i, colCostItemIndex);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"15_AllocStdSetByWIPListUI"));
            SysUtil.abort();
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int qryPre = 8;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                NCMClientUtils.iniColumnsPrecision((int)qryPre, (String[])new String[]{Col_Coef}, (IRowSet)rowSet);
                if (rowSet.getBigDecimal(Col_Coef) != null) continue;
                rowSet.updateObject(Col_Coef, (Object)BigDecimal.valueOf(0L));
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected boolean isShowAttachmentAction() {
        return false;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    @Override
    public void actionAddline_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable(), 0);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        KDTSelectBlock selectBlock = selectManager.get(0);
        if (selectManager.size() == 0) {
            this.addLine(this.getDetailTable(), 0);
        } else if (selectManager.size() > 0) {
            int inserRowIndex = selectBlock.getBeginRow();
            if (inserRowIndex < 0) {
                inserRowIndex = 0;
            }
            this.addLine(this.getDetailTable(), inserRowIndex);
        }
    }

    protected void addLine(KDTable table, int rowIndex) throws BOSException {
        if (table == null) {
            return;
        }
        if (this.tblMain.getRowCount() == 0) {
            this.actionRemoveLine.setEnabled(true);
        }
        IRow row = table.addRow(rowIndex);
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
        this.formatAddline(row);
    }

    private void formatAddline(IRow row) throws BOSException {
        row.getCell(Col_IsDirty).setValue((Object)String.valueOf(true));
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        row.getCell(Col_CompanyName).setValue((Object)companyInfo.getName());
        row.getCell(Col_CompanyNumber).setValue((Object)companyInfo);
        this.prmtMaterial = new KDBizPromptBox();
        this.prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery");
        this.prmtMaterial.setVisible(true);
        this.prmtMaterial.setEditable(true);
        this.prmtMaterial.setDisplayFormat("$number$");
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$");
        KDTDefaultCellEditor cellMaterial = new KDTDefaultCellEditor((IKDEditor)this.prmtMaterial);
        ObjectValueRender ovrMaterial = new ObjectValueRender();
        ovrMaterial.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_MaterialNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_MaterialNumber).setEditor((ICellEditor)cellMaterial);
        row.getCell(Col_MaterialNumber).setRenderer((IBasicRender)ovrMaterial);
        this.prmtCostItem = new KDBizPromptBox();
        this.prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        this.prmtCostItem.setVisible(true);
        this.prmtCostItem.setEditable(true);
        this.prmtCostItem.setDisplayFormat("$number$");
        this.prmtCostItem.setEditFormat("$number$");
        this.prmtCostItem.setCommitFormat("$number$");
        KDTDefaultCellEditor cellCostItem = new KDTDefaultCellEditor((IKDEditor)this.prmtCostItem);
        ObjectValueRender ovrCostItem = new ObjectValueRender();
        ovrCostItem.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_CostItemNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_CostItemNumber).setEditor((ICellEditor)cellCostItem);
        row.getCell(Col_CostItemNumber).setRenderer((IBasicRender)ovrCostItem);
    }

    private void filterMaterial(KDBizPromptBox prmtMat) {
        try {
            FilterInfo filterByObj = new FilterInfo();
            filterByObj.getFilterItems().add(new FilterItemInfo("company", (Object)this._company.getId().toString(), CompareType.EQUALS));
            filterByObj.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)"0", CompareType.EQUALS));
            filterByObj.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)"3", CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterByObj);
            CostObjectCollection costObjectCollection = CostObjectFactory.getRemoteInstance().getCostObjectCollection(evi);
            Iterator iter = costObjectCollection.iterator();
            HashSet<String> materialSet = new HashSet<String>();
            while (iter.hasNext()) {
                CostObjectInfo costObjectInfo = (CostObjectInfo)iter.next();
                if (costObjectInfo.getCalculateMode() == null || 3 != costObjectInfo.getCalculateMode().getValue()) continue;
                CostObjectEntryCollection entries = costObjectInfo.getEntries();
                for (CostObjectEntryInfo costEntryInfo : entries) {
                    String materialID = costEntryInfo.getRelatedID().toString();
                    if (!costEntryInfo.isIsByproduct()) continue;
                    materialSet.add(materialID);
                }
            }
            FilterInfo filter = new FilterInfo();
            if (materialSet.size() == 0) {
                materialSet.add(" ");
            }
            if (materialSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo(Col_ID, materialSet, CompareType.INCLUDE));
            }
            EntityViewInfo newEvi = new EntityViewInfo();
            newEvi.setFilter(filter);
            prmtMat.getQueryAgent().resetRuntimeEntityView();
            prmtMat.setEntityViewInfo(newEvi);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void filtExsitMaterial(int editRowIndex) throws Exception {
        int selectRowIndex = editRowIndex;
        ICellEditor editor = this.tblMain.getRow(selectRowIndex).getCell(Col_MaterialNumber).getEditor();
        if (editor == null) {
            return;
        }
        KDBizPromptBox prmtMat = (KDBizPromptBox)this.tblMain.getRow(selectRowIndex).getCell(Col_MaterialNumber).getEditor().getComponent();
        CostItemInfo info = (CostItemInfo)this.tblMain.getCell(selectRowIndex, Col_CostItemNumber).getValue();
        this.filterMaterial(prmtMat);
        FilterInfo filterPrmt = prmtMat.getEntityViewInfo().getFilter();
        prmtMat = NCMUtils.materialTreeDisplay(null, (KDBizPromptBox)this.prmtMaterial, (FilterInfo)filterPrmt);
        if (info == null) {
            return;
        }
        String id2 = info.getId().toString();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.tblMain.getCell(i, Col_ID).getValue() != null || selectRowIndex == i) continue;
            IRow row = this.tblMain.getRow(i);
            String exsitId = null;
            exsitId = row.getCell(Col_CostItemNumber).getValue() instanceof CostItemInfo ? ((CostItemInfo)row.getCell(Col_CostItemNumber).getValue()).getId().toString() : (String)row.getCell(Col_CostItemNumber).getValue();
            if (row.getCell(Col_MaterialNumber).getValue() == null || !id2.equals(exsitId)) continue;
            String infoId = null;
            infoId = row.getCell(Col_MaterialNumber).getValue() instanceof MaterialInfo ? ((MaterialInfo)row.getCell(Col_MaterialNumber).getValue()).getId().toString() : (String)row.getCell(Col_MaterialNumber).getValue();
            if (infoId == null) continue;
            set.add(infoId);
        }
        CostItemInfo costItemInfo = null;
        MaterialInfo materialInfo = null;
        FilterInfo filter = new FilterInfo();
        FilterInfo filter2 = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this._currPeriod.getId().toString(), CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("company.id", (Object)this._company.getId().toString(), CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("costItem.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.mergeFilter(filter2, "AND");
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        IByProductUnitCost ctr = ByProductUnitCostFactory.getRemoteInstance();
        ByProductUnitCostCollection collection = ctr.getByProductUnitCostCollection(eviData);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            ByProductUnitCostInfo byProductUnitCostInfo = (ByProductUnitCostInfo)iter.next();
            costItemInfo = byProductUnitCostInfo.getCostItem();
            materialInfo = byProductUnitCostInfo.getMaterial();
            if (!costItemInfo.getId().toString().equals(info.getId().toString())) continue;
            set.add(materialInfo.getId().toString());
        }
        FilterInfo filterId = new FilterInfo();
        if (set.size() > 0) {
            filterId.getFilterItems().add(new FilterItemInfo(Col_ID, set, CompareType.NOTINCLUDE));
        }
        EntityViewInfo evi = prmtMat.getEntityViewInfo();
        evi.getFilter().mergeFilter(filterId, "AND");
        prmtMat.getQueryAgent().resetRuntimeEntityView();
        prmtMat.setEntityViewInfo(evi);
    }

    private void filterCostItem(KDBizPromptBox pbCostItem) {
        FilterInfo filterId = new FilterInfo();
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filterId);
        pbCostItem.getQueryAgent().resetRuntimeEntityView();
        pbCostItem.setEntityViewInfo(newEvi);
    }

    private void filtExsitCostItem(int editRowIndex) throws Exception {
        int selectRowIndex = editRowIndex;
        ICellEditor editor = this.tblMain.getRow(selectRowIndex).getCell(Col_MaterialNumber).getEditor();
        if (editor == null) {
            return;
        }
        KDBizPromptBox pboxCostItem = (KDBizPromptBox)this.tblMain.getRow(selectRowIndex).getCell(Col_CostItemNumber).getEditor().getComponent();
        MaterialInfo info = (MaterialInfo)this.tblMain.getCell(selectRowIndex, Col_MaterialNumber).getValue();
        this.filterCostItem(pboxCostItem);
        if (info == null) {
            return;
        }
        String id2 = info.getId().toString();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.tblMain.getCell(i, Col_ID).getValue() != null || selectRowIndex == i) continue;
            IRow row = this.tblMain.getRow(i);
            String exsitId = null;
            exsitId = row.getCell(Col_MaterialNumber).getValue() instanceof MaterialInfo ? ((MaterialInfo)row.getCell(Col_MaterialNumber).getValue()).getId().toString() : (String)row.getCell(Col_MaterialNumber).getValue();
            if (row.getCell(Col_CostItemNumber).getValue() == null || !id2.equals(exsitId)) continue;
            String infoId = null;
            infoId = row.getCell(Col_CostItemNumber).getValue() instanceof CostItemInfo ? ((CostItemInfo)row.getCell(Col_CostItemNumber).getValue()).getId().toString() : (String)row.getCell(Col_CostItemNumber).getValue();
            if (infoId == null) continue;
            set.add(infoId);
        }
        CostItemInfo costItemInfo = null;
        MaterialInfo materialInfo = null;
        FilterInfo filter = new FilterInfo();
        FilterInfo filter2 = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this._currPeriod.getId().toString(), CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("company.id", (Object)this._company.getId().toString(), CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.mergeFilter(filter2, "AND");
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        IByProductUnitCost ctr = ByProductUnitCostFactory.getRemoteInstance();
        ByProductUnitCostCollection collection = ctr.getByProductUnitCostCollection(eviData);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            ByProductUnitCostInfo byProductUnitCostInfo = (ByProductUnitCostInfo)iter.next();
            costItemInfo = byProductUnitCostInfo.getCostItem();
            materialInfo = byProductUnitCostInfo.getMaterial();
            if (!materialInfo.getId().toString().equals(info.getId().toString())) continue;
            set.add(costItemInfo.getId().toString());
        }
        FilterInfo filterId = new FilterInfo();
        if (set.size() > 0) {
            filterId.getFilterItems().add(new FilterItemInfo(Col_ID, set, CompareType.NOTINCLUDE));
        }
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filterId);
        pboxCostItem.getQueryAgent().resetRuntimeEntityView();
        pboxCostItem.setEntityViewInfo(newEvi);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "ByProductUnitCost";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.ImportExportResource", (String)"ByProductUnitCost");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "ByProductUnitCost";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.ImportExportResource", (String)"ByProductUnitCost");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(ByProductUnitCostListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                ICell cell = tblMain.getRow(i).getCell(ByProductUnitCostListUI.Col_IsDirty);
                if (cell == null) continue;
                cell.setValue((Object)String.valueOf(false));
            }
            ByProductUnitCostListUI.this.actionSave.setEnabled(false);
            if (tblMain.getRowCount() == 0) {
                ByProductUnitCostListUI.this.actionBatchSet.setEnabled(false);
                ByProductUnitCostListUI.this.actionRemoveLine.setEnabled(false);
            } else {
                ByProductUnitCostListUI.this.actionBatchSet.setEnabled(true);
                ByProductUnitCostListUI.this.actionRemoveLine.setEnabled(true);
            }
        }
    }

    private final class DeleteProgressHintListener
    implements ProgressHintListener {
        private DeleteProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            ByProductUnitCostListUI.this.innerDoRemoveLine();
        }
    }

    private static final class genProgressHintListener
    implements ProgressHintListener {
        private genProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("company"));
            Assert.that((boolean)param.containsKey("period"));
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
            PeriodInfo period = (PeriodInfo)param.get("period");
            ByProductUnitCostFactory.getRemoteInstance().GenSettingData(company, period);
        }
    }
}

