/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.Constant;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.bill.AdjustAllocDataInfo;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.AllocatorFacadeFactory;
import com.kingdee.eas.ncm.bill.client.AbstractCCOAllocEditUI;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.AllocClientDispatch;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Allocator;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CCOAllocEditUI
extends AbstractCCOAllocEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CCOAllocEditUI.class);
    private static final String Col_ID = "FID";
    private static final String Col_AllocStdData = "allocStdData";
    private static final String Col_CostItem = "costItem";
    private static final String Col_Qty = "qty";
    private static final String Col_Price = "price";
    private static final String Col_Amount = "amount";
    private static final String Col_QtyPrecision = "qryPrecision";
    private static final String Col_PricePrecision = "pricePrecision";
    private static final String Col_AmountPrecision = "amountPrecision";
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _sourceBillId = null;
    private String _sourceBillEntryId = null;
    private String _ExpenseId = null;
    private String _CostCenterGroupId = null;
    private CoreUIObject _parentUI;
    private tblMainIterator _iterator;
    private String _operType = null;
    private IRowSet _Data = null;
    private Task _task;
    private boolean _allocating = false;
    private boolean _updating = false;
    private boolean _isDirty = false;
    private BigDecimal _totalQty = null;
    private BigDecimal _totalAmount = null;
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127 && CCOAllocEditUI.this.kDTable1.getSelectManager().getActiveColumnIndex() == CCOAllocEditUI.this.kDTable1.getColumnIndex(CCOAllocEditUI.Col_AllocStdData)) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            } else if (arg0.getKeyCode() == 10) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127 && CCOAllocEditUI.this.kDTable1.getSelectManager().getActiveColumnIndex() == CCOAllocEditUI.this.kDTable1.getColumnIndex(CCOAllocEditUI.Col_AllocStdData)) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }
    };

    public static void showAllocEditUI(CoreUIObject ui, Map param, String operType, KDTable tblMain) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("filterInfo"));
        Assert.that((tblMain != null ? 1 : 0) != 0);
        Assert.that((operType.equals("VIEW") || operType.equals("ADJUST") ? 1 : 0) != 0);
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            uiContext.put((Object)"operType", (Object)operType);
            uiContext.put((Object)"tblMain", (Object)tblMain);
            uiContext.put((Object)"parentUI", (Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CCOAllocEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this._operType = (String)this.getUIContext().get("operType");
        KDTable tbl = (KDTable)this.getUIContext().get("tblMain");
        this._parentUI = (CoreUIObject)this.getUIContext().get("parentUI");
        this._iterator = new tblMainIterator(tbl);
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this.formatControls();
        if (this._operType.equals("ADJUST")) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"29_CCOAllocEditUI"));
        }
        this.fillData();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this._operType.equals("ADJUST")) {
            this._task = new Task();
            this._task.start(100, 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doManuAlloc(AllocStdInfo allocStd, boolean isOnlyRangeChange) throws Exception {
        HashMap param = new HashMap();
        param.put("filterInfo", this._parentParam.get("filterInfo"));
        param.put("companyId", this._parentParam.get("companyId"));
        param.put("periodId", this._parentParam.get("periodId"));
        param.put("companyName", this._parentParam.get("companyName"));
        param.put("periodNumber", this._parentParam.get("periodNumber"));
        param.put("sourceBillId", this._sourceBillId);
        param.put("sourceBillEntryId", this._sourceBillEntryId);
        if (allocStd != null) {
            param.put("allocStd", allocStd);
        }
        if (this.btnOnlyNotZero.isSelected()) {
            param.put("isOnlyNotZero", String.valueOf(true));
        } else {
            param.put("isOnlyNotZero", String.valueOf(false));
        }
        if (isOnlyRangeChange) {
            param.put("isOnlyRangeChange", String.valueOf(true));
        } else {
            param.put("isOnlyRangeChange", String.valueOf(false));
        }
        this.kDTable1.removeRows();
        this.set_isDirty(true);
        AllocClientDispatch disp = new AllocClientDispatch();
        Allocator alloc = disp.DoCCOAllocate(this._parentUI, AllocTypeEnum.MANU, param);
        if (alloc.getResultInfo().containsKey("AdjustData")) {
            AllocStdInfo std = (AllocStdInfo)alloc.getResultInfo().get("AllocStd");
            try {
                this._allocating = true;
                this.kdbpbAllocStd.setValue((Object)std);
            }
            finally {
                this._allocating = false;
            }
            this._Data = (IRowSet)alloc.getResultInfo().get("AdjustData");
            this.initKDTable();
        }
    }

    private void formatControls() {
        this.kDTable1.checkParsed();
        NCMClientUtils.filterF7((KDBizPromptBox)this.kdbpbAllocStd, (String)"allocStdType", (Object)String.valueOf(AllocStdTypeEnum.INNERCC.getValue()));
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setVisible(true);
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$number$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        KDTDefaultCellEditor ceCostItem = new KDTDefaultCellEditor((IKDEditor)prmtCostItem);
        this.kDTable1.getColumn(Col_CostItem).setEditor((ICellEditor)ceCostItem);
        ObjectValueRender ovrCostItem = new ObjectValueRender();
        ovrCostItem.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kDTable1.getColumn(Col_CostItem).setRenderer((IBasicRender)ovrCostItem);
        this.kDTable1.getColumn(Col_AllocStdData).setRequired(true);
        this.kDTable1.getColumn(Col_CostItem).setRequired(true);
        KDFormattedTextField txtAllocStdData = new KDFormattedTextField();
        txtAllocStdData.setDataType(1);
        txtAllocStdData.setPrecision(8);
        txtAllocStdData.setHorizontalAlignment(4);
        txtAllocStdData.setDecimalSeparatorAlwaysShown(true);
        txtAllocStdData.setRemoveingZeroInDispaly(true);
        txtAllocStdData.setMinimumValue((Comparable)SysConstant.BIGZERO);
        this.kDTable1.getColumn(Col_AllocStdData).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAllocStdData));
        this.kDTable1.getColumn(Col_AllocStdData).getStyleAttributes().setNumberFormat("%{0.##########}f");
        if (this._operType.equals("VIEW")) {
            this.kdbpbAllocStd.setEditable(false);
            this.kdbpbAllocStd.setEnabled(false);
            this.kDTable1.getColumn(Col_AllocStdData).getStyleAttributes().setLocked(true);
            this.kDTable1.getColumn(Col_CostItem).getStyleAttributes().setLocked(true);
            this.actionSave.setVisible(false);
            this.btnOnlyNotZero.setVisible(false);
        } else {
            this.kdbpbAllocStd.setEditable(true);
            this.kdbpbAllocStd.setEnabled(true);
            this.kDTable1.getColumn(Col_AllocStdData).getStyleAttributes().setLocked(false);
            this.kDTable1.getColumn(Col_CostItem).getStyleAttributes().setLocked(false);
            this.actionSave.setVisible(true);
            this.actionSave.setEnabled(false);
            this.btnOnlyNotZero.setVisible(true);
        }
        this.kDTable1.getColumn(Col_Qty).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kDTable1.getColumn(Col_Price).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kDTable1.getColumn(Col_Amount).getStyleAttributes().setNumberFormat("%{0.##########}f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKDTable() throws BOSException, EASBizException, SQLException {
        if (this._Data != null) {
            IRow row;
            boolean isSetted = false;
            this.kDTable1.removeRows();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            BigDecimal totalAllocStdData = BigDecimal.valueOf(0L);
            BigDecimal totalAmount = BigDecimal.valueOf(0L);
            BigDecimal totalPrice = BigDecimal.valueOf(0L);
            BigDecimal totalQty = BigDecimal.valueOf(0L);
            this._Data.first();
            while (this._Data.getRow() > 0 && !this._Data.isAfterLast()) {
                if (!isSetted) {
                    if (this._operType.equals("VIEW")) {
                        this.kdbpbAllocStd.setText(this._Data.getString("FAllocStdName"));
                    } else {
                        try {
                            this._allocating = true;
                            if (this._Data.getString("FAllocStdId") != null) {
                                ObjectUuidPK pk = new ObjectUuidPK(this._Data.getString("FAllocStdId"));
                                AllocStdInfo std = AllocStdFactory.getRemoteInstance().getAllocStdInfo((IObjectPK)pk);
                                this.kdbpbAllocStd.setValue((Object)std);
                            } else {
                                this.kdbpbAllocStd.setValue(null);
                            }
                        }
                        finally {
                            this._allocating = false;
                        }
                    }
                    this.txtCreater.setText(this._Data.getString("FCreatorName"));
                    this.txtLastUpdateUser.setText(this._Data.getString("FAdjustUserName"));
                    this.txtCreateTime.setText(sdf.format(this._Data.getTime("FCreateTime")));
                    if (this._Data.getString("FAdjustUserName") != null) {
                        this.txtLastUpdateTime.setText(sdf.format(this._Data.getTime("FAdjustTime")));
                    } else {
                        this.txtLastUpdateTime.setText("");
                    }
                    isSetted = true;
                }
                row = this.kDTable1.addRow();
                row.getCell("costCenterId").setValue((Object)this._Data.getString("FCostCenterId"));
                row.getCell("costCenterNumber").setValue((Object)this._Data.getString("FCostCenterNumber"));
                row.getCell("costCenterName").setValue((Object)this._Data.getString("FCostCenterName"));
                row.getCell(Col_AllocStdData).setValue((Object)this._Data.getBigDecimal("FAllocStdData"));
                totalAllocStdData = totalAllocStdData.add(this._Data.getBigDecimal("FAllocStdData"));
                row.getCell(Col_Qty).setValue((Object)this._Data.getBigDecimal("FQty"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Qty), (int)this._Data.getInt("FQtyPrecision"));
                totalQty = this._Data.getBigDecimal("FQty") == null ? totalQty.add(Constant.DECIMAL_0) : totalQty.add(this._Data.getBigDecimal("FQty"));
                row.getCell(Col_Price).setValue((Object)this._Data.getBigDecimal("FPrice"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Price), (int)this._Data.getInt("FPricePrecision"));
                totalPrice = this._Data.getBigDecimal("FPrice") == null ? totalPrice.add(Constant.DECIMAL_0) : totalPrice.add(this._Data.getBigDecimal("FPrice"));
                row.getCell(Col_Amount).setValue((Object)this._Data.getBigDecimal("FAmount"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Amount), (int)this._Data.getInt("FAmountPrecision"));
                totalAmount = this._Data.getBigDecimal("FAmount") == null ? totalAmount.add(Constant.DECIMAL_0) : totalAmount.add(this._Data.getBigDecimal("FAmount"));
                row.getCell(Col_CostItem).setValue((Object)this._Data.getString("FCostItemName"));
                row.getCell("department").setValue((Object)this._Data.getString("Fdepartmentname"));
                row.getCell("sourceCostCenter").setValue((Object)this._Data.getString("FSourceCostCenterName"));
                if (this._operType.equals("ADJUST")) {
                    row.getCell(Col_ID).setValue((Object)this._Data.getString(Col_ID));
                    row.getCell(Col_QtyPrecision).setValue((Object)this._Data.getBigDecimal("FQtyPrecision"));
                    row.getCell(Col_PricePrecision).setValue((Object)this._Data.getBigDecimal("FPricePrecision"));
                    row.getCell(Col_AmountPrecision).setValue((Object)this._Data.getBigDecimal("FAmountPrecision"));
                    row.getCell(Col_CostItem).setUserObject((Object)this._Data.getString("FCostItemID"));
                }
                this._Data.next();
            }
            if (!totalAllocStdData.equals(BigDecimal.valueOf(0L))) {
                row = this.kDTable1.addRow();
                row.getCell("costCenterName").setValue((Object)NCMClientUtils.getNcmBillResource((String)"SubTotal"));
                row.getCell(Col_AllocStdData).setValue((Object)totalAllocStdData);
                row.getCell(Col_Amount).setValue((Object)totalAmount);
                row.getCell(Col_Qty).setValue((Object)totalQty);
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    private IRowSet GetAdjustData() throws BOSException {
        boolean forAdjust = this._operType.equals("ADJUST");
        return AllocatorFacadeFactory.getRemoteInstance().getCCOAdjustData(this._companyId, this._periodId, this._sourceBillId, this._sourceBillEntryId, forAdjust);
    }

    private void fillData() throws BOSException, EASBizException, SQLException {
        IRow row = this._iterator.CurrentRow();
        if (row == null) {
            return;
        }
        this.checkMustToSave();
        this.txtNumber.setText((String)row.getCell("number").getValue());
        this.txtEntrySeq.setText(String.valueOf(row.getCell("entries.seq").getValue()));
        this.txtCostCenterGroupNumber.setText((String)row.getCell("costCenterGroup.number").getValue());
        this.txtExpenseNumber.setText((String)row.getCell("expense.number").getValue());
        this.txtUnit.setText((String)row.getCell("unit.name").getValue());
        this.prmtDepartment.setText((String)row.getCell("department.name").getValue());
        this.prmtSourceCostCenter.setText((String)row.getCell("sourceCostCenter.name").getValue());
        if (row.getCell("entries.qty").getValue() == null) {
            this.txtQty.setText("0");
            this._totalQty = BigDecimal.valueOf(0L);
        } else {
            this.txtQty.setText(row.getCell("entries.qty").getValue().toString());
            this._totalQty = (BigDecimal)row.getCell("entries.qty").getValue();
        }
        if (row.getCell("entries.amount").getValue() == null) {
            this.txtAmount.setText("0");
            this._totalAmount = BigDecimal.valueOf(0L);
        } else {
            this.txtAmount.setText(row.getCell("entries.amount").getValue().toString());
            this._totalAmount = (BigDecimal)row.getCell("entries.amount").getValue();
        }
        this._sourceBillId = (String)row.getCell("id").getValue();
        this._sourceBillEntryId = (String)row.getCell("entries.id").getValue();
        this._CostCenterGroupId = (String)row.getCell("costCenterGroup.id").getValue();
        this._ExpenseId = (String)row.getCell("expense.id").getValue();
        this.kdbpbAllocStd.setText("");
        this._Data = this.GetAdjustData();
        this.initKDTable();
    }

    @Override
    protected void btnOnlyNotZero_itemStateChanged(ItemEvent e) throws Exception {
        super.btnOnlyNotZero_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            this.btnOnlyNotZero.setText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_ALL"));
            this.btnOnlyNotZero.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_ALL_Hint"));
        } else {
            this.btnOnlyNotZero.setText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_Default"));
            this.btnOnlyNotZero.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_Default_Hint"));
        }
        this.checkMustToSave();
        if (this._allocating) {
            return;
        }
        AllocStdInfo std = (AllocStdInfo)this.kdbpbAllocStd.getValue();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("allocStd", std);
        param.put("isOnlyRangeChange", String.valueOf(true));
        this.progressManuAlloc(param);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this._iterator.First();
        this.fillData();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this._iterator.Last();
        this.fillData();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this._iterator.Next();
        this.fillData();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this._iterator.Pre();
        this.fillData();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.fillData();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable1);
        this.kDTable1.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable1);
        this.kDTable1.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnOnlyNotZero.setIcon(EASResource.getIcon((String)"imgTbtn_entirely"));
        this.btnOnlyNotZero.setSelectedIcon(EASResource.getIcon((String)"imgTbtn_partshow"));
    }

    private void progressManuAlloc(Map param) throws Exception {
        Assert.that((boolean)param.containsKey("allocStd"));
        Assert.that((boolean)param.containsKey("isOnlyRangeChange"));
        allocProgressHintListener listener = new allocProgressHintListener();
        ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, (Map)param);
    }

    private boolean hasAllocData() throws SQLException {
        if (this._Data == null) {
            return false;
        }
        this._Data.first();
        return this._Data.getRow() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void kdbpbAllocStd_dataChanged(DataChangeEvent e) throws Exception {
        super.kdbpbAllocStd_dataChanged(e);
        if (this._allocating) {
            return;
        }
        try {
            this._allocating = true;
            this.btnOnlyNotZero.setSelected(true);
            AllocStdInfo std = (AllocStdInfo)e.getNewValue();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("allocStd", std);
            param.put("isOnlyRangeChange", String.valueOf(false));
            this.progressManuAlloc(param);
        }
        finally {
            this._allocating = false;
        }
    }

    private void checkMustToSave() throws EASBizException, BOSException, SQLException {
        if (this._isDirty) {
            int ret = MsgBox.showConfirm3((String)NCMClientUtils.getNcmBillResource((String)"CHECK_DIRTY"));
            if (ret == 0) {
                if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(null, null)) {
                    SysUtil.abort();
                }
                try {
                    this.updateManuAdjustData();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)e.getMessage(), (int)8188);
                    SysUtil.abort();
                }
            } else if (ret == 2) {
                SysUtil.abort();
            } else if (ret == 1) {
                this.set_isDirty(false);
            }
        }
    }

    private void updateManuAdjustData() throws BOSException, AllocateException, EASBizException, SQLException {
        int rowCount = this.kDTable1.getRowCount();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("companyID", this._companyId);
        data.put("periodID", this._periodId);
        data.put("sourceBillId", this._sourceBillId);
        data.put("sourceBillEntryId", this._sourceBillEntryId);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        data.put("userId", user.getId().toString());
        String allocStdId = null;
        if (this.kdbpbAllocStd.getValue() instanceof AllocStdInfo) {
            AllocStdInfo std = (AllocStdInfo)this.kdbpbAllocStd.getValue();
            allocStdId = std.getId().toString();
        }
        data.put("allocStdID", allocStdId);
        if (rowCount > 0) {
            AdjustAllocDataInfo[] info = new AdjustAllocDataInfo[rowCount - 1];
            for (int i = 0; i < rowCount - 1; ++i) {
                IRow row = this.kDTable1.getRow(i);
                ICell id = row.getCell(Col_ID);
                ICell allocStdData = row.getCell(Col_AllocStdData);
                ICell costItem = row.getCell(Col_CostItem);
                ICell qty = row.getCell(Col_Qty);
                ICell price = row.getCell(Col_Price);
                ICell amount = row.getCell(Col_Amount);
                String costItemId = costItem.getUserObject().toString();
                if (costItemId.trim().length() <= 0) {
                    throw new AllocateException(AllocateException.ITEM_MANUALLOC_NO_COSTITEM);
                }
                info[i] = new AdjustAllocDataInfo(id.getValue().toString(), costItemId, (BigDecimal)allocStdData.getValue(), (BigDecimal)qty.getValue(), (BigDecimal)price.getValue(), (BigDecimal)amount.getValue());
            }
            data.put("Info", info);
        } else {
            data.put("Info", null);
        }
        AllocatorFacadeFactory.getRemoteInstance().updateCCOAdjustData(data);
        this.set_isDirty(false);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkMustToSave();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }

    @Override
    protected void kDTable1_editStopped(KDTEditEvent e) throws Exception {
        super.kDTable1_editStopped(e);
        if (e.getColIndex() == this.kDTable1.getColumnIndex(Col_AllocStdData)) {
            if (!e.getValue().equals(e.getOldValue())) {
                this.set_isDirty(true);
                if (!this._updating) {
                    try {
                        this._updating = true;
                        this.updateAlloc();
                    }
                    finally {
                        this._updating = false;
                    }
                }
            }
        } else if (e.getColIndex() == this.kDTable1.getColumnIndex(Col_CostItem) && e.getOldValue() != e.getValue()) {
            this.set_isDirty(true);
            if (e.getValue() instanceof CostItemInfo) {
                String costItemId = ((CostItemInfo)e.getValue()).getId().toString();
                this.kDTable1.getRow(e.getRowIndex()).getCell(Col_CostItem).setUserObject((Object)costItemId);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(null, null)) {
            return;
        }
        try {
            this.updateManuAdjustData();
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)ex.getMessage(), (int)8188);
            SysUtil.abort();
        }
    }

    public void set_isDirty(boolean dirty) throws EASBizException, BOSException, SQLException {
        this._isDirty = dirty;
        this.actionSave.setEnabled(dirty);
        if (!dirty) {
            this.fillData();
        }
    }

    private void updateAlloc() {
        ICell allocStdData;
        IRow row;
        int i;
        BigDecimal totalAllocStdData = BigDecimal.valueOf(0L);
        BigDecimal totalAllocedQty = BigDecimal.valueOf(0L);
        BigDecimal totalAllocedAmount = BigDecimal.valueOf(0L);
        BigDecimal maxAllocStdData = BigDecimal.valueOf(0L);
        int maxRateRowIndex = 0;
        for (i = 0; i < this.kDTable1.getRowCount() - 1; ++i) {
            row = this.kDTable1.getRow(i);
            allocStdData = row.getCell(Col_AllocStdData);
            totalAllocStdData = totalAllocStdData.add((BigDecimal)allocStdData.getValue());
        }
        for (i = 0; i < this.kDTable1.getRowCount() - 1; ++i) {
            row = this.kDTable1.getRow(i);
            allocStdData = row.getCell(Col_AllocStdData);
            ICell qty = row.getCell(Col_Qty);
            ICell price = row.getCell(Col_Price);
            ICell amount = row.getCell(Col_Amount);
            int qtyPrec = ((BigDecimal)row.getCell(Col_QtyPrecision).getValue()).intValue();
            int pricePrec = ((BigDecimal)row.getCell(Col_PricePrecision).getValue()).intValue();
            int amountPrec = ((BigDecimal)row.getCell(Col_AmountPrecision).getValue()).intValue();
            BigDecimal value = (BigDecimal)allocStdData.getValue();
            if (value == null) {
                value = BigDecimal.valueOf(0L);
            }
            if (maxAllocStdData.compareTo(value) < 0) {
                maxAllocStdData = value;
                maxRateRowIndex = i;
            }
            BigDecimal rate = null;
            rate = totalAllocStdData.compareTo(BigDecimal.valueOf(0L)) <= 0 ? BigDecimal.valueOf(0L) : value.divide(totalAllocStdData, 12, 4);
            BigDecimal tempQty = this._totalQty.multiply(rate).setScale(qtyPrec, 4);
            totalAllocedQty = totalAllocedQty.add(tempQty);
            qty.setValue((Object)tempQty);
            BigDecimal tempAmount = this._totalAmount.multiply(rate).setScale(amountPrec, 4);
            totalAllocedAmount = totalAllocedAmount.add(tempAmount);
            amount.setValue((Object)tempAmount);
            BigDecimal tempPrice = null;
            tempPrice = tempQty.compareTo(BigDecimal.valueOf(0L)) == 0 ? BigDecimal.valueOf(0L) : tempAmount.divide(tempQty, pricePrec, 4);
            price.setValue((Object)tempPrice);
        }
        if (this._totalAmount.compareTo(totalAllocedAmount) != 0 && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row2 = this.kDTable1.getRow(maxRateRowIndex);
            ICell amount = row2.getCell(Col_Amount);
            BigDecimal tempAmt = ((BigDecimal)amount.getValue()).add(this._totalAmount).subtract(totalAllocedAmount);
            totalAllocedAmount = totalAllocedAmount.add(this._totalAmount).subtract(totalAllocedAmount);
            amount.setValue((Object)tempAmt);
        }
        if (this._totalQty.compareTo(totalAllocedQty) != 0 && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row3 = this.kDTable1.getRow(maxRateRowIndex);
            ICell qty = row3.getCell(Col_Qty);
            BigDecimal tempQty = ((BigDecimal)qty.getValue()).add(this._totalQty).subtract(totalAllocedQty);
            totalAllocedQty = totalAllocedQty.add(this._totalQty).subtract(totalAllocedQty);
            qty.setValue((Object)tempQty);
        }
        if ((this._totalAmount.compareTo(totalAllocedAmount) != 0 || this._totalQty.compareTo(totalAllocedQty) != 0) && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row4 = this.kDTable1.getRow(maxRateRowIndex);
            BigDecimal tempPrice = null;
            tempPrice = ((BigDecimal)row4.getCell(Col_Qty).getValue()).compareTo(BigDecimal.valueOf(0L)) == 0 ? BigDecimal.valueOf(0L) : ((BigDecimal)row4.getCell(Col_Amount).getValue()).divide((BigDecimal)row4.getCell(Col_Qty).getValue(), ((BigDecimal)row4.getCell(Col_PricePrecision).getValue()).intValue(), 4);
            row4.getCell(Col_Price).setValue((Object)tempPrice);
        }
        this.kDTable1.getRow(this.kDTable1.getRowCount() - 1).getCell(Col_AllocStdData).setValue((Object)totalAllocStdData);
        this.kDTable1.getRow(this.kDTable1.getRowCount() - 1).getCell(Col_Qty).setValue((Object)totalAllocedQty);
        this.kDTable1.getRow(this.kDTable1.getRowCount() - 1).getCell(Col_Amount).setValue((Object)totalAllocedAmount);
    }

    protected void initListener() {
        super.initListener();
        this.kDTable1.addKeyListener(this.keyListener);
    }

    private class Task {
        private Timer timer;
        private TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    Task.this.timer.cancel();
                    if (CCOAllocEditUI.this._operType.equals("ADJUST") && !CCOAllocEditUI.this.hasAllocData()) {
                        try {
                            HashMap<String, String> param = new HashMap<String, String>();
                            param.put("allocStd", null);
                            param.put("isOnlyRangeChange", String.valueOf(false));
                            CCOAllocEditUI.this.progressManuAlloc(param);
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                            CCOAllocEditUI.this.handUIException(e);
                        }
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        };

        public Task() {
            this.timer = new Timer(false);
        }

        public void start(int delay, int internal) {
            this.timer.schedule(this.task, delay, (long)internal);
        }
    }

    private class tblMainIterator {
        private KDTable _tblMain;
        private int _currentRowIndex = -1;

        public tblMainIterator(KDTable tblMain) {
            this._tblMain = tblMain;
            this._currentRowIndex = this._tblMain.getSelectManager().getActiveRowIndex();
        }

        public void First() {
            this._currentRowIndex = 0;
            CCOAllocEditUI.this.actionFirst.setEnabled(false);
            CCOAllocEditUI.this.actionPre.setEnabled(false);
            CCOAllocEditUI.this.actionNext.setEnabled(true);
            CCOAllocEditUI.this.actionLast.setEnabled(true);
        }

        public void Pre() {
            if (!this.IsFirst()) {
                --this._currentRowIndex;
                CCOAllocEditUI.this.actionFirst.setEnabled(true);
                CCOAllocEditUI.this.actionPre.setEnabled(true);
                CCOAllocEditUI.this.actionNext.setEnabled(true);
                CCOAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                CCOAllocEditUI.this.actionFirst.setEnabled(false);
                CCOAllocEditUI.this.actionPre.setEnabled(false);
                CCOAllocEditUI.this.actionNext.setEnabled(true);
                CCOAllocEditUI.this.actionLast.setEnabled(true);
            }
        }

        public void Next() {
            if (!this.IsLast()) {
                ++this._currentRowIndex;
                CCOAllocEditUI.this.actionFirst.setEnabled(true);
                CCOAllocEditUI.this.actionPre.setEnabled(true);
                CCOAllocEditUI.this.actionNext.setEnabled(true);
                CCOAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                CCOAllocEditUI.this.actionFirst.setEnabled(true);
                CCOAllocEditUI.this.actionPre.setEnabled(true);
                CCOAllocEditUI.this.actionNext.setEnabled(false);
                CCOAllocEditUI.this.actionLast.setEnabled(false);
            }
        }

        public void Last() {
            this._currentRowIndex = this._tblMain.getRowCount() - 1;
            CCOAllocEditUI.this.actionFirst.setEnabled(true);
            CCOAllocEditUI.this.actionPre.setEnabled(true);
            CCOAllocEditUI.this.actionNext.setEnabled(false);
            CCOAllocEditUI.this.actionLast.setEnabled(false);
        }

        public boolean IsFirst() {
            return this._currentRowIndex == 0;
        }

        public boolean IsLast() {
            return this._tblMain.getRowCount() == this._currentRowIndex + 1;
        }

        public IRow CurrentRow() {
            return this._tblMain.getRow(this._currentRowIndex);
        }
    }

    private final class allocProgressHintListener
    implements ProgressHintListener {
        private allocProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            AllocStdInfo allocStd = (AllocStdInfo)param.get("allocStd");
            boolean isOnlyRangeChange = false;
            if (param.get("isOnlyRangeChange").equals(String.valueOf(true))) {
                isOnlyRangeChange = true;
            }
            CCOAllocEditUI.this.doManuAlloc(allocStd, isOnlyRangeChange);
        }
    }
}

