/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.bill.client.AbstractCCOAllocListUI;
import com.kingdee.eas.ncm.bill.client.CCOAllocEditUI;
import com.kingdee.eas.ncm.bill.client.CCOAllocFiterUI;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.bill.client.OtherAllocLogReportUI;
import com.kingdee.eas.ncm.bill.utils.CostAllocUtils;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CCOAllocListUI
extends AbstractCCOAllocListUI {
    private static final Logger logger = CoreUIObject.getLogger(CCOAllocListUI.class);
    private FilterInfo _currFilterInfo = null;
    private boolean bFilter_all = false;
    private CCOAllocFiterUI filterUI = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("costCenterGroup.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("description").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("expense.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("department.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entries.seq").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("costItem.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entries.remark").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("creator.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("createTime").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("auditor.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("lastUpdateUser.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("lastUpdateTime").getStyleAttributes().setHided(true);
        String[] a = new String[]{"entries.qty", "entries.price", "entries.amount"};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])a, (String)"%{###,###,###.##########}f");
    }

    public CCOAllocListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRowIndex = e.getFirstRow();
                int lastRowIndex = e.getLastRow();
                IRow row = null;
                int precision = 0;
                for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                    row = CCOAllocListUI.this.tblMain.getRow(i);
                    if (row.getCell("entries.amount") != null && row.getCell("entries.amount").getValue() != null) {
                        precision = (Integer)row.getCell("amountPrecision").getValue();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.amount"), (int)precision);
                    }
                    if (row.getCell("entries.qty") != null && row.getCell("entries.qty").getValue() != null) {
                        precision = (Integer)row.getCell("qtyPrecision").getValue();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.qty"), (int)precision);
                    }
                    if (row.getCell("entries.price") == null || row.getCell("entries.price").getValue() == null) continue;
                    precision = (Integer)row.getCell("pricePrecision").getValue();
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.price"), (int)precision);
                }
            }
        });
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuItemViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.getCurrPeriod().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
            this.bFilter_all = ev.getFilter().getFilterItems().size() <= 3;
            try {
                ev.getFilter().mergeFilter(filter, "and");
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionViewAlloc_actionPerformed(null);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(CCOAllocListUI.this.btnViewAlloc, 0, "Enter");
                ItemAction actView = CCOAllocListUI.this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        });
    }

    @Override
    public void actionAutoAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionAutoAlloc_actionPerformed(e);
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(this.getCompanyOrgInfoWithDefault(), this.getCurrPeriod())) {
            return;
        }
        this.ifHasCodingRule();
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("company", this.getCompanyOrgInfoWithDefault());
        source.put("period", this.getCurrPeriod());
        source.put("user", SysContext.getSysContext().getCurrentUserInfo());
        source.put("filterInfo", this._currFilterInfo);
        source.put("bFilter_all", String.valueOf(this.bFilter_all));
        Map param = CostAllocUtils.buildCCOAllocParam(source);
        CostTaskClientUtils.execute((Map)param, (CoreUIObject)this, (boolean)false);
    }

    private void ifHasCodingRule() throws AllocateException {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (!codingRuleManager.isExist((IObjectValue)new OtherFeeBillInfo(), this.getCompanyOrgInfoWithDefault().getId().toString())) {
                throw new AllocateException(AllocateException.ITEM_ALLOC_NOCODINGRULE);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    @Override
    public void actionManuAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionManuAlloc_actionPerformed(e);
        this.ifHasCodingRule();
        NCMClientUtils.requestMutex((CoreUI)this, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        try {
            this.checkSelected();
            this.showAllocEditUI("ADJUST");
        }
        finally {
            NCMClientUtils.releaseMutex((CoreUI)this, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        }
    }

    private void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.getCompanyOrgInfoWithDefault().getId().toString());
        param.put("periodId", this.getCurrPeriod().getId().toString());
        param.put("companyName", this.getCompanyOrgInfoWithDefault().getName().toString());
        param.put("periodNumber", String.valueOf(this.getCurrPeriod().getNumber()));
        param.put("filterInfo", (String)this.GetManuFilter(this._currFilterInfo));
        param.put("bFilter_all", String.valueOf(this.bFilter_all));
        CCOAllocEditUI.showAllocEditUI((CoreUIObject)this, param, operType, this.tblMain);
    }

    private FilterInfo GetManuFilter(FilterInfo filter) {
        String Col_ID = "id";
        String Col_EntryID = "entries.id";
        int top = this.tblMain.getSelectManager().get(0).getBeginRow();
        String id = this.tblMain.getRow(top).getCell(Col_ID).getValue().toString();
        String entryId = this.tblMain.getRow(top).getCell(Col_EntryID).getValue().toString();
        FilterInfo ret = new FilterInfo();
        try {
            FilterInfo addfilter = new FilterInfo();
            addfilter.getFilterItems().add(new FilterItemInfo(Col_ID, (Object)id));
            addfilter.getFilterItems().add(new FilterItemInfo(Col_EntryID, (Object)entryId));
            try {
                ret.mergeFilter(filter, "and ");
                ret.mergeFilter(addfilter, "and");
                return ret;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAlloc_actionPerformed(e);
        String oprationName = AllocSourceBillEnum.CCOFeeBill.getName() + "Alloc_View";
        NCMUtils.addEASLogForAlloc(null, (String)"actionViewAlloc_actionPerformed", (String)(this.getCompanyOrgInfoWithDefault().getNumber() + ' ' + this.getCompanyOrgInfoWithDefault().getName()), (String)oprationName, (String)this.getCompanyOrgInfoWithDefault().getId().toString(), (boolean)true);
        this.showAllocEditUI("VIEW");
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewLog_actionPerformed(e);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.getCompanyOrgInfoWithDefault().getId().toString());
        param.put("periodId", this.getCurrPeriod().getId().toString());
        param.put("companyName", this.getCompanyOrgInfoWithDefault().getName().toString());
        param.put("periodNumber", String.valueOf(this.getCurrPeriod().getNumber()));
        param.put("logTblName", "T_NCM_LOG_CCO");
        OtherAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (rowSet == null || rowSet.size() == 0) {
            this.actionAutoAlloc.setEnabled(false);
            this.actionViewAlloc.setEnabled(false);
            this.actionViewLog.setEnabled(false);
            this.actionManuAlloc.setEnabled(false);
            this.actionPrint.setEnabled(false);
            this.actionPrintPreview.setEnabled(false);
        } else {
            this.actionAutoAlloc.setEnabled(true);
            this.actionViewAlloc.setEnabled(true);
            this.actionViewLog.setEnabled(true);
            this.actionManuAlloc.setEnabled(true);
            this.actionPrint.setEnabled(true);
            this.actionPrintPreview.setEnabled(true);
        }
    }

    @Override
    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    private PeriodInfo getCurrPeriod() {
        PeriodInfo period = null;
        try {
            period = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return period;
    }

    @Override
    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new CCOAllocFiterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }
}

