/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.CCOFeeBillEntryInfo;
import com.kingdee.eas.ncm.bill.CCOFeeBillFactory;
import com.kingdee.eas.ncm.bill.CCOFeeBillInfo;
import com.kingdee.eas.ncm.bill.client.AbstractCCOFeeBillEditUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CCOFeeBillEditUI
extends AbstractCCOFeeBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CCOFeeBillEditUI.class);
    KDBizPromptBox prmtExpense = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.pkBizDate.setRequired(true);
        this.prmtCostCenterGroup.setRequired(true);
        this.kdtEntries.getColumn("expense").setRequired(true);
        this.kdtEntries.getColumn("expense.name").getStyleAttributes().setLocked(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuWorkflow.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        String companyOrgId = null;
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgId = comOrg.getId().toString();
            try {
                BDCMClientUtils.filterCostCenterGroupF7((KDBizPromptBox)this.prmtCostCenterGroup, (String)companyOrgId);
                CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(comOrg.getBaseCurrency().getId()));
                NCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currency, (KDTable)this.kdtEntries, (String[])new String[]{"amount"});
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        try {
            BDCMClientUtils.filterAdminAndCostCenterF7((KDBizPromptBox)this.prmtDepartment, companyOrgId);
            BDCMClientUtils.filterCostCenterByCompanyOrgF7((KDBizPromptBox)this.prmtSourceCostCenter, (String)companyOrgId, (boolean)true);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.formatEntryTable();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setDepartment((AdminOrgUnitInfo)this.prmtDepartment.getValue());
    }

    private void formatEntryTable() {
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$name$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        prmtCostItem.setRequired(true);
        EntityViewInfo costItemview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ItemType", (Object)"1", CompareType.NOTEQUALS));
        costItemview.setFilter(filter);
        prmtCostItem.setEntityViewInfo(costItemview);
        KDTDefaultCellEditor costItemEditor = new KDTDefaultCellEditor((IKDEditor)prmtCostItem);
        this.kdtEntries.getColumn("costItem.number").setEditor((ICellEditor)costItemEditor);
        ObjectValueRender costItemAvr = new ObjectValueRender();
        costItemAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("costItem.number").setRenderer((IBasicRender)costItemAvr);
        this.prmtExpense = new KDBizPromptBox();
        this.prmtExpense.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ExpenseF7Query");
        this.prmtExpense.setEditable(true);
        this.prmtExpense.setDisplayFormat("$name$");
        this.prmtExpense.setEditFormat("$number$");
        this.prmtExpense.setCommitFormat("$number$");
        this.prmtExpense.setRequired(true);
        this.prmtExpense.setEnabledMultiSelection(true);
        KDTDefaultCellEditor expenseEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtExpense);
        this.kdtEntries.getColumn("expense").setEditor((ICellEditor)expenseEditor);
        ObjectValueRender expenseAvr = new ObjectValueRender();
        expenseAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("expense").setRenderer((IBasicRender)expenseAvr);
        EntityViewInfo view = this.prmtExpense.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
            this.prmtExpense.setEntityViewInfo(view);
        }
        CompanyOrgUnitInfo comOrg = null;
        if (this.prmtCompanyOrg.getData() != null) {
            comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
        }
        HashSet<Integer> extypes = new HashSet<Integer>();
        extypes.add(2);
        extypes.add(30);
        extypes.add(40);
        extypes.add(50);
        extypes.add(60);
        try {
            if (comOrg != null) {
                BDCMClientUtils.filterExpenseF7((EntityViewInfo)view, (String)comOrg.getId().toString(), extypes);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        KDFormattedTextField txtAdjustQty = new KDFormattedTextField();
        txtAdjustQty.setDataType(1);
        txtAdjustQty.setPrecision(4);
        txtAdjustQty.setHorizontalAlignment(4);
        this.kdtEntries.getColumn("qty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAdjustQty));
        KDTDefaultCellEditor obj = (KDTDefaultCellEditor)this.kdtEntries.getColumn("amount").getEditor();
        KDFormattedTextField txtField = (KDFormattedTextField)obj.getComponent();
        txtField.setDataType(1);
        txtField.setRemoveingZeroInDispaly(false);
        txtField.setNegatived(true);
        this.kdtEntries.getColumn("seq").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("costItem.name").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("contUnit").getStyleAttributes().setLocked(true);
        try {
            this.setQtyPriceColumnPrecision();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setQtyPriceColumnPrecision() throws EASBizException, BOSException {
        ExpenseInfo expense = null;
        MeasureUnitInfo unit = null;
        int qtyPrecision = 8;
        int pricePrecision = 8;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            if (row.getCell("expense").getValue() instanceof ExpenseInfo) {
                expense = (ExpenseInfo)row.getCell("expense").getValue();
                if (expense != null) {
                    pricePrecision = expense.getPricePrecision();
                    if (expense.getUnit() != null) {
                        unit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(expense.getUnit().getId().toString()));
                        qtyPrecision = unit.getQtyPrecision();
                    }
                    boolean isAllocQty = expense.isIsAllocateQty();
                    row.getCell("qty").getStyleAttributes().setLocked(!isAllocQty);
                    row.getCell("price").getStyleAttributes().setLocked(!isAllocQty);
                } else {
                    row.getCell("qty").getStyleAttributes().setLocked(false);
                    row.getCell("price").getStyleAttributes().setLocked(false);
                }
            }
            row.getCell("qty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)qtyPrecision));
            row.getCell("price").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)pricePrecision));
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuTable1.setVisible(false);
        this.menuWorkflow.setVisible(false);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected void prmtExpense_dataChanged(KDTEditEvent e) throws Exception {
        int i;
        int rowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntries.getRow(rowIndex);
        Object newValue = this.prmtExpense.getData();
        ArrayList<Object> expenses = new ArrayList<Object>();
        if (newValue instanceof ExpenseInfo) {
            expenses.add(newValue);
        } else if (newValue instanceof Object[]) {
            Object[] temp = (Object[])newValue;
            for (i = 0; i < temp.length; ++i) {
                if (temp[i] == null || !(temp[i] instanceof ExpenseInfo)) continue;
                expenses.add(temp[i]);
            }
        } else {
            row.getCell("expense").setValue(null);
            return;
        }
        try {
            int newIndex = -1;
            for (i = 0; i < expenses.size(); ++i) {
                IRow newRow = null;
                if (i == 0) {
                    newIndex = rowIndex;
                    newRow = row;
                } else {
                    newRow = this.insertRow(newIndex);
                }
                ExpenseInfo info = (ExpenseInfo)expenses.get(i);
                newRow.getCell("expense").setValue((Object)info);
                newRow.getCell("expense.name").setValue((Object)info.getName());
                CostItemInfo ci = NCMUtils.getCostItemByExpense(null, (String)info.getId().toString(), (String)((CompanyOrgUnitInfo)this.prmtCompanyOrg.getData()).getId().toString());
                if (ci != null) {
                    this.kdtEntries.getCell(newIndex, "costItem.number").setValue((Object)ci);
                    this.kdtEntries.getCell(newIndex, "costItem.name").setValue((Object)ci.getName());
                } else {
                    this.kdtEntries.getCell(newIndex, "costItem.number").setValue(null);
                    this.kdtEntries.getCell(newIndex, "costItem.name").setValue(null);
                }
                int pricePrecision = info.getPricePrecision();
                int qtyPrecision = 4;
                if (info.getUnit() != null) {
                    String unitId = info.getUnit().getId().toString();
                    MeasureUnitInfo unit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitId));
                    this.kdtEntries.getRow(newIndex).getCell("contUnit").setValue((Object)unit.getName());
                    qtyPrecision = unit.getQtyPrecision();
                }
                boolean isAllocQty = info.isIsAllocateQty();
                this.kdtEntries.getRow(newIndex).getCell("qty").getStyleAttributes().setLocked(!isAllocQty);
                this.kdtEntries.getRow(newIndex).getCell("price").getStyleAttributes().setLocked(!isAllocQty);
                String qtyPrecisionStr = PrecisionUtil.getFormatString((int)qtyPrecision);
                String pricePrecisionStr = PrecisionUtil.getFormatString((int)pricePrecision);
                KDTDefaultCellEditor obj = (KDTDefaultCellEditor)this.kdtEntries.getColumn("qty").getEditor();
                KDFormattedTextField txtField = (KDFormattedTextField)obj.getComponent();
                txtField.setPrecision(qtyPrecision);
                this.kdtEntries.getCell(newIndex, "qty").getStyleAttributes().setNumberFormat(qtyPrecisionStr);
                this.kdtEntries.getCell(newIndex, "price").getStyleAttributes().setNumberFormat(pricePrecisionStr);
                ++newIndex;
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
    }

    protected IRow insertRow(int rowIndex) {
        IRow irow = null;
        KDTable kdtEntries = this.getDetailTable();
        if (kdtEntries == null) {
            return irow;
        }
        IObjectValue detailData = this.createNewDetailData(kdtEntries);
        irow = kdtEntries.addRow(rowIndex);
        this.loadLineFields(kdtEntries, irow, detailData);
        this.afterInsertLine(kdtEntries, detailData);
        return irow;
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        int qtyPrecision = 8;
        int pricePrecision = 8;
        if (e.getValue() instanceof CostItemInfo) {
            CostItemInfo ci = (CostItemInfo)e.getValue();
            this.kdtEntries.getCell(row, "costItem.name").setValue((Object)ci.getName());
            return;
        }
        if (e.getOldValue() instanceof CostItemInfo) {
            this.kdtEntries.getCell(row, "costItem.name").setValue(null);
            return;
        }
        if (e.getValue() instanceof Object[]) {
            this.prmtExpense_dataChanged(e);
        }
        String column = this.kdtEntries.getColumnKey(e.getColIndex());
        BigDecimal price = SysConstant.BIGZERO;
        if ("qty".equals(column) || "price".equals(column)) {
            BigDecimal qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"qty");
            price = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"price");
            BigDecimal amount = qty.multiply(price);
            this.kdtEntries.getCell(row, "amount").setValue((Object)amount);
        } else if ("amount".equals(column)) {
            BigDecimal amount = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"amount");
            BigDecimal qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"qty");
            if (qty.compareTo(SysConstant.BIGZERO) != 0) {
                price = amount.divide(qty, 4);
            }
            this.kdtEntries.getCell(row, "price").setValue((Object)price);
        }
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.kdtEntries, new String[]{"qty", "amount"});
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CCOFeeBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        CCOFeeBillInfo objectValue = new CCOFeeBillInfo();
        super.applyBillDefaultValue((IObjectValue)objectValue);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        CCOFeeBillEntryInfo entry = new CCOFeeBillEntryInfo();
        entry.setAmount(SysConstant.BIGZERO);
        return entry;
    }

    protected String[] getValidateColumns() {
        return new String[]{"costItem.number"};
    }

    protected void checkValidDataForSubmit() throws Exception {
        super.checkValidDataForSubmit();
        BDCMClientUtils.checkIsNull((JComponent)this.prmtCostCenterGroup, (String)this.contCostCenterGroup.getBoundLabelText());
        int rowCount = this.kdtEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object val = this.kdtEntries.getCell(i, "costItem.number").getValue();
            if (val == null || "".equals(val)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"31_CCOFeeBillEditUI"));
                SysUtil.abort();
            }
            if ((val = this.kdtEntries.getCell(i, "expense").getValue()) == null || "".equals(val)) {
                MsgBox.showInfo((String)"\u8981\u7d20\u8d39\u7528\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                SysUtil.abort();
            }
            if (!((val = this.kdtEntries.getCell(i, "amount").getValue()) instanceof BigDecimal) || SysConstant.BIGZERO.compareTo((BigDecimal)val) != 0) continue;
            MsgBox.showInfo((String)NCMClientUtils.getNcmBillResource((String)"AmountCannotBeZero"));
            SysUtil.abort();
        }
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.comboBillStatus.getSelectedItem() != null && this.comboBillStatus.getSelectedItem().toString().equals("\u5ba1\u6838")) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("CCOFeeBill_Aduit");
        }
        super.auditAction_actionPerformed(e);
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        super.unauditAction_actionPerformed(e);
        this.setQtyColumLock();
        this.setOprtState("EDIT");
        this.unLockUI();
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    private void setQtyColumLock() {
        ExpenseInfo expense = null;
        Object unit = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            if (row.getCell("expense").getValue() instanceof ExpenseInfo) {
                expense = (ExpenseInfo)row.getCell("expense").getValue();
            }
            boolean isAllocQty = expense != null && expense.isIsAllocateQty();
            row.getCell("qty").getStyleAttributes().setLocked(!isAllocQty);
            row.getCell("price").getStyleAttributes().setLocked(!isAllocQty);
        }
    }
}

