/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.CCOFeeBillFilterParam;
import com.kingdee.eas.ncm.bill.CCOFeeBillInfo;
import com.kingdee.eas.ncm.bill.client.AbstractCCOFeeBillFiterUI;
import com.kingdee.eas.ncm.bill.client.ActualHourFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class CCOFeeBillFiterUI
extends AbstractCCOFeeBillFiterUI {
    private static final Logger logger = CoreUIObject.getLogger(ActualHourFilterUI.class);
    private static final int PERIOD_MAX_MONTH = 12;
    private String CCOFeeBillFrom = "ccoFeeBillFrom";
    private String CCOFeeBillTo = "ccoFeeBillTo";
    private String BizDateFrom = "bizDateFrom";
    private String BizDateTo = "bizDateTo";
    private String PeriodFrom = "periodFrom";
    private String PeriodTo = "periodTo";
    private String CostCenterGroupFrom = "costCenterGroupFrom";
    private String CostCenterGroupTo = "costCenterGroupTo";
    private String ExpenseFrom = "expenseFrom";
    private String ExpenseTo = "expenseTo";
    private String CostItemFrom = "costItemFrom";
    private String CostItemTo = "costItemTo";
    private String BillSate = "billSate";
    private PeriodInfo periodStart;
    private PeriodInfo periodCur;

    public void onLoad() throws Exception {
        super.onLoad();
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.formatUI();
    }

    private void formatUI() throws Exception {
        this.initBizDate(this.dpBizDateFrom);
        this.initBizDate(this.dpBizDateTo);
        this.initCompany(this.getCompanyOrgInfoWithDefault());
        this.initPeriod();
        EntityViewInfo costItemview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ItemType", (Object)"1", CompareType.NOTEQUALS));
        costItemview.setFilter(filter);
        this.prtCostItemFrom.setEntityViewInfo(costItemview);
        this.prtCostItemTo.setEntityViewInfo(costItemview);
    }

    private void initPeriod() throws EASBizException, BOSException {
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        if (this.periodStart == null || this.periodCur == null) {
            return;
        }
        int minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initFromPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
    }

    public CCOFeeBillFilterParam getFilterParam() {
        CCOFeeBillFilterParam filterParam = (CCOFeeBillFilterParam)this.createNewFilterParam();
        this.storeFilterParam((NCMIFilterParam)filterParam);
        return filterParam;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new CCOFeeBillFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof CCOFeeBillFilterParam)) {
            return;
        }
        CCOFeeBillFilterParam fp = (CCOFeeBillFilterParam)filterParam;
        CCOFeeBillInfo bnFrom = null;
        CCOFeeBillInfo bnTo = null;
        String CCOFeeBillFromData = customerParams.getCustomerParam(this.CCOFeeBillFrom);
        String CCOFeeBillToData = customerParams.getCustomerParam(this.CCOFeeBillTo);
        if (CCOFeeBillFromData != null && CCOFeeBillFromData.length() > 0) {
            bnFrom = new CCOFeeBillInfo();
            bnFrom.setId(BOSUuid.read((String)CCOFeeBillFromData));
        }
        if (CCOFeeBillToData != null && CCOFeeBillToData.length() > 0) {
            bnTo = new CCOFeeBillInfo();
            bnTo.setId(BOSUuid.read((String)CCOFeeBillToData));
        }
        fp.setCcoFeeBillInfoFrom(bnFrom);
        fp.setCcoFeeBillInfoTo(bnTo);
        String bizDateFromData = customerParams.getCustomerParam(this.BizDateFrom);
        String bizDateToData = customerParams.getCustomerParam(this.BizDateTo);
        fp.setBizDateFrom(Long.parseLong(bizDateFromData));
        fp.setBizDateTo(Long.parseLong(bizDateToData));
        String periodFromData = customerParams.getCustomerParam(this.PeriodFrom);
        String periodToData = customerParams.getCustomerParam(this.PeriodTo);
        fp.setPeriodFrom(periodFromData);
        fp.setPeriodTo(periodToData);
        CostCenterOrgUnitGroupInfo ccFrom = null;
        CostCenterOrgUnitGroupInfo ccTo = null;
        String costCenterGroupFromData = customerParams.getCustomerParam(this.CostCenterGroupFrom);
        String costCenterGroupToData = customerParams.getCustomerParam(this.CostCenterGroupTo);
        if (costCenterGroupFromData != null && costCenterGroupFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitGroupInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterGroupFromData));
        }
        if (costCenterGroupToData != null && costCenterGroupToData.length() > 0) {
            ccTo = new CostCenterOrgUnitGroupInfo();
            ccTo.setId(BOSUuid.read((String)costCenterGroupToData));
        }
        fp.setCostCenterGroupFrom(ccFrom);
        fp.setCostCenterGroupTo(ccTo);
        ExpenseInfo cbFrom = null;
        ExpenseInfo cbTo = null;
        String expenseFromData = customerParams.getCustomerParam(this.ExpenseFrom);
        String expenseToData = customerParams.getCustomerParam(this.ExpenseTo);
        if (expenseFromData != null && expenseFromData.length() > 0) {
            cbFrom = new ExpenseInfo();
            cbFrom.setId(BOSUuid.read((String)expenseFromData));
        }
        if (expenseToData != null && expenseToData.length() > 0) {
            cbTo = new ExpenseInfo();
            cbTo.setId(BOSUuid.read((String)expenseToData));
        }
        fp.setExpenseFrom(cbFrom);
        fp.setExpenseTo(cbTo);
        CostItemInfo ciFrom = null;
        CostItemInfo ciTo = null;
        String costItemFromData = customerParams.getCustomerParam(this.CostItemFrom);
        String costItemctToData = customerParams.getCustomerParam(this.CostItemTo);
        if (costItemFromData != null && costItemFromData.length() > 0) {
            ciFrom = new CostItemInfo();
            ciFrom.setId(BOSUuid.read((String)costItemFromData));
        }
        if (costItemctToData != null && costItemctToData.length() > 0) {
            ciTo = new CostItemInfo();
            ciTo.setId(BOSUuid.read((String)costItemctToData));
        }
        fp.setCostItemFrom(ciFrom);
        fp.setCostItemTo(ciTo);
        String schemeState = customerParams.getCustomerParam(this.BillSate);
        if (schemeState != null && schemeState.length() > 0) {
            fp.setBillSate(schemeState);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        int minPeriod;
        if (!(filterParam instanceof CCOFeeBillFilterParam)) {
            return;
        }
        CCOFeeBillFilterParam fp = (CCOFeeBillFilterParam)filterParam;
        this.prtBillNumFrom.setData((Object)fp.getCcoFeeBillInfoFrom());
        this.prtBillNumTo.setData((Object)fp.getCcoFeeBillInfoTo());
        if (fp.getBizDateFrom() == 0L) {
            this.dpBizDateFrom.setValue(null);
        } else {
            this.dpBizDateFrom.setValue((Object)new Date(fp.getBizDateFrom()));
        }
        if (fp.getBizDateTo() == 0L) {
            this.dpBizDateTo.setValue(null);
        } else {
            this.dpBizDateTo.setValue((Object)new Date(fp.getBizDateTo()));
        }
        int initFromPeriod = minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        if (fp.getPeriodFrom() != null) {
            initFromPeriod = Integer.parseInt(fp.getPeriodFrom());
        }
        if (fp.getPeriodTo() != null) {
            initToPeriod = Integer.parseInt(fp.getPeriodTo());
        }
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
        this.prtCostcenterGroupFrom.setData((Object)fp.getCostCenterGroupFrom());
        this.prtCostcenterGroupTo.setData((Object)fp.getCostCenterGroupTo());
        this.prtExpenseFrom.setData((Object)fp.getExpenseFrom());
        this.prtExpenseTo.setData((Object)fp.getExpenseTo());
        this.prtCostItemFrom.setData((Object)fp.getCostItemFrom());
        this.prtCostItemTo.setData((Object)fp.getCostItemTo());
        this.combBillState.setSelectedIndex(Integer.parseInt(fp.getBillSate()));
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof CCOFeeBillFilterParam)) {
            return;
        }
        CCOFeeBillFilterParam fp = (CCOFeeBillFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getCcoFeeBillInfoFrom(), this.CCOFeeBillFrom);
        super.putIdByKey(customerParams, (Object)fp.getCcoFeeBillInfoTo(), this.CCOFeeBillTo);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateFrom()).toString(), this.BizDateFrom);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateTo()).toString(), this.BizDateTo);
        super.putIdByKey(customerParams, (Object)fp.getPeriodFrom(), this.PeriodFrom);
        super.putIdByKey(customerParams, (Object)fp.getPeriodTo(), this.PeriodTo);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterGroupFrom(), this.CostCenterGroupFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterGroupTo(), this.CostCenterGroupTo);
        super.putIdByKey(customerParams, (Object)fp.getExpenseFrom(), this.ExpenseFrom);
        super.putIdByKey(customerParams, (Object)fp.getExpenseTo(), this.ExpenseTo);
        super.putIdByKey(customerParams, (Object)fp.getCostItemFrom(), this.CostItemFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostItemTo(), this.CostItemTo);
        super.putIdByKey(customerParams, (Object)fp.getBillSate(), this.BillSate);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof CCOFeeBillFilterParam)) {
            return;
        }
        CCOFeeBillFilterParam fp = (CCOFeeBillFilterParam)filterParam;
        Object temp = null;
        CCOFeeBillInfo ccoFeeBillFrom = null;
        CCOFeeBillInfo ccoFeeBillTo = null;
        temp = this.prtBillNumFrom.getData();
        if (temp != null && temp instanceof CCOFeeBillInfo) {
            ccoFeeBillFrom = (CCOFeeBillInfo)temp;
        }
        if ((temp = this.prtBillNumTo.getData()) != null && temp instanceof CCOFeeBillInfo) {
            ccoFeeBillTo = (CCOFeeBillInfo)temp;
        }
        fp.setCcoFeeBillInfoFrom(ccoFeeBillFrom);
        fp.setCcoFeeBillInfoTo(ccoFeeBillTo);
        long bizDateFrom = 0L;
        long bizDateTo = 0L;
        temp = this.dpBizDateFrom.getValue();
        if (temp != null && temp instanceof Date) {
            bizDateFrom = ((Date)temp).getTime();
        }
        if ((temp = this.dpBizDateTo.getValue()) != null && temp instanceof Date) {
            bizDateTo = ((Date)temp).getTime();
        }
        fp.setBizDateFrom(bizDateFrom);
        fp.setBizDateTo(bizDateTo);
        String periodFrom = null;
        String periodTo = null;
        temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = ((Integer)temp).toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = ((Integer)temp).toString();
        }
        fp.setPeriodFrom(periodFrom);
        fp.setPeriodTo(periodTo);
        CostCenterOrgUnitGroupInfo costCenterGroupFrom = null;
        CostCenterOrgUnitGroupInfo costCenterGroupTo = null;
        temp = this.prtCostcenterGroupFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitGroupInfo) {
            costCenterGroupFrom = (CostCenterOrgUnitGroupInfo)temp;
        }
        if ((temp = this.prtCostcenterGroupTo.getData()) != null && temp instanceof CostCenterOrgUnitGroupInfo) {
            costCenterGroupTo = (CostCenterOrgUnitGroupInfo)temp;
        }
        fp.setCostCenterGroupFrom(costCenterGroupFrom);
        fp.setCostCenterGroupTo(costCenterGroupTo);
        ExpenseInfo expenseFrom = null;
        ExpenseInfo expenseTo = null;
        temp = this.prtExpenseFrom.getData();
        if (temp != null && temp instanceof ExpenseInfo) {
            expenseFrom = (ExpenseInfo)temp;
        }
        if ((temp = this.prtExpenseTo.getData()) != null && temp instanceof ExpenseInfo) {
            expenseTo = (ExpenseInfo)temp;
        }
        fp.setExpenseFrom(expenseFrom);
        fp.setExpenseTo(expenseTo);
        CostItemInfo costItemFrom = null;
        CostItemInfo costItemTo = null;
        temp = this.prtCostItemFrom.getData();
        if (temp != null && temp instanceof CostItemInfo) {
            costItemFrom = (CostItemInfo)temp;
        }
        if ((temp = this.prtCostItemTo.getData()) != null && temp instanceof CostItemInfo) {
            costItemTo = (CostItemInfo)temp;
        }
        fp.setCostItemFrom(costItemFrom);
        fp.setCostItemTo(costItemTo);
        int selectIndex = this.combBillState.getSelectedIndex();
        fp.setBillSate(String.valueOf(selectIndex));
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        Date bizDateFrom = (Date)this.dpBizDateFrom.getValue();
        Date bizDateTo = (Date)this.dpBizDateTo.getValue();
        if (bizDateFrom != null && bizDateTo != null && bizDateFrom.equals(bizDateTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            bizDateTo.setHours(23);
            bizDateTo.setMinutes(59);
            bizDateTo.setSeconds(59);
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
        } else {
            if (bizDateFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            }
            if (bizDateTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
            }
        }
        int selectIndex = this.combBillState.getSelectedIndex();
        String billStatus = String.valueOf(selectIndex + 1);
        if (selectIndex != 0) {
            filterBiz.getFilterItems().add(new FilterItemInfo("billStatus", (Object)billStatus, CompareType.EQUALS));
        }
        String periodFrom = null;
        String periodTo = null;
        Object temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = temp.toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = temp.toString();
        }
        if (periodFrom != null && periodTo != null && periodFrom.equals(periodTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.EQUALS));
        } else {
            if (periodFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
            }
            if (periodTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
            }
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        try {
            this.clearFilterData();
            this.formatUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prtCompany.setValue((Object)companyOrg);
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(OrgType.getEnum((String)"Company"));
        CompanyOrgUnitInfo currentBizOrg = object == null ? this.getCompanyOrgInfoWithDefault() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    private void initBizDate(KDDatePicker kdDate) {
        kdDate.setValue(null);
    }

    private void clearFilterData() {
        this.prtBillNumFrom.setValue(null);
        this.prtBillNumTo.setValue(null);
        this.prtExpenseFrom.setValue(null);
        this.prtExpenseTo.setValue(null);
        this.prtCostcenterGroupFrom.setValue(null);
        this.prtCostcenterGroupTo.setValue(null);
        this.prtCostItemFrom.setValue(null);
        this.prtCostItemTo.setValue(null);
        this.combBillState.setSelectedIndex(0);
    }

    private void initPeriodSpinner(final JSpinner spFrom, final JSpinner spTo, int minPeriod, int initFromPeriod, int initToPeriod) {
        boolean argumentError = false;
        if (minPeriod <= 0) {
            argumentError = true;
        }
        String sMinPeriod = String.valueOf(minPeriod);
        if (!argumentError && sMinPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [minPeriod:" + minPeriod + "] error.");
        }
        argumentError = false;
        if (initFromPeriod <= 0 || initFromPeriod < minPeriod) {
            argumentError = true;
        }
        String sInitFromPeriod = String.valueOf(initFromPeriod);
        if (!argumentError && sInitFromPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initFromPeriod:" + initFromPeriod + "] error.");
        }
        argumentError = false;
        if (initToPeriod <= 0 || initToPeriod < minPeriod || initToPeriod < initFromPeriod) {
            argumentError = true;
        }
        String sInitToPeriod = String.valueOf(initToPeriod);
        if (!argumentError && sInitToPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initToPeriod:" + initToPeriod + "] error.");
        }
        final int minYear = Integer.parseInt(sMinPeriod.substring(0, 4));
        final int minMonth = Integer.parseInt(sMinPeriod.substring(4));
        SpinnerNumberModel modelFrom = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spTo.setValue(spFrom.getValue());
                }
            }
        };
        SpinnerNumberModel modelTo = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spFrom.setValue(spTo.getValue());
                }
            }
        };
        spFrom.setModel(modelFrom);
        spTo.setModel(modelTo);
        spFrom.setValue(initFromPeriod);
        spTo.setValue(initToPeriod);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterGroupF7(this.prtCostcenterGroupFrom);
        this.f7ContextManager.registerCostCenterGroupF7(this.prtCostcenterGroupTo);
        HashSet<Integer> extypes = new HashSet<Integer>();
        extypes.add(2);
        extypes.add(30);
        extypes.add(40);
        extypes.add(50);
        extypes.add(60);
        this.f7ContextManager.registerExpenseF7(this.prtExpenseFrom, extypes);
        this.f7ContextManager.registerExpenseF7(this.prtExpenseTo, extypes);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtBillNumFrom, "com.kingdee.eas.ncm.bill.app.CCOFeeFilterQuery", "companyOrg.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtBillNumTo, "com.kingdee.eas.ncm.bill.app.CCOFeeFilterQuery", "companyOrg.id");
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prtCostcenterGroupFrom.setData(null);
                this.prtCostcenterGroupTo.setData(null);
                this.prtBillNumFrom.setData(null);
                this.prtBillNumTo.setData(null);
                this.initPeriod();
                this.prtBillNumFrom.setDisplayFormat("$number$");
                this.prtBillNumTo.setDisplayFormat("$number$");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

