/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.CCOFeeBillFactory;
import com.kingdee.eas.ncm.bill.CCOFeeBillInfo;
import com.kingdee.eas.ncm.bill.IOtherFeeBill;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.client.AbstractCCOFeeBillListUI;
import com.kingdee.eas.ncm.bill.client.CCOFeeBillEditUI;
import com.kingdee.eas.ncm.bill.client.CCOFeeBillFiterUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CCOFeeBillListUI
extends AbstractCCOFeeBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(CCOFeeBillListUI.class);
    private CommonQueryDialog dialog = null;
    private CCOFeeBillFiterUI filterUI = null;

    public CCOFeeBillListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRowIndex = e.getFirstRow();
                int lastRowIndex = e.getLastRow();
                IRow row = null;
                int precision = 0;
                for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                    row = CCOFeeBillListUI.this.tblMain.getRow(i);
                    if (row.getCell("entries.amount") != null && row.getCell("entries.amount").getValue() != null) {
                        precision = ((BigDecimal)row.getCell("entries.amount").getValue()).scale();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.amount"), (int)precision);
                    }
                    if (row.getCell("entries.qty") != null && row.getCell("entries.qty").getValue() != null) {
                        precision = ((BigDecimal)row.getCell("entries.qty").getValue()).scale();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.qty"), (int)precision);
                    }
                    if (row.getCell("entries.price") == null || row.getCell("entries.price").getValue() == null) continue;
                    precision = ((BigDecimal)row.getCell("entries.price").getValue()).scale();
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("entries.price"), (int)precision);
                }
            }
        });
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CCOFeeBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        CCOFeeBillInfo objectValue = new CCOFeeBillInfo();
        return objectValue;
    }

    protected String getEditUIName() {
        return CCOFeeBillEditUI.class.getName();
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            while (rowSet.next()) {
                int precision = rowSet.getInt("baseCurrency.precision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.amount", (IRowSet)rowSet);
                precision = rowSet.getInt("unit.qtyPrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.qty", (IRowSet)rowSet);
                precision = rowSet.getInt("expense.pricePrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.price", (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "bizDate", "calculatePeriod.number", "companyOrg.name", "costCenterGroup.number", "costCenterGroup.name", "description", "expense.number", "expense.name", "unit.name", "creator.name", "createTime", "auditor.name", "auditTime", "lastUpdateUser.name", "lastUpdateTime", "sourceFunction", "department.number", "department.name"};
    }

    protected CommonQueryProcessor getCustomerCommonQueryProcessor() {
        CommonQueryProcessor cmcq = super.getCustomerCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
        return cmcq;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new CCOFeeBillFiterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.isAlloced()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"32_CCOFeeBillListUI"));
        } else {
            super.unauditAction_actionPerformed(e);
        }
    }

    private boolean isAlloced() throws BOSException {
        this.checkSelected();
        StringBuffer entriesId = new StringBuffer("(");
        String entrieId = "";
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                entrieId = row.getCell("entries.id").getValue().toString().trim();
                if (entrieId == null || "".equals(entrieId)) continue;
                entriesId.append("'").append(entrieId).append("'").append(j == size - 1 && i == num ? ")" : ",");
            }
        }
        IOtherFeeBill otherFeeBillIns = OtherFeeBillFactory.getRemoteInstance();
        return otherFeeBillIns.getBySourceId(entriesId.toString());
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell("entries.qty"), (int)4);
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell("entries.amount"), (int)this.getCurrencyPrecision());
    }

    private int getCurrencyPrecision() {
        int prec = 2;
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrgInfoWithDefault();
        try {
            prec = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrg.getBaseCurrency().getId())).getPrecision();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return prec;
    }

    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor test = super.getQueryExecutor(queryPK, viewInfo);
        return test;
    }
}

