/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.ClassPonderanceCollection;
import com.kingdee.eas.ncm.bill.ClassPonderanceFactory;
import com.kingdee.eas.ncm.bill.ClassPonderanceInfo;
import com.kingdee.eas.ncm.bill.IClassPonderance;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.client.AbstractClassPonderanceListUI;
import com.kingdee.eas.ncm.bill.client.AssignStandardDataFilterUI;
import com.kingdee.eas.ncm.bill.client.ClassPonderanceFilterUI;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ClassPonderanceListUI
extends AbstractClassPonderanceListUI {
    private static final Logger logger = CoreUIObject.getLogger(ClassPonderanceListUI.class);
    private static final String Col_ID = "id";
    private static final String Col_Coef = "coefficient";
    private static final String Col_IsDirty = "isDirty";
    private static final String Col_CompanyName = "company.name";
    private static final String Col_CompanyNumber = "company.number";
    private static final String Col_CostCenterName = "costCenter.name";
    private static final String Col_CostCenterNumber = "costCenter.number";
    private static final String Col_CostObjectNumber = "costObject.number";
    private static final String Col_CostObjectName = "costObject.name";
    private static final String Col_PeriodNumber = "calculatePeriod.number";
    private static final String Col_MaterialNumber = "material.number";
    private static final String Col_MaterialName = "material.name";
    private static final String Col_MaterialModel = "material.model";
    private static final int FirstRowIndex = 0;
    private CompanyOrgUnitInfo _company;
    private PeriodInfo _currPeriod;
    private ArrayList addObjList = new ArrayList();
    private ArrayList deletePkList = new ArrayList();
    private KDBizPromptBox prmtCostObject = null;
    private KDBizPromptBox prmtCostCenter = null;
    private KDBizPromptBox prmtMaterial = null;
    private boolean history = false;
    private final FillListener fillListener = new FillListener();
    private Map id2data = new HashMap();
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
                try {
                    if (!ClassPonderanceListUI.this.history) {
                        ClassPonderanceListUI.this.innerDoRemoveLine();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    ClassPonderanceListUI.this.handUIException(e);
                }
            } else if (arg0.getKeyCode() == 10) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }
    };
    private CommonQueryDialog dialog = null;
    private AssignStandardDataFilterUI filterUI = null;

    public ClassPonderanceListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    public void onLoad() throws Exception {
        this._company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        this._currPeriod = NCMUtils.GetCurrentPeriod(null, (String)this._company.getId().toString());
        super.onLoad();
        this.btnAuditResult.setEnabled(false);
        this.btnAuditResult.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCopyTo.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionSignature.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionWorkflowList.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionRefresh.setVisible(true);
        this.actionAddLine.setVisible(true);
        this.actionAddLine.setEnabled(true);
        this.actionInsertLine.setVisible(true);
        this.actionInsertLine.setEnabled(true);
        this.menuWorkFlow.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuItemSendSmsMessage.setVisible(false);
        this.actionRemoveLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionGen.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_createcatalog"));
        this.actionBatchSet.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.actionSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        this.actionSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.menuItemGen.setIcon(EASResource.getIcon((String)"imgTbtn_createcatalog"));
        this.menuItemBatchSet.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuItemInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
    }

    public void onShow() throws Exception {
        super.onShow();
        this.formatEntryTable();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        if (this.history) {
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionImportData.setEnabled(false);
            this.actionBatchSet.setEnabled(false);
            this.actionGen.setEnabled(false);
        } else {
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
            this.actionImportData.setEnabled(true);
            this.actionBatchSet.setEnabled(true);
            this.actionGen.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.formatEntryTable();
    }

    private void formatEntryTable() {
        KDFormattedTextField txtCoef = new KDFormattedTextField();
        txtCoef.setDataType(1);
        txtCoef.setPrecision(4);
        txtCoef.setHorizontalAlignment(4);
        txtCoef.setDecimalSeparatorAlwaysShown(true);
        txtCoef.setRemoveingZeroInDispaly(true);
        this.tblMain.getColumn(Col_Coef).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtCoef));
        this.tblMain.getColumn(Col_Coef).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)4));
        this.tblMain.getColumn(Col_Coef).setRequired(true);
        this.tblMain.getColumn(Col_Coef).getStyleAttributes().setLocked(this.history);
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    public String[] getMergeColumnKeys() {
        return new String[]{Col_CompanyName, "costCenter.id", Col_CostCenterNumber, Col_CostCenterName, "costObject.id", Col_CostObjectNumber, Col_CostObjectName};
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ClassPonderanceFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return Col_ID;
    }

    protected IObjectValue createNewData() {
        ClassPonderanceInfo objectValue = new ClassPonderanceInfo();
        return objectValue;
    }

    protected void initTableParams() {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(1);
        KDTableHelper.releaseTab((JComponent)this.tblMain);
    }

    @Override
    public void actionBatchSet_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows;
        super.actionBatchSet_actionPerformed(e);
        if (this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"13_AllocStdSetByWIPListUI"));
            SysUtil.abort();
        }
        if ((selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)) == null || selectRows.length <= 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"14_AllocStdSetByWIPListUI"));
            SysUtil.abort();
        }
        ICell first = this.tblMain.getRow(selectRows[0]).getCell(Col_Coef);
        BigDecimal firstValue = null;
        firstValue = first.getValue() instanceof BigDecimal ? (BigDecimal)first.getValue() : BigDecimal.valueOf(0L);
        IRow row = null;
        for (int i = 1; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            if (row.getCell(Col_ID).getValue() != null) {
                String id = row.getCell(Col_ID).getValue().toString();
                BigDecimal oldVal = null;
                oldVal = row.getCell(Col_Coef).getValue() instanceof BigDecimal ? (BigDecimal)row.getCell(Col_Coef).getValue() : BigDecimal.valueOf(0L);
                BigDecimal[] values = null;
                if (this.id2data.containsKey(id)) {
                    values = (BigDecimal[])this.id2data.get(id);
                    values[1] = firstValue;
                    this.id2data.put(id, values);
                } else {
                    this.id2data.put(id, new BigDecimal[]{oldVal, firstValue});
                }
            }
            row.getCell(Col_Coef).setValue((Object)firstValue);
            ICell isDirty = row.getCell(Col_IsDirty);
            isDirty.setValue((Object)String.valueOf(true));
        }
        this.actionSave.setEnabled(true);
    }

    @Override
    public void actionGen_actionPerformed(ActionEvent e) throws Exception {
        super.actionGen_actionPerformed(e);
        this.checkMustToSave();
        if (MsgBox.isOk((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BillResource", (String)"GenInfo")))) {
            HashMap<String, Object> listenerParam = new HashMap<String, Object>();
            listenerParam.put("company", this._company);
            listenerParam.put("period", this._currPeriod);
            genProgressHintListener listener = new genProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, listenerParam);
            this.refreshList();
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        this.innerDoRemoveLine();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkValidData();
        super.actionSave_actionPerformed(e);
        try {
            this.updateDataSetting();
            this.refreshList();
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)ex.getMessage(), (int)8188);
            SysUtil.abort();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkMustToSave();
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable() != null) {
            this.addLine(this.getDetailTable(), 0);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        KDTSelectBlock selectBlock = selectManager.get(0);
        if (selectManager.size() == 0 || selectBlock.getBeginRow() == -1) {
            this.addLine(this.getDetailTable(), 0);
        } else if (selectManager.size() > 0) {
            int inserRowIndex = selectBlock.getBeginRow();
            this.addLine(this.getDetailTable(), inserRowIndex);
        }
    }

    private void progressDoRemoveLine() throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            DeleteProgressHintListener listener = new DeleteProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, null);
            this.refreshList();
        }
    }

    private void innerDoRemoveLine() throws Exception {
        this.checkSelected();
        this.removeLine(this.tblMain);
        if (this.tblMain.getRowCount() == 0) {
            this.tblMain.reLayoutAndPaint();
        }
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                int i;
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                if (8 == selectBlock.getMode()) {
                    for (i = 0; i < table.getRowCount(); ++i) {
                        indexSet.add(i);
                    }
                    continue;
                }
                for (i = top; i <= bottom; ++i) {
                    indexSet.add(i);
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            table.setRefresh(false);
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                ObjectSingleKey opk = new ObjectSingleKey(Col_ID, table.getRow(rowIndex).getCell(Col_ID).getValue());
                if (opk.getKeyValue(opk.getKeyFields()[0]) != null) {
                    this.deletePkList.add(opk);
                }
                this.actionSave.setEnabled(true);
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null || (index = this.getCollectionIndex(collection, detailData)) < 0 || collection.size() <= index) continue;
                collection.removeObject(index);
            }
            table.setRefresh(true);
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0, 0, 0);
            } else {
                this.actionRemoveLine.setEnabled(false);
                this.actionBatchSet.setEnabled(false);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    private void checkMustToSave() throws Exception {
        if (this.CheckDirty()) {
            int ret = MsgBox.showConfirm3((String)NCMClientUtils.getNcmBillResource((String)"CHECK_DIRTY"));
            if (ret == 0) {
                try {
                    IPermission iPer = PermissionFactory.getRemoteInstance();
                    iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString())), (IObjectPK)new ObjectUuidPK(this._company.getId().toString()), "ClassPonderance_Save");
                    this.checkValidData();
                    this.updateDataSetting();
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)e.getMessage(), (int)8188);
                    SysUtil.abort();
                }
                catch (EASBizException e1) {
                    logger.error((Object)"", (Throwable)e1);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)e1.getMessage(), (int)8188);
                    SysUtil.abort();
                }
            } else if (ret == 2) {
                SysUtil.abort();
            }
        }
    }

    private boolean CheckDirty() {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            return false;
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell isDirty = row.getCell(Col_IsDirty);
            if (isDirty.getValue() == null || !isDirty.getValue().toString().equals(String.valueOf(true))) continue;
            return true;
        }
        return false;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev.getSorter().size() == 0) {
            SorterItemCollection sort = ev.getSorter();
            sort.add(new SorterItemInfo(Col_CompanyName));
            sort.add(new SorterItemInfo(Col_CostCenterNumber));
            sort.add(new SorterItemInfo(Col_CostObjectNumber));
            sort.add(new SorterItemInfo(Col_MaterialNumber));
        }
        this.history = false;
        if (this.filterUI != null && this.filterUI.getFilterParam().isHistory()) {
            this.history = true;
        }
        try {
            String period = this._currPeriod.getId().toString();
            FilterInfo filter = new FilterInfo();
            if (!this.history) {
                filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)period));
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this._company.getId().toString()));
            try {
                ev.getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.tblMain.getColumn(Col_Coef).getStyleAttributes().setLocked(this.history);
        super.beforeExcutQuery(ev);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
        this.tblMain.addKeyListener(this.keyListener);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkMustToSave();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
            if (this.getFilterUI() != null) {
                this.dialog.addUserPanel((KDPanel)this.getFilterUI());
            }
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", (Object)"ClassPonderanceQuery");
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new ClassPonderanceFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int colCostObjectIndex = this.tblMain.getCell(e.getRowIndex(), Col_CostObjectNumber).getColumnIndex();
        if (e.getValue() instanceof CostObjectInfo) {
            CostObjectInfo costObjectInfo = (CostObjectInfo)e.getValue();
            this.tblMain.getCell(e.getRowIndex(), Col_CostObjectName).setValue((Object)costObjectInfo.getName());
            this.actionSave.setEnabled(true);
        } else if (e.getValue() == null && e.getColIndex() == colCostObjectIndex) {
            this.tblMain.getCell(e.getRowIndex(), Col_CostObjectName).setValue((Object)"");
        }
        int colCostCenterIndex = this.tblMain.getCell(e.getRowIndex(), Col_CostCenterNumber).getColumnIndex();
        if (e.getValue() instanceof CostCenterOrgUnitInfo) {
            CostCenterOrgUnitInfo CostCenter = (CostCenterOrgUnitInfo)e.getValue();
            this.tblMain.getCell(e.getRowIndex(), Col_CostCenterName).setValue((Object)CostCenter.getName());
            this.actionSave.setEnabled(true);
        } else if (e.getValue() == null && e.getColIndex() == colCostCenterIndex) {
            this.tblMain.getCell(e.getRowIndex(), Col_CostCenterName).setValue((Object)"");
        }
        int colMaterialIndex = this.tblMain.getCell(e.getRowIndex(), Col_MaterialNumber).getColumnIndex();
        if (e.getValue() instanceof MaterialInfo) {
            MaterialInfo materialInfo = (MaterialInfo)e.getValue();
            this.tblMain.getCell(e.getRowIndex(), Col_MaterialName).setValue((Object)materialInfo.getName());
            this.tblMain.getCell(e.getRowIndex(), Col_MaterialModel).setValue((Object)materialInfo.getModel());
            this.actionSave.setEnabled(true);
        } else if (e.getValue() == null && e.getColIndex() == colMaterialIndex) {
            this.tblMain.getCell(e.getRowIndex(), Col_MaterialName).setValue((Object)"");
        }
        if (e.getColIndex() == this.tblMain.getColumnIndex(Col_Coef)) {
            ICell cell = this.tblMain.getRow(e.getRowIndex()).getCell(Col_IsDirty);
            if (e.getOldValue() != e.getValue() || e.getValue() instanceof MaterialInfo) {
                cell.setValue((Object)String.valueOf(true));
                this.actionSave.setEnabled(true);
            }
        }
        super.tblMain_editStopped(e);
    }

    private void updateDataSetting() throws Exception {
        IRow row;
        int i;
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0 && this.deletePkList.size() == 0) {
            return;
        }
        HashMap<Object, BigDecimal> data = new HashMap<Object, BigDecimal>();
        for (i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            ICell id = row.getCell(Col_ID);
            ICell coef = row.getCell(Col_Coef);
            ICell isDirty = row.getCell(Col_IsDirty);
            BigDecimal value = null;
            if (!isDirty.getValue().toString().equals(String.valueOf(true))) continue;
            if (coef.getValue() instanceof BigDecimal && id.getValue() != null) {
                value = (BigDecimal)coef.getValue();
            }
            if ((value == null || value.compareTo(BigDecimal.valueOf(0L)) < 0) && id.getValue() != null) {
                throw new NcmBillException(NcmBillException.CHECK_POND_LESSTHAN_ZERO);
            }
            if (id.getValue() == null) {
                ClassPonderanceInfo classPonderanceInfo = new ClassPonderanceInfo();
                classPonderanceInfo.setId(BOSUuid.create((BOSObjectType)classPonderanceInfo.getBOSType()));
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)row.getCell(Col_CompanyNumber).getValue();
                classPonderanceInfo.setCompany(companyInfo);
                CostCenterOrgUnitInfo costcenterInfo = (CostCenterOrgUnitInfo)row.getCell(Col_CostCenterNumber).getValue();
                classPonderanceInfo.setCostCenter(costcenterInfo);
                CostObjectInfo costCenterInfo = (CostObjectInfo)row.getCell(Col_CostObjectNumber).getValue();
                classPonderanceInfo.setCostObject(costCenterInfo);
                MaterialInfo materialInfo = (MaterialInfo)row.getCell(Col_MaterialNumber).getValue();
                classPonderanceInfo.setMaterial(materialInfo);
                if (coef.getValue() instanceof BigDecimal) {
                    value = (BigDecimal)coef.getValue();
                    classPonderanceInfo.setCoefficient(value);
                }
                if (value != null && value.compareTo(BigDecimal.valueOf(0L)) < 0) {
                    throw new NcmBillException(NcmBillException.CHECK_COEF_BETWEEN_ZERO_ONE);
                }
                this.addObjList.add(classPonderanceInfo);
            }
            if (value == null || id.getValue() == null) continue;
            data.put(id.getValue(), value);
        }
        try {
            ClassPonderanceFactory.getRemoteInstance().UpdateCoefSetting(data, this.deletePkList, this.addObjList);
            this.deletePkList.clear();
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            data.clear();
            this.addObjList.clear();
        }
        for (i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            ICell isDirty = row.getCell(Col_IsDirty);
            if (!isDirty.getValue().toString().equals(String.valueOf(true))) continue;
            isDirty.setValue((Object)String.valueOf(false));
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int qryPre = 8;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                NCMClientUtils.iniColumnsPrecision((int)qryPre, (String[])new String[]{Col_Coef}, (IRowSet)rowSet);
                if (rowSet.getBigDecimal(Col_Coef) != null) continue;
                rowSet.updateObject(Col_Coef, (Object)BigDecimal.valueOf(0L));
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected boolean isShowAttachmentAction() {
        return false;
    }

    protected void addLine(KDTable table, int rowIndex) throws Exception {
        if (table == null) {
            return;
        }
        if (this.tblMain.getRowCount() == 0) {
            this.actionRemoveLine.setEnabled(true);
        }
        IRow row = table.addRow(rowIndex);
        this.formatAddline(row);
    }

    private void formatAddline(IRow row) throws Exception {
        row.getCell(Col_IsDirty).setValue((Object)String.valueOf(true));
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        row.getCell(Col_CompanyName).setValue((Object)companyInfo.getName());
        row.getCell(Col_CompanyNumber).setValue((Object)companyInfo);
        this.prmtCostCenter = new KDBizPromptBox();
        this.prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        this.prmtCostCenter.setVisible(true);
        this.prmtCostCenter.setEditable(true);
        this.prmtCostCenter.setDisplayFormat("$number$");
        this.prmtCostCenter.setEditFormat("$number$");
        this.prmtCostCenter.setCommitFormat("$number$");
        this.filterCostCenterByOrg(this.prmtCostCenter);
        this.prmtCostCenter.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    ClassPonderanceListUI.this.filtExsitCostCenter(e);
                }
                catch (Exception e1) {
                    ClassPonderanceListUI.this.handUIException(e1);
                }
            }
        });
        KDTDefaultCellEditor cellCostCenter = new KDTDefaultCellEditor((IKDEditor)this.prmtCostCenter);
        ObjectValueRender ovrCostCenter = new ObjectValueRender();
        ovrCostCenter.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_CostCenterNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_CostCenterNumber).setEditor((ICellEditor)cellCostCenter);
        row.getCell(Col_CostCenterNumber).setRenderer((IBasicRender)ovrCostCenter);
        this.prmtCostObject = new KDBizPromptBox();
        this.prmtCostObject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        this.prmtCostObject.setVisible(true);
        this.prmtCostObject.setEditable(true);
        this.prmtCostObject.setDisplayFormat("$number$");
        this.prmtCostObject.setEditFormat("$number$");
        this.prmtCostObject.setCommitFormat("$number$");
        CostObjectF7UISelector selector = new CostObjectF7UISelector((Object)this, this.prmtCostObject, Boolean.TRUE);
        this.prmtCostObject.setSelector((KDPromptSelector)selector);
        this.filterCostObjectByOrg(this.prmtCostObject);
        this.prmtCostObject.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    ClassPonderanceListUI.this.filtExsitCostObject(e);
                }
                catch (Exception e1) {
                    ClassPonderanceListUI.this.handUIException(e1);
                }
            }
        });
        KDTDefaultCellEditor cellCostObject = new KDTDefaultCellEditor((IKDEditor)this.prmtCostObject);
        ObjectValueRender ovrCostObject = new ObjectValueRender();
        ovrCostObject.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_CostObjectNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_CostObjectNumber).setEditor((ICellEditor)cellCostObject);
        row.getCell(Col_CostObjectNumber).setRenderer((IBasicRender)ovrCostObject);
        this.prmtMaterial = new KDBizPromptBox();
        this.prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery");
        this.prmtMaterial.setVisible(true);
        this.prmtMaterial.setEditable(true);
        this.prmtMaterial.setDisplayFormat("$number$");
        this.prmtMaterial.setEditFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$");
        this.filterMaterial(this.prmtMaterial, row);
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    ClassPonderanceListUI.this.filtExsitMaterial(e);
                }
                catch (Exception e1) {
                    ClassPonderanceListUI.this.handUIException(e1);
                }
            }
        });
        KDTDefaultCellEditor cellMaterial = new KDTDefaultCellEditor((IKDEditor)this.prmtMaterial);
        ObjectValueRender ovrMaterial = new ObjectValueRender();
        ovrMaterial.setFormat((IDataFormat)new BizDataFormat("$number$"));
        row.getCell(Col_MaterialNumber).getStyleAttributes().setLocked(false);
        row.getCell(Col_MaterialNumber).setEditor((ICellEditor)cellMaterial);
        row.getCell(Col_MaterialNumber).setRenderer((IBasicRender)ovrMaterial);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    private void filtExsitCostCenter(SelectorEvent e) throws Exception {
        int selectRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        MaterialInfo materialInfo = (MaterialInfo)this.tblMain.getCell(selectRowIndex, Col_MaterialNumber).getValue();
        CostObjectInfo costObjectInfo = (CostObjectInfo)this.tblMain.getCell(selectRowIndex, Col_CostObjectNumber).getValue();
        KDBizPromptBox prmt = (KDBizPromptBox)this.tblMain.getRow(selectRowIndex).getCell(Col_CostCenterNumber).getEditor().getComponent();
        EntityViewInfo initEvi = new EntityViewInfo();
        prmt.setEntityViewInfo(initEvi);
        this.filterCostCenterByOrg(prmt);
        if (materialInfo == null || costObjectInfo == null) {
            return;
        }
        String materialNumber = materialInfo.getNumber();
        String costObjectNumber = costObjectInfo.getNumber();
        HashSet<String> setCostCenter = new HashSet<String>();
        setCostCenter.clear();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object id = this.tblMain.getCell(i, Col_ID).getValue();
            if (selectRowIndex == i || id != null) continue;
            IRow row = this.tblMain.getRow(i);
            String materialExsitNumber = null;
            String costObjectExsitNumber = null;
            materialExsitNumber = row.getCell(Col_MaterialNumber).getValue() instanceof MaterialInfo ? ((MaterialInfo)row.getCell(Col_MaterialNumber).getValue()).getNumber() : (String)row.getCell(Col_MaterialNumber).getValue();
            costObjectExsitNumber = row.getCell(Col_CostObjectNumber).getValue() instanceof CostObjectInfo ? ((CostObjectInfo)row.getCell(Col_CostObjectNumber).getValue()).getNumber() : (String)row.getCell(Col_CostObjectNumber).getValue();
            if (row.getCell(Col_CostCenterNumber).getValue() == null || !materialNumber.equals(materialExsitNumber) || !costObjectNumber.equals(costObjectExsitNumber)) continue;
            String infoNumber = null;
            infoNumber = row.getCell(Col_CostCenterNumber).getValue() instanceof CostCenterOrgUnitInfo ? ((CostCenterOrgUnitInfo)row.getCell(Col_CostCenterNumber).getValue()).getId().toString() : (String)row.getCell(Col_CostCenterNumber).getValue();
            if (infoNumber == null) continue;
            setCostCenter.add(infoNumber);
        }
        FilterInfo filterPeriod = new FilterInfo();
        FilterInfo filterCompany = new FilterInfo();
        filterPeriod.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this._currPeriod.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)this._company.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("costObject.id", (Object)costObjectInfo.getId().toString(), CompareType.EQUALS));
        filterPeriod.mergeFilter(filterCompany, "AND");
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filterPeriod);
        IClassPonderance iClassPonderance = ClassPonderanceFactory.getRemoteInstance();
        ClassPonderanceCollection collection = iClassPonderance.getClassPonderanceCollection(eviData);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            ClassPonderanceInfo classPonderanceInfo = (ClassPonderanceInfo)iter.next();
            String materialID = classPonderanceInfo.getMaterial().getId().toString();
            String costObjectID = classPonderanceInfo.getCostObject().getId().toString();
            if (!materialID.equals(materialInfo.getId().toString()) || !costObjectID.equals(costObjectInfo.getId().toString())) continue;
            setCostCenter.add(classPonderanceInfo.getCostCenter().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        if (setCostCenter.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(Col_ID, setCostCenter, CompareType.NOTINCLUDE));
        }
        FilterInfo filterByOrg = prmt.getEntityViewInfo().getFilter();
        filter.mergeFilter(filterByOrg, "AND");
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filter);
        prmt.getQueryAgent().resetRuntimeEntityView();
        prmt.setEntityViewInfo(newEvi);
    }

    private void filtExsitCostObject(SelectorEvent e) throws Exception {
        int selectRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        CostCenterOrgUnitInfo costCenterInfo = (CostCenterOrgUnitInfo)this.tblMain.getCell(selectRowIndex, Col_CostCenterNumber).getValue();
        MaterialInfo materialInfo = (MaterialInfo)this.tblMain.getCell(selectRowIndex, Col_MaterialNumber).getValue();
        KDBizPromptBox prmt = (KDBizPromptBox)this.tblMain.getRow(selectRowIndex).getCell(Col_CostObjectNumber).getEditor().getComponent();
        EntityViewInfo initEvi = new EntityViewInfo();
        prmt.setEntityViewInfo(initEvi);
        this.filterCostObjectByOrg(prmt);
        if (costCenterInfo == null || materialInfo == null) {
            return;
        }
        String costCenterNumber = costCenterInfo.getNumber();
        String materialNumber = materialInfo.getNumber();
        HashSet<String> setCostObject = new HashSet<String>();
        setCostObject.clear();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object id = this.tblMain.getCell(i, Col_ID).getValue();
            if (selectRowIndex == i || id != null) continue;
            IRow row = this.tblMain.getRow(i);
            String costCenterExsitNumber = null;
            String materialExsitNumber = null;
            costCenterExsitNumber = row.getCell(Col_CostCenterNumber).getValue() instanceof CostCenterOrgUnitInfo ? ((CostCenterOrgUnitInfo)row.getCell(Col_CostCenterNumber).getValue()).getNumber() : (String)row.getCell(Col_CostCenterNumber).getValue();
            materialExsitNumber = row.getCell(Col_MaterialNumber).getValue() instanceof MaterialInfo ? ((MaterialInfo)row.getCell(Col_MaterialNumber).getValue()).getNumber() : (String)row.getCell(Col_MaterialNumber).getValue();
            if (row.getCell(Col_CostObjectNumber).getValue() == null || !costCenterNumber.equals(costCenterExsitNumber) || !materialNumber.equals(materialExsitNumber)) continue;
            String infoNumber = null;
            infoNumber = row.getCell(Col_CostObjectNumber).getValue() instanceof CostObjectInfo ? ((CostObjectInfo)row.getCell(Col_CostObjectNumber).getValue()).getId().toString() : (String)row.getCell(Col_CostObjectNumber).getValue();
            if (infoNumber == null) continue;
            setCostObject.add(infoNumber);
        }
        FilterInfo filterPeriod = new FilterInfo();
        FilterInfo filterCompany = new FilterInfo();
        filterPeriod.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this._currPeriod.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)this._company.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)costCenterInfo.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
        filterPeriod.mergeFilter(filterCompany, "AND");
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filterPeriod);
        IClassPonderance iClassPonderance = ClassPonderanceFactory.getRemoteInstance();
        ClassPonderanceCollection collection = iClassPonderance.getClassPonderanceCollection(eviData);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            ClassPonderanceInfo classPonderanceInfo = (ClassPonderanceInfo)iter.next();
            String materialID = classPonderanceInfo.getMaterial().getId().toString();
            String costCenterID = classPonderanceInfo.getCostCenter().getId().toString();
            if (!materialID.equals(materialInfo.getId().toString()) || !costCenterID.equals(costCenterInfo.getId().toString())) continue;
            setCostObject.add(classPonderanceInfo.getCostObject().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        if (setCostObject.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(Col_ID, setCostObject, CompareType.NOTINCLUDE));
        }
        FilterInfo filterByOrg = prmt.getEntityViewInfo().getFilter();
        filter.mergeFilter(filterByOrg, "AND");
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filter);
        prmt.getQueryAgent().resetRuntimeEntityView();
        prmt.setEntityViewInfo(newEvi);
    }

    private void filtExsitMaterial(SelectorEvent e) throws Exception {
        int selectRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        CostCenterOrgUnitInfo costCenterInfo = (CostCenterOrgUnitInfo)this.tblMain.getCell(selectRowIndex, Col_CostCenterNumber).getValue();
        CostObjectInfo costObjectInfo = (CostObjectInfo)this.tblMain.getCell(selectRowIndex, Col_CostObjectNumber).getValue();
        KDBizPromptBox prmt = (KDBizPromptBox)this.tblMain.getRow(selectRowIndex).getCell(Col_MaterialNumber).getEditor().getComponent();
        EntityViewInfo initEvi = new EntityViewInfo();
        prmt.setEntityViewInfo(initEvi);
        this.filterMaterial(prmt, this.tblMain.getRow(selectRowIndex));
        prmt.getQueryAgent().resetRuntimeEntityView();
        if (costCenterInfo == null || costObjectInfo == null) {
            return;
        }
        String costCenterNumber = costCenterInfo.getNumber();
        String costObjectNumber = costObjectInfo.getNumber();
        HashSet<String> setMaterial = new HashSet<String>();
        setMaterial.clear();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object id = this.tblMain.getCell(i, Col_ID).getValue();
            if (selectRowIndex == i || id != null) continue;
            IRow row = this.tblMain.getRow(i);
            String costCenterExsitNumber = null;
            String costObjectExsitNumber = null;
            costCenterExsitNumber = row.getCell(Col_CostCenterNumber).getValue() instanceof CostCenterOrgUnitInfo ? ((CostCenterOrgUnitInfo)row.getCell(Col_CostCenterNumber).getValue()).getNumber() : (String)row.getCell(Col_CostCenterNumber).getValue();
            costObjectExsitNumber = row.getCell(Col_CostObjectNumber).getValue() instanceof CostObjectInfo ? ((CostObjectInfo)row.getCell(Col_CostObjectNumber).getValue()).getNumber() : (String)row.getCell(Col_CostObjectNumber).getValue();
            if (row.getCell(Col_MaterialNumber).getValue() == null || !costCenterNumber.equals(costCenterExsitNumber) || !costObjectNumber.equals(costObjectExsitNumber)) continue;
            String infoNumber = null;
            infoNumber = row.getCell(Col_MaterialNumber).getValue() instanceof MaterialInfo ? ((MaterialInfo)row.getCell(Col_MaterialNumber).getValue()).getId().toString() : (String)row.getCell(Col_MaterialNumber).getValue();
            if (infoNumber == null) continue;
            setMaterial.add(infoNumber);
        }
        FilterInfo filterPeriod = new FilterInfo();
        FilterInfo filterCompany = new FilterInfo();
        filterPeriod.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this._currPeriod.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)this._company.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)costCenterInfo.getId().toString(), CompareType.EQUALS));
        filterCompany.getFilterItems().add(new FilterItemInfo("costObject.id", (Object)costObjectInfo.getId().toString(), CompareType.EQUALS));
        filterPeriod.mergeFilter(filterCompany, "AND");
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filterPeriod);
        IClassPonderance iClassPonderance = ClassPonderanceFactory.getRemoteInstance();
        ClassPonderanceCollection collection = iClassPonderance.getClassPonderanceCollection(eviData);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            ClassPonderanceInfo classPonderanceInfo = (ClassPonderanceInfo)iter.next();
            String costObjectID = classPonderanceInfo.getCostObject().getId().toString();
            String costCenterID = classPonderanceInfo.getCostCenter().getId().toString();
            if (!costObjectID.equals(costObjectInfo.getId().toString()) || !costCenterID.equals(costCenterInfo.getId().toString())) continue;
            setMaterial.add(classPonderanceInfo.getMaterial().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        if (setMaterial.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(Col_ID, setMaterial, CompareType.NOTINCLUDE));
        }
        FilterInfo filterByOrg = prmt.getEntityViewInfo().getFilter();
        filter.mergeFilter(filterByOrg, "AND");
        EntityViewInfo newEvi = new EntityViewInfo();
        newEvi.setFilter(filter);
        prmt.getQueryAgent().resetRuntimeEntityView();
        prmt.setEntityViewInfo(newEvi);
    }

    protected void checkValidData() throws Exception {
        int rowCount = this.tblMain.getRowCount();
        int colMaterialIndex = 0;
        int colCostCenterIndex = 0;
        int colCostObjectIndex = 0;
        if (rowCount > 0) {
            colMaterialIndex = this.tblMain.getCell(0, Col_MaterialNumber).getColumnIndex();
            colCostCenterIndex = this.tblMain.getCell(0, Col_CostCenterNumber).getColumnIndex();
            colCostObjectIndex = this.tblMain.getCell(0, Col_CostObjectNumber).getColumnIndex();
        }
        for (int i = 0; i < rowCount; ++i) {
            Object material = this.tblMain.getCell(i, Col_MaterialNumber).getValue();
            Object costCenter = this.tblMain.getCell(i, Col_CostCenterNumber).getValue();
            Object costObject = this.tblMain.getCell(i, Col_CostObjectNumber).getValue();
            if (costCenter == null) {
                this.tblMain.getEditManager().editCellAt(i, colCostCenterIndex);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"9_AllocStdSetByAUXOverheadListUI"));
                SysUtil.abort();
            }
            if (costObject == null) {
                this.tblMain.getEditManager().editCellAt(i, colCostObjectIndex);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"0_ActualHourEditUI"));
                SysUtil.abort();
            }
            if (material != null) continue;
            this.tblMain.getEditManager().editCellAt(i, colMaterialIndex);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"28_ByProductUnitCostListUI"));
            SysUtil.abort();
        }
    }

    private void filterCostCenterByOrg(KDBizPromptBox prmt) {
        try {
            BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)prmt, (String)this._company.getId().toString());
            FilterInfo filterCostCenterType = new FilterInfo();
            filterCostCenterType.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)"0", CompareType.EQUALS));
            filterCostCenterType.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
            filterCostCenterType.mergeFilter(filterCostCenterType, "AND");
            filterCostCenterType.mergeFilter(prmt.getEntityViewInfo().getFilter(), "AND");
            prmt.getEntityViewInfo().setFilter(filterCostCenterType);
            prmt.getQueryAgent().resetRuntimeEntityView();
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void filterCostObjectByOrg(KDBizPromptBox prmt) throws Exception {
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)prmt, (String)this._company.getId().toString());
        FilterInfo filterIsForbiden = new FilterInfo();
        FilterInfo filterRelatedType = new FilterInfo();
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)"0", CompareType.EQUALS));
        filterRelatedType.getFilterItems().add(new FilterItemInfo("relatedType", (Object)"0", CompareType.EQUALS));
        filterRelatedType.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)"3", CompareType.EQUALS));
        filterIsForbiden.mergeFilter(filterRelatedType, "AND");
        filterIsForbiden.mergeFilter(prmt.getEntityViewInfo().getFilter(), "AND");
        prmt.getEntityViewInfo().setFilter(filterIsForbiden);
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    private void filterMaterial(KDBizPromptBox prmt, IRow row) {
        try {
            CostObjectCollection costObjectCollection;
            NCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)prmt, (String)"status", (Object)"1", (String)this._company.getId().toString(), (String)"StorageOrgUnit.id");
            KDBizPromptBox prmtObject = null;
            CostObjectInfo costObject = null;
            prmtObject = (KDBizPromptBox)row.getCell(Col_CostObjectNumber).getEditor().getComponent();
            costObject = (CostObjectInfo)row.getCell(Col_CostObjectNumber).getValue();
            if (costObject != null) {
                FilterInfo filterByObj = new FilterInfo();
                filterByObj.getFilterItems().add(new FilterItemInfo("number", (Object)costObject.getNumber(), CompareType.EQUALS));
                filterByObj.mergeFilter(prmtObject.getEntityViewInfo().getFilter(), "AND");
                EntityViewInfo newEvi = new EntityViewInfo();
                newEvi.setFilter(filterByObj);
                costObjectCollection = CostObjectFactory.getRemoteInstance().getCostObjectCollection(newEvi);
            } else {
                costObjectCollection = CostObjectFactory.getRemoteInstance().getCostObjectCollection(prmtObject.getEntityViewInfo());
            }
            Iterator iter = costObjectCollection.iterator();
            HashSet<String> materialSet = new HashSet<String>();
            while (iter.hasNext()) {
                CostObjectInfo costObjectInfo = (CostObjectInfo)iter.next();
                if (costObjectInfo.getCalculateMode() == null || 3 != costObjectInfo.getCalculateMode().getValue()) continue;
                CostObjectEntryCollection entries = costObjectInfo.getEntries();
                for (CostObjectEntryInfo costEntryInfo : entries) {
                    if (costEntryInfo.isIsByproduct() || costEntryInfo.getRelatedID() == null) continue;
                    String materialId = costEntryInfo.getRelatedID().toString();
                    materialSet.add(materialId);
                }
            }
            FilterInfo filterIsMaterial = new FilterInfo();
            filterIsMaterial.getFilterItems().add(new FilterItemInfo(Col_ID, materialSet, CompareType.INCLUDE));
            prmt.getEntityViewInfo().setFilter(filterIsMaterial);
            prmt.getQueryAgent().resetRuntimeEntityView();
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "ClassPonderance";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.ImportExportResource", (String)"ClassPonderance");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "ClassPonderance";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.ImportExportResource", (String)"ClassPonderance");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(ClassPonderanceListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                ICell cell = tblMain.getRow(i).getCell(ClassPonderanceListUI.Col_IsDirty);
                if (cell == null) continue;
                cell.setValue((Object)String.valueOf(false));
            }
            ClassPonderanceListUI.this.actionSave.setEnabled(false);
            if (tblMain.getRowCount() == 0) {
                ClassPonderanceListUI.this.actionBatchSet.setEnabled(false);
                ClassPonderanceListUI.this.actionRemoveLine.setEnabled(false);
            } else {
                ClassPonderanceListUI.this.actionBatchSet.setEnabled(true);
            }
        }
    }

    private final class DeleteProgressHintListener
    implements ProgressHintListener {
        private DeleteProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            ClassPonderanceListUI.this.innerDoRemoveLine();
        }
    }

    private static final class genProgressHintListener
    implements ProgressHintListener {
        private genProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("company"));
            Assert.that((boolean)param.containsKey("period"));
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
            PeriodInfo period = (PeriodInfo)param.get("period");
            ClassPonderanceFactory.getRemoteInstance().GenSettingData(company, period, true);
        }
    }
}

