/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.client.AbstractCostAdjustAllocListUI;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.AllocClientDispatch;
import com.kingdee.eas.ncm.bill.client.CostAdjustAllocEditUI;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.bill.client.MaterialAllocLogReportUI;
import com.kingdee.eas.ncm.bill.client.OtherInWarehsAllocFilterUI;
import com.kingdee.eas.ncm.bill.utils.CostAllocUtils;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.client.CMBillBaseFilterUI;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CostAdjustAllocListUI
extends AbstractCostAdjustAllocListUI {
    private static final Logger logger = CoreUIObject.getLogger(CostAdjustAllocListUI.class);
    protected CompanyOrgUnitInfo _company;
    private PeriodInfo _period;
    protected boolean isNormal = true;
    private static final String QtyCol = "entry.baseQty";
    private static final String PriceCol = "entry.unitActualCost";
    private static final String AmtCol = "entry.actualCost";
    protected FilterInfo _currFilterInfo = null;
    private CommonQueryDialog dialog = null;
    private OtherInWarehsAllocFilterUI filterUI = null;

    public CostAdjustAllocListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        if (this.isNormal) {
            NCMClientUtils.checkIsStart();
        }
        NCMClientUtils.checkIsIncludeCostAdjustData();
    }

    public void onLoad() throws Exception {
        this._company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        this._period = NCMUtils.GetCurrentPeriod(null, (String)this._company.getId().toString());
        super.onLoad();
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionWizAlloc.setVisible(false);
        this.menuEdit.setVisible(false);
        this.tblMain.getColumn("costCenterOrgUnit.number").setWidth(100);
        this.tblMain.getColumn("costCenterOrgUnit.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entry.seq").setWidth(100);
        this.tblMain.getColumn("entry.seq").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("material.number").setWidth(100);
        this.tblMain.getColumn("material.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("material.model").setWidth(100);
        this.tblMain.getColumn("material.model").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("costObject.number").setWidth(100);
        this.tblMain.getColumn("costObject.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("warehouse.name").setWidth(100);
        this.tblMain.getColumn("warehouse.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entry.remark").setWidth(100);
        this.tblMain.getColumn("entry.remark").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("creator.name").setWidth(100);
        this.tblMain.getColumn("creator.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("createTime").setWidth(100);
        this.tblMain.getColumn("createTime").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("baseStatus").setWidth(66);
        this.tblMain.getColumn("bizDate").setWidth(69);
        this.tblMain.getColumn("fiVouchered").setWidth(64);
        this.tblMain.getColumn("baseUnit.name").setWidth(83);
        String[] a = new String[]{QtyCol, PriceCol, AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])a, (String)"%{###,###,###.##########}f");
    }

    protected void initTableParams() {
        super.initTableParams();
        try {
            this.initFormatTable();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initFormatTable() throws Exception {
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        String[] cols = new String[]{QtyCol, PriceCol, AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])cols, (String)"%{0.##########}f");
        this.setMergeColumn();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuItemViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    private void setMergeColumn() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("baseStatus").setGroup(true);
        this.tblMain.getColumn("baseStatus").setMergeable(true);
        this.tblMain.getColumn("bizDate").setGroup(true);
        this.tblMain.getColumn("bizDate").setMergeable(true);
        this.tblMain.getColumn("costCenterOrgUnit.number").setGroup(true);
        this.tblMain.getColumn("costCenterOrgUnit.number").setMergeable(true);
        this.tblMain.getColumn("costCenterOrgUnit.name").setGroup(true);
        this.tblMain.getColumn("costCenterOrgUnit.name").setMergeable(true);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amoutPre = 2;
        int priceprec = 8;
        int baseUnitprce = 8;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                baseUnitprce = rowSet.getInt("baseUnit.qtyPrecision");
                priceprec = rowSet.getInt("material.pricePrecision");
                amoutPre = rowSet.getInt("baseCurrency.precision");
                NCMClientUtils.iniColumnsPrecision((int)baseUnitprce, (String[])new String[]{QtyCol}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)priceprec, (String[])new String[]{PriceCol}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)amoutPre, (String[])new String[]{AmtCol}, (IRowSet)rowSet);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (rowSet == null || rowSet.size() == 0) {
            this.actionAutoAlloc.setEnabled(false);
            this.actionViewAlloc.setEnabled(false);
            this.actionViewLog.setEnabled(false);
            this.actionManuAlloc.setEnabled(false);
            this.actionPrint.setEnabled(false);
            this.actionPrintPreview.setEnabled(false);
        } else {
            this.actionAutoAlloc.setEnabled(true);
            this.actionViewAlloc.setEnabled(true);
            this.actionViewLog.setEnabled(true);
            this.actionManuAlloc.setEnabled(true);
            this.actionPrint.setEnabled(true);
            this.actionPrintPreview.setEnabled(true);
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(this._period.getPeriodYear())));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(this._period.getPeriodNumber())));
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4));
            filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("calculateKind", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("issueType", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this._company.getId().toString()));
            HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
            ccoTypeSet.add(0);
            ccoTypeSet.add(1);
            filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", ccoTypeSet, CompareType.INCLUDE));
            try {
                ev.getFilter().mergeFilter(filter, "and");
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionViewAlloc_actionPerformed(null);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(CostAdjustAllocListUI.this.btnViewAlloc, 0, "Enter");
                ItemAction actView = CostAdjustAllocListUI.this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        });
    }

    @Override
    public void actionAutoAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionAutoAlloc_actionPerformed(e);
        NCMClientUtils.checkIsIncludeCostAdjustData();
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(this._company, this._period)) {
            return;
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("company", this._company);
        source.put("period", this._period);
        source.put("user", SysContext.getSysContext().getCurrentUserInfo());
        source.put("filterInfo", this._currFilterInfo);
        Map param = CostAllocUtils.buildCostAdjustAllocParam(source);
        CostTaskClientUtils.execute((Map)param, (CoreUIObject)this, (boolean)false);
    }

    @Override
    public void actionManuAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionManuAlloc_actionPerformed(e);
        NCMClientUtils.checkIsIncludeCostAdjustData();
        NCMClientUtils.requestMutex((CoreUI)this, (String)this._company.getId().toString());
        try {
            this.checkSelected();
            this.showAllocEditUI("ADJUST");
        }
        finally {
            NCMClientUtils.releaseMutex((CoreUI)this, (String)this._company.getId().toString());
        }
    }

    private void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("companyName", this._company.getName().toString());
        this.setPeriodForDaily(param, operType);
        param.put("filterInfo", (String)this._currFilterInfo);
        CostAdjustAllocEditUI.showAllocEditUI((CoreUIObject)this, param, operType, this.tblMain);
    }

    protected void setPeriodForDaily(Map param, String operType) throws BOSException {
        param.put("periodId", this._period.getId().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
    }

    @Override
    public void actionWizAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionWizAlloc_actionPerformed(e);
        NCMClientUtils.checkIsIncludeCostAdjustData();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("filterInfo", this._currFilterInfo);
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("parentUi", (Object)this);
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        AllocClientDispatch disp = new AllocClientDispatch();
        disp.DoOtherInWHAllocate((CoreUIObject)this, AllocTypeEnum.WIZ, param);
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAlloc_actionPerformed(e);
        NCMClientUtils.checkIsIncludeCostAdjustData();
        String oprationName = AllocSourceBillEnum.CostAjustBill.getName() + "Alloc_View";
        NCMUtils.addEASLogForAlloc(null, (String)"actionViewAlloc_actionPerformed", (String)(this._company.getNumber() + ' ' + this._company.getName()), (String)oprationName, (String)this._company.getId().toString(), (boolean)true);
        this.showAllocEditUI("VIEW");
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewLog_actionPerformed(e);
        NCMClientUtils.checkIsIncludeCostAdjustData();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("logTblName", "T_NCM_LOG_CostAdjust");
        MaterialAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CostAdjustBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        if (this.getFilterUI() != null) {
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        this.dialog.setWidth(400);
        this.dialog.setHeight(250);
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this._company.getId().toString());
        cmcq.set("query", (Object)"CostAdjustBillAllocQuery");
        try {
            boolean isShowShareCostObject = NCMUtils.isCostObjectOfBillRequired(null, (String)this._company.getId().toString());
            cmcq.set("showShareCostObject", (Object)isShowShareCostObject);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new OtherInWarehsAllocFilterUI();
                this.filterUI.initCostCenterForCostAdjust();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CompanyOrgUnitInfo getCompanyOrgInfoWithDefault() throws BOSException {
        CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
        if (filterUI != null && filterUI.getCompanyF7() != null && filterUI.getCompanyF7().getData() != null && filterUI.getCompanyF7().getData() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)filterUI.getCompanyF7().getData();
            if (!org.isLoaded() && org.getId().toString().trim().length() > 0) {
                try {
                    org = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()));
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMainCode(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            return org;
        }
        if (this.getUIContext().containsKey(OrgType.Company) && this.getUIContext().get(OrgType.Company) != null) {
            return (CompanyOrgUnitInfo)this.getUIContext().get(OrgType.Company);
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    protected boolean isFootVisible() {
        return true;
    }
}

