/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.OrgStructureUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.ncm.bill.IInitFacade;
import com.kingdee.eas.ncm.bill.InitFacadeFactory;
import com.kingdee.eas.ncm.bill.client.AbstractDailySettleUI;
import com.kingdee.eas.ncm.common.utils.client.OrgUnitClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class DailySettleUI
extends AbstractDailySettleUI {
    private static final Logger logger = CoreUIObject.getLogger(DailySettleUI.class);
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String curCompId = this.currentCompany.getId().toString();
    private static final String resPath = "com.kingdee.eas.ncm.bill.client.BillResource";
    private UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
    private IObjectPK userpk = new ObjectStringPK(this.user.getId().toString());
    private static final int UNAURIT = 0;
    private static final int FISHANEDINIT = 1;
    private static final int ALREADYFINIT = 2;
    private static final int UNINIT = 3;
    private static final int TIMEPAST = 4;
    private static final int NOSYSTEMINITDATA = 5;
    private static final int AURIT = 0;
    private Context mainOrgContext;
    private String permissionItem_Close = "costinit";
    private String permissionItem_UnClose = "uncostinit";
    private static final String opertPermItemName = "";

    public void onLoad() throws Exception {
        OrgStructureUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        super.onLoad();
        this.initUI();
        this.ChangePermissionItem();
    }

    private void initUI() throws Exception {
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.prmtCompany.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    DailySettleUI.this.prmtCompanyOrg_dataChanged(e);
                }
                catch (Exception exc) {
                    DailySettleUI.this.handUIException(exc);
                }
            }
        });
        this.prmtPeriod.setValue((Object)SystemStatusCtrolFactory.getRemoteInstance().getStartPeriod(1001, this.curCompId));
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("number");
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.prmtPeriod.setEnabled(false);
        this.setImage();
        this.txtDesc.setText(this.getResString("InitInfo"));
        this.kDProgressBar1.setVisible(false);
    }

    private void ChangePermissionItem() {
        if (this.radioAntiDailySettle.isSelected()) {
            OrgUnitClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtCompany, (OrgType)OrgType.Company, (String[])new String[]{this.permissionItem_UnClose});
        } else if (this.radioDailySettle.isSelected()) {
            OrgUnitClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtCompany, (OrgType)OrgType.Company, (String[])new String[]{this.permissionItem_Close});
        }
    }

    private CompanyOrgUnitInfo getCompanyOrg() {
        CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        return companyOrg;
    }

    private PeriodInfo getCurrPeriod() {
        PeriodInfo currPeriod = null;
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrg();
        if (companyOrg == null) {
            return null;
        }
        try {
            currPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, this.getCompanyOrg().getId().toString());
            if (currPeriod != null) {
                this.prmtPeriod.setText(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"0_AccountClosingUI") + currPeriod.getNumber());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return currPeriod;
    }

    public void prmtCompanyOrg_dataChanged(DataChangeEvent e) {
        try {
            CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            if (curCompany == null || this.getCurrPeriod() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CalResource.COMPANY_PERIOD_ISNULL"));
                this.prmtCompany.setValue((Object)this.currentCompany);
                SysUtil.abort();
            }
            if (this.getCurrPeriod() != null) {
                this.prmtPeriod.setText(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"0_AccountClosingUI") + this.getCurrPeriod().getNumber());
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setImage() {
        Icon guide = EASResource.getIcon((String)"imgGuide_pic260");
        KDLabel backlabel = new KDLabel(guide);
        backlabel.setBounds(0, 0, guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.add((Component)backlabel, (Object)"Center");
        this.pnlPicture.setSize(guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.setBackground(Color.blue);
    }

    private String getResString(String resName) {
        return EASResource.getString((String)resPath, (String)resName);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        String info;
        block30: {
            String closing = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"34_DailySettleUI");
            this.kDProgressBar1.setVisible(true);
            this.kDProgressBar1.setStringPainted(true);
            this.kDProgressBar1.setString(closing);
            this.kDProgressBar1.setIndeterminate(true);
            info = null;
            IInitFacade manager = InitFacadeFactory.getRemoteInstance();
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            try {
                if (this.radioDailySettle.isSelected()) {
                    switch (manager.init((IObjectPK)new ObjectStringPK(this.getCompanyOrg().getId().toString()), this.userpk, false)) {
                        case 1: {
                            ComponentUtil.setWindowCursorOfDefault((Window)window);
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"35_DailySettleUI"));
                            this.kDProgressBar1.setVisible(false);
                            this.btnOK.setVisible(false);
                            this.btnCancel.setText(this.getResString("Close"));
                            info = "\n" + MessageFormat.format(this.getResString("SuccessInfo"), this.prmtCompany.getValue(), this.getCurrPeriod());
                            this.txtDesc.setText(info);
                            return;
                        }
                        case 2: {
                            ComponentUtil.setWindowCursorOfDefault((Window)window);
                            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"36_DailySettleUI"));
                            this.kDProgressBar1.setVisible(false);
                            return;
                        }
                        case 5: {
                            ComponentUtil.setWindowCursorOfDefault((Window)window);
                            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"37_DailySettleUI"));
                            this.kDProgressBar1.setVisible(false);
                            return;
                        }
                        case 0: {
                            ComponentUtil.setWindowCursorOfDefault((Window)window);
                            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"38_DailySettleUI"));
                            this.kDProgressBar1.setVisible(false);
                            return;
                        }
                    }
                    info = this.getResString("Success");
                    break block30;
                }
                if (!this.radioAntiDailySettle.isSelected()) break block30;
                if (SystemStatusCtrolFactory.getRemoteInstance().isClose(1001, new ObjectStringPK(this.curCompId).toString())) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"39_DailySettleUI"));
                    SysUtil.abort();
                }
                this.requestMutex(this.curCompId);
                int result = 3;
                try {
                    result = manager.uninit((IObjectPK)new ObjectStringPK(this.getCompanyOrg().getId().toString()), this.userpk);
                }
                finally {
                    this.releaseMutex(this.curCompId);
                }
                switch (result) {
                    case 1: {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"40_DailySettleUI"));
                        this.kDProgressBar1.setVisible(false);
                        this.btnOK.setVisible(false);
                        this.btnCancel.setText(this.getResString("Close"));
                        return;
                    }
                    case 3: {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"41_DailySettleUI"));
                        this.kDProgressBar1.setVisible(false);
                        return;
                    }
                    case 4: {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"42_DailySettleUI"));
                        this.kDProgressBar1.setVisible(false);
                        return;
                    }
                    case 5: {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"43_DailySettleUI"));
                        this.kDProgressBar1.setVisible(false);
                        return;
                    }
                    case 0: {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"AntiDailySettle_BillAurited"));
                        this.kDProgressBar1.setVisible(false);
                        return;
                    }
                }
                info = this.getResString("AntiSettleSuccess");
            }
            finally {
                this.kDProgressBar1.setIndeterminate(false);
                this.kDProgressBar1.setValue(this.kDProgressBar1.getMaximum());
                this.kDProgressBar1.setVisible(false);
            }
        }
        info = info + "\n" + MessageFormat.format(this.getResString("SuccessInfo"), this.currentCompany, this.prmtPeriod.getValue());
        this.txtDesc.setText(info);
        this.radioDailySettle.setEnabled(false);
        this.radioAntiDailySettle.setEnabled(false);
        this.kDProgressBar1.setVisible(false);
        this.btnOK.setVisible(false);
        this.btnCancel.setText(this.getResString("Close"));
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void radioDailySettle_actionPerformed(ActionEvent e) throws Exception {
        this.ChangePermissionItem();
    }

    @Override
    protected void radioAntiDailySettle_actionPerformed(ActionEvent e) throws Exception {
        this.ChangePermissionItem();
    }

    protected void prmtPeriod_dataChanged(DataChangeEvent e) throws Exception {
    }

    public void verify() throws EASBizException, BOSException {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPeriod);
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.kDProgressBar1.setVisible(false);
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }
}

