/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisEntryCollection;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisEntryFactory;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisEntryInfo;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisFactory;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisMatDetailCollection;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisMatDetailInfo;
import com.kingdee.eas.ncm.bill.client.AbstractEopWipAdjustHisEditUI;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class EopWipAdjustHisEditUI
extends AbstractEopWipAdjustHisEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EopWipAdjustHisEditUI.class);
    private int amountPrecision = 0;

    public EopWipAdjustHisEditUI() throws Exception {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        this.amountPrecision = currency.getPrecision();
        this.pkdate.setEditable(false);
        this.prmtcostCenter.setEnabled(false);
        this.prmtcostObject.setEnabled(false);
        this.prmtProduct.setEnabled(false);
        this.prmtOrder.setEnabled(false);
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EopWipAdjustHisFactory.getRemoteInstance();
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.auditAction.setEnabled(false);
        this.unauditAction.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadHeader();
        this.loadEntries();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void loadData() throws Exception {
        super.loadData();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void loadHeader() throws Exception {
        MeasureUnitInfo unit;
        MaterialInfo material;
        CostObjectInfo costObject = this.editData.getCostObject();
        if (costObject != null && (material = costObject.getStdProductID()) != null && (unit = material.getBaseUnit()) != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unit.getId().toString()));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("material.id");
            sic.add("measureUnit.id");
            sic.add("qtyPrecision");
            view.setSelector(sic);
            MultiMeasureUnitCollection mmuColl = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(view);
            if (mmuColl.size() > 0) {
                MultiMeasureUnitInfo mUnit = mmuColl.get(0);
                this.txtEoPWipQty.setPrecision(mUnit.getQtyPrecision());
                this.txtAdjustQty.setPrecision(mUnit.getQtyPrecision());
                this.txtFinishQty.setPrecision(mUnit.getQtyPrecision());
            }
        }
    }

    private void loadEntries() throws Exception {
        EopWipAdjustHisEntryCollection entries = this.editData.getEntries();
        if (entries == null) {
            return;
        }
        this.kdtEntries.getColumn("eopWipAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPrecision));
        this.kdtEntries.getColumn("adjustAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPrecision));
        this.kdtEntries.getColumn("finishAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amountPrecision));
        HashSet<String> entryIds = new HashSet<String>();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            EopWipAdjustHisEntryInfo entry = (EopWipAdjustHisEntryInfo)it.next();
            entryIds.add(entry.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIds, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("seq");
        sic.add("costItem.number");
        sic.add("costItem.name");
        sic.add("costItem.ItemType");
        sic.add("costItem.unit.name");
        sic.add("costItem.unit.qtyPrecision");
        sic.add("eopWipQty");
        sic.add("adjustQty");
        sic.add("finishQty");
        sic.add("eopWipAmount");
        sic.add("adjustAmount");
        sic.add("finishAmount");
        sic.add("entries.id");
        sic.add("entries.material.number");
        sic.add("entries.material.name");
        sic.add("entries.material.model");
        sic.add("entries.material.baseUnit.id");
        sic.add("entries.material.baseUnit.name");
        sic.add("entries.eopWipQty");
        sic.add("entries.adjustQty");
        sic.add("entries.finishQty");
        sic.add("entries.eopWipAmount");
        sic.add("entries.adjustAmount");
        sic.add("entries.finishAmount");
        view.setSelector(sic);
        entries = EopWipAdjustHisEntryFactory.getRemoteInstance().getEopWipAdjustHisEntryCollection(view);
        boolean findMaterial = false;
        view = new EntityViewInfo();
        filter = new FilterInfo();
        Iterator it2 = entries.iterator();
        while (it2.hasNext()) {
            EopWipAdjustHisEntryInfo entry = (EopWipAdjustHisEntryInfo)it2.next();
            CostItemInfo costItem = entry.getCostItem();
            if (!CostItemEnum.STUFF.equals((Object)costItem.getItemType())) continue;
            EopWipAdjustHisMatDetailCollection matDetails = entry.getEntries();
            Iterator it22 = matDetails.iterator();
            while (it22.hasNext()) {
                MeasureUnitInfo unit;
                EopWipAdjustHisMatDetailInfo matDetail = (EopWipAdjustHisMatDetailInfo)it22.next();
                MaterialInfo material = matDetail.getMaterial();
                if (material == null || (unit = material.getBaseUnit()) == null) continue;
                FilterInfo mfilter = new FilterInfo();
                mfilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString()));
                mfilter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unit.getId().toString()));
                filter.mergeFilter(mfilter, "or");
                findMaterial = true;
            }
        }
        view.setFilter(filter);
        sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("material.id");
        sic.add("measureUnit.id");
        sic.add("qtyPrecision");
        view.setSelector(sic);
        HashMap<String, MultiMeasureUnitInfo> mUnits = new HashMap<String, MultiMeasureUnitInfo>();
        if (findMaterial) {
            MultiMeasureUnitCollection mmuColl = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitCollection(view);
            for (MultiMeasureUnitInfo mUnit : mmuColl) {
                mUnits.put(mUnit.getMaterial().getId().toString() + mUnit.getMeasureUnit().getId().toString(), mUnit);
            }
        }
        Iterator it3 = entries.iterator();
        while (it3.hasNext()) {
            EopWipAdjustHisEntryInfo entry = (EopWipAdjustHisEntryInfo)it3.next();
            CostItemInfo costItem = entry.getCostItem();
            if (CostItemEnum.STUFF.equals((Object)costItem.getItemType())) {
                EopWipAdjustHisMatDetailCollection matDetails = entry.getEntries();
                Iterator it23 = matDetails.iterator();
                while (it23.hasNext()) {
                    EopWipAdjustHisMatDetailInfo matDetail = (EopWipAdjustHisMatDetailInfo)it23.next();
                    IRow row = this.kdtEntries.addRow();
                    row.getCell("costItemNumber").setValue((Object)costItem.getNumber());
                    row.getCell("costItemName").setValue((Object)costItem.getName());
                    MaterialInfo material = matDetail.getMaterial();
                    if (material != null) {
                        row.getCell("materialNumber").setValue((Object)material.getNumber());
                        row.getCell("materialName").setValue((Object)material.getName());
                        row.getCell("materialModel").setValue((Object)material.getModel());
                        row.getCell("materialBatch").setValue((Object)matDetail.getBatchNo());
                        MeasureUnitInfo unit = material.getBaseUnit();
                        if (unit != null) {
                            row.getCell("unit").setValue((Object)unit.getName());
                            MultiMeasureUnitInfo mUnit = (MultiMeasureUnitInfo)mUnits.get(material.getId().toString() + unit.getId().toString());
                            if (mUnit != null) {
                                row.getCell("eopWipQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)mUnit.getQtyPrecision()));
                                row.getCell("adjustQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)mUnit.getQtyPrecision()));
                                row.getCell("finishQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)mUnit.getQtyPrecision()));
                            }
                        }
                        row.getCell("eopWipQty").setValue((Object)matDetail.getEopWipQty());
                        row.getCell("adjustQty").setValue((Object)matDetail.getAdjustQty());
                        row.getCell("finishQty").setValue((Object)matDetail.getFinishQty());
                        row.getCell("eopWipAmount").setValue((Object)matDetail.getEopWipAmount());
                        row.getCell("adjustAmount").setValue((Object)matDetail.getAdjustAmount());
                        row.getCell("finishAmount").setValue((Object)matDetail.getFinishAmount());
                    }
                    row.getCell("remark").setValue((Object)entry.getRemark());
                }
                continue;
            }
            IRow row = this.kdtEntries.addRow();
            row.getCell("costItemNumber").setValue((Object)costItem.getNumber());
            row.getCell("costItemName").setValue((Object)costItem.getName());
            MeasureUnitInfo unit = costItem.getUnit();
            if (unit != null) {
                row.getCell("unit").setValue((Object)unit.getName());
                row.getCell("eopWipQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)unit.getQtyPrecision()));
                row.getCell("adjustQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)unit.getQtyPrecision()));
                row.getCell("finishQty").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)unit.getQtyPrecision()));
                row.getCell("eopWipQty").setValue((Object)entry.getEopWipQty());
                row.getCell("adjustQty").setValue((Object)entry.getAdjustQty());
                row.getCell("finishQty").setValue((Object)entry.getFinishQty());
            } else {
                row.getCell("eopWipQty").setValue((Object)"");
                row.getCell("adjustQty").setValue((Object)"");
                row.getCell("finishQty").setValue((Object)"");
            }
            row.getCell("eopWipAmount").setValue((Object)entry.getEopWipAmount());
            row.getCell("adjustAmount").setValue((Object)entry.getAdjustAmount());
            row.getCell("finishAmount").setValue((Object)entry.getFinishAmount());
            row.getCell("remark").setValue((Object)entry.getRemark());
        }
    }

    protected void setTableToSumField() {
        StringBuffer format = new StringBuffer("0.");
        for (int i = 0; i < this.amountPrecision; ++i) {
            format.append("0");
        }
        super.setTableToSumField(this.kdtEntries, new String[]{"eopWipAmount@" + format.toString(), "adjustAmount@" + format.toString(), "finishAmount@" + format.toString()});
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("companyOrg.*"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("calculatePeriod.id"));
        sic.add(new SelectorItemInfo("calculatePeriod.periodYear"));
        sic.add(new SelectorItemInfo("calculatePeriod.periodNumber"));
        sic.add(new SelectorItemInfo("costCenter.id"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("costObject.id"));
        sic.add(new SelectorItemInfo("costObject.number"));
        sic.add(new SelectorItemInfo("costObject.name"));
        sic.add(new SelectorItemInfo("costObject.StdProductID.model"));
        sic.add(new SelectorItemInfo("costObject.batchNumber"));
        sic.add(new SelectorItemInfo("costObject.orderNumber"));
        sic.add(new SelectorItemInfo("costObject.StdProductID.id"));
        sic.add(new SelectorItemInfo("costObject.StdProductID.number"));
        sic.add(new SelectorItemInfo("costObject.StdProductID.name"));
        sic.add(new SelectorItemInfo("costObject.StdProductID.baseUnit.id"));
        sic.add(new SelectorItemInfo("costObject.StdProductID.baseUnit.name"));
        sic.add(new SelectorItemInfo("eopWipQty"));
        sic.add(new SelectorItemInfo("adjustQty"));
        sic.add(new SelectorItemInfo("finishQty"));
        sic.add(new SelectorItemInfo("eopWipHour"));
        sic.add(new SelectorItemInfo("adjustHour"));
        sic.add(new SelectorItemInfo("finishHour"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("entries.id"));
        return sic;
    }
}

