/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisFilterParam;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisInfo;
import com.kingdee.eas.ncm.bill.client.AbstractEopWipAdjustHisFilterUI;
import com.kingdee.eas.ncm.bill.client.ActualHourFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class EopWipAdjustHisFilterUI
extends AbstractEopWipAdjustHisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ActualHourFilterUI.class);
    private CompanyOrgUnitInfo companyOrg = null;
    private static final int PERIOD_MAX_MONTH = 12;
    private String EopWipAdjustHisInfoFrom = "EopWipAdjustHisInfoFrom";
    private String EopWipAdjustHisInfoTo = "EopWipAdjustHisInfoTo";
    private String BizDateFrom = "bizDateFrom";
    private String BizDateTo = "bizDateTo";
    private String PeriodFrom = "periodFrom";
    private String PeriodTo = "periodTo";
    private String CostCenterFrom = "costCenterFrom";
    private String CostCenterTo = "costCenterTo";
    private String CostObjectFrom = "costObjectFrom";
    private String CostObjectTo = "costObjectTo";
    private String CostItemFrom = "costItemFrom";
    private String CostItemTo = "costItemTo";
    private String BillSate = "billSate";
    private PeriodInfo periodStart;
    private PeriodInfo periodPre;
    private PeriodInfo periodCur;

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpBizDateTo.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                EopWipAdjustHisFilterUI.this.verifyDate(e);
            }
        });
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.companyOrg.getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.companyOrg.getId().toString());
        this.periodPre = this.getPrePeriod(this.periodStart, this.periodCur);
        if (this.periodPre.getId().toString().equals(this.periodCur.getId().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.EopWipAdjustResource", (String)"NO_HIS_PERIOD"));
            SysUtil.abort();
        }
        this.formatUI();
    }

    protected void verifyDate(DataChangeEvent e) {
        if (e.getNewValue() == e.getOldValue()) {
            return;
        }
        if (e.getNewValue() != e.getOldValue() && e.getNewValue() != null) {
            Date dateFrom = (Date)this.dpBizDateFrom.getValue();
            Date dataTo = (Date)e.getNewValue();
            if (dateFrom != null && dateFrom.compareTo(dataTo) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.EopWipAdjustResource", (String)"DateError"));
                this.dpBizDateTo.setValue(this.dpBizDateFrom.getValue());
            }
        }
    }

    private PeriodInfo getPrePeriod(PeriodInfo periodStart, PeriodInfo periodCur) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodCur.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)periodCur.getBeginDate()), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)periodStart.getBeginDate()), CompareType.GREATER_EQUALS));
        evi.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("endDate");
        sorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorter);
        PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(evi);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return periodCur;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
    }

    private void formatUI() throws Exception {
        this.initCompany(this.companyOrg);
        this.initBizDate(this.dpBizDateFrom);
        this.initBizDate(this.dpBizDateTo);
        int minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initFromPeriod = this.periodPre.getPeriodYear() * 100 + this.periodPre.getPeriodNumber();
        int initToPeriod = this.periodPre.getPeriodYear() * 100 + this.periodPre.getPeriodNumber();
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        this.filterCostObjectByOrg(this.prtCostObjectTo);
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prtCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prtCostObjectTo.setSelector((KDPromptSelector)arg1);
        this.prtCostItemFrom.setDisplayFormat("$number$");
        this.prtCostItemFrom.setEditFormat("$number$");
        this.prtCostItemTo.setDisplayFormat("$number$");
        this.prtCostItemTo.setEditFormat("$number$");
        this.prtBillNumFrom.setDisplayFormat("$number$");
        this.prtBillNumFrom.setEditFormat("$number$");
        this.prtBillNumTo.setDisplayFormat("$number$");
        this.prtBillNumTo.setEditFormat("$number$");
    }

    public EopWipAdjustHisFilterParam getFilterParam() {
        EopWipAdjustHisFilterParam filterParam = (EopWipAdjustHisFilterParam)this.createNewFilterParam();
        this.storeFilterParam((NCMIFilterParam)filterParam);
        return filterParam;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new EopWipAdjustHisFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof EopWipAdjustHisFilterParam)) {
            return;
        }
        EopWipAdjustHisFilterParam fp = (EopWipAdjustHisFilterParam)filterParam;
        EopWipAdjustHisInfo bnFrom = null;
        EopWipAdjustHisInfo bnTo = null;
        String EopWipAdjustHisFromData = customerParams.getCustomerParam(this.EopWipAdjustHisInfoFrom);
        String EopWipAdjustHisToData = customerParams.getCustomerParam(this.EopWipAdjustHisInfoTo);
        if (EopWipAdjustHisFromData != null && EopWipAdjustHisFromData.length() > 0) {
            bnFrom = new EopWipAdjustHisInfo();
            bnFrom.setId(BOSUuid.read((String)EopWipAdjustHisFromData));
        }
        if (EopWipAdjustHisToData != null && EopWipAdjustHisToData.length() > 0) {
            bnTo = new EopWipAdjustHisInfo();
            bnTo.setId(BOSUuid.read((String)EopWipAdjustHisToData));
        }
        fp.setEopWipAdjustHisInfoFrom(bnFrom);
        fp.setEopWipAdjustHisInfoTo(bnTo);
        String bizDateFromData = customerParams.getCustomerParam(this.BizDateFrom);
        String bizDateToData = customerParams.getCustomerParam(this.BizDateTo);
        fp.setBizDateFrom(Long.parseLong(bizDateFromData));
        fp.setBizDateTo(Long.parseLong(bizDateToData));
        String periodFromData = customerParams.getCustomerParam(this.PeriodFrom);
        String periodToData = customerParams.getCustomerParam(this.PeriodTo);
        fp.setPeriodFrom(periodFromData);
        fp.setPeriodTo(periodToData);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        String costCenterFromData = customerParams.getCustomerParam(this.CostCenterFrom);
        String costCenterToData = customerParams.getCustomerParam(this.CostCenterTo);
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            ccTo = new CostCenterOrgUnitInfo();
            ccTo.setId(BOSUuid.read((String)costCenterToData));
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
        CostObjectInfo cbFrom = null;
        CostObjectInfo cbTo = null;
        String costObjectFromData = customerParams.getCustomerParam(this.CostObjectFrom);
        String costObjectToData = customerParams.getCustomerParam(this.CostObjectTo);
        if (costObjectFromData != null && costObjectFromData.length() > 0) {
            cbFrom = new CostObjectInfo();
            cbFrom.setId(BOSUuid.read((String)costObjectFromData));
        }
        if (costObjectToData != null && costObjectToData.length() > 0) {
            cbTo = new CostObjectInfo();
            cbTo.setId(BOSUuid.read((String)costObjectToData));
        }
        fp.setCostObjectFrom(cbFrom);
        fp.setCostObjectTo(cbTo);
        CostItemInfo ciFrom = null;
        CostItemInfo ciTo = null;
        String costItemFromData = customerParams.getCustomerParam(this.CostItemFrom);
        String costItemctToData = customerParams.getCustomerParam(this.CostItemTo);
        if (costItemFromData != null && costItemFromData.length() > 0) {
            ciFrom = new CostItemInfo();
            ciFrom.setId(BOSUuid.read((String)costItemFromData));
        }
        if (costItemctToData != null && costItemctToData.length() > 0) {
            ciTo = new CostItemInfo();
            ciTo.setId(BOSUuid.read((String)costItemctToData));
        }
        fp.setCostItemFrom(ciFrom);
        fp.setCostItemTo(ciTo);
        String schemeState = customerParams.getCustomerParam(this.BillSate);
        if (schemeState != null && schemeState.length() > 0) {
            fp.setBillSate(schemeState);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        int minPeriod;
        if (!(filterParam instanceof EopWipAdjustHisFilterParam)) {
            return;
        }
        EopWipAdjustHisFilterParam fp = (EopWipAdjustHisFilterParam)filterParam;
        this.prtBillNumFrom.setData((Object)fp.getEopWipAdjustHisInfoFrom());
        this.prtBillNumTo.setData((Object)fp.getEopWipAdjustHisInfoTo());
        if (fp.getBizDateFrom() == 0L) {
            this.dpBizDateFrom.setValue(null);
        } else {
            this.dpBizDateFrom.setValue((Object)new Date(fp.getBizDateFrom()));
        }
        if (fp.getBizDateTo() == 0L) {
            this.dpBizDateTo.setValue(null);
        } else {
            this.dpBizDateTo.setValue((Object)new Date(fp.getBizDateTo()));
        }
        int initFromPeriod = minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initToPeriod = this.periodPre.getPeriodYear() * 100 + this.periodPre.getPeriodNumber();
        if (fp.getPeriodFrom() != null) {
            initFromPeriod = Integer.parseInt(fp.getPeriodFrom());
        }
        if (fp.getPeriodTo() != null) {
            initToPeriod = Integer.parseInt(fp.getPeriodTo());
        }
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
        this.prtCostcenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prtCostcenterTo.setData((Object)fp.getCostCenterTo());
        this.prtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prtCostObjectTo.setData((Object)fp.getCostObjectTo());
        this.prtCostItemFrom.setData((Object)fp.getCostItemFrom());
        this.prtCostItemTo.setData((Object)fp.getCostItemTo());
        this.combBillState.setSelectedIndex(Integer.parseInt(fp.getBillSate()));
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof EopWipAdjustHisFilterParam)) {
            return;
        }
        EopWipAdjustHisFilterParam fp = (EopWipAdjustHisFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getEopWipAdjustHisInfoFrom(), this.EopWipAdjustHisInfoFrom);
        super.putIdByKey(customerParams, (Object)fp.getEopWipAdjustHisInfoTo(), this.EopWipAdjustHisInfoTo);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateFrom()).toString(), this.BizDateFrom);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateTo()).toString(), this.BizDateTo);
        super.putIdByKey(customerParams, (Object)fp.getPeriodFrom(), this.PeriodFrom);
        super.putIdByKey(customerParams, (Object)fp.getPeriodTo(), this.PeriodTo);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), this.CostCenterFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), this.CostCenterTo);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectFrom(), this.CostObjectFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectTo(), this.CostObjectTo);
        super.putIdByKey(customerParams, (Object)fp.getCostItemFrom(), this.CostItemFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostItemTo(), this.CostItemTo);
        super.putIdByKey(customerParams, (Object)fp.getBillSate(), this.BillSate);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof EopWipAdjustHisFilterParam)) {
            return;
        }
        EopWipAdjustHisFilterParam fp = (EopWipAdjustHisFilterParam)filterParam;
        Object temp = null;
        EopWipAdjustHisInfo EopWipAdjustHisInfoFrom = null;
        EopWipAdjustHisInfo EopWipAdjustHisInfoTo = null;
        temp = this.prtBillNumFrom.getData();
        if (temp != null && temp instanceof EopWipAdjustHisInfo) {
            EopWipAdjustHisInfoFrom = (EopWipAdjustHisInfo)temp;
        }
        if ((temp = this.prtBillNumTo.getData()) != null && temp instanceof EopWipAdjustHisInfo) {
            EopWipAdjustHisInfoTo = (EopWipAdjustHisInfo)temp;
        }
        fp.setEopWipAdjustHisInfoFrom(EopWipAdjustHisInfoFrom);
        fp.setEopWipAdjustHisInfoTo(EopWipAdjustHisInfoTo);
        long bizDateFrom = 0L;
        long bizDateTo = 0L;
        temp = this.dpBizDateFrom.getValue();
        if (temp != null && temp instanceof Date) {
            bizDateFrom = ((Date)temp).getTime();
        }
        if ((temp = this.dpBizDateTo.getValue()) != null && temp instanceof Date) {
            bizDateTo = ((Date)temp).getTime();
        }
        fp.setBizDateFrom(bizDateFrom);
        fp.setBizDateTo(bizDateTo);
        String periodFrom = null;
        String periodTo = null;
        temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = ((Integer)temp).toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = ((Integer)temp).toString();
        }
        fp.setPeriodFrom(periodFrom);
        fp.setPeriodTo(periodTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.prtCostcenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.prtCostcenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        temp = this.prtCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.prtCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)temp;
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        CostItemInfo costItemFrom = null;
        CostItemInfo costItemTo = null;
        temp = this.prtCostItemFrom.getData();
        if (temp != null && temp instanceof CostItemInfo) {
            costItemFrom = (CostItemInfo)temp;
        }
        if ((temp = this.prtCostItemTo.getData()) != null && temp instanceof CostItemInfo) {
            costItemTo = (CostItemInfo)temp;
        }
        fp.setCostItemFrom(costItemFrom);
        fp.setCostItemTo(costItemTo);
        int selectIndex = this.combBillState.getSelectedIndex();
        fp.setBillSate(String.valueOf(selectIndex));
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        Date bizDateFrom = (Date)this.dpBizDateFrom.getValue();
        Date bizDateTo = (Date)this.dpBizDateTo.getValue();
        if (bizDateFrom != null && bizDateTo != null && bizDateFrom.equals(bizDateTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            bizDateTo.setHours(23);
            bizDateTo.setMinutes(59);
            bizDateTo.setSeconds(59);
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
        } else {
            if (bizDateFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            }
            if (bizDateTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
            }
        }
        int selectIndex = this.combBillState.getSelectedIndex();
        String billStatus = String.valueOf(selectIndex + 1);
        if (selectIndex != 0) {
            filterBiz.getFilterItems().add(new FilterItemInfo("billStatus", (Object)billStatus, CompareType.EQUALS));
        }
        String periodFrom = null;
        String periodTo = null;
        Object temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = temp.toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = temp.toString();
        }
        if (periodFrom != null && periodTo != null && periodFrom.equals(periodTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.EQUALS));
        } else {
            if (periodFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
            }
            if (periodTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
            }
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public void clear() {
        try {
            this.clearFilterData();
            this.formatUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prtCompany.setValue((Object)companyOrg);
    }

    private void filterCostCenter(KDBizPromptBox prmt) {
        try {
            BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)prmt, (String)this.companyOrg.getId().toString());
            FilterInfo filterCostCenterType = new FilterInfo();
            filterCostCenterType.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)"0", CompareType.EQUALS));
            filterCostCenterType.mergeFilter(filterCostCenterType, "AND");
            filterCostCenterType.mergeFilter(prmt.getEntityViewInfo().getFilter(), "AND");
            prmt.getEntityViewInfo().setFilter(filterCostCenterType);
            prmt.getQueryAgent().resetRuntimeEntityView();
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void filterCostObjectByOrg(KDBizPromptBox prmt) throws Exception {
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)prmt, (String)this.companyOrg.getId().toString());
        FilterInfo filterIsForbiden = new FilterInfo();
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)"0", CompareType.EQUALS));
        filterIsForbiden.mergeFilter(prmt.getEntityViewInfo().getFilter(), "AND");
        prmt.getEntityViewInfo().setFilter(filterIsForbiden);
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    private void filterBillNumByOrg(KDBizPromptBox prmt) throws Exception {
        FilterInfo filterIsForbiden = new FilterInfo();
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.companyOrg.getId().toString(), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterIsForbiden);
        prmt.setEntityViewInfo(view);
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    private void intiPeriod(KDSpinner kdsp) throws Exception {
        PeriodInfo periodStart = NCMUtils.GetStartPeriod(null, (String)this.companyOrg.getId().toString());
        PeriodInfo periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.companyOrg.getId().toString());
        int startYear = periodStart.getPeriodYear();
        int curYear = periodCur.getPeriodYear();
        ArrayList<String> periodList = new ArrayList<String>();
        for (int year = startYear; year <= curYear; ++year) {
            String tem = null;
            for (int month = 1; month < 13; ++month) {
                tem = month < 10 ? String.valueOf(year) + "0" + month : String.valueOf(year) + month;
                if (Integer.parseInt(tem) < periodStart.getNumber() || Integer.parseInt(tem) > periodCur.getNumber()) continue;
                periodList.add(tem);
            }
        }
        SpinnerListModel dataModel = new SpinnerListModel(periodList);
        kdsp.setModel((SpinnerModel)dataModel);
        kdsp.setValue((Object)String.valueOf(periodCur.getNumber()));
    }

    private void initBizDate(KDDatePicker kdDate) {
        kdDate.setValue(null);
    }

    private void clearFilterData() {
        this.prtBillNumFrom.setValue(null);
        this.prtBillNumTo.setValue(null);
        this.prtCostcenterFrom.setValue(null);
        this.prtCostcenterTo.setValue(null);
        this.prtCostItemFrom.setValue(null);
        this.prtCostItemTo.setValue(null);
        this.prtCostObjectFrom.setValue(null);
        this.prtCostObjectTo.setValue(null);
        this.combBillState.setSelectedIndex(0);
    }

    private void initPeriodSpinner(final JSpinner spFrom, final JSpinner spTo, int minPeriod, int initFromPeriod, int initToPeriod) {
        boolean argumentError = false;
        if (minPeriod <= 0) {
            argumentError = true;
        }
        String sMinPeriod = String.valueOf(minPeriod);
        if (!argumentError && sMinPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [minPeriod:" + minPeriod + "] error.");
        }
        argumentError = false;
        if (initFromPeriod <= 0 || initFromPeriod < minPeriod) {
            argumentError = true;
        }
        String sInitFromPeriod = String.valueOf(initFromPeriod);
        if (!argumentError && sInitFromPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initFromPeriod:" + initFromPeriod + "] error.");
        }
        argumentError = false;
        if (initToPeriod <= 0 || initToPeriod < minPeriod || initToPeriod < initFromPeriod) {
            argumentError = true;
        }
        String sInitToPeriod = String.valueOf(initToPeriod);
        if (!argumentError && sInitToPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initToPeriod:" + initToPeriod + "] error.");
        }
        final int minYear = Integer.parseInt(sMinPeriod.substring(0, 4));
        final int minMonth = Integer.parseInt(sMinPeriod.substring(4));
        SpinnerNumberModel modelFrom = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spTo.setValue(spFrom.getValue());
                }
            }
        };
        SpinnerNumberModel modelTo = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spFrom.setValue(spTo.getValue());
                }
            }
        };
        spFrom.setModel(modelFrom);
        spTo.setModel(modelTo);
        spFrom.setValue(initFromPeriod);
        spTo.setValue(initToPeriod);
    }

    private void initPeriod() throws EASBizException, BOSException {
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        if (this.periodStart == null || this.periodCur == null) {
            return;
        }
        int minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initFromPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prtCompany;
    }

    protected void registerF7() throws Exception {
        this.f7ContextManager.registerCostCenterF7(this.prtCostcenterFrom, new CostCenterType[]{CostCenterType.DirectProdDept});
        this.f7ContextManager.registerCostCenterF7(this.prtCostcenterTo, new CostCenterType[]{CostCenterType.DirectProdDept});
        this.f7ContextManager.registerCostObjectF7(this.prtCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.prtCostObjectTo, false);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtBillNumFrom, "com.kingdee.eas.ncm.bill.app.EopWipAdjustHisForFilterQuery", "companyOrg.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtBillNumTo, "com.kingdee.eas.ncm.bill.app.EopWipAdjustHisForFilterQuery", "companyOrg.id");
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prtCostcenterFrom.setData(null);
                this.prtCostcenterTo.setData(null);
                this.prtCostObjectFrom.setData(null);
                this.prtCostObjectTo.setData(null);
                this.prtBillNumFrom.setData(null);
                this.prtBillNumTo.setData(null);
                this.prtCostItemFrom.setData(null);
                this.prtCostItemTo.setData(null);
                this.initPeriod();
                this.prtBillNumFrom.setDisplayFormat("$number$");
                this.prtBillNumTo.setDisplayFormat("$number$");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

