/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.EopWipAdjustHisFactory;
import com.kingdee.eas.ncm.bill.client.AbstractEopWipAdjustHisListUI;
import com.kingdee.eas.ncm.bill.client.EopWipAdjustHisEditUI;
import com.kingdee.eas.ncm.bill.client.EopWipAdjustHisFilterUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class EopWipAdjustHisListUI
extends AbstractEopWipAdjustHisListUI {
    private static final Logger logger = CoreUIObject.getLogger(EopWipAdjustHisListUI.class);
    private EopWipAdjustHisFilterUI filterUI = null;
    private CommonQueryDialog dialog = null;
    private int amountPrecision = 2;
    private String amountFormat = "0.00";

    public EopWipAdjustHisListUI() throws Exception {
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
        this.amountPrecision = currency.getPrecision();
        StringBuffer format = new StringBuffer();
        for (int i = 0; i < this.amountPrecision; ++i) {
            format.append("0");
        }
        this.amountFormat = "0." + format.toString();
        this.actionAddNew.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.auditAction.setEnabled(false);
        this.auditAction.setVisible(false);
        this.unauditAction.setEnabled(false);
        this.unauditAction.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("entries.eopWipAmount").getStyleAttributes().setNumberFormat(this.amountFormat);
        this.tblMain.getColumn("entries.adjustAmount").getStyleAttributes().setNumberFormat(this.amountFormat);
        this.tblMain.getColumn("entries.finishAmount").getStyleAttributes().setNumberFormat(this.amountFormat);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EopWipAdjustHisFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return EopWipAdjustHisEditUI.class.getName();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "companyOrg.name", "costCenter.number", "costCenter.name", "costObject.number", "costObject.name", "costObject.orderNumber", "costObject.batchNumber", "baseUnit.name", "eopWipQty", "adjustQty", "finishQty", "eopWipHour", "adjustHour", "finishHour"};
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                EopWipAdjustHisListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        int firstRowIndex = e.getFirstRow();
        int lastRowIndex = e.getLastRow();
        IRow row = null;
        for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
            row = this.tblMain.getRow(i);
            Object unitName = row.getCell("unit.name").getValue();
            if (unitName != null && unitName.toString().trim().length() != 0) continue;
            row.getCell("entries.eopWipQty").setValue((Object)"");
            row.getCell("entries.adjustQty").setValue((Object)"");
            row.getCell("entries.finishQty").setValue((Object)"");
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        try {
            while (rowSet.next()) {
                int precision = rowSet.getInt("mmu.qtyPrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"eopWipQty", (IRowSet)rowSet);
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"adjustQty", (IRowSet)rowSet);
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"finishQty", (IRowSet)rowSet);
                precision = rowSet.getInt("unit.qtyPrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.eopWipQty", (IRowSet)rowSet);
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.adjustQty", (IRowSet)rowSet);
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.finishQty", (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new EopWipAdjustHisFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        return super.initCommonQueryDialog();
    }
}

