/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucherFacade;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.common.GLf7Utils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.FetchDataDirectionEnum;
import com.kingdee.eas.ncm.bill.GLFetchDataEntryInfo;
import com.kingdee.eas.ncm.bill.GLFetchDataFactory;
import com.kingdee.eas.ncm.bill.GLFetchDataInfo;
import com.kingdee.eas.ncm.bill.IGLFetchData;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.client.AbstractGLFetchDataEditUI;
import com.kingdee.eas.ncm.bill.client.AsstActF7UI;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;
import com.kingdee.eas.ncm.common.utils.CostObjectUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GLFetchDataEditUI
extends AbstractGLFetchDataEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GLFetchDataEditUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.ncm.bill.GLFetchDataResource";
    String[] asstActName = null;
    private HashMap asstActTypeInfos = new HashMap();
    private HashMap accountViewInfos = new HashMap();
    KDBizPromptBox prmtAsstActF7 = null;
    String asstAccountIDs = null;
    private int costObjectOfBillRequired = -1;

    public GLFetchDataEditUI() throws Exception {
        this.contCalculatePeriod.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadBaseData();
        NCMClientUtils.selectFirstRow((KDTable)this.kdtEntrys);
        this.setAnalogyEnabled(false);
        IColumn column = this.kdtEntrys.getColumn("asstAccountName");
        this.prmtAsstActF7 = new KDBizPromptBox();
        this.prmtAsstActF7.setCommitFormat("$asstAccountName$");
        this.prmtAsstActF7.setEditFormat("$asstAccountName$");
        this.prmtAsstActF7.setDisplayFormat("$asstAccountName$");
        this.prmtAsstActF7.setEditable(false);
        this.prmtAsstActF7.addSelectorListener(this.createSelectorListener1());
        ObjectValueRender avr2 = new ObjectValueRender();
        avr2.setFormat((IDataFormat)new BizDataFormat("$asstAccountName$"));
        column.setRenderer((IBasicRender)avr2);
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtAsstActF7));
        KDTEditAdapter entryTableChange = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    GLFetchDataEditUI.this.kdtEntries_Changed(e);
                }
                catch (Exception exc) {
                    GLFetchDataEditUI.this.handUIException(exc);
                }
            }
        };
        this.kdtEntrys.addKDTEditListener((KDTEditListener)entryTableChange);
    }

    public void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        GLFetchDataEntryInfo info;
        Object o;
        IRow row;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        if ("asstAccountName".equalsIgnoreCase(fieldName)) {
            row = this.kdtEntrys.getRow(rowIndex);
            o = e.getValue();
            if (o instanceof GLFetchDataEntryInfo) {
                info = (GLFetchDataEntryInfo)o;
                row.getCell("asstAccount").setValue((Object)info.getAsstAccount());
                row.getCell("asstAccountID").setValue((Object)info.getAsstAccountID());
                row.getCell("asstAccountName").setValue((Object)info.getAsstAccountName());
            } else if (o == null) {
                row.getCell("asstAccount").setValue(null);
                row.getCell("asstAccountID").setValue(null);
                row.getCell("asstAccountName").setValue(null);
            }
        }
        if ("account".equalsIgnoreCase(fieldName)) {
            row = this.kdtEntrys.getRow(rowIndex);
            o = e.getValue();
            if (o instanceof AccountViewInfo) {
                info = (AccountViewInfo)o;
                row.getCell("accountName").setValue((Object)info.getName());
            }
        }
        if ("expense".equalsIgnoreCase(fieldName)) {
            row = this.kdtEntrys.getRow(rowIndex);
            o = e.getValue();
            if (o instanceof ExpenseInfo) {
                info = (ExpenseInfo)o;
                CostItemInfo ci = NCMUtils.getCostItemByExpense(null, (String)info.getId().toString(), (String)((CompanyOrgUnitInfo)this.prmtcompanyOrg.getData()).getId().toString());
                row.getCell("costItem").setValue((Object)ci);
            }
        }
        if ("batchNumber".equalsIgnoreCase(fieldName)) {
            row = this.kdtEntrys.getRow(rowIndex);
            o = e.getValue();
            if (o instanceof String) {
                String batchNumber = (String)o;
                MaterialInfo materialInfo = (MaterialInfo)row.getCell("materialNumber").getValue();
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((MaterialInfo)materialInfo, (String)batchNumber, (boolean)true);
                if (costObjectRelatedInfo != null) {
                    row.getCell("costObject").setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                } else {
                    row.getCell("batchNumber").setValue(null);
                    throw new NcmBillException(NcmBillException.MATANDBATCH_NO_COSTOBJECT);
                }
            }
        }
        if (colIndex == this.kdtEntrys.getColumn("manufacturerOrder").getColumnIndex() && (o = (row = this.kdtEntrys.getRow(rowIndex)).getCell("costObject").getValue()) == null) {
            row.getCell("manufacturerOrder").setValue(null);
        }
        if (colIndex == this.kdtEntrys.getColumn("materialNumber").getColumnIndex() && (o = (row = this.kdtEntrys.getRow(rowIndex)).getCell("costObject").getValue()) == null && row.getCell("batchNumber").getFormattedStyleAttributes().isLocked()) {
            row.getCell("materialNumber").setValue(null);
            row.getCell("materialName").setValue(null);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.editData != null && BillBaseStatusEnum.AUDITED == this.editData.getBillStatus()) {
            this.setFetchDataEnabled(true);
            this.setAuditEnabled(false);
            this.setUnAuditEnabled(true);
        } else {
            this.setFetchDataEnabled(false);
            this.setAuditEnabled(true);
            this.setUnAuditEnabled(false);
        }
        if ("ADDNEW".equals(this.oprtState) || "EDIT".equals(this.oprtState)) {
            this.setAnalogyEnabled(false);
            this.setCopyEntryEnabled(true);
        } else {
            this.setAnalogyEnabled(false);
            this.setCopyEntryEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getCompanyOrg() == null) {
            this.kdtEntrys.setEnabled(false);
        } else {
            this.kdtEntrys.setEnabled(true);
        }
        int count = this.kdtEntrys.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            Object o = row.getCell("account").getValue();
            if (!(o instanceof AccountViewInfo)) continue;
            AccountViewInfo info = (AccountViewInfo)o;
            row.getCell("accountName").setValue((Object)info.getName());
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuTable1.setVisible(false);
        this.menuWorkflow.setVisible(false);
        if (this.editData != null && BillBaseStatusEnum.AUDITED == this.editData.getBillStatus()) {
            this.setFetchDataEnabled(true);
            this.setAuditEnabled(false);
            this.setUnAuditEnabled(true);
        } else {
            this.setFetchDataEnabled(false);
            this.setAuditEnabled(true);
            this.setUnAuditEnabled(false);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BDCMUtils.checkClose((PeriodInfo)this.editData.getCalculatePeriod(), (CompanyOrgUnitInfo)this.editData.getCompanyOrg());
        super.actionEdit_actionPerformed(e);
        if (this.getOprtState().equalsIgnoreCase("ADDNEW") || this.getOprtState().equalsIgnoreCase("EDIT")) {
            this.kdtEntrys.setEditable(true);
            this.setAuditEnabled(false);
            this.setUnAuditEnabled(false);
            this.setFetchDataEnabled(false);
        } else {
            this.kdtEntrys.setEditable(false);
            if (this.editData.getBillStatus() == BillBaseStatusEnum.AUDITED) {
                this.setFetchDataEnabled(true);
                this.setAuditEnabled(false);
                this.setUnAuditEnabled(true);
            } else {
                this.setFetchDataEnabled(false);
                this.setAuditEnabled(true);
                this.setUnAuditEnabled(false);
            }
        }
    }

    private void loadBaseData() {
        BDCMClientUtils.setBizOrgF7ByType((KDBizPromptBox)this.prmtcompanyOrg, (OrgType)OrgType.Company, (boolean)false);
        try {
            this.companyOrgUnit_dataChanged(null);
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
        DataChangeListener companyOrgUnitListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    GLFetchDataEditUI.this.companyOrgUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    GLFetchDataEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtcompanyOrg.addDataChangeListener(companyOrgUnitListener);
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("GlFetchData_audit");
        }
        super.auditAction_actionPerformed(e);
        if (this.editData != null && BillBaseStatusEnum.AUDITED == this.editData.getBillStatus()) {
            this.setFetchDataEnabled(true);
        }
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        super.unauditAction_actionPerformed(e);
        if (this.editData == null || BillBaseStatusEnum.AUDITED != this.editData.getBillStatus()) {
            this.setFetchDataEnabled(false);
        }
    }

    private void setFetchDataEnabled(boolean isEnabled) {
        this.btnFetchData.setEnabled(isEnabled);
        this.menuItemFetchData.setEnabled(isEnabled);
        this.actionFetchData.setEnabled(isEnabled);
    }

    private void setAuditEnabled(boolean isEnabled) {
        this.btnAudit.setEnabled(isEnabled);
        this.menuItemAudit.setEnabled(isEnabled);
        this.auditAction.setEnabled(isEnabled);
    }

    private void setUnAuditEnabled(boolean isEnabled) {
        this.btnUnaudit.setEnabled(isEnabled);
        this.menuItemunAudit.setEnabled(isEnabled);
        this.unauditAction.setEnabled(isEnabled);
    }

    private void setAnalogyEnabled(boolean isEnabled) {
        this.actionAnalogy.setEnabled(isEnabled);
        this.actionAnalogy.setVisible(true);
    }

    private void setCopyEntryEnabled(boolean isEnabled) {
        this.actionCopyEntry.setEnabled(isEnabled);
        this.actionCopyEntry.setVisible(isEnabled);
    }

    private void formatEntryTable(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        PeriodTypeInfo periodType = companyOrgUnitInfo.getAccountPeriodType();
        BDCMClientUtils.filterCompanyOrgForPeriod((KDBizPromptBox)this.prmtCalculatePeriod, (String)periodType.getId().toString());
        KDBizPromptBox prmtAccount = new KDBizPromptBox();
        this.setAccountF7(companyOrgUnitInfo, prmtAccount);
        prmtAccount.setEditFormat("$number$");
        prmtAccount.setCommitFormat("$number$");
        prmtAccount.setDisplayFormat("$number$");
        IColumn iColumn = this.kdtEntrys.getColumn("account");
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtAccount));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn("account").setRenderer((IBasicRender)avr);
        KDBizPromptBox prmtExpense = new KDBizPromptBox();
        prmtExpense.setEditFormat("$number$");
        prmtExpense.setCommitFormat("$number$");
        prmtExpense.setDisplayFormat("$name$");
        prmtExpense.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ExpenseF7Query");
        iColumn = this.kdtEntrys.getColumn("expense");
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtExpense));
        EntityViewInfo view = prmtExpense.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
            prmtExpense.setEntityViewInfo(view);
        }
        HashSet<Integer> expenseTypeSet = new HashSet<Integer>();
        expenseTypeSet.add(2);
        expenseTypeSet.add(30);
        expenseTypeSet.add(40);
        expenseTypeSet.add(50);
        expenseTypeSet.add(60);
        BDCMClientUtils.filterExpenseF7((EntityViewInfo)view, (String)companyOrgUnitInfo.getId().toString(), expenseTypeSet);
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        prmtCostItem.setDisplayFormat("$name$");
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ItemType", (Object)"1", CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        prmtCostItem.setEntityViewInfo(viewInfo);
        iColumn = this.kdtEntrys.getColumn("costItem");
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostItem));
        KDBizPromptBox prmtCostCenterGroup = new KDBizPromptBox();
        prmtCostCenterGroup.setQueryInfo("com.kingdee.eas.basedata.ncm.app.CostCenterGroupQuery");
        prmtCostCenterGroup.setEditFormat("$number$");
        prmtCostCenterGroup.setCommitFormat("$number$");
        prmtCostCenterGroup.setDisplayFormat("$name$");
        BDCMClientUtils.filterCostCenterGroupF7((KDBizPromptBox)prmtCostCenterGroup, (String)companyOrgUnitInfo.getId().toString());
        iColumn = this.kdtEntrys.getColumn("costCenterGroup");
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostCenterGroup));
        KDBizPromptBox prmtCostCenter = new KDBizPromptBox();
        prmtCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtCostCenter.setEditFormat("$number$");
        prmtCostCenter.setCommitFormat("$number$");
        prmtCostCenter.setDisplayFormat("$name$");
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)prmtCostCenter, (String)companyOrgUnitInfo.getId().toString());
        iColumn = this.kdtEntrys.getColumn("costCenter");
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostCenter));
        KDBizPromptBox prmtCostObject = new KDBizPromptBox();
        prmtCostObject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, prmtCostObject, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, this.getCompanyOrgInfoWithDefault().getId().toString());
        prmtCostObject.setSelector((KDPromptSelector)arg0);
        prmtCostObject.setEditFormat("$number$");
        prmtCostObject.setCommitFormat("$number$");
        prmtCostObject.setDisplayFormat("$name$");
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)prmtCostObject, (String)companyOrgUnitInfo.getId().toString());
        iColumn = this.kdtEntrys.getColumn("costObject");
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostObject));
        prmtCostObject.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                GLFetchDataEditUI.this.fillCostObjectAfterDo(eventObj);
            }
        });
        if (this.isCostObjectOfBillRequired()) {
            iColumn.setRequired(true);
        }
        KDBizPromptBox prmtMnaufacture = new KDBizPromptBox();
        NCMClientUtils.setManufactureF7((KDBizPromptBox)prmtMnaufacture, (String)companyOrgUnitInfo.getId().toString());
        ObjectValueRender avrMnaufacture = new ObjectValueRender();
        avrMnaufacture.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("manufacturerOrder").setRenderer((IBasicRender)avrMnaufacture);
        this.kdtEntries.getColumn("manufacturerOrder").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMnaufacture));
        prmtMnaufacture.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                GLFetchDataEditUI.this.fillManufactureAfterDo(eventObj);
            }
        });
        KDBizPromptBox prmtMaterial = new KDBizPromptBox();
        NCMClientUtils.setMaterialF7((KDBizPromptBox)prmtMaterial, (String)companyOrgUnitInfo.getId().toString());
        ObjectValueRender avrMat = new ObjectValueRender();
        avrMat.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("materialNumber").setRenderer((IBasicRender)avrMat);
        this.kdtEntries.getColumn("materialNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtMaterial));
        prmtMaterial.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                GLFetchDataEditUI.this.fillMaterialAfterDo(eventObj);
            }
        });
        KDBizPromptBox prmtCostObjectSuite = new KDBizPromptBox();
        prmtCostObjectSuite.setQueryInfo("com.kingdee.eas.basedata.assistant.F7CostObjectSuiteQuery");
        prmtCostObjectSuite.setEditable(true);
        prmtCostObjectSuite.setDisplayFormat("$name$");
        prmtCostObjectSuite.setEditFormat("$number$");
        prmtCostObjectSuite.setCommitFormat("$number$");
        prmtCostObjectSuite.setRequired(true);
        BDCMClientUtils.filterF7((KDBizPromptBox)prmtCostObjectSuite, (String)"company.id", (Object)companyOrgUnitInfo.getId().toString());
        KDTDefaultCellEditor itemEditor2 = new KDTDefaultCellEditor((IKDEditor)prmtCostObjectSuite);
        this.kdtEntrys.getColumn("costObjectSuite").setEditor((ICellEditor)itemEditor2);
        ObjectValueRender avr2 = new ObjectValueRender();
        avr2.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn("costObjectSuite").setRenderer((IBasicRender)avr2);
        KDBizPromptBox prmtDepartment = new KDBizPromptBox();
        prmtDepartment.setQueryInfo("com.kingdee.eas.ncm.bill.app.AdminAndCostCenterQuery");
        prmtDepartment.setEditable(true);
        prmtDepartment.setDisplayFormat("$name$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$");
        BDCMClientUtils.filterAdminAndCostCenterF7((KDBizPromptBox)prmtDepartment, (String)companyOrgUnitInfo.getId().toString());
        KDTDefaultCellEditor dpEditor = new KDTDefaultCellEditor((IKDEditor)prmtDepartment);
        this.kdtEntrys.getColumn("department").setEditor((ICellEditor)dpEditor);
        ObjectValueRender dpRender = new ObjectValueRender();
        dpRender.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn("department").setRenderer((IBasicRender)dpRender);
        KDBizPromptBox prmtSourceCostCenter = new KDBizPromptBox();
        prmtSourceCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtSourceCostCenter.setEditFormat("$number$");
        prmtSourceCostCenter.setCommitFormat("$number$");
        prmtSourceCostCenter.setDisplayFormat("$name$");
        BDCMClientUtils.filterCostCenterByCompanyOrgF7((KDBizPromptBox)prmtSourceCostCenter, (String)companyOrgUnitInfo.getId().toString());
        iColumn = this.kdtEntrys.getColumn("sourceCostCenter");
        iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSourceCostCenter));
        DataChangeListener accountListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    GLFetchDataEditUI.this.account_dataChanged(e);
                }
                catch (Exception exc) {
                    GLFetchDataEditUI.this.handUIException(exc);
                }
            }
        };
        KDTSelectListener kDTSelectListener = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock block = e.getSelectBlock();
                if (block != null && !"VIEW".equals(GLFetchDataEditUI.this.oprtState)) {
                    GLFetchDataEditUI.this.setAnalogyEnabled(true);
                } else {
                    GLFetchDataEditUI.this.setAnalogyEnabled(false);
                }
            }
        };
        prmtAccount.addDataChangeListener(accountListener);
        this.kdtEntrys.addKDTSelectListener(kDTSelectListener);
        kDTSelectListener.toString();
    }

    private void companyOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object o = this.prmtcompanyOrg.getData();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (o instanceof CompanyOrgUnitInfo) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)o;
        }
        if (companyOrgUnitInfo != null) {
            this.kdtEntrys.setEnabled(true);
            this.formatEntryTable(companyOrgUnitInfo);
        } else {
            this.kdtEntrys.setEnabled(false);
        }
    }

    private void account_dataChanged(DataChangeEvent e) throws Exception {
        int rowIndex = this.kdtEntrys.getSelectManager().getActiveRowIndex();
        int colIndex = this.kdtEntrys.getSelectManager().getActiveColumnIndex();
        Object old = this.kdtEntrys.getCell(rowIndex, colIndex).getValue();
        boolean isChanged = false;
        if (old == null && e.getNewValue() != null) {
            isChanged = true;
        }
        if (old != null && e.getNewValue() == null) {
            isChanged = true;
        }
        if (old != null && e.getNewValue() != null && !old.equals(e.getNewValue())) {
            isChanged = true;
        }
        if (isChanged) {
            if (e.getNewValue() == null) {
                IRow row = this.kdtEntrys.getRow(rowIndex);
                row.getCell("asstAccountName").setValue(null);
                row.getCell("asstAccountID").setValue(null);
                row.getCell("asstAccount").setValue(null);
            } else {
                Object o = e.getNewValue();
                if (o instanceof AccountViewInfo) {
                    this.getAsstActInfoByAccount((AccountViewInfo)o);
                }
                StringBuffer asstAccountName = new StringBuffer();
                if (this.asstActName != null) {
                    int count = this.asstActName.length;
                    for (int i = 0; i < count; ++i) {
                        if (!asstAccountName.toString().equals("")) {
                            asstAccountName.append(" ; ");
                        }
                        asstAccountName.append(this.asstActName[i]);
                        asstAccountName.append(" = ");
                    }
                }
                IRow row = this.kdtEntrys.getRow(rowIndex);
                row.getCell("asstAccountName").setValue((Object)asstAccountName.toString());
                row.getCell("asstAccountID").setValue(null);
                row.getCell("asstAccount").setValue(null);
                if (this.asstActName == null || this.asstActName.length == 0) {
                    row.getCell("asstAccountName").getStyleAttributes().setLocked(true);
                } else {
                    row.getCell("asstAccountName").getStyleAttributes().setLocked(false);
                }
            }
        }
    }

    protected IVoucherFacade getFacadeInterface() throws Exception {
        return VoucherFacadeFactory.getRemoteInstance();
    }

    private void setAccountF7(CompanyOrgUnitInfo companyOrgUnitInfo, KDBizPromptBox prmtAccount) {
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, companyOrgUnitInfo.getAccountTable(), null);
        prmtAccount.setEditable(true);
        prmtAccount.setEditFormat("$number$");
        prmtAccount.setCommitFormat("$helpCode$;$number$;$name$");
        prmtAccount.setDisplayFormat("$name$");
        prmtAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        prmtAccount.setSelector((KDPromptSelector)apb);
        BDCMClientUtils.filterAccountVIewF7((KDBizPromptBox)prmtAccount, (String)companyOrgUnitInfo.getCU().getId().toString(), (CompanyOrgUnitInfo)companyOrgUnitInfo);
    }

    @Override
    public void actionFetchData_actionPerformed(ActionEvent e) throws Exception {
        IGLFetchData iGLFetchData = GLFetchDataFactory.getRemoteInstance();
        MsgBox.showInfo((String)iGLFetchData.fetchData(new String[]{this.editData.getId().toString()}));
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return GLFetchDataFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        GLFetchDataEntryInfo entryInfo = new GLFetchDataEntryInfo();
        entryInfo.setFetchDataDirect(FetchDataDirectionEnum.DEBIT);
        return entryInfo;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected IObjectValue createNewData() {
        GLFetchDataInfo objectValue = new GLFetchDataInfo();
        super.applyBillDefaultValue((IObjectValue)objectValue);
        PeriodInfo period = null;
        try {
            period = NCMUtils.GetCurrentPeriod(null, (String)objectValue.getCompanyOrg().getId().toString());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        objectValue.setCalculatePeriod(period);
        return objectValue;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.prmtCalculatePeriod.setEnabled(true);
    }

    @Override
    public void actionAnalogy_actionPerformed(ActionEvent e) throws Exception {
        this.dealAnalogy(this.kdtEntrys);
    }

    @Override
    public void actionCopyEntry_actionPerformed(ActionEvent e) throws Exception {
        this.dealCopyEntry(this.kdtEntrys);
    }

    public void checkValidDataForSubmit() throws Exception {
        BDCMClientUtils.checkIsNull((JComponent)this.txtDescription, (String)this.contDescription.getBoundLabelText());
        this.checkEntryNotNull();
    }

    private void checkEntryNotNull() {
        String[] checkCols = this.isCostObjectOfBillRequired() ? new String[]{"account", "fetchDataDirect", "expense", "costItem", "costObject"} : new String[]{"account", "fetchDataDirect", "expense", "costItem"};
        IRow row = null;
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            row = this.kdtEntrys.getRow(i);
            for (int j = 0; j < checkCols.length; ++j) {
                if (row.getCell(checkCols[j]).getValue() != null) continue;
                String colName = this.kdtEntrys.getHeadRow(0).getCell(checkCols[j]).getValue().toString();
                String msg = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"146_GLFetchDataEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"44_GLFetchDataEditUI") + colName + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"45_GLFetchDataEditUI");
                int firstTableCol = this.kdtEntrys.getColumnIndex(checkCols[j]);
                this.kdtEntrys.getEditManager().editCellAt(i, firstTableCol);
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (row.getCell("costCenter").getValue() != null || row.getCell("costCenterGroup").getValue() != null) continue;
            int firstTableCol = this.kdtEntrys.getColumnIndex("costCenterGroup");
            this.kdtEntrys.getEditManager().editCellAt(i, firstTableCol);
            String msg = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"146_GLFetchDataEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"46_GLFetchDataEditUI");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    protected KDBizPromptBox getKDBizPromptBox(VoucherInfo.DynamicColumnInfo colInfo) {
        return new KDBizPromptBox();
    }

    protected void getCellEditor(KDBizPromptBox bizPromptBox, AsstActTypeInfo colInfo, AccountViewInfo acc) {
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setDisplayFormat("$number$;$name$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setQueryInfo(colInfo.getDefaultQueryName());
        bizPromptBox.setDefaultF7UIName(colInfo.getDefaultF7UI());
        GLf7Utils.assignSelector((KDBizPromptBox)bizPromptBox, null, (String)colInfo.getMappingFieldName(), (boolean)colInfo.isIsForCompany(), (boolean)true, (String)acc.getId().toString(), (CoreUIObject)this, (boolean)true);
    }

    protected ICellEditor getTextEditor() {
        KDTDefaultCellEditor textEditor = new KDTDefaultCellEditor((JTextField)new KDTextField());
        textEditor.setClickCountToStart(1);
        return textEditor;
    }

    private void getAsstActInfo() throws Exception {
        this.asstActName = null;
        int currentRow = this.kdtEntrys.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntrys.getRow(currentRow);
        Object o = row.getCell("account").getValue();
        AccountViewInfo accountViewInfo = null;
        if (!(o instanceof AccountViewInfo)) {
            return;
        }
        accountViewInfo = (AccountViewInfo)o;
        o = row.getCell("asstAccountID").getValue();
        this.asstAccountIDs = o == null ? null : o.toString();
        this.getAsstActInfoByAccount(accountViewInfo);
    }

    private void getAsstActInfoByAccount(AccountViewInfo accountViewInfo) throws Exception {
        String asstAccountID = null;
        AsstAccountInfo asstAccount = accountViewInfo.getCAA();
        if (asstAccount == null) {
            this.asstActName = null;
            return;
        }
        asstAccountID = asstAccount.getId().toString();
        IAsstAccount iAsstAccount = AsstAccountFactory.getRemoteInstance();
        AsstAccountInfo asstAccountInfo = iAsstAccount.getAsstAccountInfo((IObjectPK)new ObjectStringPK(asstAccountID));
        AsstActGroupDetailCollection asstCollection = asstAccountInfo.getAsstActGpDt();
        AsstActTypeInfo asstActTypeInfo = null;
        ArrayList<String> asstActNameList = new ArrayList<String>();
        int count1 = asstCollection.size();
        for (int i = 0; i < count1; ++i) {
            asstActTypeInfo = asstAccountInfo.getAsstActGpDt().get(i).getAsstActType();
            if (asstActTypeInfo.getId() == null) continue;
            IAsstActType iAsstAcctType = AsstActTypeFactory.getRemoteInstance();
            AsstActTypeInfo fullAsstActTypeInfo = iAsstAcctType.getAsstActTypeInfo((IObjectPK)new ObjectStringPK(asstActTypeInfo.getId().toString()));
            asstActNameList.add(fullAsstActTypeInfo.getName());
            if (this.asstActTypeInfos.get(fullAsstActTypeInfo.getName()) == null) {
                this.asstActTypeInfos.put(fullAsstActTypeInfo.getName(), fullAsstActTypeInfo);
            }
            if (this.accountViewInfos.get(fullAsstActTypeInfo.getName()) != null) continue;
            this.accountViewInfos.put(fullAsstActTypeInfo.getName(), accountViewInfo);
        }
        this.asstActName = new String[asstActNameList.size()];
        asstActNameList.toArray(this.asstActName);
    }

    private SelectorListener createSelectorListener1() {
        return new SelectorListener(){

            public void willShow(SelectorEvent e) {
                int rowIndex = GLFetchDataEditUI.this.kdtEntrys.getSelectManager().getActiveRowIndex();
                IRow row = GLFetchDataEditUI.this.kdtEntrys.getRow(rowIndex);
                if (row.getCell("account").getValue() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)GLFetchDataEditUI.RESOURCE_PATH, (String)"ACCOUNT_BEFORE_ASST"));
                    SysUtil.abort();
                }
                AsstActF7UI prmtCostItem_F7ListUI = null;
                try {
                    GLFetchDataEditUI.this.getAsstActInfo();
                    prmtCostItem_F7ListUI = new AsstActF7UI(GLFetchDataEditUI.this.asstActName, GLFetchDataEditUI.this.asstActTypeInfos, GLFetchDataEditUI.this.accountViewInfos, GLFetchDataEditUI.this.asstAccountIDs);
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                    GLFetchDataEditUI.this.handUIException(e1);
                }
                HashMap<String, Window> ctx = new HashMap<String, Window>();
                ctx.put("bizUIOwner", SwingUtilities.getWindowAncestor(prmtCostItem_F7ListUI));
                prmtCostItem_F7ListUI.setF7Use(true, ctx);
                GLFetchDataEditUI.this.prmtAsstActF7.setSelector((KDPromptSelector)prmtCostItem_F7ListUI);
            }
        };
    }

    protected PeriodInfo getPeriodByBizDate(Date date, CompanyOrgUnitInfo orgInfo) {
        if (orgInfo == null) {
            return null;
        }
        return super.getPeriodByBizDate(date, orgInfo);
    }

    public void isAddViewAndNeverBreak(CMBillBaseInfo aSCMBillBaseInfo) throws EASBizException, BOSException {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void isStart() throws Exception {
    }

    private boolean isCostObjectOfBillRequired() {
        try {
            if (this.costObjectOfBillRequired < 0) {
                this.costObjectOfBillRequired = 0;
                if (NCMUtils.isCostObjectOfBillRequired(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
                    this.costObjectOfBillRequired = 1;
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            this.abort();
        }
        return this.costObjectOfBillRequired == 1;
    }

    private void dealAnalogy(KDTable table) throws Exception {
        int selectIndex = table.getSelectManager().getActiveRowIndex();
        AccountViewInfo accountViewInfo = (AccountViewInfo)table.getCell(selectIndex, "account").getValue();
        if (accountViewInfo != null) {
            StringBuffer getAccountView = new StringBuffer();
            AccountViewInfo accountViewParent = accountViewInfo.getParent();
            if (accountViewParent == null) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"NO_AnalogiedData"));
                SysUtil.abort();
            } else {
                String accountViewParentID = accountViewParent.getId().toString();
                getAccountView.append("select * where Parent.ID = '").append(accountViewParentID).append("' and number > '").append(accountViewInfo.getNumber()).append("' order by number");
            }
            AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(getAccountView.toString());
            if (coll != null && coll.size() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"NO_AnalogiedData"));
                SysUtil.abort();
            } else if (coll != null && coll.size() > 0) {
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    StringBuffer asstAccountName = new StringBuffer();
                    AccountViewInfo accountViewInfoTmp = (AccountViewInfo)iter.next();
                    IRow row = table.addRow(++selectIndex);
                    row.getCell("account").setValue((Object)accountViewInfoTmp);
                    row.getCell("accountName").setValue((Object)accountViewInfoTmp.getName());
                    this.getAsstActInfoByAccount(accountViewInfoTmp);
                    if (this.asstActName != null) {
                        int count = this.asstActName.length;
                        for (int i = 0; i < count; ++i) {
                            if (!asstAccountName.toString().equals("")) {
                                asstAccountName.append(" ; ");
                            }
                            asstAccountName.append(this.asstActName[i]);
                            asstAccountName.append(" = ");
                        }
                    }
                    row.getCell("asstAccountName").setValue((Object)asstAccountName.toString());
                    row.getCell("fetchDataDirect").setValue((Object)FetchDataDirectionEnum.DEBIT);
                    this.createSelectorListener1();
                }
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"NO_AnalogiedData"));
            SysUtil.abort();
        }
    }

    private void dealCopyEntry(KDTable table) throws Exception {
        KDTSelectBlock seleBlock = table.getSelectManager().get();
        if (seleBlock == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"NO_SelectedData"));
            SysUtil.abort();
        }
        int selectRowIndex = table.getSelectManager().get().getBeginRow();
        IRow rowCopyFrom = table.getRow(selectRowIndex);
        IRow rowCopyTo = table.addRow(++selectRowIndex);
        rowCopyTo.getCell("account").setValue(rowCopyFrom.getCell("account").getValue());
        rowCopyTo.getCell("accountName").setValue(rowCopyFrom.getCell("accountName").getValue());
        rowCopyTo.getCell("asstAccountID").setValue(rowCopyFrom.getCell("asstAccountID").getValue());
        rowCopyTo.getCell("asstAccount").setValue(rowCopyFrom.getCell("asstAccount").getValue());
        rowCopyTo.getCell("asstAccountName").setValue(rowCopyFrom.getCell("asstAccountName").getValue());
        rowCopyTo.getCell("fetchDataDirect").setValue(rowCopyFrom.getCell("fetchDataDirect").getValue());
        rowCopyTo.getCell("costCenterGroup").setValue(rowCopyFrom.getCell("costCenterGroup").getValue());
        rowCopyTo.getCell("costCenter").setValue(rowCopyFrom.getCell("costCenter").getValue());
        rowCopyTo.getCell("expense").setValue(rowCopyFrom.getCell("expense").getValue());
        rowCopyTo.getCell("costItem").setValue(rowCopyFrom.getCell("costItem").getValue());
        rowCopyTo.getCell("costObject").setValue(rowCopyFrom.getCell("costObject").getValue());
        rowCopyTo.getCell("costObjectSuite").setValue(rowCopyFrom.getCell("costObjectSuite").getValue());
        rowCopyTo.getCell("department").setValue(rowCopyFrom.getCell("department").getValue());
        rowCopyTo.getCell("sourceCostCenter").setValue(rowCopyFrom.getCell("sourceCostCenter").getValue());
        rowCopyTo.getCell("materialNumber").setValue(rowCopyFrom.getCell("materialNumber").getValue());
        rowCopyTo.getCell("materialName").setValue(rowCopyFrom.getCell("materialName").getValue());
        rowCopyTo.getCell("manufacturerOrder").setValue(rowCopyFrom.getCell("manufacturerOrder").getValue());
        rowCopyTo.getCell("projectNumber").setValue(rowCopyFrom.getCell("projectNumber").getValue());
        rowCopyTo.getCell("trackNumber").setValue(rowCopyFrom.getCell("trackNumber").getValue());
        table.getSelectManager().select(selectRowIndex, rowCopyTo.getCell("account").getColumnIndex());
    }

    private void fillCostObjectAfterDo(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntries.getRow(selectRowIndex);
        if (newValue != null && newValue instanceof CostObjectInfo) {
            CostObjectInfo oldCostObject = null;
            if (row.getCell("costObject").getValue() instanceof CostObjectInfo) {
                oldCostObject = (CostObjectInfo)row.getCell("costObject").getValue();
            }
            if (oldCostObject != null && oldCostObject.getId().toString().equals(((CostObjectInfo)newValue).getId().toString())) {
                return;
            }
            try {
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByCO((CostObjectInfo)((CostObjectInfo)newValue));
                row.getCell("manufacturerOrder").setValue((Object)costObjectRelatedInfo.getManufactureOrderInfo());
                row.getCell("materialNumber").setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                row.getCell("materialName").setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                row.getCell("projectNumber").setValue((Object)costObjectRelatedInfo.getProjectNumber());
                row.getCell("trackNumber").setValue((Object)costObjectRelatedInfo.getTrackNumber());
                row.getCell("batchNumber").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            row.getCell("materialNumber").setValue(null);
            row.getCell("materialName").setValue(null);
            row.getCell("manufacturerOrder").setValue(null);
            row.getCell("projectNumber").setValue(null);
            row.getCell("trackNumber").setValue(null);
            row.getCell("batchNumber").setValue(null);
        }
    }

    private void fillManufactureAfterDo(DataChangeEvent eventObj) {
        block10: {
            Object newValue = eventObj.getNewValue();
            int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
            IRow row = this.kdtEntries.getRow(selectRowIndex);
            if (newValue != null && newValue instanceof ManufactureOrderInfo) {
                ManufactureOrderInfo oldOrder = null;
                if (row.getCell("manufacturerOrder").getValue() instanceof ManufactureOrderInfo) {
                    oldOrder = (ManufactureOrderInfo)row.getCell("manufacturerOrder").getValue();
                }
                if (oldOrder != null && oldOrder.getId().toString().equals(((ManufactureOrderInfo)newValue).getId().toString())) {
                    return;
                }
                try {
                    CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByOrder((ManufactureOrderInfo)((ManufactureOrderInfo)newValue), (String)((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString());
                    if (costObjectRelatedInfo != null) {
                        if (costObjectRelatedInfo.getCostObjectInfo() != null) {
                            row.getCell("costObject").setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                            row.getCell("batchNumber").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                            row.getCell("batchNumber").getStyleAttributes().setLocked(true);
                            row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 255));
                        } else {
                            row.getCell("batchNumber").getStyleAttributes().setLocked(false);
                            row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 204));
                            row.getCell("costObject").setValue(null);
                            row.getCell("materialNumber").setValue(null);
                            row.getCell("materialName").setValue(null);
                            row.getCell("projectNumber").setValue(null);
                            row.getCell("trackNumber").setValue(null);
                            row.getCell("batchNumber").setValue(null);
                        }
                        row.getCell("materialNumber").setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                        row.getCell("materialName").setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                        row.getCell("projectNumber").setValue((Object)costObjectRelatedInfo.getProjectNumber());
                        row.getCell("trackNumber").setValue((Object)costObjectRelatedInfo.getTrackNumber());
                        break block10;
                    }
                    row.getCell("costObject").setValue(null);
                    row.getCell("materialNumber").setValue(null);
                    row.getCell("materialName").setValue(null);
                    row.getCell("projectNumber").setValue(null);
                    row.getCell("trackNumber").setValue(null);
                    row.getCell("batchNumber").setValue(null);
                }
                catch (EASBizException e) {
                    row.getCell("costObject").setValue(null);
                    row.getCell("materialNumber").setValue(null);
                    row.getCell("materialName").setValue(null);
                    row.getCell("projectNumber").setValue(null);
                    row.getCell("trackNumber").setValue(null);
                    row.getCell("batchNumber").setValue(null);
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                row.getCell("materialName").setValue(null);
                row.getCell("materialNumber").setValue(null);
                row.getCell("costObject").setValue(null);
                row.getCell("projectNumber").setValue(null);
                row.getCell("trackNumber").setValue(null);
                row.getCell("batchNumber").setValue(null);
            }
        }
    }

    private void fillMaterialAfterDo(DataChangeEvent eventObj) {
        block11: {
            Object newValue = eventObj.getNewValue();
            int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
            IRow row = this.kdtEntries.getRow(selectRowIndex);
            if (newValue != null && newValue instanceof MaterialInfo) {
                MaterialInfo oldMat = null;
                if (row.getCell("materialNumber").getValue() instanceof MaterialInfo) {
                    oldMat = (MaterialInfo)row.getCell("materialNumber").getValue();
                }
                if (oldMat != null && oldMat.getNumber().equals(((MaterialInfo)newValue).getNumber())) {
                    return;
                }
                try {
                    CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((MaterialInfo)((MaterialInfo)newValue));
                    row.getCell("materialName").setValue((Object)((MaterialInfo)newValue).getName());
                    if (costObjectRelatedInfo != null) {
                        if (costObjectRelatedInfo.getCostObjectInfo() != null) {
                            row.getCell("costObject").setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                            if (costObjectRelatedInfo.getCostObjectInfo().getBatchNumber() == null || costObjectRelatedInfo.getCostObjectInfo().getBatchNumber().length() <= 0) {
                                row.getCell("batchNumber").getStyleAttributes().setLocked(true);
                                row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 255));
                            }
                        } else {
                            row.getCell("batchNumber").getStyleAttributes().setLocked(false);
                            row.getCell("costObject").setValue(null);
                            row.getCell("manufacturerOrder").setValue(null);
                            row.getCell("projectNumber").setValue(null);
                            row.getCell("trackNumber").setValue(null);
                            row.getCell("batchNumber").setValue(null);
                        }
                        row.getCell("manufacturerOrder").setValue((Object)costObjectRelatedInfo.getManufactureOrderInfo());
                        row.getCell("projectNumber").setValue((Object)costObjectRelatedInfo.getProjectNumber());
                        row.getCell("trackNumber").setValue((Object)costObjectRelatedInfo.getTrackNumber());
                        row.getCell("batchNumber").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                        break block11;
                    }
                    row.getCell("batchNumber").getStyleAttributes().setLocked(false);
                    row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 204));
                    row.getCell("costObject").setValue(null);
                    row.getCell("manufacturerOrder").setValue(null);
                    row.getCell("projectNumber").setValue(null);
                    row.getCell("trackNumber").setValue(null);
                    row.getCell("batchNumber").setValue(null);
                }
                catch (EASBizException e) {
                    row.getCell("batchNumber").getStyleAttributes().setLocked(true);
                    row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 255));
                    row.getCell("costObject").setValue(null);
                    row.getCell("projectNumber").setValue(null);
                    row.getCell("trackNumber").setValue(null);
                    row.getCell("batchNumber").setValue(null);
                    row.getCell("manufacturerOrder").setValue(null);
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                row.getCell("batchNumber").getStyleAttributes().setLocked(true);
                row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 255));
                row.getCell("materialName").setValue(null);
                row.getCell("costObject").setValue(null);
                row.getCell("manufacturerOrder").setValue(null);
                row.getCell("projectNumber").setValue(null);
                row.getCell("trackNumber").setValue(null);
                row.getCell("batchNumber").setValue(null);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            if (row.getCell("costObject").getValue() != null && !"".equals(row.getCell("costObject").getValue()) || this.editData.getEntrys() == null || this.editData.getEntrys().get(i) == null) continue;
            this.editData.getEntrys().get(i).setMaterial(null);
        }
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.combBillStatus.getSelectedItem() != null && this.combBillStatus.getSelectedItem().toString().equals("\u5ba1\u6838")) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }
}

