/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.GLFetchDataFilterParam;
import com.kingdee.eas.ncm.bill.GLFetchDataInfo;
import com.kingdee.eas.ncm.bill.client.AbstractGLFetchDataFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class GLFetchDataFilterUI
extends AbstractGLFetchDataFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(GLFetchDataFilterUI.class);
    private String GLFetchDataFrom = "gLFetchDataFrom";
    private String GLFetchDataTo = "gLFetchDataTo";
    private String AccountTableFrom = "accountTableFrom";
    private String AccountTableTo = "accountTableTo";
    private String CostCenterFrom = "costCenterFrom";
    private String CostCenterTo = "costCenterTo";
    private String ExpenseFrom = "expenseFrom";
    private String ExpenseTo = "expenseTo";
    private String CostObjectFrom = "costObjectFrom";
    private String CostObjectTo = "costObjectTo";
    private String CostItemFrom = "costItemFrom";
    private String CostItemTo = "costItemTo";
    private String SchemeState = "schemeState";

    public void onLoad() throws Exception {
        super.onLoad();
        this.formatUI();
    }

    private void formatUI() throws Exception {
        this.initCompany(this.getCompanyOrgInfoWithDefault());
        this.filterAccountByOrg(this.prtAccountFrom, (CompanyOrgUnitInfo)this.prtCompany.getData());
        this.filterAccountByOrg(this.prtAccountTo, (CompanyOrgUnitInfo)this.prtCompany.getData());
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, ((CompanyOrgUnitInfo)this.prtCompany.getData()).getId().toString());
        this.prtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prtCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, ((CompanyOrgUnitInfo)this.prtCompany.getData()).getId().toString());
        this.prtCostObjectTo.setSelector((KDPromptSelector)arg1);
    }

    public GLFetchDataFilterParam getFilterParam() {
        GLFetchDataFilterParam filterParam = (GLFetchDataFilterParam)this.createNewFilterParam();
        this.storeFilterParam((NCMIFilterParam)filterParam);
        return filterParam;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new GLFetchDataFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof GLFetchDataFilterParam)) {
            return;
        }
        GLFetchDataFilterParam fp = (GLFetchDataFilterParam)filterParam;
        GLFetchDataInfo bnFrom = null;
        GLFetchDataInfo bnTo = null;
        String GLFetchDataFromData = customerParams.getCustomerParam(this.GLFetchDataFrom);
        String GLFetchDataToData = customerParams.getCustomerParam(this.GLFetchDataTo);
        if (GLFetchDataFromData != null && GLFetchDataFromData.length() > 0) {
            bnFrom = new GLFetchDataInfo();
            bnFrom.setId(BOSUuid.read((String)GLFetchDataFromData));
        }
        if (GLFetchDataToData != null && GLFetchDataToData.length() > 0) {
            bnTo = new GLFetchDataInfo();
            bnTo.setId(BOSUuid.read((String)GLFetchDataToData));
        }
        fp.setGLFetchDataInfoFrom(bnFrom);
        fp.setGLFetchDataInfoTo(bnTo);
        AccountViewInfo pfFrom = null;
        AccountViewInfo pfTo = null;
        String AccountTableFromData = customerParams.getCustomerParam(this.AccountTableFrom);
        String AccountTableToData = customerParams.getCustomerParam(this.AccountTableTo);
        if (AccountTableFromData != null && AccountTableFromData.length() > 0) {
            pfFrom = new AccountViewInfo();
            pfFrom.setId(BOSUuid.read((String)AccountTableFromData));
        }
        if (AccountTableToData != null && AccountTableToData.length() > 0) {
            pfTo = new AccountViewInfo();
            pfTo.setId(BOSUuid.read((String)AccountTableToData));
        }
        fp.setAccountTableInfoFrom(pfFrom);
        fp.setAccountTableInfoTo(pfTo);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        String costCenterFromData = customerParams.getCustomerParam(this.CostCenterFrom);
        String costCenterToData = customerParams.getCustomerParam(this.CostCenterTo);
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            ccTo = new CostCenterOrgUnitInfo();
            ccTo.setId(BOSUuid.read((String)costCenterToData));
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
        ExpenseInfo exFrom = null;
        ExpenseInfo exTo = null;
        String ExpenseFromData = customerParams.getCustomerParam(this.ExpenseFrom);
        String ExpenseToData = customerParams.getCustomerParam(this.ExpenseFrom);
        if (ExpenseFromData != null && ExpenseFromData.length() > 0) {
            exFrom = new ExpenseInfo();
            exFrom.setId(BOSUuid.read((String)ExpenseFromData));
        }
        if (ExpenseToData != null && ExpenseToData.length() > 0) {
            exTo = new ExpenseInfo();
            exTo.setId(BOSUuid.read((String)ExpenseToData));
        }
        fp.setExpenseInfoFrom(exFrom);
        fp.setExpenseInfoTo(exTo);
        CostObjectInfo cbFrom = null;
        CostObjectInfo cbTo = null;
        String costObjectFromData = customerParams.getCustomerParam(this.CostObjectFrom);
        String costObjectToData = customerParams.getCustomerParam(this.CostObjectTo);
        if (costObjectFromData != null && costObjectFromData.length() > 0) {
            cbFrom = new CostObjectInfo();
            cbFrom.setId(BOSUuid.read((String)costObjectFromData));
        }
        if (costObjectToData != null && costObjectToData.length() > 0) {
            cbTo = new CostObjectInfo();
            cbTo.setId(BOSUuid.read((String)costObjectToData));
        }
        fp.setCostObjectFrom(cbFrom);
        fp.setCostObjectTo(cbTo);
        CostItemInfo ciFrom = null;
        CostItemInfo ciTo = null;
        String costItemFromData = customerParams.getCustomerParam(this.CostItemFrom);
        String costItemctToData = customerParams.getCustomerParam(this.CostItemTo);
        if (costItemFromData != null && costItemFromData.length() > 0) {
            ciFrom = new CostItemInfo();
            ciFrom.setId(BOSUuid.read((String)costItemFromData));
        }
        if (costItemctToData != null && costItemctToData.length() > 0) {
            ciTo = new CostItemInfo();
            ciTo.setId(BOSUuid.read((String)costItemctToData));
        }
        fp.setCostItemFrom(ciFrom);
        fp.setCostItemTo(ciTo);
        String schemeState = customerParams.getCustomerParam(this.SchemeState);
        if (schemeState != null && schemeState.length() > 0) {
            fp.setSchemeSate(schemeState);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof GLFetchDataFilterParam)) {
            return;
        }
        GLFetchDataFilterParam fp = (GLFetchDataFilterParam)filterParam;
        this.prtSchemeFrom.setData((Object)fp.getGLFetchDataInfoFrom());
        this.prtSchemeTo.setData((Object)fp.getGLFetchDataInfoTo());
        this.prtAccountFrom.setValue((Object)fp.getAccountTableInfoFrom());
        this.prtAccountTo.setValue((Object)fp.getAccountTableInfoTo());
        this.prtCostCenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prtCostCenterTo.setData((Object)fp.getCostCenterTo());
        this.prtExtenFrom.setData((Object)fp.getExpenseInfoFrom());
        this.prtExtenTo.setData((Object)fp.getExpenseInfoTo());
        this.prtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prtCostObjectTo.setData((Object)fp.getCostObjectTo());
        this.prtCostItemFrom.setData((Object)fp.getCostItemFrom());
        this.prtCostItemTo.setData((Object)fp.getCostItemTo());
        this.combSchemeState.setSelectedIndex(Integer.parseInt(fp.getSchemeSate()));
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof GLFetchDataFilterParam)) {
            return;
        }
        GLFetchDataFilterParam fp = (GLFetchDataFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getGLFetchDataInfoFrom(), this.GLFetchDataFrom);
        super.putIdByKey(customerParams, (Object)fp.getGLFetchDataInfoTo(), this.GLFetchDataTo);
        super.putIdByKey(customerParams, (Object)fp.getAccountTableInfoFrom(), this.AccountTableFrom);
        super.putIdByKey(customerParams, (Object)fp.getAccountTableInfoTo(), this.AccountTableTo);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), this.CostCenterFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), this.CostCenterTo);
        super.putIdByKey(customerParams, (Object)fp.getExpenseInfoFrom(), this.ExpenseFrom);
        super.putIdByKey(customerParams, (Object)fp.getExpenseInfoTo(), this.ExpenseTo);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectFrom(), this.CostObjectFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectTo(), this.CostObjectTo);
        super.putIdByKey(customerParams, (Object)fp.getCostItemFrom(), this.CostItemFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostItemTo(), this.CostItemTo);
        super.putIdByKey(customerParams, (Object)fp.getSchemeSate(), this.SchemeState);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof GLFetchDataFilterParam)) {
            return;
        }
        GLFetchDataFilterParam fp = (GLFetchDataFilterParam)filterParam;
        Object temp = null;
        GLFetchDataInfo gLFetchDataInfoFrom = null;
        GLFetchDataInfo gLFetchDataInfoTo = null;
        temp = this.prtSchemeFrom.getData();
        if (temp != null && temp instanceof GLFetchDataInfo) {
            gLFetchDataInfoFrom = (GLFetchDataInfo)temp;
        }
        if ((temp = this.prtSchemeTo.getData()) != null && temp instanceof GLFetchDataInfo) {
            gLFetchDataInfoTo = (GLFetchDataInfo)temp;
        }
        fp.setGLFetchDataInfoFrom(gLFetchDataInfoFrom);
        fp.setGLFetchDataInfoTo(gLFetchDataInfoTo);
        AccountViewInfo acountInfoFrom = null;
        AccountViewInfo acountInfoTo = null;
        temp = this.prtAccountFrom.getValue();
        if (temp != null && temp instanceof AccountViewInfo) {
            acountInfoFrom = (AccountViewInfo)temp;
        }
        if ((temp = this.prtAccountTo.getValue()) != null && temp instanceof AccountViewInfo) {
            acountInfoTo = (AccountViewInfo)temp;
        }
        fp.setAccountTableInfoFrom(acountInfoFrom);
        fp.setAccountTableInfoTo(acountInfoTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.prtCostCenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.prtCostCenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        ExpenseInfo expenseInfoFrom = null;
        ExpenseInfo expenseInfoTo = null;
        temp = this.prtExtenFrom.getData();
        if (temp != null && temp instanceof ExpenseInfo) {
            expenseInfoFrom = (ExpenseInfo)temp;
        }
        if ((temp = this.prtExtenTo.getData()) != null && temp instanceof ExpenseInfo) {
            expenseInfoTo = (ExpenseInfo)temp;
        }
        fp.setExpenseInfoFrom(expenseInfoFrom);
        fp.setExpenseInfoTo(expenseInfoTo);
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        temp = this.prtCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.prtCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)temp;
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        CostItemInfo costItemFrom = null;
        CostItemInfo costItemTo = null;
        temp = this.prtCostItemFrom.getData();
        if (temp != null && temp instanceof CostItemInfo) {
            costItemFrom = (CostItemInfo)temp;
        }
        if ((temp = this.prtCostItemTo.getData()) != null && temp instanceof CostItemInfo) {
            costItemTo = (CostItemInfo)temp;
        }
        fp.setCostItemFrom(costItemFrom);
        fp.setCostItemTo(costItemTo);
        int selectIndex = this.combSchemeState.getSelectedIndex();
        fp.setSchemeSate(String.valueOf(selectIndex));
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        int selectIndex = this.combSchemeState.getSelectedIndex();
        String billStatus = String.valueOf(selectIndex + 1);
        if (selectIndex != 0) {
            filterBiz.getFilterItems().add(new FilterItemInfo("billStatus", (Object)billStatus, CompareType.EQUALS));
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        try {
            this.clearFilterData();
            this.formatUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prtCompany.setValue((Object)companyOrg);
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(OrgType.getEnum((String)"Company"));
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    private void clearFilterData() {
        this.prtSchemeFrom.setValue(null);
        this.prtSchemeTo.setValue(null);
        this.prtExtenFrom.setValue(null);
        this.prtExtenTo.setValue(null);
        this.prtCostCenterFrom.setValue(null);
        this.prtCostCenterTo.setValue(null);
        this.prtAccountFrom.setValue(null);
        this.prtAccountTo.setValue(null);
        this.prtCostItemFrom.setValue(null);
        this.prtCostItemTo.setValue(null);
        this.prtCostObjectFrom.setValue(null);
        this.prtCostObjectTo.setValue(null);
        this.combSchemeState.setSelectedIndex(0);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        HashSet<Integer> extypes = new HashSet<Integer>();
        extypes.add(1);
        extypes.add(2);
        extypes.add(30);
        extypes.add(40);
        extypes.add(50);
        extypes.add(60);
        this.f7ContextManager.registerExpenseF7(this.prtExtenFrom, extypes);
        this.f7ContextManager.registerExpenseF7(this.prtExtenTo, extypes);
        this.f7ContextManager.registerCostCenterF7(this.prtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prtCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.prtCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.prtCostObjectTo, false);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtSchemeFrom, "com.kingdee.eas.ncm.bill.app.GLFetchDataFilterQuery", "companyOrg.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtSchemeTo, "com.kingdee.eas.ncm.bill.app.GLFetchDataFilterQuery", "companyOrg.id");
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prtSchemeFrom.setDisplayFormat("$number$");
                this.prtSchemeTo.setDisplayFormat("$number$");
                this.prtCostCenterFrom.setData(null);
                this.prtCostCenterTo.setData(null);
                this.prtCostObjectFrom.setData(null);
                this.prtCostObjectTo.setData(null);
                this.prtSchemeFrom.setData(null);
                this.prtSchemeTo.setData(null);
                this.filterAccountByOrg(this.prtAccountFrom, (CompanyOrgUnitInfo)chgVo.getNewOrg());
                this.filterAccountByOrg(this.prtAccountTo, (CompanyOrgUnitInfo)chgVo.getNewOrg());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void filterAccountByOrg(KDBizPromptBox prmtAccount, CompanyOrgUnitInfo company) throws Exception {
        if (company == null) {
            return;
        }
        AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company.getAccountTable(), null);
        prmtAccount.setSelector((KDPromptSelector)apb);
        BDCMClientUtils.filterAccountVIewF7((KDBizPromptBox)prmtAccount, (String)company.getCU().getId().toString(), (CompanyOrgUnitInfo)company);
    }
}

