/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.GLFetchDataFactory;
import com.kingdee.eas.ncm.bill.GLFetchDataInfo;
import com.kingdee.eas.ncm.bill.IGLFetchData;
import com.kingdee.eas.ncm.bill.client.AbstractGLFetchDataListUI;
import com.kingdee.eas.ncm.bill.client.GLFetchDataEditUI;
import com.kingdee.eas.ncm.bill.client.GLFetchDataFilterUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GLFetchDataListUI
extends AbstractGLFetchDataListUI {
    private static final Logger logger = CoreUIObject.getLogger(GLFetchDataListUI.class);
    private CommonQueryDialog dialog = null;
    private GLFetchDataFilterUI filterUI = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionFetchData_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String companyID = this.getCompanyOrgInfoWithDefault().getId().toString();
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=GLFETCHDATA" + companyID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
        try {
            String[] selIDs = NCMClientUtils.getSelectRowFieldValue((KDTable)this.tblMain, (String)this.getKeyFieldName());
            IGLFetchData iGLFetchData = GLFetchDataFactory.getRemoteInstance();
            String tips = iGLFetchData.fetchData(selIDs);
            this.setLogInfo("actionFetchData", new GLFetchDataInfo().getBOSType(), "GLFetchData_fetchData");
            MsgBox.showInfo((String)tips);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=GLFETCHDATA" + companyID);
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.actionImportData.setEnabled(true);
        this.actionImportData.setVisible(true);
        this.actionExportData.setEnabled(true);
        this.actionExportData.setVisible(true);
    }

    private void setLogInfo(String methodName, BOSObjectType bizObjType, String logItemName) {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        IObjectPK pk = LogUtil.beginLog(null, (String)methodName, (BOSObjectType)bizObjType, null, (String)(company.getNumber() + " " + company.getName()), (String)logItemName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("calculatePeriodNumber").getStyleAttributes().setHided(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return GLFetchDataFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    protected IObjectValue createNewData() {
        GLFetchDataInfo objectValue = new GLFetchDataInfo();
        return objectValue;
    }

    @Override
    protected String getEditUIName() {
        return GLFetchDataEditUI.class.getName();
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] cols = new String[]{"number", "description", "billStatus", "companyOrg.name", "calculatePeriodNumber"};
        return cols;
    }

    protected CommonQueryProcessor getCustomerCommonQueryProcessor() {
        CommonQueryProcessor cmcq = super.getCustomerCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
        cmcq.set("COMPANYORGINFO", (Object)this.getCompanyOrgInfoWithDefault());
        cmcq.set("query", (Object)"GLFetchDataQuery");
        try {
            boolean isShowShareCostObject = NCMUtils.isCostObjectOfBillRequired(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
            cmcq.set("showShareCostObject", (Object)isShowShareCostObject);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        return cmcq;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new GLFetchDataFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isCheckStart() {
        return false;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "GLFetchData";
        param.alias = "\u603b\u8d26\u53d6\u6570";
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "GLFetchData";
        param.alias = "\u603b\u8d26\u53d6\u6570";
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("GlFetchData_audit");
        }
        super.auditAction_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, (IObjectPK)new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId().toString()), (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }
}

