/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.ncm.bill.ActualHourFactory;
import com.kingdee.eas.ncm.bill.client.AbstractHourImportFilterUI;
import com.kingdee.eas.ncm.bill.client.HourImportCheckConditionResultUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class HourImportFilterUI
extends AbstractHourImportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(HourImportFilterUI.class);
    private static final String STORAGE = "_storage";
    private static final String WORKCENTER = "_workCenter";
    private static final String COSTCENTER = "_costCenter";
    private static final String COSTOBJECT = "_costObejct";
    private CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    private String companyID = this.currentCompany.getId().toString();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tableMain.checkParsed();
        this.refresh();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.btnSave.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnCheck.setEnabled(true);
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tableMain.addRow();
        row.getCell("costCenter.number").setValue(null);
        row.getCell("costObject.number").setValue(null);
        KDBizPromptBox bizCostCenterBox = new KDBizPromptBox();
        bizCostCenterBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        bizCostCenterBox.setEditFormat("$number$");
        bizCostCenterBox.setDisplayFormat("$name$");
        bizCostCenterBox.setCommitFormat("$number$");
        bizCostCenterBox.setEditable(true);
        bizCostCenterBox.setRequired(true);
        this.tableMain.getColumn("costCenter.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCostCenterBox));
        BDCMClientUtils.filterDirectCostCenterF7((KDBizPromptBox)bizCostCenterBox, (String)this.companyID);
        KDBizPromptBox bizCostObjectBox = new KDBizPromptBox();
        bizCostObjectBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
        bizCostObjectBox.setEditFormat("$number$");
        bizCostObjectBox.setDisplayFormat("$name$");
        bizCostObjectBox.setCommitFormat("$number$");
        bizCostObjectBox.setEditable(true);
        bizCostObjectBox.setRequired(true);
        this.tableMain.getColumn("costObject.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCostObjectBox));
        this.filterCostObjectF7(bizCostObjectBox, this.companyID);
        KDBizPromptBox bizStorageBox = new KDBizPromptBox();
        bizStorageBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        bizStorageBox.setEditFormat("$number$");
        bizStorageBox.setDisplayFormat("$name$");
        bizStorageBox.setCommitFormat("$number$");
        bizStorageBox.setEditable(true);
        bizStorageBox.setRequired(true);
        this.tableMain.getColumn("storage.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizStorageBox));
        this.filterStorageF7(bizStorageBox, this.companyID);
        KDBizPromptBox bizWorkCenterBox = new KDBizPromptBox();
        bizWorkCenterBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.WorkCenterQuery");
        bizWorkCenterBox.setEditFormat("$number$");
        bizWorkCenterBox.setDisplayFormat("$name$");
        bizWorkCenterBox.setCommitFormat("$number$");
        bizWorkCenterBox.setEditable(true);
        bizWorkCenterBox.setRequired(true);
        this.tableMain.getColumn("workCenter.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizWorkCenterBox));
        this.filterWorkCenterF7(bizWorkCenterBox, this.companyID);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        HashSet condition = new HashSet();
        int rowCount = this.tableMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String costObjcetInfo;
            String costCenterInfo;
            String workCenterInfo;
            IRow row = this.tableMain.getRow(i);
            HashMap<String, String> map = new HashMap<String, String>();
            String storageInfo = (String)row.getCell("Storage.id").getValue();
            if (storageInfo != null) {
                map.put(STORAGE, storageInfo);
            }
            if ((workCenterInfo = (String)row.getCell("workCenter.id").getValue()) != null) {
                map.put(WORKCENTER, workCenterInfo);
            }
            if ((costCenterInfo = (String)row.getCell("costCenter.id").getValue()) != null) {
                map.put(COSTCENTER, costCenterInfo);
            }
            if ((costObjcetInfo = (String)row.getCell("costObject.id").getValue()) != null) {
                map.put(COSTOBJECT, costObjcetInfo);
            }
            if (map.size() <= 0) continue;
            condition.add(map);
        }
        ActualHourFactory.getRemoteInstance().saveCondition(this.companyID, condition);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"95_InputQtyImportFilterUI"));
        this.tableMain.refresh();
        this.refresh();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        int index = this.tableMain.getSelectManager().getActiveRowIndex();
        if (index < 0 || index >= this.tableMain.getRowCount()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"27_BoPInvSFPCostMatDetailUI"));
            return;
        }
        this.tableMain.removeRow(index);
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String checkResult = ActualHourFactory.getRemoteInstance().checkCondition(this.companyID);
        uiContext.put((Object)"CheckResult", (Object)checkResult);
        IUIWindow uiWindow1 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HourImportCheckConditionResultUI.class.getName(), (Map)uiContext, null);
        uiWindow1.show();
    }

    private void filterCostObjectF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        HashSet<String> cuIDs = new HashSet<String>();
        CtrlUnitInfo currentCU = SysContext.getSysContext().getCurrentCtrlUnit();
        cuIDs.add("00000000-0000-0000-0000-000000000000CCE7AED4");
        do {
            cuIDs.add(currentCU.getId().toString());
        } while ((currentCU = currentCU.getParent()) != null);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID));
        HashSet<Integer> typeSet = new HashSet<Integer>();
        typeSet.add(Integer.valueOf("0"));
        filter.getFilterItems().add(new FilterItemInfo("relatedType", typeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID", CompareType.NOTEQUALS));
        EntityViewInfo eviCostObject = new EntityViewInfo();
        eviCostObject.setFilter(filter);
        f7.setEntityViewInfo(eviCostObject);
    }

    private void filterStorageF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        BDCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)f7, (String)"isBizUnit", (Object)1, (String)companyOrgID, (String)"id");
    }

    private void filterWorkCenterF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(20), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", ccIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    private void refresh() {
        KDBizPromptBox bizWorkCenterBox;
        KDBizPromptBox bizStorageBox;
        KDBizPromptBox bizCostObjectBox;
        KDBizPromptBox bizCostCenterBox;
        IRowSet rowSet = null;
        int isAddRow = 0;
        try {
            rowSet = ActualHourFactory.getRemoteInstance().getConditionCount(this.companyID);
            while (rowSet.next()) {
                ++isAddRow;
                IRow row = this.tableMain.addRow();
                row.getCell("costCenter.number").setValue((Object)"");
                row.getCell("costObject.number").setValue((Object)"");
                row.getCell("storage.number").setValue((Object)"");
                row.getCell("workCenter.number").setValue((Object)"");
                bizCostCenterBox = new KDBizPromptBox();
                bizCostCenterBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
                bizCostCenterBox.setEditFormat("$number$");
                bizCostCenterBox.setDisplayFormat("$name$");
                bizCostCenterBox.setCommitFormat("$number$");
                bizCostCenterBox.setEditable(true);
                bizCostCenterBox.setRequired(true);
                this.tableMain.getColumn("costCenter.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCostCenterBox));
                BDCMClientUtils.filterDirectCostCenterF7((KDBizPromptBox)bizCostCenterBox, (String)this.companyID);
                bizCostObjectBox = new KDBizPromptBox();
                bizCostObjectBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
                bizCostObjectBox.setEditFormat("$number$");
                bizCostObjectBox.setDisplayFormat("$name$");
                bizCostObjectBox.setCommitFormat("$number$");
                bizCostObjectBox.setEditable(true);
                bizCostObjectBox.setRequired(true);
                this.tableMain.getColumn("costObject.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCostObjectBox));
                this.filterCostObjectF7(bizCostObjectBox, this.companyID);
                bizStorageBox = new KDBizPromptBox();
                bizStorageBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
                bizStorageBox.setEditFormat("$number$");
                bizStorageBox.setDisplayFormat("$name$");
                bizStorageBox.setCommitFormat("$number$");
                bizStorageBox.setEditable(true);
                bizStorageBox.setRequired(true);
                this.tableMain.getColumn("storage.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizStorageBox));
                this.filterStorageF7(bizStorageBox, this.companyID);
                bizWorkCenterBox = new KDBizPromptBox();
                bizWorkCenterBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.WorkCenterQuery");
                bizWorkCenterBox.setEditFormat("$number$");
                bizWorkCenterBox.setDisplayFormat("$name$");
                bizWorkCenterBox.setCommitFormat("$number$");
                bizWorkCenterBox.setEditable(true);
                bizWorkCenterBox.setRequired(true);
                this.tableMain.getColumn("workCenter.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizWorkCenterBox));
                this.filterWorkCenterF7(bizWorkCenterBox, this.companyID);
                if (rowSet.getString(1) != null && rowSet.getString(1).length() != 0) {
                    row.getCell("costCenter.id").setValue((Object)rowSet.getString(1));
                } else {
                    row.getCell("costCenter.id").setValue((Object)"");
                }
                if (rowSet.getString(3) != null && rowSet.getString(3).length() != 0) {
                    row.getCell("costCenter.number").setValue((Object)rowSet.getString(3));
                } else {
                    row.getCell("costCenter.number").setValue((Object)"");
                }
                if (rowSet.getString(4) != null && rowSet.getString(4).length() != 0) {
                    row.getCell("costObject.id").setValue((Object)rowSet.getString(4));
                } else {
                    row.getCell("costObject.id").setValue((Object)"");
                }
                if (rowSet.getString(6) != null && rowSet.getString(6).length() != 0) {
                    row.getCell("costObject.number").setValue((Object)rowSet.getString(6));
                } else {
                    row.getCell("costObject.number").setValue((Object)"");
                }
                if (rowSet.getString(8) != null && rowSet.getString(8).length() != 0) {
                    row.getCell("Storage.id").setValue((Object)rowSet.getString(8));
                } else {
                    row.getCell("Storage.id").setValue((Object)"");
                }
                if (rowSet.getString(10) != null && rowSet.getString(10).length() != 0) {
                    row.getCell("storage.number").setValue((Object)rowSet.getString(10));
                } else {
                    row.getCell("storage.number").setValue((Object)"");
                }
                if (rowSet.getString(11) != null && rowSet.getString(11).length() != 0) {
                    row.getCell("workCenter.id").setValue((Object)rowSet.getString(11));
                } else {
                    row.getCell("workCenter.id").setValue((Object)"");
                }
                if (rowSet.getString(13) != null && rowSet.getString(13).length() != 0) {
                    row.getCell("workCenter.number").setValue((Object)rowSet.getString(13));
                    continue;
                }
                row.getCell("workCenter.number").setValue((Object)"");
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
        int rowCount = 11;
        if (isAddRow == 0) {
            this.tableMain.addRows(rowCount);
            try {
                bizCostCenterBox = new KDBizPromptBox();
                bizCostCenterBox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
                bizCostCenterBox.setEditFormat("$number$");
                bizCostCenterBox.setDisplayFormat("$name$");
                bizCostCenterBox.setCommitFormat("$number$");
                bizCostCenterBox.setEditable(true);
                bizCostCenterBox.setRequired(true);
                this.tableMain.getColumn("costCenter.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCostCenterBox));
                BDCMClientUtils.filterDirectCostCenterF7((KDBizPromptBox)bizCostCenterBox, (String)this.companyID);
                bizCostObjectBox = new KDBizPromptBox();
                bizCostObjectBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
                bizCostObjectBox.setEditFormat("$number$");
                bizCostObjectBox.setDisplayFormat("$name$");
                bizCostObjectBox.setCommitFormat("$number$");
                bizCostObjectBox.setEditable(true);
                bizCostObjectBox.setRequired(true);
                this.tableMain.getColumn("costObject.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCostObjectBox));
                this.filterCostObjectF7(bizCostObjectBox, this.companyID);
                bizStorageBox = new KDBizPromptBox();
                bizStorageBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
                bizStorageBox.setEditFormat("$number$");
                bizStorageBox.setDisplayFormat("$name$");
                bizStorageBox.setCommitFormat("$number$");
                bizStorageBox.setEditable(true);
                bizStorageBox.setRequired(true);
                this.tableMain.getColumn("storage.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizStorageBox));
                this.filterStorageF7(bizStorageBox, this.companyID);
                bizWorkCenterBox = new KDBizPromptBox();
                bizWorkCenterBox.setQueryInfo("com.kingdee.eas.mm.basedata.app.WorkCenterQuery");
                bizWorkCenterBox.setEditFormat("$number$");
                bizWorkCenterBox.setDisplayFormat("$name$");
                bizWorkCenterBox.setCommitFormat("$number$");
                bizWorkCenterBox.setEditable(true);
                bizWorkCenterBox.setRequired(true);
                this.tableMain.getColumn("workCenter.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizWorkCenterBox));
                this.filterWorkCenterF7(bizWorkCenterBox, this.companyID);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected void tableMain_editStopped(KDTEditEvent e) throws Exception {
        IRow row;
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.tableMain.getColumn("costCenter.number").getColumnIndex() == colIndex) {
            row = this.tableMain.getRow(rowIndex);
            Object costCenter = row.getCell("costCenter.number").getValue();
            if (costCenter != null && costCenter instanceof CostCenterOrgUnitInfo) {
                CostCenterOrgUnitInfo costCenterInfo = (CostCenterOrgUnitInfo)costCenter;
                row.getCell("costCenter.number").setValue((Object)costCenterInfo);
                row.getCell("costCenter.id").setValue((Object)costCenterInfo.getId().toString());
            } else {
                row.getCell("costCenter.id").setValue(null);
            }
        }
        if (this.tableMain.getColumn("costObject.number").getColumnIndex() == colIndex) {
            row = this.tableMain.getRow(rowIndex);
            Object costObject = row.getCell("costObject.number").getValue();
            if (costObject != null && costObject instanceof CostObjectInfo) {
                CostObjectInfo costObjectInfo = (CostObjectInfo)costObject;
                row.getCell("costObject.id").setValue((Object)costObjectInfo.getId().toString());
                row.getCell("costObject.number").setValue((Object)costObjectInfo.getName());
            } else {
                row.getCell("costObject.id").setValue(null);
            }
        }
        if (this.tableMain.getColumn("storage.number").getColumnIndex() == colIndex) {
            row = this.tableMain.getRow(rowIndex);
            Object storage = row.getCell("storage.number").getValue();
            if (storage != null && storage instanceof StorageOrgUnitInfo) {
                StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)storage;
                row.getCell("Storage.id").setValue((Object)storageInfo.getId().toString());
                row.getCell("storage.number").setValue((Object)storageInfo.getName());
            } else {
                row.getCell("Storage.id").setValue(null);
            }
        }
        if (this.tableMain.getColumn("workCenter.number").getColumnIndex() == colIndex) {
            row = this.tableMain.getRow(rowIndex);
            Object workCenter = row.getCell("workCenter.number").getValue();
            if (workCenter != null && workCenter instanceof WorkCenterInfo) {
                WorkCenterInfo workCenterInfo = (WorkCenterInfo)workCenter;
                row.getCell("workCenter.id").setValue((Object)workCenterInfo.getId().toString());
                row.getCell("workCenter.number").setValue((Object)workCenterInfo.getName());
            } else {
                row.getCell("workCenter.id").setValue(null);
            }
        }
    }

    @Override
    protected void tableMain_editStopping(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void tableMain_editValueChanged(KDTEditEvent e) throws Exception {
    }
}

