/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.bill.ActualHourFactory;
import com.kingdee.eas.ncm.bill.client.AbstractHourImportUI;
import com.kingdee.eas.ncm.bill.client.HourImportCheckConditionResultUI;
import com.kingdee.eas.ncm.bill.client.HourImportFilterUI;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Assert;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HourImportUI
extends AbstractHourImportUI {
    private static final Logger logger = CoreUIObject.getLogger(HourImportUI.class);
    private CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    private String companyID = this.currentCompany.getId().toString();
    private PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod(null, (String)this.companyID);

    public HourImportUI() throws Exception {
        this.btnCancle.setEnabled(true);
        this.btnEnter.setEnabled(true);
        this.btnSetCondition.setEnabled(true);
        this.getUIContext().put("result", Boolean.FALSE);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSetCondition_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow1 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(HourImportFilterUI.class.getName(), (Map)uiContext, null);
        uiWindow1.show();
    }

    @Override
    public void actionEnter_actionPerformed(ActionEvent e) throws Exception {
        String checkResult = this.checkWorkCenterAndCostCenter();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"CheckResult", (Object)checkResult);
        IUIWindow uiWindow1 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HourImportCheckConditionResultUI.class.getName(), (Map)uiContext, null);
        uiWindow1.show();
        int option = 0;
        boolean isRecover = false;
        if (this.rdIsAdd.isSelected()) {
            isRecover = false;
        } else if (this.rdIsOver.isSelected()) {
            isRecover = true;
        }
        String sumMode = "";
        if (this.sumByCCCO.isSelected()) {
            sumMode = "1";
        } else if (this.kDRadioButton2.isSelected()) {
            sumMode = "2";
        }
        if (checkResult != null && checkResult.length() > 0 && !"//".equals(checkResult)) {
            option = MsgBox.showConfirm2New((Component)((Object)this), (String)"\u5b58\u5728\u5de5\u4f5c\u4e2d\u5fc3\u672a\u6307\u5b9a\u6210\u672c\u4e2d\u5fc3\uff0c\u6216\u6210\u672c\u4e2d\u5fc3\u6ca1\u6709\u5bf9\u5e94\u7684\u5de5\u4f5c\u4e2d\u5fc3\u3002\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\uff1f");
        }
        if (option == 1) {
            return;
        }
        if (option == 0) {
            HashMap<String, Object> listenerParam = new HashMap<String, Object>();
            listenerParam.put("company", this.currentCompany);
            listenerParam.put("period", this.currPeriod);
            listenerParam.put("isRecover", isRecover);
            listenerParam.put("sumMode", sumMode);
            genProgressHintListener listener = new genProgressHintListener();
            ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, listenerParam);
            Boolean result = Boolean.valueOf(listenerParam.get("result").toString());
            this.getUIContext().put("result", result);
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionCancle_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    private String checkWorkCenterAndCostCenter() throws EASBizException, BOSException {
        String checkResult = ActualHourFactory.getRemoteInstance().checkCondition(this.companyID);
        return checkResult;
    }

    private Set getStoragebyCompany(String companyID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyID, 1, 4);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)NCMClientUtils.getNcmBillResource((String)"NostorageOrgDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        return ccIDSet;
    }

    private final class genProgressHintListener
    implements ProgressHintListener {
        private genProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            Assert.that((boolean)param.containsKey("company"));
            Assert.that((boolean)param.containsKey("period"));
            Assert.that((boolean)param.containsKey("isRecover"));
            Assert.that((boolean)param.containsKey("sumMode"));
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
            PeriodInfo period = (PeriodInfo)param.get("period");
            Boolean isRecover = (Boolean)param.get("isRecover");
            String sumMode = (String)param.get("sumMode");
            boolean result = false;
            HashSet conditions = ActualHourFactory.getRemoteInstance().getCondition(company.getId().toString());
            if (conditions.size() == 0) {
                Set storageIDs = HourImportUI.this.getStoragebyCompany(company.getId().toString());
                Iterator iter = storageIDs.iterator();
                conditions = new HashSet();
                while (iter.hasNext()) {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    condition.put("_storage", iter.next().toString());
                    condition.put("_workCenter", null);
                    condition.put("_costCenter", null);
                    condition.put("_costObject", null);
                    conditions.add(condition);
                }
            }
            try {
                result = ActualHourFactory.getRemoteInstance().inductData(isRecover, company, period, conditions, sumMode);
                param.put("result", result);
            }
            catch (Exception ex) {
                param.put("result", result);
                if (ex.getCause() != null) {
                    MsgBox.showError((String)ex.getCause().getMessage());
                }
                MsgBox.showError((String)ex.getMessage());
            }
        }
    }
}

