/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.InitBalancFilterParam;
import com.kingdee.eas.ncm.bill.client.AbstractInitBalancFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class InitBalancFilterUI
extends AbstractInitBalancFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InitBalancFilterUI.class);
    private boolean mainOrgChangeCanceling = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompany.setValue((Object)this.getCompanyOrgInfoWithDefault());
    }

    public InitBalancFilterParam getFilterParam() {
        InitBalancFilterParam filterParam = (InitBalancFilterParam)this.createNewFilterParam();
        this.storeFilterParam((NCMIFilterParam)filterParam);
        return filterParam;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new InitBalancFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof InitBalancFilterParam)) {
            return;
        }
        InitBalancFilterParam fp = (InitBalancFilterParam)filterParam;
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        String costObjectFromData = customerParams.getCustomerParam("costObjectFrom");
        String costObjectToData = customerParams.getCustomerParam("costObjectTo");
        if (costObjectFromData != null && costObjectFromData.length() > 0) {
            costObjectFrom = new CostObjectInfo();
            costObjectFrom.setId(BOSUuid.read((String)costObjectFromData));
        }
        if (costObjectToData != null && costObjectToData.length() > 0) {
            costObjectTo = new CostObjectInfo();
            costObjectTo.setId(BOSUuid.read((String)costObjectToData));
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        String costCenterFromData = customerParams.getCustomerParam("costCenterFrom");
        String costCenterToData = customerParams.getCustomerParam("costCenterTo");
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            costCenterFrom = new CostCenterOrgUnitInfo();
            costCenterFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            costCenterTo = new CostCenterOrgUnitInfo();
            costCenterTo.setId(BOSUuid.read((String)costCenterToData));
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        ManufactureOrderInfo orderFrom = null;
        ManufactureOrderInfo orderTo = null;
        String orderFromData = customerParams.getCustomerParam("orderFrom");
        String orderToData = customerParams.getCustomerParam("orderTo");
        if (orderFromData != null && orderFromData.length() > 0) {
            orderFrom = new ManufactureOrderInfo();
            orderFrom.setId(BOSUuid.read((String)orderFromData));
        }
        if (orderToData != null && orderToData.length() > 0) {
            orderTo = new ManufactureOrderInfo();
            orderTo.setId(BOSUuid.read((String)orderToData));
        }
        fp.setOrderFrom(orderFrom);
        fp.setOrderTo(orderTo);
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof InitBalancFilterParam)) {
            return;
        }
        InitBalancFilterParam fp = (InitBalancFilterParam)filterParam;
        this.prmtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prmtCostObjectTo.setData((Object)fp.getCostObjectTo());
        this.prmtCostCenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prmtCostCenterTo.setData((Object)fp.getCostCenterTo());
        this.prmtOrderFrom.setData((Object)fp.getOrderFrom());
        this.prmtOrderTo.setData((Object)fp.getOrderTo());
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof InitBalancFilterParam)) {
            return;
        }
        InitBalancFilterParam fp = (InitBalancFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getCostObjectFrom(), "costObjectFrom");
        super.putIdByKey(customerParams, (Object)fp.getCostObjectTo(), "costObjectTo");
        super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), "costCenterFrom");
        super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), "costCenterTo");
        super.putIdByKey(customerParams, (Object)fp.getOrderFrom(), "orderFrom");
        super.putIdByKey(customerParams, (Object)fp.getOrderTo(), "orderTo");
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof InitBalancFilterParam)) {
            return;
        }
        InitBalancFilterParam fp = (InitBalancFilterParam)filterParam;
        Object temp = null;
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        temp = this.prmtCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.prmtCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)temp;
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.prmtCostCenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.prmtCostCenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        ManufactureOrderInfo orderFrom = null;
        ManufactureOrderInfo orderTo = null;
        temp = this.prmtOrderFrom.getData();
        if (temp != null && temp instanceof ManufactureOrderInfo) {
            orderFrom = (ManufactureOrderInfo)temp;
        }
        if ((temp = this.prmtOrderTo.getData()) != null && temp instanceof ManufactureOrderInfo) {
            orderTo = (ManufactureOrderInfo)temp;
        }
        fp.setOrderFrom(orderFrom);
        fp.setOrderTo(orderTo);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompany;
    }

    public void clear() {
        super.clear();
        try {
            this.clearFilterData();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void clearFilterData() {
        this.prmtCostObjectFrom.setValue(null);
        this.prmtCostObjectTo.setValue(null);
        this.prmtCostCenterFrom.setValue(null);
        this.prmtCostCenterTo.setValue(null);
        this.prmtOrderFrom.setValue(null);
        this.prmtOrderTo.setValue(null);
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, true);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, true);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo);
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(4);
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderTo, filter);
        this.prmtOrderFrom.setDisplayFormat("$number$");
        this.prmtOrderTo.setDisplayFormat("$number$");
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        if (this.mainOrgChangeCanceling) {
            return;
        }
        if (chgVo.isDiffrent()) {
            try {
                if (chgVo.getNewOrg() == null || !(chgVo.getNewOrg() instanceof CompanyOrgUnitInfo)) {
                    return;
                }
                CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)chgVo.getNewOrg();
                if (companyOrg == null) {
                    return;
                }
                this.getUIContext().put("ORG.PK", new ObjectUuidPK(companyOrg.getId()));
            }
            catch (Exception e) {
                MsgBox.showInfo((String)e.getMessage());
                if (this.getCompanyF7() != null) {
                    try {
                        this.mainOrgChangeCanceling = true;
                        this.getCompanyF7().setData(chgVo.getOldOrg());
                    }
                    finally {
                        this.mainOrgChangeCanceling = false;
                    }
                    this.getCompanyF7().requestFocus();
                }
                SysUtil.abort();
            }
        }
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostObjectFrom.setValue(null);
                this.prmtCostObjectTo.setValue(null);
                this.prmtCostCenterFrom.setValue(null);
                this.prmtCostCenterTo.setValue(null);
                this.prmtOrderFrom.setValue(null);
                this.prmtOrderTo.setValue(null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void isStart() throws Exception {
    }

    public boolean verify() {
        if (this.isEnableMultiOrgSupport() && this.getCompanyF7().getData() == null) {
            MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg((OrgType)OrgType.Company));
            this.getCompanyF7().requestFocus();
            SysUtil.abort();
        }
        return true;
    }
}

