/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.core.util.KDTableUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.InitBalanceEntryInfo;
import com.kingdee.eas.ncm.bill.InitBalanceFactory;
import com.kingdee.eas.ncm.bill.InitBalanceInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.client.AbstractInitBalanceEditUI;
import com.kingdee.eas.ncm.bill.client.InitBalanceMatDetailUI;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;
import com.kingdee.eas.ncm.common.client.NCMClientVerifyHelper;
import com.kingdee.eas.ncm.common.utils.CostObjectUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InitBalanceEditUI
extends AbstractInitBalanceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InitBalanceEditUI.class);
    private CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    private String companyID = null;
    CurrencyInfo currency = null;
    private boolean isCostObject = false;

    @Override
    public void loadFields() {
        EventListener[] prmtListners = this.prmtcostCenter.getListeners(DataChangeListener.class);
        BDCMClientUtils.removeDataChangeListeners((JComponent)this.prmtcostCenter);
        super.loadFields();
        BDCMClientUtils.addDataChangeListeners((JComponent)this.prmtcostCenter, (EventListener[])prmtListners);
        this.loadEntry();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("NcmCompanyOrg") != null) {
            this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("NcmCompanyOrg");
        }
        if (this.currentCompany != null) {
            this.companyID = this.currentCompany.getId().toString();
            this.currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        }
        super.onLoad();
        if (this.prmtCompany.getData() != null) {
            this.currentCompany = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            this.companyID = this.currentCompany.getId().toString();
            this.currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        }
        this.initEntry();
        BDCMClientUtils.filterBaseCostCenterF7((KDBizPromptBox)this.prmtcostCenter, (String)"isBizUnit", (Object)Boolean.TRUE, (String)this.companyID);
        FilterInfo filterCostCenterType = new FilterInfo();
        filterCostCenterType.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
        filterCostCenterType.mergeFilter(this.prmtcostCenter.getEntityViewInfo().getFilter(), "AND");
        this.prmtcostCenter.getEntityViewInfo().setFilter(filterCostCenterType);
        this.prmtcostCenter.getQueryAgent().resetRuntimeEntityView();
        this.filterCostObjectF7();
        this.prmtcostObject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtcostObject);
        this.prmtcostObject.setSelector((KDPromptSelector)arg0);
        this.prmtcostObject.setRequired(true);
        BillBaseStatusEnum[] status = new BillBaseStatusEnum[]{BillBaseStatusEnum.COMPLETE, BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.CLOSED};
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtOrder, (String)this.companyID, (BillBaseStatusEnum[])status);
        NCMClientUtils.setMaterialF7((KDBizPromptBox)this.prmtMaterialNumber, (String)this.companyID);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.menuTable1.setEnabled(false);
        this.menuWorkflow.setEnabled(false);
        this.menuTable1.setVisible(false);
        this.menuWorkflow.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kdbDetail.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.menuWorkflow.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    private void filterCostObjectF7() {
        CORelatedType[] types = new CORelatedType[]{CORelatedType.Product};
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtcostObject, (String)this.companyID, (CORelatedType[])types);
    }

    protected void initEntry() throws Exception {
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        ExtendParser parserCostItem = new ExtendParser(prmtCostItem);
        prmtCostItem.setCommitParser((IParser)parserCostItem);
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.CostItemTreeListQuery");
        prmtCostItem.setVisible(true);
        prmtCostItem.setEnabledMultiSelection(true);
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$number$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        EntityViewInfo eviCostItem = new EntityViewInfo();
        eviCostItem.setFilter(this.getCostItemFilter());
        prmtCostItem.setEntityViewInfo(eviCostItem);
        ObjectValueRender avCostItem = new ObjectValueRender();
        avCostItem.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn("costItem").setRenderer((IBasicRender)avCostItem);
        prmtCostItem.setRequired(true);
        prmtCostItem.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                InitBalanceEditUI.this.fillCellAfterBillSelectedRelation(eventObj);
            }
        });
        this.kdtEntrys.getColumn("costItem").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtCostItem));
        this.kdtEntrys.getColumn("costItem").setRequired(true);
        this.kdtEntrys.getColumn("costItemName").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("detail").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        int curPrecision = this.currency == null ? 2 : this.currency.getPrecision();
        KDFormattedTextField txtYTDInputAmount = new KDFormattedTextField();
        txtYTDInputAmount.setDataType(1);
        txtYTDInputAmount.setPrecision(curPrecision);
        txtYTDInputAmount.setHorizontalAlignment(4);
        this.kdtEntrys.getColumn("YTDInputAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtYTDInputAmount));
        this.kdtEntrys.getColumn("YTDInputAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntrys.getColumn("YTDInputAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)curPrecision));
        KDFormattedTextField txtBoPWIPAmount = new KDFormattedTextField();
        txtBoPWIPAmount.setDataType(1);
        txtBoPWIPAmount.setPrecision(curPrecision);
        txtBoPWIPAmount.setHorizontalAlignment(4);
        this.kdtEntrys.getColumn("BoPWIPAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtBoPWIPAmount));
        this.kdtEntrys.getColumn("BoPWIPAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntrys.getColumn("BoPWIPAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)curPrecision));
        KDFormattedTextField txtYTDFinishAmount = new KDFormattedTextField();
        txtYTDFinishAmount.setDataType(1);
        txtYTDFinishAmount.setPrecision(curPrecision);
        txtYTDFinishAmount.setHorizontalAlignment(4);
        this.kdtEntrys.getColumn("YTDFinishAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtYTDFinishAmount));
        this.kdtEntrys.getColumn("YTDFinishAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntrys.getColumn("YTDFinishAmount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)curPrecision));
    }

    protected void loadEntry() {
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            CostItemInfo info = (CostItemInfo)row.getCell("costItem").getValue();
            if (info == null || !info.getItemType().equals((Object)CostItemEnum.STUFF)) continue;
            row.getCell("detail").setValue((Object)"...");
            row.getCell("YTDInputAmount").getStyleAttributes().setLocked(true);
            row.getCell("BoPWIPAmount").getStyleAttributes().setLocked(true);
            row.getCell("YTDFinishAmount").getStyleAttributes().setLocked(true);
        }
    }

    protected void fillCellAfterBillSelectedRelation(DataChangeEvent eventObj) {
        int rowIndex = this.kdtEntrys.getSelectManager().getActiveRowIndex();
        if (eventObj.getNewValue() instanceof Object[]) {
            Object[] Objinfo = (Object[])eventObj.getNewValue();
            for (int i = 0; i < Objinfo.length; ++i) {
                try {
                    IRow curRow;
                    CostItemInfo info = CostItemFactory.getRemoteInstance().getCostItemInfo((IObjectPK)new ObjectUuidPK(InitBalanceEditUI.getId(Objinfo[i])));
                    if (info == null) continue;
                    if (i == 0) {
                        curRow = this.kdtEntrys.getRow(rowIndex);
                        KDTableUtil.clearCells((KDTable)this.kdtEntrys, (int)rowIndex, (String[])new String[]{"costItem", "costItemName", "detail"});
                        curRow.getCell("costItem").setValue((Object)info);
                        curRow.getCell("costItemName").setValue((Object)info.getName());
                        if (info.getItemType().equals((Object)CostItemEnum.STUFF)) {
                            curRow.getCell("detail").setValue((Object)"...");
                            curRow.getCell("YTDInputAmount").setValue((Object)SysConstant.BIGZERO);
                            curRow.getCell("BoPWIPAmount").setValue((Object)SysConstant.BIGZERO);
                            curRow.getCell("YTDFinishAmount").setValue((Object)SysConstant.BIGZERO);
                            curRow.getCell("YTDInputAmount").getStyleAttributes().setLocked(true);
                            curRow.getCell("BoPWIPAmount").getStyleAttributes().setLocked(true);
                            curRow.getCell("YTDFinishAmount").getStyleAttributes().setLocked(true);
                            continue;
                        }
                        curRow.getCell("YTDInputAmount").getStyleAttributes().setLocked(false);
                        curRow.getCell("BoPWIPAmount").getStyleAttributes().setLocked(false);
                        curRow.getCell("YTDFinishAmount").getStyleAttributes().setLocked(false);
                        continue;
                    }
                    curRow = null;
                    curRow = rowIndex != -1 ? this.kdtEntrys.addRow(rowIndex + i) : this.kdtEntrys.addRow();
                    curRow.getCell("costItem").setValue((Object)info);
                    curRow.getCell("costItemName").setValue((Object)info.getName());
                    if (info.getItemType().equals((Object)CostItemEnum.STUFF)) {
                        curRow.getCell("detail").setValue((Object)"...");
                        curRow.getCell("YTDInputAmount").setValue((Object)SysConstant.BIGZERO);
                        curRow.getCell("BoPWIPAmount").setValue((Object)SysConstant.BIGZERO);
                        curRow.getCell("YTDFinishAmount").setValue((Object)SysConstant.BIGZERO);
                        curRow.getCell("YTDInputAmount").getStyleAttributes().setLocked(true);
                        curRow.getCell("BoPWIPAmount").getStyleAttributes().setLocked(true);
                        curRow.getCell("YTDFinishAmount").getStyleAttributes().setLocked(true);
                        continue;
                    }
                    curRow.getCell("YTDInputAmount").setValue((Object)SysConstant.BIGZERO);
                    curRow.getCell("BoPWIPAmount").setValue((Object)SysConstant.BIGZERO);
                    curRow.getCell("YTDFinishAmount").setValue((Object)SysConstant.BIGZERO);
                    curRow.getCell("YTDInputAmount").getStyleAttributes().setLocked(false);
                    curRow.getCell("BoPWIPAmount").getStyleAttributes().setLocked(false);
                    curRow.getCell("YTDFinishAmount").getStyleAttributes().setLocked(false);
                    continue;
                }
                catch (EASBizException e1) {
                    logger.error((Object)"", (Throwable)e1);
                    this.handUIException(e1);
                    continue;
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                    this.handUIException(e1);
                }
            }
        }
    }

    public static String getId(Object info) {
        if (info == null) {
            return null;
        }
        if (AbstractObjectValue.class.isInstance(info)) {
            AbstractObjectValue objInfo = (AbstractObjectValue)info;
            return objInfo.getBOSUuid("id").toString();
        }
        return info.toString();
    }

    protected FilterInfo getCostItemFilter() throws Exception {
        return CostItemFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), this.getKeyFieldName(), this.getAdminCUFieldName());
    }

    protected IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(this.getMainBizOrgType());
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getAdminCUFieldName() {
        return "adminCU.id";
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
    }

    public void verifySubmit() throws Exception {
        NCMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        NCMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTable)this.kdtEntrys);
        if (this.txtBoPWIPQty.getBigDecimalValue() != null && this.txtBoPWIPQty.getBigDecimalValue().compareTo(SysConstant.BIGZERO) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"54_InitBalanceEditUI"));
            SysUtil.abort();
        }
        if (this.txtYTDFinishedQty.getBigDecimalValue() != null && this.txtYTDFinishedQty.getBigDecimalValue().compareTo(SysConstant.BIGZERO) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"55_InitBalanceEditUI"));
            SysUtil.abort();
        }
        if (this.txtBopWIOHour.getBigDecimalValue() != null && this.txtBopWIOHour.getBigDecimalValue().compareTo(SysConstant.BIGZERO) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"156_InitBalanceEditUI"));
            SysUtil.abort();
        }
        BigDecimal init = this.txtBoPWIPQty.getBigDecimalValue().add(this.txtYTDFinishedQty.getBigDecimalValue());
        BigDecimal YTDInputAmount = SysConstant.BIGZERO;
        BigDecimal YTDFinishAmount = SysConstant.BIGZERO;
        BigDecimal BoPWIPAmount = SysConstant.BIGZERO;
        int m = this.kdtEntrys.getRowCount();
        HashMap<Object, Object> infoMap = new HashMap<Object, Object>();
        boolean onlyone = false;
        while (m-- > 0) {
            IRow row = this.kdtEntrys.getRow(m);
            if (row.getCell("costItem").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"15_AllocStdSetByWIPListUI"));
                SysUtil.abort();
            }
            if (infoMap.containsKey(row.getCell("costItem").getValue())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"56_InitBalanceEditUI"));
                this.abort();
            }
            infoMap.put(row.getCell("costItem").getValue(), row.getCell("costItem").getValue());
            if (row.getCell("YTDInputAmount").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"151_InitBalanceEditUI"));
                SysUtil.abort();
            }
            if (row.getCell("BoPWIPAmount").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"152_InitBalanceEditUI"));
                SysUtil.abort();
            }
            if (row.getCell("detail").getValue() != null && row.getCell("detail").getValue().equals("...") && ((BigDecimal)row.getCell("BoPWIPAmount").getValue()).compareTo(SysConstant.BIGZERO) == 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"59_InitBalanceEditUI") + row.getCell("costItemName").getValue() + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"60_InitBalanceEditUI")));
                SysUtil.abort();
            }
            if (row.getCell("YTDFinishAmount").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"153_InitBalanceEdit"));
                SysUtil.abort();
            }
            if (((BigDecimal)row.getCell("YTDInputAmount").getValue()).add((BigDecimal)row.getCell("BoPWIPAmount").getValue()).add((BigDecimal)row.getCell("YTDFinishAmount").getValue()).compareTo(SysConstant.BIGZERO) == 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"62_InitBalanceEditUI"));
                this.abort();
            }
            YTDInputAmount = YTDInputAmount.add((BigDecimal)row.getCell("YTDInputAmount").getValue());
            BoPWIPAmount = BoPWIPAmount.add((BigDecimal)row.getCell("BoPWIPAmount").getValue());
            YTDFinishAmount = YTDFinishAmount.add((BigDecimal)row.getCell("YTDFinishAmount").getValue());
            init = init.add((BigDecimal)row.getCell("YTDInputAmount").getValue()).add((BigDecimal)row.getCell("BoPWIPAmount").getValue()).add((BigDecimal)row.getCell("YTDFinishAmount").getValue());
        }
        if (init.compareTo(SysConstant.BIGZERO) == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"63_InitBalanceEditUI"));
            this.abort();
        }
        if (BoPWIPAmount.compareTo(SysConstant.BIGZERO) < 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"64_InitBalanceEditUI"));
            this.abort();
        }
        if (YTDInputAmount.compareTo(SysConstant.BIGZERO) < 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"65_InitBalanceEditUI"));
            this.abort();
        }
        if (YTDFinishAmount.compareTo(SysConstant.BIGZERO) < 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"66_InitBalanceEditUI"));
            this.abort();
        }
    }

    @Override
    protected void kdtEntrys_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdtEntrys_tableClicked(e);
        if (e.getClickCount() == 2 && this.kdtEntrys.getSelectManager().getActiveColumnIndex() == 3) {
            this.isDetail();
        }
    }

    @Override
    public void actionDetail_actionPerformed(ActionEvent e) throws Exception {
        super.actionDetail_actionPerformed(e);
        this.isDetail();
    }

    public void isDetail() throws Exception {
        if ("ADDNEW".equals(this.getOprtState())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"20_BoPInvSFPCostEditUI"));
            SysUtil.abort();
        }
        this.checkSelected();
        IRow row = this.kdtEntrys.getRow(InitBalanceEditUI.getSelectedRow(this.kdtEntrys));
        if (row.getCell("detail").getValue() == null || !row.getCell("detail").getValue().toString().equals("...")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"21_BoPInvSFPCostEditUI"));
            SysUtil.abort();
        }
        if (row.getCell("entriesID").getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"20_BoPInvSFPCostEditUI"));
            SysUtil.abort();
        }
        this.getUIContext().put("entry.id", row.getCell("entriesID").getValue());
        InitBalanceMatDetailUI.showMatDetaiUI((CoreUIObject)this, (CoreBaseInfo)this.editData, row.getCell("entriesID").getValue().toString(), row.getCell("costItemName").getValue().toString(), this.txtmodel.getText(), this.getOprtState());
        try {
            String sql = "select isnull(sum(Famount),0) as amount,isnull(sum(FYTDInputMatAmou),0) as YTDInputAmount,isnull(sum(FYTDFinishedMatA),0) as YTDFinishAmount from t_ncm_initbalancematdetail where fparentid='" + row.getCell("entriesID").getValue().toString() + "'";
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
            while (rs.next()) {
                row.getCell("YTDInputAmount").setValue((Object)rs.getBigDecimal("YTDInputAmount"));
                row.getCell("BoPWIPAmount").setValue((Object)rs.getBigDecimal("amount"));
                row.getCell("YTDFinishAmount").setValue((Object)rs.getBigDecimal("YTDFinishAmount"));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifySubmit();
        super.actionSubmit_actionPerformed(e);
        if (this.billstatus.getSelectedItem() != null && this.billstatus.getSelectedItem().toString().equals(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"157_InitBalanceEditUI_Audit"))) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        if (this.chkMenuItemSubmitAndAddNew.isSelected()) {
            this.btnAudit.setEnabled(false);
            this.btnSave.setEnabled(true);
            this.actionAddLine_actionPerformed(null);
        }
    }

    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("balance_audit");
        }
        super.auditAction_actionPerformed(e);
    }

    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkAuditPermission("balance_unaudit");
        super.unauditAction_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, (IObjectPK)new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId().toString()), (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InitBalanceFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        InitBalanceEntryInfo objectValueEntry = new InitBalanceEntryInfo();
        objectValueEntry.setYTDFinishAmount(SysConstant.BIGZERO);
        objectValueEntry.setYTDInputAmount(SysConstant.BIGZERO);
        objectValueEntry.setBoPWIPAmount(SysConstant.BIGZERO);
        return objectValueEntry;
    }

    protected IObjectValue createNewData() {
        InitBalanceInfo objectValue = new InitBalanceInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setCompanyOrg(this.currentCompany);
        objectValue.setDescription("");
        objectValue.setBillStatus(com.kingdee.eas.ncm.common.BillBaseStatusEnum.ADD);
        objectValue.setBopWIPQty(SysConstant.BIGZERO);
        objectValue.setYTDFinishedQty(SysConstant.BIGZERO);
        objectValue.setBopWIPHour(SysConstant.BIGZERO);
        return objectValue;
    }

    public void checkSelected() {
        if (this.kdtEntrys.getRowCount() == 0 || this.kdtEntrys.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public static int getSelectedRow(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        if (selectBlock == null) {
            return -1;
        }
        return selectBlock.getTop();
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected void prmtcostObject_dataChanged(DataChangeEvent e) throws Exception {
        CostObjectInfo info;
        if (this.isCostObject) {
            return;
        }
        this.isCostObject = true;
        this.fillCostObjectAfterDo2(e);
        this.isCostObject = false;
        if (e.getNewValue() instanceof CostObjectInfo && (info = (CostObjectInfo)e.getNewValue()) != null && info.getStdProductID() != null) {
            MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getStdProductID().getId().toString()));
            this.txtmodel.setText(material.getModel());
            int qtyPrecision = 4;
            if (material.getBaseUnit() != null) {
                String unitID = material.getBaseUnit().getId().toString();
                String materialID = material.getId().toString();
                String oql = "select * where material.id = '" + materialID + "' and measureUnit.id = '" + unitID + "'";
                MultiMeasureUnitInfo mulUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitInfo(oql);
                qtyPrecision = mulUnitInfo.getQtyPrecision();
            }
            this.txtBoPWIPQty.setPrecision(qtyPrecision);
            this.txtYTDFinishedQty.setPrecision(qtyPrecision);
        }
    }

    @Override
    protected void prmtMaterialNumber_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isCostObject) {
            return;
        }
        this.isCostObject = true;
        this.fillMaterialAfterDo2(e);
        this.isCostObject = false;
        if (e.getNewValue() instanceof MaterialInfo) {
            MaterialInfo info = (MaterialInfo)e.getNewValue();
            this.txtmodel.setText(info.getModel());
            int qtyPrecision = 4;
            if (info.getBaseUnit() != null) {
                String unitID = info.getBaseUnit().getId().toString();
                String materialID = info.getId().toString();
                String oql = "select * where material.id = '" + materialID + "' and measureUnit.id = '" + unitID + "'";
                MultiMeasureUnitInfo mulUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitInfo(oql);
                qtyPrecision = mulUnitInfo.getQtyPrecision();
            }
            this.txtBoPWIPQty.setPrecision(qtyPrecision);
            this.txtYTDFinishedQty.setPrecision(qtyPrecision);
        }
    }

    @Override
    protected void prmtOrder_dataChanged(DataChangeEvent e) throws Exception {
        ManufactureOrderInfo info;
        if (this.isCostObject) {
            return;
        }
        this.isCostObject = true;
        this.fillManufactureAfterDo2(e);
        this.isCostObject = false;
        if (e.getNewValue() instanceof ManufactureOrderInfo && (info = (ManufactureOrderInfo)e.getNewValue()).getMaterial() != null) {
            MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId().toString()));
            this.txtmodel.setText(material.getModel());
            int qtyPrecision = 4;
            if (material.getBaseUnit() != null) {
                String unitID = material.getBaseUnit().getId().toString();
                String materialID = material.getId().toString();
                String oql = "select * where material.id = '" + materialID + "' and measureUnit.id = '" + unitID + "'";
                MultiMeasureUnitInfo mulUnitInfo = MultiMeasureUnitFactory.getRemoteInstance().getMultiMeasureUnitInfo(oql);
                qtyPrecision = mulUnitInfo.getQtyPrecision();
            }
            this.txtBoPWIPQty.setPrecision(qtyPrecision);
            this.txtYTDFinishedQty.setPrecision(qtyPrecision);
        }
    }

    @Override
    protected void tfBatch_focusLost(FocusEvent e) throws Exception {
        String batchNumber = null;
        if (this.tfBatch.getText().equals("")) {
            throw new NcmBillException(NcmBillException.BATCHISNULL);
        }
        batchNumber = this.tfBatch.getText();
        MaterialInfo materialInfo = null;
        if (this.prmtMaterialNumber.getValue() instanceof MaterialInfo) {
            materialInfo = (MaterialInfo)this.prmtMaterialNumber.getValue();
        }
        CostObjectRelatedInfo costObjectRelatedInfo = null;
        try {
            costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((MaterialInfo)materialInfo, (String)batchNumber, (boolean)true);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        if (costObjectRelatedInfo == null) {
            throw new NcmBillException(NcmBillException.MATANDBATCH_NO_COSTOBJECT);
        }
        this.prmtcostObject.setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
    }

    protected void checkValidDataForSubmit() throws Exception {
        if (UIRuleUtil.isNull((Object)this.prmtCompany.getValue())) {
            this.prmtCompany.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{BDCMClientUtils.getNcmResource((String)"CompanyOrgUnit")});
        }
    }

    protected void isStartSet() throws Exception {
        boolean disable = false;
        if (this.getUIContext().get("SPETIAL_START") != null) {
            if (!((Boolean)this.getUIContext().get("SPETIAL_START")).booleanValue()) {
                disable = true;
            }
        } else {
            ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
            if (sysctrol.isStart(1001, SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
                disable = true;
            }
        }
        if (disable) {
            ItemAction[] actList = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.auditAction, this.unauditAction, this.actionSubmit, this.actionAddLine, this.actionInsertLine, this.actionRemoveLine, this.actionSave};
            NCMClientUtils.setActionVisible((boolean)false, (ItemAction[])actList);
            NCMClientUtils.setActionEnabled((boolean)false, (ItemAction[])actList);
        }
    }

    protected void isStart() throws Exception {
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().printPreview();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntrys.getPrintManager().pageSetup();
    }

    protected void showSaveSuccess() {
        super.showSaveSuccess();
    }

    protected void showSubmitSuccess() {
        super.showSubmitSuccess();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.costItem.*"));
        sic.add(new SelectorItemInfo("entrys.YTDInputAmount"));
        sic.add(new SelectorItemInfo("entrys.BoPWIPAmount"));
        sic.add(new SelectorItemInfo("entrys.YTDFinishAmount"));
        sic.add(new SelectorItemInfo("entrys.costItem.name"));
        sic.add(new SelectorItemInfo("companyOrg.*"));
        sic.add(new SelectorItemInfo("costObject.*"));
        sic.add(new SelectorItemInfo("costObject.StdProductID.*"));
        sic.add(new SelectorItemInfo("costCenter.*"));
        sic.add(new SelectorItemInfo("BopWIPQty"));
        sic.add(new SelectorItemInfo("YTDFinishedQty"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("calculatePeriod.*"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("BopWIPHour"));
        sic.add(new SelectorItemInfo("costObject.order.id"));
        sic.add(new SelectorItemInfo("costObject.order.number"));
        return sic;
    }

    protected void setTableToSumField() {
        int curPrecision = this.currency.getPrecision();
        StringBuffer curPrecisionStr = new StringBuffer("@0.");
        for (int i = 0; i < curPrecision; ++i) {
            curPrecisionStr.append("0");
        }
        super.setTableToSumField(this.kdtEntries, new String[]{"BoPWIPAmount" + curPrecisionStr.toString(), "YTDInputAmount" + curPrecisionStr.toString(), "YTDFinishAmount" + curPrecisionStr.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMaterialAfterDo2(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        this.prmtOrder.setEnabled(true);
        if (newValue != null && newValue instanceof MaterialInfo) {
            try {
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfo(null, (MaterialInfo)((MaterialInfo)newValue), null, (CompanyOrgUnitInfo)this.currentCompany);
                this.txtMaterialName.setText(((MaterialInfo)newValue).getName());
                if (costObjectRelatedInfo != null) {
                    if (costObjectRelatedInfo.getCostObjectInfo() != null) {
                        this.prmtcostObject.setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                        this.tfBatch.setText(costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                        if (costObjectRelatedInfo.getCostObjectInfo().getBatchNumber() == null || costObjectRelatedInfo.getCostObjectInfo().getBatchNumber().length() <= 0) {
                            this.tfBatch.setEnabled(false);
                        }
                    } else {
                        this.tfBatch.setEnabled(true);
                    }
                    this.txtProjectNumber.setText(costObjectRelatedInfo.getProjectNumber());
                    this.txtTrackNumber.setText(costObjectRelatedInfo.getTrackNumber());
                }
                this.tfBatch.setEnabled(true);
                this.tfBatch.setRequired(true);
                this.prmtcostObject.setValue(null);
                this.prmtOrder.setValue(null);
                this.prmtOrder.setEnabled(false);
                this.txtProjectNumber.setText(null);
                this.txtTrackNumber.setText(null);
                this.tfBatch.setText(null);
            }
            catch (EASBizException e) {
                this.handUIException(e);
                this.prmtcostObject.setValue(null);
                this.txtMaterialName.setText(null);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            finally {
                this.isCostObject = false;
            }
        } else {
            this.txtMaterialName.setText(null);
            this.prmtcostObject.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillManufactureAfterDo2(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        if (newValue != null && newValue instanceof ManufactureOrderInfo) {
            try {
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByOrder((ManufactureOrderInfo)((ManufactureOrderInfo)newValue), (String)((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString());
                if (costObjectRelatedInfo != null) {
                    if (costObjectRelatedInfo.getCostObjectInfo() != null) {
                        this.prmtcostObject.setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                        this.tfBatch.setText(costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                        this.tfBatch.setEnabled(false);
                        this.tfBatch.setRequired(false);
                    } else {
                        this.prmtcostObject.setValue(null);
                        this.tfBatch.setEnabled(true);
                    }
                    this.prmtMaterialNumber.setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                    this.txtMaterialName.setText(costObjectRelatedInfo.getMaterialInfo().getName());
                    this.txtProjectNumber.setText(costObjectRelatedInfo.getProjectNumber());
                    this.txtTrackNumber.setText(costObjectRelatedInfo.getTrackNumber());
                    this.isCostObject = false;
                } else {
                    this.prmtcostObject.setValue(null);
                    String materialID = ((ManufactureOrderInfo)newValue).getMaterial().getId().toString();
                    MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                    this.prmtMaterialNumber.setValue((Object)material);
                    this.txtMaterialName.setText(material.getName());
                    this.txtProjectNumber.setText(null);
                    this.txtTrackNumber.setText(null);
                    this.tfBatch.setText(null);
                    this.tfBatch.setEnabled(true);
                    this.tfBatch.setRequired(true);
                    this.isCostObject = false;
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            finally {
                this.isCostObject = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCostObjectAfterDo2(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        this.prmtOrder.setEnabled(true);
        if (newValue != null && newValue instanceof CostObjectInfo) {
            try {
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByCO((CostObjectInfo)((CostObjectInfo)newValue));
                this.prmtOrder.setValue((Object)costObjectRelatedInfo.getManufactureOrderInfo());
                this.prmtMaterialNumber.setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                if (costObjectRelatedInfo.getMaterialInfo() != null) {
                    this.txtMaterialName.setText(costObjectRelatedInfo.getMaterialInfo().getName());
                }
                this.txtProjectNumber.setText(costObjectRelatedInfo.getProjectNumber());
                this.txtTrackNumber.setText(costObjectRelatedInfo.getTrackNumber());
                this.tfBatch.setText(costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                String coID = ((CostObjectInfo)newValue).getId().toString();
                CostObjectInfo costObject = CostObjectFactory.getRemoteInstance().getCostObjectInfo((IObjectPK)new ObjectUuidPK(coID));
                if (!costObject.getCalculateMode().equals((Object)CalculateModeEnum.BYBATCH)) {
                    this.tfBatch.setEnabled(false);
                    this.tfBatch.setRequired(false);
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            finally {
                this.isCostObject = false;
            }
        }
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.prmtMaterialNumber.setValue(null);
        this.txtMaterialName.setText(null);
        this.prmtOrder.setValue(null);
        this.tfBatch.setText(null);
        this.txtProjectNumber.setText(null);
        this.txtTrackNumber.setText(null);
    }
}

