/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.bill.InitBalanceFilterParam;
import com.kingdee.eas.ncm.bill.InitBalanceInfo;
import com.kingdee.eas.ncm.bill.client.AbstractInitBalanceFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import org.apache.log4j.Logger;

public class InitBalanceFilterUI
extends AbstractInitBalanceFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InitBalanceFilterUI.class);
    private CompanyOrgUnitInfo companyOrg = null;
    private String InitBalanceInfoFrom = "initBalanceInfoFrom";
    private String InitBalanceInfoTo = "initBalanceInfoTo";
    private String CostCenterFrom = "costCenterFrom";
    private String CostCenterTo = "costCenterTo";
    private String CostObjectFrom = "costObjectFrom";
    private String CostObjectTo = "costObjectTo";
    private String CostItemFrom = "costItemFrom";
    private String CostItemTo = "costItemTo";
    private String BillSate = "billSate";

    public void onLoad() throws Exception {
        this.isNormal = false;
        super.onLoad();
        this.companyOrg = SysContext.getSysContext().getCurrentFIUnit();
        this.formatUI();
    }

    private void formatUI() throws Exception {
        this.filterBillNumByOrg(this.prtBillNumFrom);
        this.filterBillNumByOrg(this.prtBillNumTo);
        this.initCompany(this.companyOrg);
        this.filterCostCenter(this.prtCostcenterFrom);
        this.filterCostCenter(this.prtCostcenterTo);
        this.filterCostObjectByOrg(this.prtCostObjectFrom);
        this.filterCostObjectByOrg(this.prtCostObjectTo);
    }

    public InitBalanceFilterParam getFilterParam() {
        InitBalanceFilterParam filterParam = (InitBalanceFilterParam)this.createNewFilterParam();
        this.storeFilterParam(filterParam);
        return filterParam;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new InitBalanceFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof InitBalanceFilterParam)) {
            return;
        }
        InitBalanceFilterParam fp = (InitBalanceFilterParam)filterParam;
        InitBalanceInfo bnFrom = null;
        InitBalanceInfo bnTo = null;
        String initBalanceFromData = customerParams.getCustomerParam(this.InitBalanceInfoFrom);
        String initBalanceToData = customerParams.getCustomerParam(this.InitBalanceInfoTo);
        if (initBalanceFromData != null && initBalanceFromData.length() > 0) {
            bnFrom = new InitBalanceInfo();
            bnFrom.setId(BOSUuid.read((String)initBalanceFromData));
        }
        if (initBalanceToData != null && initBalanceToData.length() > 0) {
            bnTo = new InitBalanceInfo();
            bnTo.setId(BOSUuid.read((String)initBalanceToData));
        }
        fp.setInitBalanceInfoFrom(bnFrom);
        fp.setInitBalanceInfoTo(bnTo);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        String costCenterFromData = customerParams.getCustomerParam(this.CostCenterFrom);
        String costCenterToData = customerParams.getCustomerParam(this.CostCenterTo);
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            ccTo = new CostCenterOrgUnitInfo();
            ccTo.setId(BOSUuid.read((String)costCenterToData));
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
        CostObjectInfo cbFrom = null;
        CostObjectInfo cbTo = null;
        String costObjectFromData = customerParams.getCustomerParam(this.CostObjectFrom);
        String costObjectToData = customerParams.getCustomerParam(this.CostObjectTo);
        if (costObjectFromData != null && costObjectFromData.length() > 0) {
            cbFrom = new CostObjectInfo();
            cbFrom.setId(BOSUuid.read((String)costObjectFromData));
        }
        if (costObjectToData != null && costObjectToData.length() > 0) {
            cbTo = new CostObjectInfo();
            cbTo.setId(BOSUuid.read((String)costObjectToData));
        }
        fp.setCostObjectFrom(cbFrom);
        fp.setCostObjectTo(cbTo);
        CostItemInfo ciFrom = null;
        CostItemInfo ciTo = null;
        String costItemFromData = customerParams.getCustomerParam(this.CostItemFrom);
        String costItemctToData = customerParams.getCustomerParam(this.CostItemTo);
        if (costItemFromData != null && costItemFromData.length() > 0) {
            ciFrom = new CostItemInfo();
            ciFrom.setId(BOSUuid.read((String)costItemFromData));
        }
        if (costItemctToData != null && costItemctToData.length() > 0) {
            ciTo = new CostItemInfo();
            ciTo.setId(BOSUuid.read((String)costItemctToData));
        }
        fp.setCostItemFrom(ciFrom);
        fp.setCostItemTo(ciTo);
        String schemeState = customerParams.getCustomerParam(this.BillSate);
        if (schemeState != null && schemeState.length() > 0) {
            fp.setBillSate(schemeState);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof InitBalanceFilterParam)) {
            return;
        }
        InitBalanceFilterParam fp = (InitBalanceFilterParam)filterParam;
        this.prtBillNumFrom.setData((Object)fp.getInitBalanceInfoFrom());
        this.prtBillNumTo.setData((Object)fp.getInitBalanceInfoTo());
        this.prtCostcenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prtCostcenterTo.setData((Object)fp.getCostCenterTo());
        this.prtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prtCostObjectTo.setData((Object)fp.getCostObjectTo());
        this.prtCostItemFrom.setData((Object)fp.getCostItemFrom());
        this.prtCostItemTo.setData((Object)fp.getCostItemTo());
        this.combBillState.setSelectedIndex(Integer.parseInt(fp.getBillSate()));
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof InitBalanceFilterParam)) {
            return;
        }
        InitBalanceFilterParam fp = (InitBalanceFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getInitBalanceInfoFrom(), this.InitBalanceInfoFrom);
        super.putIdByKey(customerParams, (Object)fp.getInitBalanceInfoTo(), this.InitBalanceInfoTo);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), this.CostCenterFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), this.CostCenterTo);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectFrom(), this.CostObjectFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectTo(), this.CostObjectTo);
        super.putIdByKey(customerParams, (Object)fp.getCostItemFrom(), this.CostItemFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostItemTo(), this.CostItemTo);
        super.putIdByKey(customerParams, (Object)fp.getBillSate(), this.BillSate);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof InitBalanceFilterParam)) {
            return;
        }
        InitBalanceFilterParam fp = (InitBalanceFilterParam)filterParam;
        Object temp = null;
        InitBalanceInfo initBalanceInfoFrom = null;
        InitBalanceInfo initBalanceInfoTo = null;
        temp = this.prtBillNumFrom.getData();
        if (temp != null && temp instanceof InitBalanceInfo) {
            initBalanceInfoFrom = (InitBalanceInfo)temp;
        }
        if ((temp = this.prtBillNumTo.getData()) != null && temp instanceof InitBalanceInfo) {
            initBalanceInfoTo = (InitBalanceInfo)temp;
        }
        fp.setInitBalanceInfoFrom(initBalanceInfoFrom);
        fp.setInitBalanceInfoTo(initBalanceInfoTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.prtCostcenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.prtCostcenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        temp = this.prtCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.prtCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)temp;
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        CostItemInfo costItemFrom = null;
        CostItemInfo costItemTo = null;
        temp = this.prtCostItemFrom.getData();
        if (temp != null && temp instanceof CostItemInfo) {
            costItemFrom = (CostItemInfo)temp;
        }
        if ((temp = this.prtCostItemTo.getData()) != null && temp instanceof CostItemInfo) {
            costItemTo = (CostItemInfo)temp;
        }
        fp.setCostItemFrom(costItemFrom);
        fp.setCostItemTo(costItemTo);
        int selectIndex = this.combBillState.getSelectedIndex();
        fp.setBillSate(String.valueOf(selectIndex));
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        int selectIndex = this.combBillState.getSelectedIndex();
        String billStatus = String.valueOf(selectIndex + 1);
        if (selectIndex != 0) {
            filterBiz.getFilterItems().add(new FilterItemInfo("billStatus", (Object)billStatus, CompareType.EQUALS));
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public void clear() {
        try {
            this.clearFilterData();
            this.formatUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prtCompany.setValue((Object)companyOrg);
        this.prtCompany.setEnabled(false);
    }

    private void filterCostCenter(KDBizPromptBox prmt) {
        try {
            BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)prmt, (String)this.companyOrg.getId().toString());
            FilterInfo filterCostCenterType = new FilterInfo();
            filterCostCenterType.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)"0", CompareType.EQUALS));
            filterCostCenterType.mergeFilter(filterCostCenterType, "AND");
            filterCostCenterType.mergeFilter(prmt.getEntityViewInfo().getFilter(), "AND");
            prmt.getEntityViewInfo().setFilter(filterCostCenterType);
            prmt.getQueryAgent().resetRuntimeEntityView();
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    private void filterCostObjectByOrg(KDBizPromptBox prmt) throws Exception {
        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)prmt, (String)this.companyOrg.getId().toString());
        FilterInfo filterIsForbiden = new FilterInfo();
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)"0", CompareType.EQUALS));
        filterIsForbiden.mergeFilter(prmt.getEntityViewInfo().getFilter(), "AND");
        prmt.getEntityViewInfo().setFilter(filterIsForbiden);
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    private void filterBillNumByOrg(KDBizPromptBox prmt) throws Exception {
        FilterInfo filterIsForbiden = new FilterInfo();
        filterIsForbiden.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.companyOrg.getId().toString(), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterIsForbiden);
        prmt.setEntityViewInfo(view);
        prmt.getQueryAgent().resetRuntimeEntityView();
    }

    private void clearFilterData() {
        this.prtBillNumFrom.setValue(null);
        this.prtBillNumTo.setValue(null);
        this.prtCostcenterFrom.setValue(null);
        this.prtCostcenterTo.setValue(null);
        this.prtCostItemFrom.setValue(null);
        this.prtCostItemTo.setValue(null);
        this.prtCostObjectFrom.setValue(null);
        this.prtCostObjectTo.setValue(null);
        this.combBillState.setSelectedIndex(0);
    }
}

