/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.InitBalanceFactory;
import com.kingdee.eas.ncm.bill.client.AbstractInitBalanceListUI;
import com.kingdee.eas.ncm.bill.client.InitBalancFilterUI;
import com.kingdee.eas.ncm.bill.client.InitBalanceEditUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class InitBalanceListUI
extends AbstractInitBalanceListUI {
    private CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    private String companyID = this.currentCompany.getId().toString();
    private static final Logger logger = CoreUIObject.getLogger(InitBalanceListUI.class);
    private final FillListener fillListener = new FillListener();
    private InitBalancFilterUI filterUI = null;
    private ActionManager actionManager;
    CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    Boolean spetialStart = Boolean.FALSE;
    private int importInfoIndex = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCompany = this.getCompanyOrgInfoWithDefault();
        this.companyID = this.currentCompany.getId().toString();
        this.currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (SystemStatusCtrolFactory.getRemoteInstance().isStart(1001, this.companyID)) {
            this.spetialStart = Boolean.FALSE;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"67_InitBalanceListUI"));
            SysUtil.abort();
        }
        this.spetialStart = Boolean.TRUE;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (SystemStatusCtrolFactory.getRemoteInstance().isStart(1001, this.companyID)) {
            this.spetialStart = Boolean.FALSE;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"68_InitBalanceListUI"));
            SysUtil.abort();
        }
        this.spetialStart = Boolean.TRUE;
        super.actionEdit_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.spetialStart.booleanValue()) {
            uiContext.put((Object)"SPETIAL_START", (Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (SystemStatusCtrolFactory.getRemoteInstance().isStart(1001, this.companyID)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"69_InitBalanceListUI"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InitBalanceFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return InitBalanceEditUI.class.getName();
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = 24;
        String[] keys = new String[24];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    protected void isStartSet() throws Exception {
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getRemoteInstance();
        if (sysctrol.isStart(1001, SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
            ItemAction[] actList = new ItemAction[]{this.actionAddNew, this.actionEdit, this.actionRemove, this.auditAction, this.unauditAction};
            NCMClientUtils.setActionVisible((boolean)false, (ItemAction[])actList);
            NCMClientUtils.setActionEnabled((boolean)false, (ItemAction[])actList);
        }
    }

    protected void isStart() throws Exception {
    }

    public void checkStart(String id) throws Exception {
    }

    protected boolean isCheckStart() {
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        cmcq.set("query", (Object)"InitBalanceListQuery");
        try {
            boolean isShowShareCostObject = NCMUtils.isCostObjectOfBillRequired(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
            cmcq.set("showShareCostObject", (Object)isShowShareCostObject);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        dialog.setProcessor((IProcessor)cmcq);
        return dialog;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        if (SystemStatusCtrolFactory.getRemoteInstance().isStart(1001, this.companyID)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"70_InitBalanceListUI"));
            SysUtil.abort();
        }
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    @Override
    public void actionImportInitBalance_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 0;
        this.actionImportData_actionPerformed(e);
    }

    @Override
    public void actionImportInitBalanceMat_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 1;
        this.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = this.initParamForImport();
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private DatataskParameter initParamForImport() {
        String alias;
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        switch (this.importInfoIndex) {
            case 0: {
                solutionName = "initBalance";
                alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"71_InitBalanceListUI");
                break;
            }
            default: {
                solutionName = "initBalanceMatDetail";
                alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"72_InitBalanceListUI");
            }
        }
        param.solutionName = solutionName;
        param.alias = alias;
        return param;
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemImportInitBalance.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.menuItemImportInitBalanceMat.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        int curPre = this.currency.getPrecision();
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell("entrys.BoPWIPAmount"), (int)curPre);
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell("entrys.YTDInputAmount"), (int)curPre);
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)this.tblMain.getFootRow(0).getCell("entrys.YTDFinishAmount"), (int)curPre);
        return super.appendFootRow();
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new InitBalancFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.verifySubmit();
        super.actionSubmit_actionPerformed(e);
    }

    public void verifySubmit() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Object bopWIPQtyObj = this.tblMain.getRow(rowIndex).getCell("BopWIPQty").getValue();
        BigDecimal bopWIPQty = (BigDecimal)bopWIPQtyObj;
        if (bopWIPQty != null && bopWIPQty.compareTo(SysConstant.BIGZERO) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"54_InitBalanceEditUI"));
            SysUtil.abort();
        }
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    public final class FillListener
    implements KDTDataFillListener {
        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(InitBalanceListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            int curPre = InitBalanceListUI.this.currency.getPrecision();
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)tblMain.getRow(i).getCell("BopWIPQty"), (int)Integer.parseInt(String.valueOf(tblMain.getRow(i).getCell("qtyPre").getValue())));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)tblMain.getRow(i).getCell("YTDFinishedQty"), (int)Integer.parseInt(String.valueOf(tblMain.getRow(i).getCell("qtyPre").getValue())));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)tblMain.getRow(i).getCell("BopWIPHour"), (int)2);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)tblMain.getRow(i).getCell("entrys.BoPWIPAmount"), (int)curPre);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)tblMain.getRow(i).getCell("entrys.YTDInputAmount"), (int)curPre);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)tblMain.getRow(i).getCell("entrys.YTDFinishAmount"), (int)curPre);
            }
        }
    }
}

