/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.InitBalanceEntryFactory;
import com.kingdee.eas.ncm.bill.InitBalanceEntryInfo;
import com.kingdee.eas.ncm.bill.InitBalanceInfo;
import com.kingdee.eas.ncm.bill.InitBalanceMatDetailCollection;
import com.kingdee.eas.ncm.bill.InitBalanceMatDetailFactory;
import com.kingdee.eas.ncm.bill.InitBalanceMatDetailInfo;
import com.kingdee.eas.ncm.bill.client.AbstractInitBalanceMatDetaiUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InitBalanceMatDetaiUI
extends AbstractInitBalanceMatDetaiUI {
    private static Logger logger = Logger.getLogger((String)InitBalanceMatDetaiUI.class.getName());
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.currentCompany.getId().toString();
    private int amoountPrecision = 0;
    private IMultiMeasureUnit multiMeasureUnitInstance = null;
    private IMeasureUnit measureUnitInstance = null;
    private Object cellOldValue = null;
    KDBizPromptBox bizBaseUnitBox = new KDBizPromptBox();

    public void onLoad() throws Exception {
        this.initCustomedVariable();
        super.onLoad();
        this.multiMeasureUnitInstance = MultiMeasureUnitFactory.getRemoteInstance();
        this.measureUnitInstance = MeasureUnitFactory.getRemoteInstance();
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        this.amoountPrecision = currency == null ? 2 : currency.getPrecision();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddline.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveline.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionSave.setEnabled(true);
        this.initEntry();
        this.loadFields();
        if (this.kDTable1.getRowCount() < 1) {
            this.addLine(this.kDTable1);
        }
        if ("VIEW".equals((String)this.getUIContext().get("operState"))) {
            this.actionSave.setEnabled(false);
            this.btnAddline.setEnabled(false);
            this.btnRemoveline.setEnabled(false);
            this.kDTable1.setEditable(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.loadTable((String)this.getUIContext().get("parent"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void loadTable(String parentid) throws Exception {
        String osql = "SELECT parent.id, id, batchNo, Qty, Price, amount, YTDInputMatQty, YTDInputMatAmou, YTDFinishedMatQ, YTDFinishedMatA, seq, material.model, material.name, material.number, material.id, material.baseUnit.name,material.baseUnit.QtyPrecision,material.pricePrecision, material.assistUnit.name,material.assistUnit.QtyPrecision,assistQty, unit.id,unit.name,unit.qtyPrecision,addqty WHERE parent.id = '" + parentid + "'";
        InitBalanceMatDetailCollection coll = InitBalanceMatDetailFactory.getRemoteInstance().getInitBalanceMatDetailCollection(osql);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                InitBalanceMatDetailInfo obj = coll.get(i);
                IRow row = this.kDTable1.addRow();
                row.setUserObject((Object)obj);
                row.getCell("materialid").setValue((Object)obj.getMaterial());
                row.getCell("materialname").setValue((Object)obj.getMaterial().getName());
                row.getCell("model").setValue((Object)obj.getMaterial().getModel());
                row.getCell("baseUnit").setValue((Object)obj.getMaterial().getBaseUnit().getName());
                MeasureUnitInfo unitInfo = null;
                MultiMeasureUnitInfo multiUnifInfo = null;
                if (obj.getUnit() != null) {
                    unitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(obj.getUnit().getId()));
                    IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                    multiUnifInfo = multiUnit.getMultiUnit(obj.getMaterial().getId().toString(), unitInfo.getId().toString());
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("addQty"), (int)multiUnifInfo.getQtyPrecision(), (boolean)true);
                    row.getCell("unit").setValue((Object)unitInfo);
                }
                MeasureUnitInfo assistUnitInfo = null;
                if (obj.getMaterial().getAssistUnit() != null) {
                    assistUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(obj.getMaterial().getAssistUnit().getId()));
                    row.getCell("assistUnit").setValue((Object)assistUnitInfo);
                }
                String osql2 = "SELECT mateial.id, company.id, accountType WHERE mateial.id = '" + obj.getMaterial().getId().toString() + "' AND company.id = '" + this.companyID + "'";
                MaterialCompanyInfoInfo comInfo = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoInfo(osql2);
                if (!comInfo.getAccountType().equals((Object)AccountType.SPECIAL_ACCT)) {
                    row.getCell("batchNo").getStyleAttributes().setLocked(true);
                } else {
                    row.getCell("batchNo").getStyleAttributes().setLocked(false);
                }
                row.getCell("batchNo").setValue((Object)obj.getBatchNo());
                int qtyPrecision = this.multiMeasureUnitInstance.getQtyPrecision(obj.getMaterial().getId().toString(), obj.getMaterial().getBaseUnit().getId().toString());
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("Qty"), (int)qtyPrecision, (boolean)true);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("YTDInputMatQty"), (int)qtyPrecision, (boolean)true);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("YTDFinishedMatQ"), (int)qtyPrecision, (boolean)true);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("assistQty"), (int)qtyPrecision, (boolean)true);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("Price"), (int)obj.getMaterial().getPricePrecision(), (boolean)false);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("amount"), (int)this.amoountPrecision, (boolean)true);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("YTDInputMatAmou"), (int)this.amoountPrecision, (boolean)true);
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("YTDFinishedMatA"), (int)this.amoountPrecision, (boolean)true);
                row.getCell("Qty").setValue((Object)obj.getQty());
                row.getCell("Price").setValue((Object)obj.getPrice());
                row.getCell("amount").setValue((Object)obj.getAmount());
                row.getCell("addQty").setValue((Object)obj.getAddqty());
                row.getCell("assistQty").setValue((Object)obj.getAssistQty());
                row.getCell("YTDInputMatQty").setValue((Object)obj.getYTDInputMatQty());
                row.getCell("YTDInputMatAmou").setValue((Object)obj.getYTDInputMatAmou());
                row.getCell("YTDFinishedMatQ").setValue((Object)obj.getYTDFinishedMatQ());
                row.getCell("YTDFinishedMatA").setValue((Object)obj.getYTDFinishedMatA());
                Object unit = row.getCell("unit").getValue();
                row.getCell("addQty").getStyleAttributes().setLocked(unit == null);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initCustomedVariable() throws Exception {
        InitBalanceInfo info = (InitBalanceInfo)this.getUIContext().get("INFO");
        if (info.getCostObject() != null) {
            this.costobject.setText(info.getCostObject().getName());
        }
        if (info.getCostCenter() != null) {
            this.costcenter.setText(info.getCostCenter().getName());
        }
        this.model.setText((String)this.getUIContext().get("model"));
        this.company.setText(info.getCompanyOrg().getName());
        this.costitem.setText((String)this.getUIContext().get("costitemName"));
    }

    protected void initEntry() throws Exception {
        this.kDTable1.checkParsed();
        KDBizPromptBox prmtRelation = new KDBizPromptBox();
        ExtendParser parserCostObject = new ExtendParser(prmtRelation);
        prmtRelation.setCommitParser((IParser)parserCostObject);
        prmtRelation.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MaterialCostObjectQuery");
        prmtRelation.setVisible(true);
        prmtRelation.setEditable(true);
        prmtRelation.setDisplayFormat("$number$");
        prmtRelation.setEditFormat("$number$");
        prmtRelation.setCommitFormat("$number$");
        EntityViewInfo eviCostObject = new EntityViewInfo();
        eviCostObject.setFilter(this.getCostObjectFilter());
        prmtRelation.setEntityViewInfo(eviCostObject);
        ObjectValueRender avrCostObject = new ObjectValueRender();
        avrCostObject.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kDTable1.getColumn("materialid").setRenderer((IBasicRender)avrCostObject);
        prmtRelation.setRequired(true);
        this.kDTable1.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarted(KDTEditEvent event) {
                int rowIndex = event.getRowIndex();
                int colIndex = event.getColIndex();
                InitBalanceMatDetaiUI.this.cellOldValue = InitBalanceMatDetaiUI.this.kDTable1.getCell(rowIndex, colIndex).getValue();
            }

            public void editStopped(KDTEditEvent event) {
                InitBalanceMatDetaiUI.this.fillCellAfterBillSelectedRelation(event);
            }

            public void editValueChanged(KDTEditEvent eventObj) {
            }
        });
        this.kDTable1.getColumn("materialid").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtRelation));
        KDFormattedTextField txtQty = new KDFormattedTextField();
        txtQty.setDataType(1);
        txtQty.setPrecision(4);
        txtQty.setNegatived(true);
        txtQty.setHorizontalAlignment(4);
        this.kDTable1.getColumn("Qty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtQty));
        KDFormattedTextField txtPrice = new KDFormattedTextField();
        txtPrice.setDataType(1);
        txtPrice.setPrecision(2);
        txtPrice.setNegatived(false);
        txtPrice.setHorizontalAlignment(4);
        this.kDTable1.getColumn("Price").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPrice));
        this.kDTable1.getColumn("Price").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtAmount = new KDFormattedTextField();
        txtAmount.setDataType(1);
        txtAmount.setPrecision(this.amoountPrecision);
        txtAmount.setNegatived(true);
        txtAmount.setHorizontalAlignment(4);
        this.kDTable1.getColumn("amount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAmount));
        this.kDTable1.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTable1.getColumn("amount").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)this.amoountPrecision));
        KDFormattedTextField txtYTDInputMatQty = new KDFormattedTextField();
        txtYTDInputMatQty.setDataType(1);
        txtYTDInputMatQty.setPrecision(4);
        txtYTDInputMatQty.setNegatived(true);
        txtYTDInputMatQty.setHorizontalAlignment(4);
        this.kDTable1.getColumn("YTDInputMatQty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtYTDInputMatQty));
        KDFormattedTextField txtYTDInputMatAmou = new KDFormattedTextField();
        txtYTDInputMatAmou.setDataType(1);
        txtYTDInputMatAmou.setPrecision(2);
        txtYTDInputMatAmou.setNegatived(true);
        txtYTDInputMatAmou.setHorizontalAlignment(4);
        this.kDTable1.getColumn("YTDInputMatAmou").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtYTDInputMatAmou));
        this.kDTable1.getColumn("YTDInputMatAmou").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtYTDFinishedMatQ = new KDFormattedTextField();
        txtYTDFinishedMatQ.setDataType(1);
        txtYTDFinishedMatQ.setPrecision(4);
        txtYTDFinishedMatQ.setNegatived(true);
        txtYTDFinishedMatQ.setHorizontalAlignment(4);
        this.kDTable1.getColumn("YTDFinishedMatQ").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtYTDFinishedMatQ));
        KDFormattedTextField txtYTDFinishedMatA = new KDFormattedTextField();
        txtYTDFinishedMatA.setDataType(1);
        txtYTDFinishedMatA.setPrecision(2);
        txtYTDFinishedMatA.setNegatived(true);
        txtYTDFinishedMatA.setHorizontalAlignment(4);
        this.kDTable1.getColumn("YTDFinishedMatA").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtYTDFinishedMatA));
        this.kDTable1.getColumn("YTDFinishedMatA").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTable1.getColumn("assistUnit").getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn("baseUnit").getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn("Qty").getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn("addQty").getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn("assistQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTable1.getColumn("Qty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTable1.getColumn("addQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kDTable1.getColumn("assistQty").getStyleAttributes().setLocked(true);
        int rowCount = this.kDTable1.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object unit = this.kDTable1.getRow(i).getCell("unit").getValue();
            if (unit != null) {
                this.kDTable1.getColumn("addQty").getStyleAttributes().setLocked(false);
                continue;
            }
            this.kDTable1.getColumn("addQty").getStyleAttributes().setLocked(true);
        }
        this.initBaseUnitF7();
    }

    public static void showMatDetaiUI(CoreUIObject ui, CoreBaseInfo info, String entryID, String CostItemName, String model, String operType) throws Exception {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"INFO", (Object)info);
            uiContext.put((Object)"parent", (Object)entryID);
            uiContext.put((Object)"costitemName", (Object)CostItemName);
            uiContext.put((Object)"model", (Object)model);
            uiContext.put((Object)"operState", (Object)operType);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InitBalanceMatDetaiUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    protected IObjectCollection createNewCollection() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InitBalanceMatDetailFactory.getRemoteInstance();
    }

    protected FilterInfo getCostObjectFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID));
        return filter;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        InitBalanceMatDetailCollection coll = null;
        if (this.kDTable1.getRowCount() > 0) {
            coll = this.storeFieldofDetail();
            InitBalanceMatDetailFactory.getRemoteInstance().addnewColl(coll, (String)this.getUIContext().get("parent"));
        } else {
            String oql = "SELECT id,parent.id WHERE parent.id = '" + (String)this.getUIContext().get("parent") + "'";
            InitBalanceMatDetailFactory.getRemoteInstance().delete(oql);
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"73_InitBalanceMatDetaiAdjustUI"));
    }

    public InitBalanceMatDetailCollection storeFieldofDetail() throws Exception {
        InitBalanceEntryInfo entryInfo = InitBalanceEntryFactory.getRemoteInstance().getInitBalanceEntryInfo((IObjectPK)new ObjectUuidPK((String)this.getUIContext().get("parent")));
        this.kDTable1.getEditManager().stopEditing();
        int rowCount = this.kDTable1.getRowCount();
        InitBalanceMatDetailCollection Col = null;
        HashMap<String, String> infoMap = new HashMap<String, String>();
        if (rowCount > 0) {
            Col = new InitBalanceMatDetailCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.kDTable1.getRow(i);
                String matADDbatchNo = null;
                if (row.getCell("materialid").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"22_BoPInvSFPCostMatDetailUI"));
                    SysUtil.abort();
                } else {
                    if (row.getCell("materialid").getValue() instanceof MaterialInfo) {
                        MaterialInfo mat = (MaterialInfo)row.getCell("materialid").getValue();
                        matADDbatchNo = mat.getId().toString();
                    } else {
                        matADDbatchNo = row.getCell("materialid").getValue().toString();
                    }
                    matADDbatchNo = matADDbatchNo + (row.getCell("batchNo").getValue() == null ? "" : row.getCell("batchNo").getValue().toString());
                    if (infoMap.containsKey(matADDbatchNo)) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"23_BoPInvSFPCostMatDetailUI"));
                        SysUtil.abort();
                    }
                }
                if (row.getCell("unit").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"83_InitBalanceMatDetaiUI"));
                    SysUtil.abort();
                }
                if (row.getCell("addQty").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"75_InitBalanceMatDetaiAdjustUI"));
                    SysUtil.abort();
                }
                BigDecimal addQty = NCMUtils.getBigDecimal((Object)row.getCell("addQty").getValue());
                if (row.getCell("Price").getValue() == null || ((BigDecimal)row.getCell("Price").getValue()).compareTo(SysConstant.BIGZERO) < 0) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"25_BoPInvSFPCostMatDetailUI"));
                    SysUtil.abort();
                }
                if (row.getCell("YTDInputMatQty").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"84_InitBalanceMatDetaiUI"));
                    SysUtil.abort();
                }
                if (row.getCell("YTDInputMatAmou").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"85_InitBalanceMatDetaiUI"));
                    SysUtil.abort();
                }
                if (row.getCell("YTDFinishedMatQ").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"86_InitBalanceMatDetaiUI"));
                    SysUtil.abort();
                }
                if (row.getCell("YTDFinishedMatA").getValue() == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"87_InitBalanceMatDetaiUI"));
                    SysUtil.abort();
                }
                if (addQty.add((BigDecimal)row.getCell("Price").getValue()).add((BigDecimal)row.getCell("Qty").getValue()).add((BigDecimal)row.getCell("YTDInputMatQty").getValue()).add((BigDecimal)row.getCell("YTDFinishedMatQ").getValue()).add((BigDecimal)row.getCell("YTDInputMatAmou").getValue()).add((BigDecimal)row.getCell("YTDFinishedMatA").getValue()).compareTo(SysConstant.BIGZERO) == 0) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"26_BoPInvSFPCostMatDetailUI"));
                    SysUtil.abort();
                }
                InitBalanceMatDetailInfo Info = new InitBalanceMatDetailInfo();
                Info.setAmount(NCMUtils.getBigDecimal((Object)row.getCell("amount").getValue()));
                if (row.getCell("batchNo").getValue() != null) {
                    Info.setBatchNo(row.getCell("batchNo").getValue().toString());
                }
                Info.setMaterial((MaterialInfo)row.getCell("materialid").getValue());
                Info.setQty(NCMUtils.getBigDecimal((Object)row.getCell("Qty").getValue()));
                Info.setPrice(NCMUtils.getBigDecimal((Object)row.getCell("Price").getValue()));
                Info.setUnit((MeasureUnitInfo)row.getCell("unit").getValue());
                Info.setAddqty(NCMUtils.getBigDecimal((Object)row.getCell("addQty").getValue()));
                Info.setAssistQty(NCMUtils.getBigDecimal((Object)row.getCell("assistQty").getValue()));
                Info.setYTDFinishedMatA(NCMUtils.getBigDecimal((Object)row.getCell("YTDFinishedMatA").getValue()));
                Info.setYTDFinishedMatQ(NCMUtils.getBigDecimal((Object)row.getCell("YTDFinishedMatQ").getValue()));
                Info.setYTDInputMatAmou(NCMUtils.getBigDecimal((Object)row.getCell("YTDInputMatAmou").getValue()));
                Info.setYTDInputMatQty(NCMUtils.getBigDecimal((Object)row.getCell("YTDInputMatQty").getValue()));
                Info.setParent(entryInfo);
                Col.add(Info);
                infoMap.put(matADDbatchNo, matADDbatchNo);
            }
        }
        return Col;
    }

    @Override
    protected void btnAddline_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddline_actionPerformed(e);
        this.addLine(this.kDTable1);
    }

    protected void addLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        IRow row = table.addRow();
        row.getCell("Qty").setValue((Object)SysConstant.BIGZERO);
        row.getCell("Price").setValue((Object)SysConstant.BIGZERO);
        row.getCell("amount").setValue((Object)SysConstant.BIGZERO);
        row.getCell("addQty").setValue((Object)SysConstant.BIGZERO);
        row.getCell("assistQty").setValue((Object)SysConstant.BIGZERO);
        row.getCell("YTDFinishedMatA").setValue((Object)SysConstant.BIGZERO);
        row.getCell("YTDFinishedMatQ").setValue((Object)SysConstant.BIGZERO);
        row.getCell("YTDInputMatAmou").setValue((Object)SysConstant.BIGZERO);
        row.getCell("YTDInputMatQty").setValue((Object)SysConstant.BIGZERO);
    }

    @Override
    protected void btnRemoveline_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveline_actionPerformed(e);
        int index = this.kDTable1.getSelectManager().getActiveRowIndex();
        if (index < 0 || index >= this.kDTable1.getRowCount()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"27_BoPInvSFPCostMatDetailUI"));
            return;
        }
        this.kDTable1.removeRow(index);
    }

    @Override
    protected void kDTable1_editStopped(KDTEditEvent e) throws Exception {
        super.kDTable1_editStopped(e);
        IRow row = this.kDTable1.getRow(e.getRowIndex());
        Object material = row.getCell("materialid").getValue();
        Object unit = row.getCell("unit").getValue();
        if (unit != null) {
            row.getCell("addQty").getStyleAttributes().setLocked(false);
            MeasureUnitInfo unitInfo = (MeasureUnitInfo)unit;
            if (row.getCell("addQty").getValue() != null && material != null) {
                BigDecimal addQty = new BigDecimal(row.getCell("addQty").getValue().toString());
                MaterialInfo info = (MaterialInfo)material;
                IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), unitInfo.getId().toString());
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("addQty"), (int)multiUnifInfo.getQtyPrecision(), (boolean)true);
                MeasureUnitInfo baseUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(info.getBaseUnit().getId()));
                BigDecimal Qty = this.getBaseUnitQtyFromData(baseUnitInfo, unitInfo, info, addQty);
                row.getCell("Qty").setValue((Object)Qty);
                if (info.getAssistUnit() != null) {
                    MeasureUnitInfo assistUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(info.getAssistUnit().getId()));
                    BigDecimal assistQty = this.getBaseUnitQtyFromData(assistUnitInfo, unitInfo, info, addQty);
                    row.getCell("assistQty").setValue((Object)assistQty);
                } else {
                    row.getCell("assistQty").setValue((Object)SysConstant.BIGZERO);
                }
            } else {
                row.getCell("Qty").setValue((Object)SysConstant.BIGZERO);
            }
        }
        if (row.getCell("Qty").getValue() != null && row.getCell("Price").getValue() != null && row.getCell("amount").getValue() != null) {
            BigDecimal amount;
            int col = e.getColIndex();
            if (col == 5 || col == 6) {
                amount = ((BigDecimal)row.getCell("Qty").getValue()).multiply((BigDecimal)row.getCell("Price").getValue());
                amount = amount.setScale(this.amoountPrecision, 2);
                row.getCell("amount").setValue((Object)amount);
            } else if (col == 12) {
                if (((BigDecimal)row.getCell("Qty").getValue()).compareTo(SysConstant.BIGZERO) != 0) {
                    row.getCell("Price").setValue((Object)((BigDecimal)row.getCell("amount").getValue()).divide((BigDecimal)row.getCell("Qty").getValue(), 2));
                }
            } else if (col == 11) {
                if (((BigDecimal)row.getCell("Qty").getValue()).compareTo(SysConstant.BIGZERO) != 0) {
                    row.getCell("amount").setValue((Object)((BigDecimal)row.getCell("Price").getValue()).multiply((BigDecimal)row.getCell("Qty").getValue()));
                }
                return;
            }
            if (row.getCell("Qty").getValue() != null && row.getCell("Price").getValue() != null) {
                amount = ((BigDecimal)row.getCell("Qty").getValue()).multiply((BigDecimal)row.getCell("Price").getValue());
                amount = amount.setScale(this.amoountPrecision, 2);
                row.getCell("amount").setValue((Object)amount);
                return;
            }
            if (row.getCell("amount").getValue() != null && row.getCell("Price").getValue() != null) {
                if (((BigDecimal)row.getCell("Price").getValue()).compareTo(SysConstant.BIGZERO) != 0) {
                    row.getCell("Qty").setValue((Object)((BigDecimal)row.getCell("amount").getValue()).divide((BigDecimal)row.getCell("Price").getValue(), 2));
                }
                return;
            }
            if (row.getCell("amount").getValue() != null && row.getCell("Qty").getValue() != null) {
                if (((BigDecimal)row.getCell("Qty").getValue()).compareTo(SysConstant.BIGZERO) != 0) {
                    row.getCell("Price").setValue((Object)((BigDecimal)row.getCell("amount").getValue()).divide((BigDecimal)row.getCell("Qty").getValue(), 2));
                }
                return;
            }
        }
    }

    protected void fillCellAfterBillSelectedRelation(DataChangeEvent eventObj) {
        int rowIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        IRow curRow = this.kDTable1.getRow(rowIndex);
        InitBalanceMatDetaiUI.clearCells(this.kDTable1, rowIndex, new String[]{"materialname", "model", "baseUnit", "Qty", "assistQty", "assistUnit", "unit", "addQty"});
        if (eventObj.getNewValue() instanceof MaterialInfo) {
            try {
                MaterialInfo info = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)eventObj.getNewValue()).getId().toString()));
                if (info != null) {
                    curRow.getCell("materialname").setValue((Object)info.getName());
                    if (info.getBaseUnit() != null) {
                        String baseUnitId = info.getBaseUnit().getId().toString();
                        MeasureUnitInfo measureUnitInfo = this.measureUnitInstance.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(baseUnitId));
                        curRow.getCell("baseUnit").setValue((Object)measureUnitInfo.getName());
                        curRow.getCell("unit").setValue((Object)measureUnitInfo);
                        int qtyPrecision = this.multiMeasureUnitInstance.getQtyPrecision(info.getId().toString(), baseUnitId);
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("Qty"), (int)qtyPrecision, (boolean)true);
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("YTDInputMatQty"), (int)qtyPrecision, (boolean)true);
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("YTDFinishedMatQ"), (int)qtyPrecision, (boolean)true);
                    }
                    if (info.getAssistUnit() != null) {
                        MeasureUnitInfo assistUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(info.getAssistUnit().getId()));
                        int assistPrecision = info.getAssistUnit().getQtyPrecision();
                        curRow.getCell("assistUnit").setValue((Object)assistUnitInfo);
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("assistQty"), (int)assistPrecision, (boolean)true);
                    } else {
                        curRow.getCell("assistQty").setValue((Object)SysConstant.BIGZERO);
                    }
                    curRow.getCell("model").setValue((Object)info.getModel());
                    String osql = "SELECT mateial.id, company.id, accountType WHERE mateial.id = '" + info.getId().toString() + "' AND company.id = '" + this.companyID + "'";
                    MaterialCompanyInfoInfo comInfo = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoInfo(osql);
                    if (!comInfo.getAccountType().equals((Object)AccountType.SPECIAL_ACCT)) {
                        InitBalanceMatDetaiUI.clearCells(this.kDTable1, rowIndex, new String[]{"batchNo"});
                        curRow.getCell("batchNo").getStyleAttributes().setLocked(true);
                    } else {
                        curRow.getCell("batchNo").getStyleAttributes().setLocked(false);
                    }
                    curRow.getCell("addQty").setValue((Object)SysConstant.BIGZERO);
                    curRow.getCell("Qty").setValue((Object)SysConstant.BIGZERO);
                    curRow.getCell("assistQty").setValue((Object)SysConstant.BIGZERO);
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("Price"), (int)info.getPricePrecision(), (boolean)false);
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("amount"), (int)this.amoountPrecision, (boolean)true);
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("YTDInputMatAmou"), (int)this.amoountPrecision, (boolean)true);
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("YTDFinishedMatA"), (int)this.amoountPrecision, (boolean)true);
                }
            }
            catch (EASBizException e1) {
                logger.error((Object)"", (Throwable)e1);
            }
            catch (BOSException e1) {
                logger.error((Object)"", (Throwable)e1);
            }
        }
    }

    protected void fillCellAfterBillSelectedRelation(KDTEditEvent event) {
        int rowIndex = event.getRowIndex();
        int colIndex = event.getColIndex();
        Object temp = this.kDTable1.getCell(rowIndex, colIndex).getValue();
        if (this.cellOldValue != null && temp != null && this.cellOldValue instanceof MaterialInfo && temp instanceof MaterialInfo && ((MaterialInfo)this.cellOldValue).getId().toString().equals(((MaterialInfo)temp).getId().toString())) {
            return;
        }
        if (colIndex == this.kDTable1.getColumnIndex("materialid")) {
            IRow curRow = this.kDTable1.getRow(rowIndex);
            InitBalanceMatDetaiUI.clearCells(this.kDTable1, rowIndex, new String[]{"materialname", "model", "baseUnit", "Qty", "assistQty", "assistUnit", "unit", "addQty"});
            if (temp != null && temp instanceof MaterialInfo) {
                try {
                    MaterialInfo info = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)temp).getId().toString()));
                    if (info != null) {
                        curRow.getCell("materialname").setValue((Object)info.getName());
                        if (info.getBaseUnit() != null) {
                            String baseUnitId = info.getBaseUnit().getId().toString();
                            MeasureUnitInfo measureUnitInfo = this.measureUnitInstance.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(baseUnitId));
                            curRow.getCell("baseUnit").setValue((Object)measureUnitInfo.getName());
                            curRow.getCell("unit").setValue((Object)measureUnitInfo);
                            int qtyPrecision = this.multiMeasureUnitInstance.getQtyPrecision(info.getId().toString(), baseUnitId);
                            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("Qty"), (int)qtyPrecision, (boolean)true);
                            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("YTDInputMatQty"), (int)qtyPrecision, (boolean)true);
                            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("YTDFinishedMatQ"), (int)qtyPrecision, (boolean)true);
                        }
                        if (info.getAssistUnit() != null) {
                            MeasureUnitInfo assistUnitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(info.getAssistUnit().getId()));
                            int assistPrecision = info.getAssistUnit().getQtyPrecision();
                            curRow.getCell("assistUnit").setValue((Object)assistUnitInfo);
                            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("assistQty"), (int)assistPrecision, (boolean)true);
                        } else {
                            curRow.getCell("assistQty").setValue((Object)SysConstant.BIGZERO);
                        }
                        curRow.getCell("model").setValue((Object)info.getModel());
                        String osql = "SELECT mateial.id, company.id, accountType WHERE mateial.id = '" + info.getId().toString() + "' AND company.id = '" + this.companyID + "'";
                        MaterialCompanyInfoInfo comInfo = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoInfo(osql);
                        if (!comInfo.getAccountType().equals((Object)AccountType.SPECIAL_ACCT)) {
                            InitBalanceMatDetaiUI.clearCells(this.kDTable1, rowIndex, new String[]{"batchNo"});
                            curRow.getCell("batchNo").getStyleAttributes().setLocked(true);
                        } else {
                            curRow.getCell("batchNo").getStyleAttributes().setLocked(false);
                        }
                        curRow.getCell("addQty").setValue((Object)SysConstant.BIGZERO);
                        curRow.getCell("Qty").setValue((Object)SysConstant.BIGZERO);
                        curRow.getCell("assistQty").setValue((Object)SysConstant.BIGZERO);
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("Price"), (int)info.getPricePrecision(), (boolean)false);
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("amount"), (int)this.amoountPrecision, (boolean)true);
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("YTDInputMatAmou"), (int)this.amoountPrecision, (boolean)true);
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("YTDFinishedMatA"), (int)this.amoountPrecision, (boolean)true);
                    }
                }
                catch (EASBizException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        }
    }

    private void initBaseUnitF7() {
        this.bizBaseUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        this.bizBaseUnitBox.setEditFormat("$name$");
        this.bizBaseUnitBox.setDisplayFormat("$number$");
        this.bizBaseUnitBox.setCommitFormat("$number$");
        this.bizBaseUnitBox.setEditable(true);
        this.bizBaseUnitBox.setRequired(true);
        this.bizBaseUnitBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    InitBalanceMatDetaiUI.this.bizBaseUnitBox_willShow(e);
                }
                catch (Exception exc) {
                    InitBalanceMatDetaiUI.this.handUIException(exc);
                }
            }
        });
        this.kDTable1.getColumn("unit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.bizBaseUnitBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kDTable1.getColumn("unit").setRenderer((IBasicRender)avr);
    }

    private void bizBaseUnitBox_willShow(SelectorEvent e) throws EASBizException, BOSException {
        int rowIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        int colIndex = this.kDTable1.getSelectManager().getActiveColumnIndex();
        IRow row = this.kDTable1.getRow(rowIndex);
        String fieldName = this.kDTable1.getColumnKey(colIndex);
        Object material = row.getCell("materialid").getValue();
        if ("unit".equalsIgnoreCase(fieldName) && material != null) {
            MaterialInfo info = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(((MaterialInfo)material).getId().toString()));
            this.filterDirectBaseUnitF7(this.bizBaseUnitBox, info);
        } else {
            this.filterDirectBaseUnitF7(this.bizBaseUnitBox, null);
        }
    }

    public void filterDirectBaseUnitF7(KDBizPromptBox f7, MaterialInfo info) {
        if (info != null) {
            this.setF7MeasureUnit(f7, info.getId().toString());
        } else {
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"id", (Object)"0");
        }
    }

    public void setF7MeasureUnit(KDBizPromptBox bizBox, String matid) {
        if (matid != null) {
            this.bizBaseUnitBox.getQueryAgent().resetRuntimeEntityView();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)matid, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            bizBox.setEntityViewInfo(viewInfo);
        }
    }

    public static void clearCells(KDTable kdt, int rowIndex, String[] colNames) {
        IRow row = kdt.getRow(rowIndex);
        if (colNames != null) {
            int n = colNames.length;
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(colNames[i]);
                cell.setValue(null);
            }
        } else {
            int n = kdt.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(i);
                cell.setValue(null);
            }
        }
    }

    public BigDecimal getBaseUnitQtyFromData(MeasureUnitInfo baseUnitInfo, MeasureUnitInfo unitInfo, MaterialInfo materialInfo, BigDecimal orderQty) throws EASBizException, BOSException {
        if (orderQty == null || baseUnitInfo == null || unitInfo == null || materialInfo == null) {
            return null;
        }
        BigDecimal baseUnitQty = this.getExchangeQtyForClient(materialInfo.getId().toString(), unitInfo, baseUnitInfo, orderQty);
        return baseUnitQty;
    }

    public BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = InitBalanceMatDetaiUI.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = InitBalanceMatDetaiUI.effectualNumeric(baseQty).divide(InitBalanceMatDetaiUI.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    public BigDecimal getExchangeQty(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo baseUnitInfo, BigDecimal qty, Context ctx) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, baseUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            BigDecimal baseQty = InitBalanceMatDetaiUI.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = InitBalanceMatDetaiUI.effectualNumeric(baseQty).divide(InitBalanceMatDetaiUI.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return InitBalanceMatDetaiUI.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return InitBalanceMatDetaiUI.isDistrustExchangeRate(exchangeRate) ? exchangeRate : new BigDecimal("1.0");
    }

    public static boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }
}

