/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.InnerOverheadBillFactory;
import com.kingdee.eas.ncm.bill.client.AbstractInnerOverheadAllocListUI;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.bill.client.InnerOverheadAllocFilterUI;
import com.kingdee.eas.ncm.bill.client.OtherAllocLogReportUI;
import com.kingdee.eas.ncm.bill.utils.CostAllocUtils;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class InnerOverheadAllocListUI
extends AbstractInnerOverheadAllocListUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerOverheadAllocListUI.class);
    private InnerOverheadAllocFilterUI filterUI;

    public InnerOverheadAllocListUI() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"88_InnerOverheadAllocListUI"));
        this.btnManuAlloc.setVisible(false);
        this.menuItemManuAlloc.setVisible(false);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuItemViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("logTblName", "T_NCM_LOG_Other");
        param.put("UITitle", EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"5_AutoAuxAllocatorBuilder"));
        this.setLogInfo("actionViewLog", "OtherAlloc_Error");
        OtherAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    @Override
    public void initFormatTable() throws Exception {
        super.initFormatTable();
        this.tblMain.getColumn("costItem.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("costItem.name").getStyleAttributes().setHided(true);
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.tblMain.getColumn("costItem.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("costItem.name").getStyleAttributes().setHided(true);
        this.setAuxCostObject();
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.ncm.bill.client.InnerOverheadAllocEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return InnerOverheadBillFactory.getRemoteInstance();
    }

    @Override
    public void actionAutoAlloc_actionPerformed(ActionEvent e) throws Exception {
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(this._company, this._period)) {
            return;
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("company", this._company);
        source.put("period", this._period);
        source.put("user", SysContext.getSysContext().getCurrentUserInfo());
        source.put("filterInfo", this._currFilterInfo);
        source.put("bFilter_all", String.valueOf(this.bFilter_all));
        Map param = CostAllocUtils.buildAuxFeeAllocParam(source);
        CostTaskClientUtils.execute((Map)param, (CoreUIObject)this, (boolean)false);
        this.setLogInfo("actionAutoAlloc", "OtherAlloc_Auto");
        this.refreshList();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("name").setWidth(100);
        this.tblMain.getColumn("name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("number").setWidth(80);
        this.tblMain.getColumn("billStatus").setWidth(58);
        this.tblMain.getColumn("isBooked").setWidth(58);
        this.tblMain.getColumn("bizDate").setWidth(78);
        this.tblMain.getColumn("period").setWidth(78);
        this.tblMain.getColumn("costCenter.number").setWidth(120);
        this.tblMain.getColumn("costCenter.name").setWidth(120);
        this.tblMain.getColumn("entrys.seq").setWidth(68);
        this.tblMain.getColumn("entrys.auxNumber").setWidth(120);
        this.tblMain.getColumn("entrys.auxName").setWidth(120);
        this.tblMain.getColumn("entrys.costCenterNumber").setWidth(120);
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.setAuxCostObject();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setAuxCostObject();
    }

    public void setAuxCostObject() throws EASBizException, BOSException {
        int rowIndex = this.tblMain.getRowCount();
        Object costObjectID = null;
        for (int i = 0; i < rowIndex; ++i) {
            AUXOverheadInfo auxInfo;
            CostObjectInfo info;
            costObjectID = this.tblMain.getRow(i).getCell("entrys.costObjectID").getValue();
            if (costObjectID == null || (info = CostObjectFactory.getRemoteInstance().getCostObjectInfo((IObjectPK)new ObjectUuidPK(costObjectID.toString()))) == null || !info.getRelatedType().equals((Object)CORelatedType.Overhead) || info.getRelatedId() == null || (auxInfo = AUXOverheadFactory.getRemoteInstance().getAUXOverheadInfo((IObjectPK)new ObjectUuidPK(info.getRelatedId().toString()))) == null) continue;
            this.tblMain.getRow(i).getCell("materialNumber").setValue((Object)auxInfo.getNumber());
            this.tblMain.getRow(i).getCell("materialName").setValue((Object)auxInfo.getName());
        }
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        String oprationName = AllocSourceBillEnum.InnerOverheadBill.getName() + "Alloc_View";
        NCMUtils.addEASLogForAlloc(null, (String)"actionViewAlloc_actionPerformed", (String)(this._company.getNumber() + ' ' + this._company.getName()), (String)oprationName, (String)this._company.getId().toString(), (boolean)true);
        this.showAllocEditUI("VIEW");
    }

    @Override
    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InnerOverheadAllocListUI.this.showAllocEditUI("VIEW");
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "bizDate", "isBooked", "period", "costCenter.number", "costCenter.name"};
    }

    @Override
    public String getCol_ID() {
        return "id";
    }

    @Override
    public String getCol_EntryID() {
        return "entrys.id";
    }

    @Override
    public String getQtyCol() {
        return "entrys.qty";
    }

    @Override
    public String getPriceCol() {
        return "entrys.actualPrice";
    }

    @Override
    public String getAmtCol() {
        return "entrys.actualAmount";
    }

    @Override
    public String getQtyColPricisionInQuery() {
        return "auxOverhead.qtyPrecision";
    }

    @Override
    public String getPriceColPricisionInQuery() {
        return "AuxFIinfo.pricePrecision";
    }

    @Override
    public String getAmtColPricisionInQuery() {
        return "baseCurrency.precision";
    }

    @Override
    protected String getResultTblName() throws BOSException {
        String tblResult = NCMCommonFacadeFactory.getRemoteInstance().getPhysicalTblName(this._company.getId().toString(), "T_NCM_AuxAllocResult");
        return tblResult;
    }

    @Override
    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        if (this._currFilterInfo != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("AuxFIinfo.companyOrgUnit.id", (Object)this._company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("FeeCO.company.id", (Object)this._company.getId().toString()));
            try {
                this._currFilterInfo.mergeFilter(filter, "and");
                ev.setFilter((FilterInfo)this._currFilterInfo.clone());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0, EntityViewInfo arg1) {
        IQueryExecutor qe = super.getQueryExecutor(arg0, arg1);
        return qe;
    }

    @Override
    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new InnerOverheadAllocFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }
}

