/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.KDTableUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.InnerOverheadBillEntryInfo;
import com.kingdee.eas.ncm.bill.InnerOverheadBillFactory;
import com.kingdee.eas.ncm.bill.InnerOverheadBillInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.OverheadBizTypeEnum;
import com.kingdee.eas.ncm.bill.client.AbstractInnerOverheadBillEditUI;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;
import com.kingdee.eas.ncm.common.utils.CostObjectUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class InnerOverheadBillEditUI
extends AbstractInnerOverheadBillEditUI {
    private static final long serialVersionUID = 6153229416480219192L;
    private static final String col_entry_auxNumber = "entrys.auxNumber";
    private static final String col_entry_auxName = "entrys.auxName";
    private static final String col_entry_costCenterNumber = "entrys.costCenterNumber";
    private static final String col_entry_costCenterName = "entrys.costCenterName";
    private static final String col_entry_costObjectNumber = "entrys.costObjectNumber";
    private static final String col_entry_costObjectName = "entrys.costObjectName";
    private static final String col_entry_manufactureOrder = "entrys.manufactureOrder";
    private static final String col_entry_materialNumber = "entrys.materialNumber";
    private static final String col_entry_materialName = "entrys.materialName";
    private static final String col_entry_projectNumber = "entrys.projectNumber";
    private static final String col_entry_trackNumber = "entrys.trackNumber";
    private static final String col_entry_bathcNumber = "entrys.batchNumber";
    private static final String col_entry_qty = "entrys.qty";
    private static final String col_entry_unit = "entrys.unit";
    private static final String col_entry_actualPrice = "entrys.actualPrice";
    private static final String col_entry_actualAmount = "entrys.actualAmount";
    private static final String col_entry_stdPrice = "entrys.stdPrice";
    private static final String col_entry_stdAmount = "entrys.stdAmount";
    private KDBizPromptBox prmtBox_AuxOverheadColumn = null;
    private KDBizPromptBox prmtBox_costCenterColumn = null;
    private KDBizPromptBox prmtBox_costObjectColumn = null;
    private KDBizPromptBox prmtBox_measureUnitColumn = null;
    private KDBizPromptBox prmtBox_ManufactureOrderColumn = null;
    private KDBizPromptBox prmtBox_MaterialColumn = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEntries.setColumnMoveable(true);
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        if ("VIEW".equals(this.getOprtState())) {
            this.costCenterBizPromptBox.setEnabled(false);
            this.costCenterBizPromptBox.setEditable(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InnerOverheadBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        InnerOverheadBillInfo billInfo = new InnerOverheadBillInfo();
        billInfo.setCompanyOrg(this.getCompanyOrgInfoWithDefault());
        Date today = new Date();
        PeriodInfo period = null;
        try {
            period = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        billInfo.setCalculatePeriod(period);
        billInfo.setBizDate(today);
        billInfo.setBillStatus(BillBaseStatusEnum.ADD);
        billInfo.setBizType(OverheadBizTypeEnum.aux);
        billInfo.setIsBooked(false);
        return billInfo;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        InnerOverheadBillEntryInfo entryInfo = new InnerOverheadBillEntryInfo();
        return entryInfo;
    }

    private void init() throws Exception {
        this.initCostCenterBox();
        this.initAuxOverheadColumn();
        this.initCostCenterColumn();
        this.initCostObjectColumn();
        this.initManufactureOrderColumn();
        this.initMaterialColumn();
        this.initMeasureUnitColumn();
        this.setBigDecimalColumnEditor(col_entry_qty);
        this.setBigDecimalColumnEditor(col_entry_actualPrice);
        this.setBigDecimalColumnEditor(col_entry_actualAmount);
        this.setBigDecimalColumnEditor(col_entry_stdPrice);
        this.setBigDecimalColumnEditor(col_entry_stdAmount);
        int size = this.table.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (!(this.table.getCell(i, col_entry_auxNumber).getValue() instanceof AUXOverheadInfo)) continue;
            AUXOverheadInfo auxOverheadInfo = (AUXOverheadInfo)this.table.getCell(i, col_entry_auxNumber).getValue();
            this.setPrecisionByAuxOverheadInfo(auxOverheadInfo, i, false);
            NCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.table, (String[])new String[]{col_entry_actualAmount}, (int)i);
            NCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.table, (String[])new String[]{col_entry_stdAmount}, (int)i);
        }
        this.bizDateDatePicker.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Date date = (Date)eventObj.getNewValue();
                if (eventObj.getNewValue() instanceof Date) {
                    InnerOverheadBillEditUI.this.periodBizPromptBox.setValue((Object)InnerOverheadBillEditUI.this.getPeriodByBizDate(date, InnerOverheadBillEditUI.this.getCompanyOrgInfoWithDefault()));
                }
            }
        });
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    int rowIndex = InnerOverheadBillEditUI.this.table.getSelectManager().getActiveRowIndex();
                    int colIndex = InnerOverheadBillEditUI.this.table.getSelectManager().getActiveColumnIndex();
                    if (rowIndex < 0) {
                        return;
                    }
                    if (colIndex == InnerOverheadBillEditUI.this.table.getColumnIndex(InnerOverheadBillEditUI.col_entry_costObjectNumber)) {
                        InnerOverheadBillEditUI.this.filterCostObjectF7();
                    } else if (colIndex == InnerOverheadBillEditUI.this.table.getColumnIndex(InnerOverheadBillEditUI.col_entry_auxNumber)) {
                        InnerOverheadBillEditUI.this.filterAuxOverheadF7();
                    } else if (colIndex == InnerOverheadBillEditUI.this.table.getColumnIndex(InnerOverheadBillEditUI.col_entry_costCenterNumber)) {
                        InnerOverheadBillEditUI.this.filterCostCenterF7(InnerOverheadBillEditUI.this.prmtBox_costCenterColumn, null);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Throwable)exc);
                }
            }
        });
    }

    private void initCostCenterBox() throws Exception {
        this.filterCostCenterF7(this.costCenterBizPromptBox, new CostCenterType[]{CostCenterType.AssistantProdDept});
        this.costCenterBizPromptBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                int flag;
                if (InnerOverheadBillEditUI.this.costCenterBizPromptBox.getValue() != null && ((flag = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"89_InnerOverheadBillEditUI"))) == 1 || flag == 2)) {
                    SysUtil.abort();
                }
            }
        });
        this.costCenterBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                if (event.getNewValue() == null) {
                    InnerOverheadBillEditUI.this.table.removeRows();
                } else if (event.getNewValue() instanceof CostCenterOrgUnitInfo && event.getOldValue() instanceof CostCenterOrgUnitInfo && !((CostCenterOrgUnitInfo)event.getNewValue()).getId().equals((Object)((CostCenterOrgUnitInfo)event.getOldValue()).getId())) {
                    InnerOverheadBillEditUI.this.table.removeRows();
                }
            }
        });
    }

    private void initAuxOverheadColumn() throws Exception {
        this.prmtBox_AuxOverheadColumn = this.createNewKDBizPromptBox("com.kingdee.eas.basedata.ncm.app.AUXOverheadQuery", "$number$", "$number$", "$number$", true, true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("qtyPrecision"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        this.prmtBox_AuxOverheadColumn.setSelectorCollection(sic);
        this.setRender(col_entry_auxNumber, "$number$");
        this.prmtBox_AuxOverheadColumn.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                InnerOverheadBillEditUI.this.onAuxOverheadChange(event);
            }
        });
        this.table.getColumn(col_entry_auxNumber).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBox_AuxOverheadColumn));
    }

    private void initCostCenterColumn() throws Exception {
        this.prmtBox_costCenterColumn = this.createNewKDBizPromptBox("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery", "$number$", "$number$", "$number$", true, true);
        this.setRender(col_entry_costCenterNumber, "$number$");
        this.prmtBox_costCenterColumn.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                CostCenterOrgUnitInfo costCenter;
                int rowIndex = InnerOverheadBillEditUI.this.table.getSelectManager().getActiveRowIndex();
                IRow curRow = InnerOverheadBillEditUI.this.table.getRow(rowIndex);
                KDTableUtil.clearCells((KDTable)InnerOverheadBillEditUI.this.table, (int)rowIndex, (String[])new String[]{InnerOverheadBillEditUI.col_entry_costCenterName});
                if (event.getNewValue() instanceof CostCenterOrgUnitInfo && (costCenter = (CostCenterOrgUnitInfo)event.getNewValue()) != null) {
                    curRow.getCell(InnerOverheadBillEditUI.col_entry_costCenterName).setValue((Object)costCenter.getName());
                    if (!CostCenterType.AssistantProdDept.equals((Object)costCenter.getCostCenterType()) && !CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType())) {
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_costObjectNumber).setValue(null);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_costObjectName).setValue(null);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_manufactureOrder).setValue(null);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_materialNumber).setValue(null);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_materialName).setValue(null);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_projectNumber).setValue(null);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_trackNumber).setValue(null);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_bathcNumber).setValue(null);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_costObjectNumber).getStyleAttributes().setLocked(true);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_manufactureOrder).getStyleAttributes().setLocked(true);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_materialNumber).getStyleAttributes().setLocked(true);
                    } else {
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_costObjectNumber).getStyleAttributes().setLocked(false);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_costObjectNumber).getStyleAttributes().setLocked(false);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_manufactureOrder).getStyleAttributes().setLocked(false);
                        curRow.getCell(InnerOverheadBillEditUI.col_entry_materialNumber).getStyleAttributes().setLocked(false);
                    }
                }
            }
        });
        this.table.getColumn(col_entry_costCenterNumber).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBox_costCenterColumn));
    }

    private void initCostObjectColumn() throws Exception {
        this.prmtBox_costObjectColumn = this.createNewKDBizPromptBox("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery", "$number$", "$number$", "$number$", true, true);
        this.setRender(col_entry_costObjectNumber, "$number$");
        this.prmtBox_costObjectColumn.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                CostObjectInfo costObject;
                int rowIndex = InnerOverheadBillEditUI.this.table.getSelectManager().getActiveRowIndex();
                IRow curRow = InnerOverheadBillEditUI.this.table.getRow(rowIndex);
                if (event.getNewValue() instanceof CostObjectInfo && (costObject = (CostObjectInfo)event.getNewValue()) != null) {
                    curRow.getCell(InnerOverheadBillEditUI.col_entry_costObjectName).setValue((Object)costObject.getName());
                }
                InnerOverheadBillEditUI.this.fillCostObjectAfterDo(event);
            }
        });
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtBox_costObjectColumn, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtBox_costObjectColumn.setSelector((KDPromptSelector)arg0);
        this.table.getColumn(col_entry_costObjectNumber).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBox_costObjectColumn));
    }

    private void initManufactureOrderColumn() throws Exception {
        this.prmtBox_ManufactureOrderColumn = new KDBizPromptBox();
        NCMClientUtils.setManufactureF7((KDBizPromptBox)this.prmtBox_ManufactureOrderColumn, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        ObjectValueRender avrMnaufacture = new ObjectValueRender();
        avrMnaufacture.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.table.getColumn(col_entry_manufactureOrder).setRenderer((IBasicRender)avrMnaufacture);
        this.table.getColumn(col_entry_manufactureOrder).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBox_ManufactureOrderColumn));
        this.prmtBox_ManufactureOrderColumn.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                InnerOverheadBillEditUI.this.fillManufactureAfterDo(event);
            }
        });
        this.table.getColumn(col_entry_manufactureOrder).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBox_ManufactureOrderColumn));
    }

    private void initMaterialColumn() throws Exception {
        this.prmtBox_MaterialColumn = new KDBizPromptBox();
        NCMClientUtils.setMaterialF7((KDBizPromptBox)this.prmtBox_MaterialColumn, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        ObjectValueRender avrMat = new ObjectValueRender();
        avrMat.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.table.getColumn(col_entry_materialNumber).setRenderer((IBasicRender)avrMat);
        this.table.getColumn(col_entry_materialNumber).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBox_MaterialColumn));
        this.prmtBox_MaterialColumn.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                InnerOverheadBillEditUI.this.fillMaterialAfterDo(event);
            }
        });
        this.table.getColumn(col_entry_materialNumber).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBox_MaterialColumn));
    }

    private void initMeasureUnitColumn() throws Exception {
        this.prmtBox_measureUnitColumn = this.createNewKDBizPromptBox("com.kingdee.eas.basedata.assistant.app.MeasureUnitQuery", "$name$", "$number$", "$number$", false, true);
        this.prmtBox_measureUnitColumn.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
            }
        });
        this.table.getColumn(col_entry_unit).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtBox_measureUnitColumn));
    }

    private void filterCostCenterF7(KDBizPromptBox f7, CostCenterType[] costCenterTypes) throws Exception {
        EntityViewInfo costCenterView = null;
        costCenterView = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCol = iOrgUnitRelation.getFromUnit(this.getCompanyOrgInfoWithDefault().getId().toString(), 1, 5);
        int ccSize = orgUnitCol.size();
        if (ccSize == 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"####################", CompareType.EQUALS));
        } else {
            HashSet<String> ccIDSet = new HashSet<String>(ccSize);
            for (int i = 0; i < ccSize; ++i) {
                ccIDSet.add(orgUnitCol.get(i).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", ccIDSet, CompareType.INCLUDE));
            if (costCenterTypes != null) {
                HashSet<Integer> types = new HashSet<Integer>();
                for (int i = 0; i < costCenterTypes.length; ++i) {
                    types.add(costCenterTypes[i].getValue());
                }
                filter.getFilterItems().add(new FilterItemInfo("costCenterType", types, CompareType.INCLUDE));
            }
            filter.mergeFilter(costCenterView.getFilter(), "AND");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("costCenterType"));
        f7.setSelectorCollection(sic);
        costCenterView.setFilter(filter);
        f7.setEntityViewInfo(costCenterView);
    }

    private void filterAuxOverheadF7() throws Exception {
        BDCMClientUtils.filterDataBaseDF7((String)"8CB367E7", (KDBizPromptBox)this.prmtBox_AuxOverheadColumn);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyID = null;
        if (this.prmtCompany.getValue() != null && this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            companyID = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
        }
        if (this.costCenterBizPromptBox.getValue() instanceof CostCenterOrgUnitInfo) {
            HashSet<String> auxIds = new HashSet<String>();
            CostCenterOrgUnitInfo costCenter = (CostCenterOrgUnitInfo)this.costCenterBizPromptBox.getValue();
            StringBuffer kSql = new StringBuffer();
            kSql.append(" SELECT DISTINCT aux.FID ");
            kSql.append(" FROM   T_NCM_AUXOverhead aux ");
            kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo auxCompany ");
            kSql.append("          ON aux.FID = auxCompany.FAuxOverheadID ");
            kSql.append(" WHERE  auxCompany.FCostCenterID = '" + costCenter.getId().toString() + "' ");
            kSql.append(" and auxCompany.FCompanyID = '" + companyID + "'");
            IRowSet rst = SQLExecutorFactory.getRemoteInstance((String)kSql.toString()).executeSQL();
            while (rst.next()) {
                auxIds.add(rst.getString(1));
            }
            if (auxIds.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", auxIds, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"####################", CompareType.EQUALS));
            }
        } else {
            HashSet<String> auxIds = new HashSet<String>();
            StringBuffer kSql = new StringBuffer();
            kSql.append(" SELECT DISTINCT aux.FID ");
            kSql.append(" FROM   T_NCM_AUXOverhead aux ");
            kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo auxCompany ");
            kSql.append("          ON aux.FID = auxCompany.FAuxOverheadID ");
            kSql.append(" where auxCompany.FCompanyID = '" + companyID + "'");
            IRowSet rst = SQLExecutorFactory.getRemoteInstance((String)kSql.toString()).executeSQL();
            while (rst.next()) {
                auxIds.add(rst.getString(1));
            }
            if (auxIds.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", auxIds, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"####################", CompareType.EQUALS));
            }
        }
        filter.mergeFilter(view.getFilter(), "AND");
        view.setFilter(filter);
        this.prmtBox_AuxOverheadColumn.setEntityViewInfo(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterCostObjectF7() {
        block14: {
            block12: {
                IRowSet rst;
                FilterInfo filter;
                EntityViewInfo view;
                block11: {
                    CostCenterOrgUnitInfo costCenter;
                    block13: {
                        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
                        if (rowIndex < 0) {
                            return;
                        }
                        Object costCenterObject = this.table.getCell(rowIndex, col_entry_costCenterNumber).getValue();
                        if (!(costCenterObject instanceof CostCenterOrgUnitInfo)) break block12;
                        costCenter = (CostCenterOrgUnitInfo)costCenterObject;
                        if (!CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType())) break block13;
                        CORelatedType[] types = new CORelatedType[]{CORelatedType.Product, CORelatedType.Project, CORelatedType.Other};
                        BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtBox_costObjectColumn, (String)this.getCompanyOrgInfoWithDefault().getId().toString(), (CORelatedType[])types);
                        FilterInfo filter2 = new FilterInfo();
                        filter2.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID", CompareType.NOTEQUALS));
                        EntityViewInfo view2 = this.prmtBox_costObjectColumn.getEntityViewInfo();
                        try {
                            view2.getFilter().mergeFilter(filter2, "AND");
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle((Throwable)ex);
                        }
                        this.prmtBox_costObjectColumn.setEntityViewInfo(view2);
                        break block14;
                    }
                    if (!CostCenterType.AssistantProdDept.equals((Object)costCenter.getCostCenterType())) break block14;
                    CORelatedType[] types = new CORelatedType[]{CORelatedType.Overhead};
                    BDCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtBox_costObjectColumn, (String)this.getCompanyOrgInfoWithDefault().getId().toString(), (CORelatedType[])types);
                    view = null;
                    view = this.prmtBox_costObjectColumn.getEntityViewInfo() != null ? this.prmtBox_costObjectColumn.getEntityViewInfo() : new EntityViewInfo();
                    filter = null;
                    filter = view.getFilter() != null ? view.getFilter() : new FilterInfo();
                    StringBuffer kSql = new StringBuffer();
                    kSql.append(" SELECT DISTINCT COEntry.FParentID as costObjectID ");
                    kSql.append("   FROM T_BD_CostObjectEntry COEntry ");
                    kSql.append("        INNER JOIN T_NCM_AUXOverhead aux ");
                    kSql.append("          ON aux.FID = COEntry.FRelatedID ");
                    kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo auxCompany ");
                    kSql.append("          ON aux.FID = auxCompany.FAuxOverheadID ");
                    kSql.append("  WHERE auxCompany.FCostCenterID = '" + costCenter.getId().toString() + "' ");
                    HashSet<String> costObjectIds = new HashSet<String>();
                    rst = null;
                    try {
                        rst = SQLExecutorFactory.getRemoteInstance((String)kSql.toString()).executeSQL();
                        while (rst.next()) {
                            costObjectIds.add(rst.getString(1));
                        }
                        if (costObjectIds.size() > 0) {
                            filter.getFilterItems().add(new FilterItemInfo("id", costObjectIds, CompareType.INCLUDE));
                            break block11;
                        }
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"##########", CompareType.EQUALS));
                    }
                    catch (Exception ex) {
                        try {
                            ExceptionHandler.handle((Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst);
                            throw throwable;
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
                try {
                    view.getFilter().mergeFilter(filter, "AND");
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
                this.prmtBox_costObjectColumn.setEntityViewInfo(view);
                break block14;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID", CompareType.NOTEQUALS));
            view.setFilter(filter);
            this.prmtBox_costObjectColumn.setEntityViewInfo(view);
            this.prmtBox_costObjectColumn.getQueryAgent().resetRuntimeEntityView();
        }
    }

    private void onAuxOverheadChange(DataChangeEvent event) {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        KDTableUtil.clearCells((KDTable)this.table, (int)rowIndex, (String[])new String[]{col_entry_auxName});
        if (event.getNewValue() instanceof AUXOverheadInfo) {
            AUXOverheadInfo auxOverheadInfo = (AUXOverheadInfo)event.getNewValue();
            this.setPrecisionByAuxOverheadInfo(auxOverheadInfo, rowIndex, true);
        }
    }

    private void setPrecisionByAuxOverheadInfo(AUXOverheadInfo axuOverheadInfo, int rowIndex, boolean updateValue) {
        if (axuOverheadInfo == null || rowIndex < 0) {
            return;
        }
        IRow curRow = this.table.getRow(rowIndex);
        if (updateValue) {
            curRow.getCell(col_entry_auxName).setValue((Object)axuOverheadInfo);
            curRow.getCell(col_entry_unit).setValue((Object)axuOverheadInfo.getUnit());
        }
        String companyID = null;
        if (this.prmtCompany.getValue() != null && this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            companyID = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
        }
        int qtyPrecision = axuOverheadInfo.getQtyPrecision();
        NCMClientUtils.changeTableColPrecision((int)qtyPrecision, (KDTable)this.table, (String[])new String[]{col_entry_qty}, (int)rowIndex);
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT auxCompany.FPricePrecision, \n");
        kSql.append("        auxCompany.FStdPrice \n");
        kSql.append(" FROM   T_NCM_AUXOverhead aux \n");
        kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo auxCompany \n");
        kSql.append("          ON aux.FID = auxCompany.FAuxOverheadID ");
        kSql.append(" WHERE  aux.FID = '" + axuOverheadInfo.getId().toString() + "' \n");
        kSql.append(" and auxCompany.FCompanyID = '" + companyID + "' \n");
        try {
            IRowSet rst = SQLExecutorFactory.getRemoteInstance((String)kSql.toString()).executeSQL();
            if (rst.next()) {
                BigDecimal stdPrice = rst.getBigDecimal(2);
                if (stdPrice != null && updateValue) {
                    curRow.getCell(col_entry_stdPrice).setValue((Object)stdPrice);
                    Object qty = curRow.getCell(col_entry_qty).getValue();
                    if (qty instanceof BigDecimal) {
                        curRow.getCell(col_entry_stdAmount).setValue((Object)((BigDecimal)qty).multiply(stdPrice));
                    }
                }
                NCMClientUtils.changeTableColPrecision((int)rst.getInt(1), (KDTable)this.table, (String[])new String[]{col_entry_actualPrice}, (int)rowIndex);
                NCMClientUtils.changeTableColPrecision((int)rst.getInt(1), (KDTable)this.table, (String[])new String[]{col_entry_stdPrice}, (int)rowIndex);
                NCMClientUtils.changeTableColPrecision((int)2, (KDTable)this.table, (String[])new String[]{col_entry_stdAmount}, (int)rowIndex);
            } else {
                NCMClientUtils.changeTableColPrecision((int)4, (KDTable)this.table, (String[])new String[]{col_entry_actualPrice}, (int)rowIndex);
                NCMClientUtils.changeTableColPrecision((int)4, (KDTable)this.table, (String[])new String[]{col_entry_stdPrice}, (int)rowIndex);
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    @Override
    protected void table_editStopped(KDTEditEvent e) throws Exception {
        Object o;
        IRow row;
        BigDecimal qty;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.table.getColumn(col_entry_qty).getColumnIndex()) {
            BigDecimal qty2 = BDCMClientUtils.castToBigDecimal((KDTable)this.table, (int)rowIndex, (String)col_entry_qty);
            if (this.table.getCell(rowIndex, col_entry_actualPrice).getValue() != null) {
                BigDecimal actualPrice = BDCMClientUtils.castToBigDecimal((KDTable)this.table, (int)rowIndex, (String)col_entry_actualPrice);
                this.table.getCell(rowIndex, col_entry_actualAmount).setValue((Object)qty2.multiply(actualPrice));
            }
            if (this.table.getCell(rowIndex, col_entry_stdPrice).getValue() != null) {
                BigDecimal stdPrice = BDCMClientUtils.castToBigDecimal((KDTable)this.table, (int)rowIndex, (String)col_entry_stdPrice);
                this.table.getCell(rowIndex, col_entry_stdAmount).setValue((Object)qty2.multiply(stdPrice));
            }
        } else if (colIndex == this.table.getColumn(col_entry_actualPrice).getColumnIndex()) {
            BigDecimal actualPrice = BDCMClientUtils.castToBigDecimal((KDTable)this.table, (int)rowIndex, (String)col_entry_actualPrice);
            if (this.table.getCell(rowIndex, col_entry_qty).getValue() != null) {
                qty = BDCMClientUtils.castToBigDecimal((KDTable)this.table, (int)rowIndex, (String)col_entry_qty);
                this.table.getCell(rowIndex, col_entry_actualAmount).setValue((Object)qty.multiply(actualPrice));
            }
        } else if (colIndex == this.table.getColumn(col_entry_actualAmount).getColumnIndex()) {
            BigDecimal actualAmount = BDCMClientUtils.castToBigDecimal((KDTable)this.table, (int)rowIndex, (String)col_entry_actualAmount);
            if (this.table.getCell(rowIndex, col_entry_qty).getValue() != null) {
                qty = BDCMClientUtils.castToBigDecimal((KDTable)this.table, (int)rowIndex, (String)col_entry_qty);
                this.table.getCell(rowIndex, col_entry_actualPrice).setValue((Object)actualAmount.divide(qty, 8, 4));
            }
        }
        if (colIndex == this.table.getColumn(col_entry_bathcNumber).getColumnIndex()) {
            row = this.table.getRow(rowIndex);
            o = e.getValue();
            if (o instanceof String) {
                String batchNumber = (String)o;
                MaterialInfo materialInfo = (MaterialInfo)row.getCell(col_entry_materialNumber).getValue();
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((MaterialInfo)materialInfo, (String)batchNumber, (boolean)true);
                if (costObjectRelatedInfo != null) {
                    row.getCell(col_entry_costObjectNumber).setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                    row.getCell(col_entry_costObjectName).setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getName());
                } else {
                    row.getCell(col_entry_bathcNumber).setValue(null);
                    throw new NcmBillException(NcmBillException.MATANDBATCH_NO_COSTOBJECT);
                }
            }
        }
        if (colIndex == this.table.getColumn(col_entry_manufactureOrder).getColumnIndex() && (o = (row = this.table.getRow(rowIndex)).getCell(col_entry_costObjectNumber).getValue()) == null) {
            row.getCell(col_entry_manufactureOrder).setValue(null);
        }
        if (colIndex == this.table.getColumn(col_entry_materialNumber).getColumnIndex() && (o = (row = this.table.getRow(rowIndex)).getCell(col_entry_costObjectNumber).getValue()) == null && row.getCell(col_entry_bathcNumber).getFormattedStyleAttributes().isLocked()) {
            row.getCell(col_entry_materialNumber).setValue(null);
            row.getCell(col_entry_materialName).setValue(null);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        boolean isExistCodingRule = codingRuleManager.isExist((IObjectValue)this.editData, this.getCompanyOrgInfoWithDefault().getId().toString());
        if (!isExistCodingRule) {
            BDCMClientUtils.checkIsNull((JComponent)this.numberTextField, (String)this.numberLabelContainer.getBoundLabelText());
        }
        int size = this.table.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow rowTemp = this.table.getRow(i);
            if (rowTemp.getCell(col_entry_costObjectNumber).getValue() != null && !"".equals(rowTemp.getCell(col_entry_costObjectNumber).getValue())) continue;
            rowTemp.getCell(col_entry_materialNumber).setValue(null);
            rowTemp.getCell(col_entry_materialName).setValue(null);
        }
        if (e == this.actionSave.getActionEvent()) {
            return;
        }
        BDCMClientUtils.checkIsNull((JComponent)this.costCenterBizPromptBox, (String)this.costCenterLabelContainer.getBoundLabelText());
        if (UIRuleUtil.isNull((Object)this.bizDateDatePicker.getValue())) {
            this.bizDateDatePicker.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.bizDateDLabelContainer.getBoundLabelText()});
        }
        IRow header = this.table.getHeadRow(0);
        int size2 = this.table.getRowCount();
        for (int i = 0; i < size2; ++i) {
            IRow row = this.table.getRow(i);
            if (UIRuleUtil.isNull((Object)row.getCell(col_entry_auxNumber).getValue())) {
                this.table.getEditManager().editCellAt(i, row.getCell(col_entry_auxNumber).getColumnIndex());
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{(String)header.getCell(col_entry_auxNumber).getValue()});
            }
            if (UIRuleUtil.isNull((Object)row.getCell(col_entry_costCenterNumber).getValue())) {
                this.table.getEditManager().editCellAt(i, row.getCell(col_entry_costCenterNumber).getColumnIndex());
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{(String)header.getCell(col_entry_costCenterNumber).getValue()});
            }
            BigDecimal qty = BDCMClientUtils.castToBigDecimal((KDTable)this.table, (int)i, (String)col_entry_qty);
            if (SysConstant.BIGZERO.compareTo(qty) < 0) continue;
            this.table.getEditManager().editCellAt(i, row.getCell(col_entry_qty).getColumnIndex());
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{(String)header.getCell(col_entry_qty).getValue()});
        }
    }

    private void setBigDecimalColumnEditor(String colKey) {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setHorizontalAlignment(4);
        this.table.getColumn(colKey).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        this.table.getColumn(colKey).getStyleAttributes().setNumberFormat("%{0.##########}f");
    }

    private KDBizPromptBox createNewKDBizPromptBox(String queryInfo, String displayFormat, String editFormat, String commitFormat, boolean editable, boolean required) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setQueryInfo(queryInfo);
        bizPromptBox.setDisplayFormat(displayFormat);
        bizPromptBox.setEditFormat(editFormat);
        bizPromptBox.setCommitFormat(commitFormat);
        bizPromptBox.setEditable(editable);
        bizPromptBox.setRequired(required);
        return bizPromptBox;
    }

    private void setRender(String columnKey, String format) {
        ObjectValueRender objectValueRender = new ObjectValueRender();
        objectValueRender.setFormat((IDataFormat)new BizDataFormat(format));
        this.table.getColumn(columnKey).setRenderer((IBasicRender)objectValueRender);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("InnerOverhead_Audit");
        }
        super.auditAction_actionPerformed(e);
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        super.unauditAction_actionPerformed(e);
    }

    protected KDTable getDetailTable() {
        return this.table;
    }

    public KDTextField getNumTextField() {
        return this.numberTextField;
    }

    private void fillCostObjectAfterDo(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntries.getRow(selectRowIndex);
        if (newValue != null && newValue instanceof CostObjectInfo) {
            CostObjectInfo oldCostObject = null;
            if (row.getCell(col_entry_costObjectNumber).getValue() instanceof CostObjectInfo) {
                oldCostObject = (CostObjectInfo)row.getCell(col_entry_costObjectNumber).getValue();
            }
            if (oldCostObject != null && oldCostObject.getId().toString().equals(((CostObjectInfo)newValue).getId().toString())) {
                return;
            }
            try {
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByCO((CostObjectInfo)((CostObjectInfo)newValue));
                row.getCell(col_entry_manufactureOrder).setValue((Object)costObjectRelatedInfo.getManufactureOrderInfo());
                row.getCell(col_entry_materialNumber).setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                row.getCell(col_entry_materialName).setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                row.getCell(col_entry_projectNumber).setValue((Object)costObjectRelatedInfo.getProjectNumber());
                row.getCell(col_entry_trackNumber).setValue((Object)costObjectRelatedInfo.getTrackNumber());
                row.getCell(col_entry_bathcNumber).setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                row.getCell(col_entry_bathcNumber).getStyleAttributes().setLocked(true);
                row.getCell(col_entry_bathcNumber).getStyleAttributes().setBackground(new Color(255, 255, 255));
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            row.getCell(col_entry_costObjectName).setValue(null);
            row.getCell(col_entry_manufactureOrder).setValue(null);
            row.getCell(col_entry_materialName).setValue(null);
            row.getCell(col_entry_materialNumber).setValue(null);
            row.getCell(col_entry_projectNumber).setValue(null);
            row.getCell(col_entry_trackNumber).setValue(null);
            row.getCell(col_entry_bathcNumber).setValue(null);
        }
    }

    private void fillManufactureAfterDo(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntries.getRow(selectRowIndex);
        if (newValue != null && newValue instanceof ManufactureOrderInfo) {
            ManufactureOrderInfo oldOrder = null;
            if (row.getCell(col_entry_manufactureOrder).getValue() instanceof ManufactureOrderInfo) {
                oldOrder = (ManufactureOrderInfo)row.getCell(col_entry_manufactureOrder).getValue();
            }
            if (oldOrder != null && oldOrder.getId().toString().equals(((ManufactureOrderInfo)newValue).getId().toString())) {
                return;
            }
            try {
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByOrder((ManufactureOrderInfo)((ManufactureOrderInfo)newValue), (String)((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString());
                if (costObjectRelatedInfo != null) {
                    if (costObjectRelatedInfo.getCostObjectInfo() != null) {
                        row.getCell(col_entry_costObjectNumber).setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                        row.getCell(col_entry_costObjectName).setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getName());
                        row.getCell(col_entry_bathcNumber).setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                        row.getCell(col_entry_bathcNumber).getStyleAttributes().setLocked(true);
                        row.getCell(col_entry_bathcNumber).getStyleAttributes().setBackground(new Color(255, 255, 255));
                    } else {
                        row.getCell(col_entry_costObjectNumber).getStyleAttributes().setLocked(false);
                        row.getCell(col_entry_bathcNumber).getStyleAttributes().setLocked(false);
                        row.getCell(col_entry_bathcNumber).getStyleAttributes().setBackground(new Color(255, 255, 204));
                        row.getCell(col_entry_costObjectNumber).setValue(null);
                        row.getCell(col_entry_costObjectName).setValue(null);
                        row.getCell(col_entry_materialNumber).setValue(null);
                        row.getCell(col_entry_materialName).setValue(null);
                        row.getCell(col_entry_projectNumber).setValue(null);
                        row.getCell(col_entry_trackNumber).setValue(null);
                        row.getCell(col_entry_bathcNumber).setValue(null);
                    }
                    row.getCell(col_entry_materialNumber).setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                    row.getCell(col_entry_materialName).setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                    row.getCell(col_entry_projectNumber).setValue((Object)costObjectRelatedInfo.getProjectNumber());
                    row.getCell(col_entry_trackNumber).setValue((Object)costObjectRelatedInfo.getTrackNumber());
                } else {
                    row.getCell(col_entry_costObjectNumber).setValue(null);
                    row.getCell(col_entry_costObjectName).setValue(null);
                    row.getCell(col_entry_materialName).setValue(null);
                    row.getCell(col_entry_materialNumber).setValue(null);
                    row.getCell(col_entry_projectNumber).setValue(null);
                    row.getCell(col_entry_trackNumber).setValue(null);
                    row.getCell(col_entry_bathcNumber).setValue(null);
                }
            }
            catch (EASBizException e) {
                row.getCell(col_entry_costObjectNumber).setValue(null);
                row.getCell(col_entry_costObjectName).setValue(null);
                row.getCell(col_entry_materialName).setValue(null);
                row.getCell(col_entry_materialNumber).setValue(null);
                row.getCell(col_entry_projectNumber).setValue(null);
                row.getCell(col_entry_trackNumber).setValue(null);
                row.getCell(col_entry_bathcNumber).setValue(null);
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void fillMaterialAfterDo(DataChangeEvent eventObj) {
        block11: {
            Object newValue = eventObj.getNewValue();
            int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
            IRow row = this.kdtEntries.getRow(selectRowIndex);
            if (newValue != null && newValue instanceof MaterialInfo) {
                MaterialInfo oldMat = null;
                if (row.getCell(col_entry_materialNumber).getValue() instanceof MaterialInfo) {
                    oldMat = (MaterialInfo)row.getCell(col_entry_materialNumber).getValue();
                }
                if (oldMat != null && oldMat.getNumber().equals(((MaterialInfo)newValue).getNumber())) {
                    return;
                }
                try {
                    CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((MaterialInfo)((MaterialInfo)newValue));
                    row.getCell(col_entry_materialName).setValue((Object)((MaterialInfo)newValue).getName());
                    if (costObjectRelatedInfo != null) {
                        if (costObjectRelatedInfo.getCostObjectInfo() != null) {
                            row.getCell(col_entry_costObjectNumber).setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                            row.getCell(col_entry_costObjectName).setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getName());
                            row.getCell(col_entry_bathcNumber).setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                            if (costObjectRelatedInfo.getCostObjectInfo().getBatchNumber() == null || costObjectRelatedInfo.getCostObjectInfo().getBatchNumber().length() <= 0) {
                                row.getCell(col_entry_bathcNumber).getStyleAttributes().setLocked(true);
                                row.getCell(col_entry_bathcNumber).getStyleAttributes().setBackground(new Color(255, 255, 255));
                            }
                        } else {
                            row.getCell(col_entry_bathcNumber).getStyleAttributes().setLocked(false);
                            row.getCell(col_entry_costObjectNumber).setValue(null);
                            row.getCell(col_entry_costObjectName).setValue(null);
                            row.getCell(col_entry_manufactureOrder).setValue(null);
                            row.getCell(col_entry_materialNumber).setValue(null);
                            row.getCell(col_entry_materialName).setValue(null);
                            row.getCell(col_entry_projectNumber).setValue(null);
                            row.getCell(col_entry_trackNumber).setValue(null);
                            row.getCell(col_entry_bathcNumber).setValue(null);
                        }
                        row.getCell(col_entry_manufactureOrder).setValue((Object)costObjectRelatedInfo.getManufactureOrderInfo());
                        row.getCell(col_entry_projectNumber).setValue((Object)costObjectRelatedInfo.getProjectNumber());
                        row.getCell(col_entry_trackNumber).setValue((Object)costObjectRelatedInfo.getTrackNumber());
                        break block11;
                    }
                    row.getCell(col_entry_bathcNumber).getStyleAttributes().setLocked(false);
                    row.getCell(col_entry_bathcNumber).getStyleAttributes().setBackground(new Color(255, 255, 204));
                    row.getCell(col_entry_costObjectNumber).setValue(null);
                    row.getCell(col_entry_costObjectName).setValue(null);
                    row.getCell(col_entry_manufactureOrder).setValue(null);
                    row.getCell(col_entry_projectNumber).setValue(null);
                    row.getCell(col_entry_trackNumber).setValue(null);
                    row.getCell(col_entry_bathcNumber).setValue(null);
                }
                catch (EASBizException e) {
                    row.getCell(col_entry_bathcNumber).getStyleAttributes().setLocked(true);
                    row.getCell(col_entry_bathcNumber).getStyleAttributes().setBackground(new Color(255, 255, 255));
                    row.getCell(col_entry_costObjectNumber).setValue(null);
                    row.getCell(col_entry_costObjectName).setValue(null);
                    row.getCell(col_entry_manufactureOrder).setValue(null);
                    row.getCell(col_entry_projectNumber).setValue(null);
                    row.getCell(col_entry_trackNumber).setValue(null);
                    row.getCell(col_entry_bathcNumber).setValue(null);
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                row.getCell(col_entry_bathcNumber).getStyleAttributes().setLocked(true);
                row.getCell(col_entry_bathcNumber).getStyleAttributes().setBackground(new Color(255, 255, 255));
                row.getCell(col_entry_materialName).setValue(null);
                row.getCell(col_entry_costObjectNumber).setValue(null);
                row.getCell(col_entry_costObjectName).setValue(null);
                row.getCell(col_entry_manufactureOrder).setValue(null);
                row.getCell(col_entry_projectNumber).setValue(null);
                row.getCell(col_entry_trackNumber).setValue(null);
                row.getCell(col_entry_bathcNumber).setValue(null);
            }
        }
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.billStatusComboBox.getSelectedItem() != null && this.billStatusComboBox.getSelectedItem().toString().equals("\u5ba1\u6838")) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, (IObjectPK)new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId().toString()), (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.initOrderInfo();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initOrderInfo() throws Exception {
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            CostObjectInfo costObject;
            this.kdtEntries.getCell(rowIndex, col_entry_bathcNumber).getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, col_entry_bathcNumber).getStyleAttributes().setBackground(Color.WHITE);
            Object value = this.kdtEntries.getRow(rowIndex).getCell(col_entry_costObjectNumber).getValue();
            if (!(value instanceof CostObjectInfo) || !CalculateModeEnum.BYBATCH.equals((Object)(costObject = (CostObjectInfo)value).getCalculateMode())) continue;
            this.kdtEntries.getCell(rowIndex, col_entry_bathcNumber).getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, col_entry_bathcNumber).getStyleAttributes().setBackground(new Color(252, 251, 223));
        }
    }
}

