/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.InnerOverheadBillFilterParam;
import com.kingdee.eas.ncm.bill.InnerOverheadBillInfo;
import com.kingdee.eas.ncm.bill.client.AbstractInnerOverheadBillFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class InnerOverheadBillFilterUI
extends AbstractInnerOverheadBillFilterUI {
    private static final long serialVersionUID = -8529335754927730567L;
    private static final int PERIOD_MAX_MONTH = 12;
    private static final String InnerOverheadBillInfoFrom = "InnerOverheadBillInfoFrom";
    private static final String InnerOverheadBillInfoTo = "InnerOverheadBillInfoTo";
    private static final String BeginDate = "BeginDate";
    private static final String EndDate = "EndDate";
    private static final String PeriodFrom = "periodFrom";
    private static final String PeriodTo = "periodTo";
    private static final String CostCenterFrom = "costCenterFrom";
    private static final String CostCenterTo = "costCenterTo";
    private static final String AUXOverheadInfoFrom = "AUXOverheadInfoFrom";
    private static final String AUXOverheadInfoTo = "AUXOverheadInfoTo";
    private static final String consumeCostCenterFrom = "consumeCostCenterFrom";
    private static final String consumeCostCenterTo = "consumeCostCenterTo";
    private static final String consumeCostObjectFrom = "consumeCostObjectFrom";
    private static final String consumeCostObjectTo = "consumeCostObjectTo";
    private String BillSate = "billSate";
    private PeriodInfo periodStart;
    private PeriodInfo periodCur;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.initCompany(this.getCompanyOrgInfoWithDefault());
        this.initBizDate(this.fromdateDatePicker);
        this.initBizDate(this.toDateDatePicker);
        this.initPeriod();
        BDCMClientUtils.filterDataBaseDF7((String)"8CB367E7", (KDBizPromptBox)this.pbAuxFrom);
        BDCMClientUtils.filterDataBaseDF7((String)"8CB367E7", (KDBizPromptBox)this.pbAuxTo);
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.pbConsumeCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.pbConsumeCostObjectFrom.setSelector((KDPromptSelector)arg0);
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.pbConsumeCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.pbConsumeCostObjectTo.setSelector((KDPromptSelector)arg1);
    }

    private void initPeriod() throws EASBizException, BOSException {
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        if (this.periodStart == null || this.periodCur == null) {
            return;
        }
        int minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initFromPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
    }

    private void initBizDate(KDDatePicker kdDate) {
        kdDate.setValue(null);
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prtCompany.setValue((Object)companyOrg);
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new InnerOverheadBillFilterParam();
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof InnerOverheadBillFilterParam)) {
            return;
        }
        InnerOverheadBillFilterParam _filterParam = (InnerOverheadBillFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getBillNumFrom(), InnerOverheadBillInfoFrom);
        super.putIdByKey(customerParams, (Object)_filterParam.getBillNumTo(), InnerOverheadBillInfoTo);
        super.putIdByKey(customerParams, (Object)Long.valueOf(_filterParam.getBeginDate()).toString(), BeginDate);
        super.putIdByKey(customerParams, (Object)Long.valueOf(_filterParam.getEndDate()).toString(), EndDate);
        super.putIdByKey(customerParams, (Object)_filterParam.getPeriodFrom(), PeriodFrom);
        super.putIdByKey(customerParams, (Object)_filterParam.getPeriodTo(), PeriodTo);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostCenterFrom(), CostCenterFrom);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostCenterTo(), CostCenterTo);
        super.putIdByKey(customerParams, (Object)_filterParam.getAUXOverheadInfoFrom(), AUXOverheadInfoFrom);
        super.putIdByKey(customerParams, (Object)_filterParam.getAUXOverheadInfoTo(), AUXOverheadInfoTo);
        super.putIdByKey(customerParams, (Object)_filterParam.getConsumeCostCenterFrom(), consumeCostCenterFrom);
        super.putIdByKey(customerParams, (Object)_filterParam.getConsumeCostCenterTo(), consumeCostCenterTo);
        super.putIdByKey(customerParams, (Object)_filterParam.getConsumeCostObjectFrom(), consumeCostObjectFrom);
        super.putIdByKey(customerParams, (Object)_filterParam.getConsumeCostObjectTo(), consumeCostObjectTo);
        super.putIdByKey(customerParams, (Object)_filterParam.getBillSate(), this.BillSate);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof InnerOverheadBillFilterParam)) {
            return;
        }
        InnerOverheadBillFilterParam _filterParam = (InnerOverheadBillFilterParam)filterParam;
        Object temp = null;
        InnerOverheadBillInfo billNumFrom = null;
        InnerOverheadBillInfo billNumTo = null;
        temp = this.pbBillNumFrom.getData();
        if (temp != null && temp instanceof InnerOverheadBillInfo) {
            billNumFrom = (InnerOverheadBillInfo)temp;
        }
        if ((temp = this.pbBillNumTo.getData()) != null && temp instanceof InnerOverheadBillInfo) {
            billNumTo = (InnerOverheadBillInfo)temp;
        }
        _filterParam.setBillNumFrom(billNumFrom);
        _filterParam.setBillNumTo(billNumTo);
        long bizDateFrom = 0L;
        long bizDateTo = 0L;
        temp = this.fromdateDatePicker.getValue();
        if (temp != null && temp instanceof Date) {
            bizDateFrom = ((Date)temp).getTime();
        }
        if ((temp = this.toDateDatePicker.getValue()) != null && temp instanceof Date) {
            bizDateTo = ((Date)temp).getTime();
        }
        _filterParam.setBeginDate(bizDateFrom);
        _filterParam.setEndDate(bizDateTo);
        String periodFrom = null;
        String periodTo = null;
        temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = ((Integer)temp).toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = ((Integer)temp).toString();
        }
        _filterParam.setPeriodFrom(periodFrom);
        _filterParam.setPeriodTo(periodTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.pbCostCenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.pbCostCenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        _filterParam.setCostCenterFrom(costCenterFrom);
        _filterParam.setCostCenterTo(costCenterTo);
        AUXOverheadInfo AUXOverheadInfoFrom = null;
        AUXOverheadInfo AUXOverheadInfoTo = null;
        temp = this.pbAuxFrom.getData();
        if (temp != null && temp instanceof AUXOverheadInfo) {
            AUXOverheadInfoFrom = (AUXOverheadInfo)temp;
        }
        if ((temp = this.pbAuxTo.getData()) != null && temp instanceof AUXOverheadInfo) {
            AUXOverheadInfoTo = (AUXOverheadInfo)temp;
        }
        _filterParam.setAUXOverheadInfoFrom(AUXOverheadInfoFrom);
        _filterParam.setAUXOverheadInfoTo(AUXOverheadInfoTo);
        CostCenterOrgUnitInfo consumeCostCenterFrom = null;
        CostCenterOrgUnitInfo consumeCostCenterTo = null;
        temp = this.pbConsumeCostCenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            consumeCostCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.pbConsumeCostCenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            consumeCostCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        _filterParam.setConsumeCostCenterFrom(consumeCostCenterFrom);
        _filterParam.setConsumeCostCenterTo(consumeCostCenterTo);
        CostObjectInfo consumeCostObjectFrom = null;
        CostObjectInfo consumeCostObjectTo = null;
        temp = this.pbConsumeCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            consumeCostObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.pbConsumeCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            consumeCostObjectTo = (CostObjectInfo)temp;
        }
        _filterParam.setConsumeCostObjectFrom(consumeCostObjectFrom);
        _filterParam.setConsumeCostObjectTo(consumeCostObjectTo);
        int selectIndex = this.cbBillState.getSelectedIndex();
        _filterParam.setBillSate(String.valueOf(selectIndex));
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof InnerOverheadBillFilterParam)) {
            return;
        }
        InnerOverheadBillFilterParam _filterParam = (InnerOverheadBillFilterParam)filterParam;
        InnerOverheadBillInfo bnFrom = null;
        InnerOverheadBillInfo bnTo = null;
        String InnerOverheadBillInfoFromData = customerParams.getCustomerParam(InnerOverheadBillInfoFrom);
        String InnerOverheadBillInfoToData = customerParams.getCustomerParam(InnerOverheadBillInfoTo);
        if (InnerOverheadBillInfoFromData != null && InnerOverheadBillInfoFromData.length() > 0) {
            bnFrom = new InnerOverheadBillInfo();
            bnFrom.setId(BOSUuid.read((String)InnerOverheadBillInfoFromData));
        }
        if (InnerOverheadBillInfoToData != null && InnerOverheadBillInfoToData.length() > 0) {
            bnTo = new InnerOverheadBillInfo();
            bnTo.setId(BOSUuid.read((String)InnerOverheadBillInfoToData));
        }
        _filterParam.setBillNumFrom(bnFrom);
        _filterParam.setBillNumTo(bnTo);
        String beginDate = customerParams.getCustomerParam(BeginDate);
        String endDate = customerParams.getCustomerParam(EndDate);
        _filterParam.setBeginDate(Long.parseLong(beginDate));
        _filterParam.setEndDate(Long.parseLong(endDate));
        String periodFromData = customerParams.getCustomerParam(PeriodFrom);
        String periodToData = customerParams.getCustomerParam(PeriodTo);
        _filterParam.setPeriodFrom(periodFromData);
        _filterParam.setPeriodTo(periodToData);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        String costCenterFromData = customerParams.getCustomerParam(CostCenterFrom);
        String costCenterToData = customerParams.getCustomerParam(CostCenterTo);
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            ccTo = new CostCenterOrgUnitInfo();
            ccTo.setId(BOSUuid.read((String)costCenterToData));
        }
        _filterParam.setCostCenterFrom(ccFrom);
        _filterParam.setCostCenterTo(ccTo);
        AUXOverheadInfo AUXFrom = null;
        AUXOverheadInfo AUXTo = null;
        String AUXFromData = customerParams.getCustomerParam(AUXOverheadInfoFrom);
        String AUXToData = customerParams.getCustomerParam(AUXOverheadInfoTo);
        if (AUXFromData != null && AUXFromData.length() > 0) {
            AUXFrom = new AUXOverheadInfo();
            AUXFrom.setId(BOSUuid.read((String)AUXFromData));
        }
        if (AUXToData != null && AUXToData.length() > 0) {
            AUXTo = new AUXOverheadInfo();
            AUXTo.setId(BOSUuid.read((String)AUXToData));
        }
        _filterParam.setAUXOverheadInfoFrom(AUXFrom);
        _filterParam.setAUXOverheadInfoTo(AUXTo);
        CostCenterOrgUnitInfo consumeCCFrom = null;
        CostCenterOrgUnitInfo consumeCCTo = null;
        String consumeCostCenterFromData = customerParams.getCustomerParam(consumeCostCenterFrom);
        String consumeCostCenterToData = customerParams.getCustomerParam(consumeCostCenterTo);
        if (consumeCostCenterFromData != null && consumeCostCenterFromData.length() > 0) {
            consumeCCFrom = new CostCenterOrgUnitInfo();
            consumeCCFrom.setId(BOSUuid.read((String)consumeCostCenterFromData));
        }
        if (consumeCostCenterToData != null && consumeCostCenterToData.length() > 0) {
            consumeCCTo = new CostCenterOrgUnitInfo();
            consumeCCTo.setId(BOSUuid.read((String)consumeCostCenterToData));
        }
        _filterParam.setConsumeCostCenterFrom(consumeCCFrom);
        _filterParam.setConsumeCostCenterTo(consumeCCTo);
        CostObjectInfo consumeCOFrom = null;
        CostObjectInfo consumeCOTo = null;
        String consumeCostObjectFromData = customerParams.getCustomerParam(consumeCostObjectFrom);
        String consumeCostObjectToData = customerParams.getCustomerParam(consumeCostObjectTo);
        if (consumeCostObjectFromData != null && consumeCostObjectFromData.length() > 0) {
            consumeCOFrom = new CostObjectInfo();
            consumeCOFrom.setId(BOSUuid.read((String)consumeCostObjectFromData));
        }
        if (consumeCostObjectToData != null && consumeCostObjectToData.length() > 0) {
            consumeCOTo = new CostObjectInfo();
            consumeCOTo.setId(BOSUuid.read((String)consumeCostObjectToData));
        }
        _filterParam.setConsumeCostObjectFrom(consumeCOFrom);
        _filterParam.setConsumeCostObjectTo(consumeCOTo);
        String schemeState = customerParams.getCustomerParam(this.BillSate);
        if (schemeState != null && schemeState.length() > 0) {
            _filterParam.setBillSate(schemeState);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof InnerOverheadBillFilterParam) {
            int minPeriod;
            InnerOverheadBillFilterParam _filterParam = (InnerOverheadBillFilterParam)filterParam;
            if (_filterParam.getBillNumFrom() != null) {
                this.pbBillNumFrom.setValue((Object)_filterParam.getBillNumFrom());
            } else {
                this.pbBillNumFrom.setValue(null);
            }
            if (_filterParam.getBillNumTo() != null) {
                this.pbBillNumTo.setValue((Object)_filterParam.getBillNumTo());
            } else {
                this.pbBillNumTo.setValue(null);
            }
            if (_filterParam.getBeginDate() != 0L) {
                this.fromdateDatePicker.setValue((Object)new Date(_filterParam.getBeginDate()));
            } else {
                this.fromdateDatePicker.setValue(null);
            }
            if (_filterParam.getEndDate() != 0L) {
                this.toDateDatePicker.setValue((Object)new Date(_filterParam.getEndDate()));
            } else {
                this.toDateDatePicker.setValue(null);
            }
            int initFromPeriod = minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
            int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
            if (_filterParam.getPeriodFrom() != null) {
                initFromPeriod = Integer.parseInt(_filterParam.getPeriodFrom());
            }
            if (_filterParam.getPeriodTo() != null) {
                initToPeriod = Integer.parseInt(_filterParam.getPeriodTo());
            }
            this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
            if (_filterParam.getCostCenterFrom() != null) {
                this.pbCostCenterFrom.setValue((Object)_filterParam.getCostCenterFrom());
            } else {
                this.pbCostCenterFrom.setValue(null);
            }
            if (_filterParam.getCostCenterTo() != null) {
                this.pbCostCenterTo.setValue((Object)_filterParam.getCostCenterTo());
            } else {
                this.pbCostCenterTo.setValue(null);
            }
            if (_filterParam.getAUXOverheadInfoFrom() != null) {
                this.pbAuxFrom.setValue((Object)_filterParam.getAUXOverheadInfoFrom());
            } else {
                this.pbAuxFrom.setValue(null);
            }
            if (_filterParam.getAUXOverheadInfoTo() != null) {
                this.pbAuxTo.setValue((Object)_filterParam.getAUXOverheadInfoTo());
            } else {
                this.pbAuxTo.setValue(null);
            }
            if (_filterParam.getConsumeCostCenterFrom() != null) {
                this.pbConsumeCostCenterFrom.setValue((Object)_filterParam.getConsumeCostCenterFrom());
            } else {
                this.pbConsumeCostCenterFrom.setValue(null);
            }
            if (_filterParam.getConsumeCostCenterTo() != null) {
                this.pbConsumeCostCenterTo.setValue((Object)_filterParam.getConsumeCostCenterTo());
            } else {
                this.pbConsumeCostCenterTo.setValue(null);
            }
            if (_filterParam.getConsumeCostObjectFrom() != null) {
                this.pbConsumeCostObjectFrom.setValue((Object)_filterParam.getConsumeCostObjectFrom());
            } else {
                this.pbConsumeCostObjectFrom.setValue(null);
            }
            if (_filterParam.getConsumeCostObjectTo() != null) {
                this.pbConsumeCostObjectTo.setValue((Object)_filterParam.getConsumeCostObjectTo());
            } else {
                this.pbConsumeCostObjectTo.setValue(null);
            }
            this.cbBillState.setSelectedIndex(Integer.parseInt(_filterParam.getBillSate()));
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        Date bizDateFrom = (Date)this.fromdateDatePicker.getValue();
        Date bizDateTo = (Date)this.toDateDatePicker.getValue();
        if (bizDateFrom != null && bizDateTo != null && bizDateFrom.equals(bizDateTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            bizDateTo.setHours(23);
            bizDateTo.setMinutes(59);
            bizDateTo.setSeconds(59);
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
        } else {
            if (bizDateFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            }
            if (bizDateTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
            }
        }
        int selectIndex = this.cbBillState.getSelectedIndex();
        String billStatus = String.valueOf(selectIndex + 1);
        if (selectIndex != 0) {
            filterBiz.getFilterItems().add(new FilterItemInfo("billStatus", (Object)billStatus, CompareType.EQUALS));
        }
        String periodFrom = null;
        String periodTo = null;
        Object temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = temp.toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = temp.toString();
        }
        if (periodFrom != null && periodTo != null && periodFrom.equals(periodTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.EQUALS));
        } else {
            if (periodFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
            }
            if (periodTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
            }
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        try {
            this.clearFilterData();
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void clearFilterData() {
        this.pbBillNumFrom.setValue(null);
        this.pbBillNumTo.setValue(null);
        this.pbCostCenterFrom.setValue(null);
        this.pbCostCenterTo.setValue(null);
        this.pbAuxFrom.setValue(null);
        this.pbAuxTo.setValue(null);
        this.pbConsumeCostCenterFrom.setValue(null);
        this.pbConsumeCostCenterTo.setValue(null);
        this.pbConsumeCostObjectFrom.setValue(null);
        this.pbConsumeCostObjectTo.setValue(null);
        this.cbBillState.setSelectedIndex(0);
    }

    private void initPeriodSpinner(final JSpinner spFrom, final JSpinner spTo, int minPeriod, int initFromPeriod, int initToPeriod) {
        boolean argumentError = false;
        if (minPeriod <= 0) {
            argumentError = true;
        }
        String sMinPeriod = String.valueOf(minPeriod);
        if (!argumentError && sMinPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [minPeriod:" + minPeriod + "] error.");
        }
        argumentError = false;
        if (initFromPeriod <= 0 || initFromPeriod < minPeriod) {
            argumentError = true;
        }
        String sInitFromPeriod = String.valueOf(initFromPeriod);
        if (!argumentError && sInitFromPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initFromPeriod:" + initFromPeriod + "] error.");
        }
        argumentError = false;
        if (initToPeriod <= 0 || initToPeriod < minPeriod || initToPeriod < initFromPeriod) {
            argumentError = true;
        }
        String sInitToPeriod = String.valueOf(initToPeriod);
        if (!argumentError && sInitToPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initToPeriod:" + initToPeriod + "] error.");
        }
        final int minYear = Integer.parseInt(sMinPeriod.substring(0, 4));
        final int minMonth = Integer.parseInt(sMinPeriod.substring(4));
        SpinnerNumberModel modelFrom = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spTo.setValue(spFrom.getValue());
                }
            }
        };
        SpinnerNumberModel modelTo = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spFrom.setValue(spTo.getValue());
                }
            }
        };
        spFrom.setModel(modelFrom);
        spTo.setModel(modelTo);
        spFrom.setValue(initFromPeriod);
        spTo.setValue(initToPeriod);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        this.f7ContextManager.registerCostCenterF7(this.pbCostCenterFrom, new CostCenterType[]{CostCenterType.AssistantProdDept});
        this.f7ContextManager.registerCostCenterF7(this.pbCostCenterTo, new CostCenterType[]{CostCenterType.AssistantProdDept});
        this.f7ContextManager.registerCostCenterF7(this.pbConsumeCostCenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.pbConsumeCostCenterTo);
        this.f7ContextManager.registerCostObjectF7(this.pbConsumeCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.pbConsumeCostObjectTo, false);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.pbBillNumFrom, "com.kingdee.eas.ncm.bill.app.InnerOverHeadFilterQuery", "companyOrg.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.pbBillNumTo, "com.kingdee.eas.ncm.bill.app.InnerOverHeadFilterQuery", "companyOrg.id");
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.pbCostCenterFrom.setData(null);
                this.pbCostCenterTo.setData(null);
                this.pbConsumeCostCenterFrom.setData(null);
                this.pbConsumeCostCenterTo.setData(null);
                this.pbConsumeCostObjectFrom.setData(null);
                this.pbConsumeCostObjectTo.setData(null);
                this.pbBillNumFrom.setData(null);
                this.pbBillNumTo.setData(null);
                this.initPeriod();
                this.pbBillNumFrom.setDisplayFormat("$number$");
                this.pbBillNumTo.setDisplayFormat("$number$");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

