/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.InnerOverheadBillFactory;
import com.kingdee.eas.ncm.bill.client.AbstractInnerOverheadBillListUI;
import com.kingdee.eas.ncm.bill.client.InnerOverheadBillEditUI;
import com.kingdee.eas.ncm.bill.client.InnerOverheadBillFilterUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InnerOverheadBillListUI
extends AbstractInnerOverheadBillListUI {
    private static final long serialVersionUID = 1232350611694629286L;
    protected InnerOverheadBillFilterUI filterUI = null;
    private CommonQueryDialog dialog = null;
    private Map rpcData = null;

    public void onLoad() throws Exception {
        this.batchGetRpcData();
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        this.btnImportData.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    protected CommonQueryProcessor getCustomerCommonQueryProcessor() {
        CommonQueryProcessor cmcq = super.getCustomerCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
        cmcq.set("query", (Object)"InnerOverheadBillQuery");
        return cmcq;
    }

    private void batchGetRpcData() throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        CompanyOrgUnitInfo currentCompany = this.getCompanyOrgInfoWithDefault();
        paramMap.put("companyId", currentCompany.getId().toString());
        this.rpcData = InnerOverheadBillFactory.getRemoteInstance().batchGetRpcData(paramMap);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionVoucher.setEnabled(true);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setEnabled(true);
        this.actionDelVoucher.setVisible(true);
        this.actionTraceDown.setEnabled(true);
        this.actionTraceDown.setVisible(true);
        this.actionTraceUp.setVisible(false);
        this.actionTraceUp.setEnabled(false);
    }

    public void refreshList() throws Exception {
        super.refreshList();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.actionVoucher.setEnabled(true);
        this.actionVoucher.setVisible(true);
        this.actionDelVoucher.setEnabled(true);
        this.actionDelVoucher.setVisible(true);
        this.actionTraceDown.setEnabled(true);
        this.actionTraceDown.setVisible(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InnerOverheadBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return InnerOverheadBillEditUI.class.getName();
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new InnerOverheadBillFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    public void checkStart() throws Exception {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
        this.refresh(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "InnerOverheadBill";
        param.alias = "\u8f85\u52a9\u670d\u52a1\u7ed3\u7b97";
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "InnerOverheadBill";
        param.alias = "\u8f85\u52a9\u670d\u52a1\u7ed3\u7b97";
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("input_audit");
        }
        super.auditAction_actionPerformed(e);
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        super.unauditAction_actionPerformed(e);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getBaseCurrency().getId().toString());
            CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk);
            int amountPrecision = currency.getPrecision();
            while (rowSet.next()) {
                Object[] precisions;
                Map auxPrecisionMap;
                int qtyPrecision = rowSet.getInt("auxOverhead.qtyPrecision");
                BDCMUtils.iniColumnsPrecision((int)qtyPrecision, (String)"entrys.qty", (IRowSet)rowSet);
                BDCMUtils.iniColumnsPrecision((int)amountPrecision, (String)"entrys.actualAmount", (IRowSet)rowSet);
                BDCMUtils.iniColumnsPrecision((int)amountPrecision, (String)"entrys.stdAmount", (IRowSet)rowSet);
                int pricePrecision = 6;
                String auxOverheadId = rowSet.getString("auxOverhead.id");
                if (this.rpcData.get("auxPrecisionMap") instanceof Map && (auxPrecisionMap = (Map)this.rpcData.get("auxPrecisionMap")) != null && auxPrecisionMap.get(auxOverheadId) instanceof Object[] && (precisions = (Object[])auxPrecisionMap.get(auxOverheadId))[0] instanceof Integer) {
                    pricePrecision = (Integer)precisions[0];
                }
                BDCMUtils.iniColumnsPrecision((int)pricePrecision, (String)"entrys.actualPrice", (IRowSet)rowSet);
                BDCMUtils.iniColumnsPrecision((int)pricePrecision, (String)"entrys.stdPrice", (IRowSet)rowSet);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    protected boolean isFootVisible() {
        return true;
    }
}

