/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.InputQtyBillEntryInfo;
import com.kingdee.eas.ncm.bill.InputQtyBillFactory;
import com.kingdee.eas.ncm.bill.InputQtyBillInfo;
import com.kingdee.eas.ncm.bill.InputQtyImportTypeEnum;
import com.kingdee.eas.ncm.bill.client.AbstractInputQtyBillEditUI;
import com.kingdee.eas.ncm.common.client.NCMClientVerifyHelper;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InputQtyBillEditUI
extends AbstractInputQtyBillEditUI {
    private static Logger logger = Logger.getLogger((String)InputQtyBillEditUI.class.getName());
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.InputQtyBillResource";
    protected static final String Col_CostObjectNumber = "costobject";
    protected static final String Col_CostObjectName = "costobjectName";
    protected static final String Col_OrderNumber = "order.number";
    protected static final String Col_ProjectNumber = "project.number";
    protected static final String Col_TrackNumber = "track.number";
    protected static final String Col_ProductNumber = "product.number";
    protected static final String Col_ProductName = "product.name";
    protected static final String Col_Model = "model";
    protected static final String Col_Batch = "batch";
    private final FillListener fillListener = new FillListener();
    private KDBizPromptBox prmtCostObejct = null;
    private KDBizPromptBox prmtOrder = null;
    private KDBizPromptBox prmtProduct = null;
    private DataChangeListener prmtCostObjectChangeListener = null;
    private Object oldValue = null;
    private Map modelMap = new HashMap();
    private Map precisionMap = new HashMap();
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            } else if (arg0.getKeyCode() == 10) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }
    };

    public InputQtyBillEditUI() throws Exception {
        this.kdtEntry.checkParsed();
        this.kdtEntry.getColumn(Col_ProjectNumber).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(Col_TrackNumber).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(Col_ProductName).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(Col_Batch).getStyleAttributes().setLocked(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEntries.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    InputQtyBillEditUI.this.kdtEntries_editStarting(e);
                }
                catch (Exception exc) {
                    InputQtyBillEditUI.this.handUIException(exc);
                }
            }
        });
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterOrgUnit, (String)this.getCompanyOrgInfoWithDefault().getId().toString(), (boolean)true, (boolean)true);
        this.formatEntryTable();
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.menuTable1.setEnabled(false);
        this.menuWorkflow.setEnabled(false);
        this.menuTable1.setVisible(false);
        this.menuWorkflow.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuWorkflow.setEnabled(false);
        this.menuWorkflow.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillCellAfterBillSelectedRelation();
        try {
            this.initOrderInfo();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initOrderInfo() throws Exception {
        HashSet<String> ids = new HashSet<String>();
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(Color.WHITE);
            Object value = this.kdtEntries.getRow(rowIndex).getCell(Col_CostObjectNumber).getValue();
            if (!(value instanceof CostObjectInfo)) continue;
            CostObjectInfo costObject = (CostObjectInfo)value;
            if (CalculateModeEnum.BYORDER.equals((Object)costObject.getCalculateMode()) && costObject.getOrderID() != null) {
                ids.add(costObject.getOrderID());
            }
            if (!CalculateModeEnum.BYBATCH.equals((Object)costObject.getCalculateMode())) continue;
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(new Color(252, 251, 223));
        }
        if (ids.size() > 0) {
            Map orders = CostObjectFactory.getRemoteInstance().getOrderInfo(ids);
            for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
                CostObjectInfo costObject;
                Object value = this.kdtEntries.getRow(rowIndex).getCell(Col_CostObjectNumber).getValue();
                if (!(value instanceof CostObjectInfo) || !CalculateModeEnum.BYORDER.equals((Object)(costObject = (CostObjectInfo)value).getCalculateMode()) || costObject.getOrderID() == null) continue;
                String orderID = costObject.getOrderID();
                Map orderInfo = (Map)orders.get(orderID);
                String orderNumber = "";
                String projectNumber = "";
                String trackNumber = "";
                if (orderInfo != null) {
                    orderNumber = (String)orderInfo.get("orderNumber");
                    projectNumber = (String)orderInfo.get("projectNumber");
                    trackNumber = (String)orderInfo.get("trackNumber");
                }
                ManufactureOrderInfo order = new ManufactureOrderInfo();
                order.setId(BOSUuid.read((String)orderID));
                order.setNumber(orderNumber);
                this.kdtEntries.getRow(rowIndex).getCell(Col_OrderNumber).setValue((Object)order);
                this.kdtEntries.getRow(rowIndex).getCell(Col_ProjectNumber).setValue((Object)projectNumber);
                this.kdtEntries.getRow(rowIndex).getCell(Col_TrackNumber).setValue((Object)trackNumber);
            }
            this.kdtEntries.invalidate();
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected void isStart() throws Exception {
    }

    private void formatEntryTable() {
        this.kdtEntry.checkParsed();
        KDFormattedTextField txtQty = new KDFormattedTextField();
        txtQty.setDataType(1);
        txtQty.setHorizontalAlignment(4);
        this.kdtEntry.getColumn("Qty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtQty));
        if (this.prmtCostObejct == null) {
            this.prmtCostObejct = new KDBizPromptBox();
            this.prmtCostObejct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
            CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObejct, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
            this.prmtCostObejct.setSelector((KDPromptSelector)arg0);
            this.prmtCostObejct.setEditable(true);
            this.prmtCostObejct.setDisplayFormat("$number$");
            this.prmtCostObejct.setEditFormat("$number$");
            this.prmtCostObejct.setCommitFormat("$number$");
            this.prmtCostObejct.setRequired(true);
            this.prmtCostObjectChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    InputQtyBillEditUI.this.prmtCostObjectDataChanged();
                }
            };
            this.prmtCostObejct.addDataChangeListener(this.prmtCostObjectChangeListener);
        }
        NCMClientUtils.filterCostObjectF7((KDBizPromptBox)this.prmtCostObejct, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtCostObejct);
        this.kdtEntry.getColumn(Col_CostObjectNumber).setEditor((ICellEditor)itemEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntry.getColumn(Col_CostObjectNumber).setRenderer((IBasicRender)avr);
        this.kdtEntry.getColumn(Col_CostObjectName).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn(Col_Model).getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("productionOrder").getStyleAttributes().setLocked(true);
        this.kdtEntry.getColumn("productionOrder").setRenderer((IBasicRender)avr);
        EntityViewInfo view = null;
        FilterInfo filter = null;
        this.prmtOrder = new KDBizPromptBox();
        this.prmtOrder.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrder.setVisible(true);
        this.prmtOrder.setEditable(true);
        this.prmtOrder.setDisplayFormat("$number$");
        this.prmtOrder.setEditFormat("$number$");
        this.prmtOrder.setCommitFormat("$number$");
        KDTDefaultCellEditor orderEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtOrder);
        ObjectValueRender orderRender = new ObjectValueRender();
        orderRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        try {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            HashSet<Integer> statuses = new HashSet<Integer>();
            statuses.add(5);
            statuses.add(7);
            statuses.add(8);
            statuses.add(11);
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)6));
            filter.getFilterItems().add(new FilterItemInfo("oldBaseStatus", statuses, CompareType.INCLUDE));
            Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
            if (storageOrgUnitIds.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitIds, CompareType.INCLUDE));
                filter.setMaskString("(#0 or #1 and #2) and #3");
            } else {
                filter.setMaskString("(#0 or #1 and #2)");
            }
            view.setFilter(filter);
            this.prmtOrder.getQueryAgent().resetRuntimeEntityView();
            this.prmtOrder.setEntityViewInfo(view);
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        this.kdtEntries.getColumn(Col_OrderNumber).setEditor((ICellEditor)orderEditor);
        this.kdtEntries.getColumn(Col_OrderNumber).setRenderer((IBasicRender)orderRender);
        this.prmtProduct = new KDBizPromptBox();
        this.prmtProduct.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        this.prmtProduct.setVisible(true);
        this.prmtProduct.setEditable(true);
        this.prmtProduct.setDisplayFormat("$number$");
        this.prmtProduct.setEditFormat("$number$");
        this.prmtProduct.setCommitFormat("$number$");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.createCOByOrder", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.calculateType", (Object)2));
        view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtProduct.setEntityViewInfo(view);
        try {
            this.prmtProduct = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtProduct, (FilterInfo)filter);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        KDTDefaultCellEditor productEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtProduct);
        ObjectValueRender materialRender = new ObjectValueRender();
        materialRender.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(Col_ProductNumber).setEditor((ICellEditor)productEditor);
        this.kdtEntries.getColumn(Col_ProductNumber).setRenderer((IBasicRender)materialRender);
    }

    private void fillDataAfterOrderSelect(int rowIndex) throws Exception {
        CostObjectInfo costObjectInfo;
        Object data = this.kdtEntries.getCell(rowIndex, Col_OrderNumber).getValue();
        this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Model).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Batch).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(true);
        this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(Color.WHITE);
        if (data == null) {
            return;
        }
        if (!(data instanceof ManufactureOrderInfo)) {
            this.kdtEntries.getCell(rowIndex, Col_OrderNumber).setValue(null);
            return;
        }
        ManufactureOrderInfo orderInfo = (ManufactureOrderInfo)data;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orderInfo.getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("baseStatus");
        selector.add("project.id");
        selector.add(Col_ProjectNumber);
        selector.add("trackNumber.id");
        selector.add("trackNumber.number");
        selector.add("material.id");
        selector.add("material.number");
        selector.add("material.name");
        selector.add("costObject.id");
        selector.add("costObject.number");
        selector.add("costObject.name");
        selector.add("costObject.calculateMode");
        selector.add("costObject.batchNumber");
        selector.add("costObject.company.id");
        selector.add("costObject.StdProductID.id");
        selector.add("costObject.StdProductID.number");
        selector.add("costObject.StdProductID.name");
        selector.add("costObject.StdProductID.model");
        view.setSelector(selector);
        ManufactureOrderCollection orderColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
        if (orderColl.size() == 0) {
            return;
        }
        orderInfo = orderColl.get(0);
        if (orderInfo.getProject() != null) {
            this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue((Object)orderInfo.getProject().getNumber());
        }
        if (orderInfo.getTrackNumber() != null) {
            this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue((Object)orderInfo.getTrackNumber().getNumber());
        }
        if ((costObjectInfo = orderInfo.getCostObject()) != null) {
            if (costObjectInfo.getCompany() == null || !costObjectInfo.getCompany().getId().toString().equals(this.getCompanyOrgInfoWithDefault().getId().toString())) {
                MsgBox.showInfo((String)this.getResource("CostObjectNotExistOfOrder"));
                return;
            }
            if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                return;
            }
            this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue((Object)costObjectInfo);
            this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue((Object)costObjectInfo.getName());
            this.kdtEntries.getCell(rowIndex, Col_Batch).setValue((Object)costObjectInfo.getBatchNumber());
            if (costObjectInfo.getStdProductID() != null) {
                MaterialInfo materialInfo = costObjectInfo.getStdProductID();
                this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                this.kdtEntries.getCell(rowIndex, Col_Model).setValue((Object)materialInfo.getModel());
            }
            this.updateModelAndPrecision(this.kdtEntries.getRow(rowIndex), costObjectInfo.getStdProductID().getId().toString());
            if (CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
                this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(false);
                this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(new Color(252, 251, 223));
            } else {
                this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(true);
                this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(Color.WHITE);
            }
            return;
        }
        if (orderInfo.getMaterial() == null) {
            return;
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)orderInfo.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        view.setFilter(filter);
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("createCOByOrder");
        view.setSelector(selector);
        MaterialCompanyInfoCollection mcColl = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(view);
        if (mcColl.size() == 0) {
            MsgBox.showInfo((String)this.getResource("MaterialNotAudited"));
            return;
        }
        MaterialCompanyInfoInfo mcInfo = mcColl.get(0);
        if (mcInfo.isCreateCOByOrder()) {
            if (BillBaseStatusEnum.RELEASED.equals((Object)orderInfo.getBaseStatus()) || BillBaseStatusEnum.CLOSED.equals((Object)orderInfo.getBaseStatus()) || BillBaseStatusEnum.COMPLETE.equals((Object)orderInfo.getBaseStatus()) || BillBaseStatusEnum.FINCLOSED.equals((Object)orderInfo.getBaseStatus())) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orderInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)7));
                filter.getFilterItems().add(new FilterItemInfo("orderID", (Object)orderInfo.getId().toString()));
                view.setFilter(filter);
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                selector.add("batchNumber");
                selector.add("StdProductID.id");
                selector.add("StdProductID.number");
                selector.add("StdProductID.name");
                selector.add("StdProductID.model");
                view.setSelector(selector);
                CostObjectCollection coColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
                if (coColl.size() == 0) {
                    MsgBox.showInfo((String)this.getResource("NoOrderCostObjectOfMaterial"));
                    return;
                }
                costObjectInfo = coColl.get(0);
                if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                    MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                    return;
                }
                this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue((Object)costObjectInfo);
                this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue((Object)costObjectInfo.getName());
                this.kdtEntries.getCell(rowIndex, Col_Batch).setValue((Object)costObjectInfo.getBatchNumber());
                if (costObjectInfo.getStdProductID() != null) {
                    MaterialInfo materialInfo = costObjectInfo.getStdProductID();
                    this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                    this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                    this.kdtEntries.getCell(rowIndex, Col_Model).setValue((Object)materialInfo.getModel());
                }
                this.updateModelAndPrecision(this.kdtEntries.getRow(rowIndex), costObjectInfo.getStdProductID().getId().toString());
                return;
            }
            MsgBox.showInfo((String)this.getResource("OrderNotReleased"));
            return;
        }
        MaterialInfo materialInfo = orderInfo.getMaterial();
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)Boolean.FALSE));
        HashSet<Integer> modes = new HashSet<Integer>();
        modes.add(1);
        modes.add(3);
        modes.add(4);
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", modes, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)3));
        StringBuffer ksql = new StringBuffer();
        ksql.append("select ");
        ksql.append("    FParentID ");
        ksql.append("from T_BD_CostObjectEntry ");
        ksql.append("where FRelatedID = '" + materialInfo.getId().toString() + "'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ksql.toString(), CompareType.INNER));
        filter.setMaskString("#0 and #1 and #2 and (#3 or (#4 and #5))");
        view.setFilter(filter);
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("batchNumber");
        selector.add("calculateMode");
        selector.add("StdProductID.id");
        selector.add("StdProductID.number");
        selector.add("StdProductID.name");
        selector.add("StdProductID.model");
        view.setSelector(selector);
        CostObjectCollection coColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
        if (coColl.size() == 0) {
            MsgBox.showInfo((String)this.getResource("NoCostObjectOfMaterial"));
            return;
        }
        costObjectInfo = coColl.get(0);
        if (CalculateModeEnum.BYCLASS.equals((Object)costObjectInfo.getCalculateMode()) || CalculateModeEnum.VARIET.equals((Object)costObjectInfo.getCalculateMode())) {
            if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                return;
            }
            this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue((Object)costObjectInfo);
            this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue((Object)costObjectInfo.getName());
            this.kdtEntries.getCell(rowIndex, Col_Batch).setValue((Object)costObjectInfo.getBatchNumber());
            if (costObjectInfo.getStdProductID() != null) {
                materialInfo = costObjectInfo.getStdProductID();
                this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                this.kdtEntries.getCell(rowIndex, Col_Model).setValue((Object)materialInfo.getModel());
                this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(true);
                this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(Color.WHITE);
            }
            this.updateModelAndPrecision(this.kdtEntries.getRow(rowIndex), costObjectInfo.getStdProductID().getId().toString());
        } else if (CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
            if (coColl.size() == 1) {
                if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                    MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                    return;
                }
                this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue((Object)costObjectInfo);
                this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue((Object)costObjectInfo.getName());
                this.kdtEntries.getCell(rowIndex, Col_Batch).setValue((Object)costObjectInfo.getBatchNumber());
                if (costObjectInfo.getStdProductID() != null) {
                    materialInfo = costObjectInfo.getStdProductID();
                    this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                    this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                    this.kdtEntries.getCell(rowIndex, Col_Model).setValue((Object)materialInfo.getModel());
                }
                this.updateModelAndPrecision(this.kdtEntries.getRow(rowIndex), costObjectInfo.getStdProductID().getId().toString());
            } else if (costObjectInfo.getStdProductID() != null) {
                materialInfo = costObjectInfo.getStdProductID();
                this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                this.kdtEntries.getCell(rowIndex, Col_Model).setValue((Object)materialInfo.getModel());
            }
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(new Color(252, 251, 223));
        }
    }

    private void fillDataAfterProductSelect(int rowIndex) throws Exception {
        Object data = this.kdtEntries.getCell(rowIndex, Col_ProductNumber).getValue();
        this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_OrderNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Model).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Batch).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(true);
        this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(Color.WHITE);
        if (data == null) {
            return;
        }
        if (!(data instanceof MaterialInfo)) {
            return;
        }
        MaterialInfo materialInfo = (MaterialInfo)data;
        this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
        this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
        this.kdtEntries.getCell(rowIndex, Col_Model).setValue((Object)materialInfo.getModel());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)Boolean.FALSE));
        HashSet<Integer> modes = new HashSet<Integer>();
        modes.add(1);
        modes.add(3);
        modes.add(4);
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", modes, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)3));
        StringBuffer ksql = new StringBuffer();
        ksql.append("select ");
        ksql.append("    FParentID ");
        ksql.append("from T_BD_CostObjectEntry ");
        ksql.append("where FRelatedID = '" + materialInfo.getId().toString() + "'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ksql.toString(), CompareType.INNER));
        filter.setMaskString("#0 and #1 and #2 and (#3 or (#4 and #5))");
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("batchNumber");
        selector.add("calculateMode");
        selector.add("StdProductID.id");
        selector.add("StdProductID.number");
        selector.add("StdProductID.name");
        selector.add("StdProductID.model");
        view.setSelector(selector);
        CostObjectCollection coColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
        if (coColl.size() == 0) {
            MsgBox.showInfo((String)this.getResource("CostObjectNotExistOfMaterial"));
            return;
        }
        CostObjectInfo costObjectInfo = coColl.get(0);
        if (CalculateModeEnum.BYCLASS.equals((Object)costObjectInfo.getCalculateMode()) || CalculateModeEnum.VARIET.equals((Object)costObjectInfo.getCalculateMode())) {
            if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                return;
            }
            this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue((Object)costObjectInfo);
            this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue((Object)costObjectInfo.getName());
            this.kdtEntries.getCell(rowIndex, Col_Batch).setValue((Object)costObjectInfo.getBatchNumber());
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(Color.WHITE);
            this.updateModelAndPrecision(this.kdtEntries.getRow(rowIndex), costObjectInfo.getStdProductID().getId().toString());
        } else if (CalculateModeEnum.BYBATCH.equals((Object)costObjectInfo.getCalculateMode())) {
            if (coColl.size() == 1) {
                if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
                    MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
                    return;
                }
                this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue((Object)costObjectInfo);
                this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue((Object)costObjectInfo.getName());
                this.kdtEntries.getCell(rowIndex, Col_Batch).setValue((Object)costObjectInfo.getBatchNumber());
                this.updateModelAndPrecision(this.kdtEntries.getRow(rowIndex), costObjectInfo.getStdProductID().getId().toString());
            }
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(new Color(252, 251, 223));
        }
    }

    private void fillDataAfterBatchSelect(int rowIndex) throws Exception {
        this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue(null);
        Object data = this.kdtEntries.getCell(rowIndex, Col_Batch).getValue();
        String batch = data != null ? data.toString() : null;
        data = this.kdtEntries.getCell(rowIndex, Col_ProductNumber).getValue();
        MaterialInfo materialInfo = null;
        if (!(data instanceof MaterialInfo)) {
            return;
        }
        materialInfo = (MaterialInfo)data;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isForbiden", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("StdProductID.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculateMode", (Object)4));
        filter.getFilterItems().add(new FilterItemInfo("batchNumber", (Object)batch));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("batchNumber");
        view.setSelector(selector);
        CostObjectCollection coColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
        if (coColl.size() == 0) {
            this.kdtEntries.getCell(rowIndex, Col_Batch).setValue(null);
            MsgBox.showInfo((String)this.getResource("CostObjectNotExistOfMaterialAndBatch", new Object[]{materialInfo.getNumber(), batch == null ? "" : batch}));
            return;
        }
        CostObjectInfo costObjectInfo = coColl.get(0);
        if (this.isCostObjectExists(costObjectInfo.getId().toString())) {
            MsgBox.showInfo((String)this.getResource("CostObjectHasSet"));
            return;
        }
        this.kdtEntries.getCell(rowIndex, Col_CostObjectNumber).setValue((Object)costObjectInfo);
        this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue((Object)costObjectInfo.getName());
        this.updateModelAndPrecision(this.kdtEntries.getRow(rowIndex), materialInfo.getId().toString());
    }

    public boolean isCostObjectExists(String costObjectID) throws Exception {
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            CostObjectInfo costObject = (CostObjectInfo)this.kdtEntry.getRow(i).getCell(Col_CostObjectNumber).getValue();
            if (costObject == null || !costObjectID.equals(costObject.getId().toString())) continue;
            return true;
        }
        return false;
    }

    private void prmtCostObjectDataChanged() {
        int rowIndex = this.kdtEntry.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntry.getRow(rowIndex);
        Object newValue = this.prmtCostObejct.getData();
        if (newValue == this.oldValue) {
            return;
        }
        boolean includeOverhead = false;
        ArrayList<Object> costObjects = new ArrayList<Object>();
        if (newValue instanceof CostObjectInfo) {
            costObjects.add(newValue);
            if (CORelatedType.Overhead.equals((Object)((CostObjectInfo)newValue).getRelatedType())) {
                includeOverhead = true;
            }
        } else if (newValue instanceof Object[]) {
            Object[] temp = (Object[])newValue;
            for (int i = 0; i < temp.length; ++i) {
                if (temp[i] == null || !(temp[i] instanceof CostObjectInfo)) continue;
                costObjects.add(temp[i]);
                if (!CORelatedType.Overhead.equals((Object)((CostObjectInfo)temp[i]).getRelatedType())) continue;
                includeOverhead = true;
                break;
            }
        } else {
            row.getCell(Col_CostObjectName).setValue(null);
            row.getCell(Col_Model).setValue(null);
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("Qty"), (int)4);
            try {
                this.fillDataAfterCostObjectSelect(rowIndex, null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            return;
        }
        if (includeOverhead) {
            this.prmtCostObejct.removeDataChangeListener(this.prmtCostObjectChangeListener);
            this.prmtCostObejct.setData(this.oldValue);
            row.getCell(Col_CostObjectNumber).setValue(this.oldValue);
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"91_InputQtyBillEditUI"));
            this.prmtCostObejct.addDataChangeListener(this.prmtCostObjectChangeListener);
            return;
        }
        CostObjectInfo costObject = null;
        HashSet<String> selectedOldCostObjectIds = new HashSet<String>();
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            costObject = (CostObjectInfo)this.kdtEntry.getRow(i).getCell(Col_CostObjectNumber).getValue();
            if (costObject == null) continue;
            selectedOldCostObjectIds.add(costObject.getId().toString());
        }
        boolean selectedOld = false;
        for (int i = costObjects.size() - 1; i >= 0; --i) {
            String costObjectId = ((CostObjectInfo)costObjects.get(i)).getId().toString();
            if (!selectedOld && this.oldValue != null && this.oldValue instanceof CostObjectInfo && costObjectId.equals(((CostObjectInfo)this.oldValue).getId().toString())) {
                selectedOld = true;
            }
            if (!selectedOldCostObjectIds.contains(costObjectId)) continue;
            costObjects.remove(i);
        }
        if (costObjects.size() > 0 || selectedOld || !selectedOld && costObjects.size() == 0) {
            this.prmtCostObejct.removeDataChangeListener(this.prmtCostObjectChangeListener);
            if (selectedOld || !selectedOld && costObjects.size() == 0) {
                this.prmtCostObejct.setData(this.oldValue);
                row.getCell(Col_CostObjectNumber).setValue(this.oldValue);
            }
            try {
                int newIndex = -1;
                for (int i = 0; i < costObjects.size(); ++i) {
                    IRow newRow = null;
                    if (i == 0) {
                        if (selectedOld) {
                            newIndex = rowIndex + 1;
                            newRow = this.insertRow(newIndex);
                        } else {
                            newIndex = rowIndex;
                            newRow = row;
                        }
                    } else {
                        newRow = this.insertRow(newIndex);
                    }
                    CostObjectInfo info = (CostObjectInfo)costObjects.get(i);
                    newRow.getCell(Col_CostObjectNumber).setValue((Object)info);
                    newRow.getCell(Col_CostObjectName).setValue((Object)info.getName());
                    String materialId = null;
                    if (info.getStdProductID() != null && CORelatedType.Product.equals((Object)info.getRelatedType())) {
                        materialId = info.getStdProductID().getId().toString();
                    }
                    this.updateModelAndPrecision(newRow, materialId);
                    this.fillDataAfterCostObjectSelect(newIndex, info);
                    ++newIndex;
                }
            }
            catch (EASBizException e1) {
                logger.error((Object)"", (Throwable)e1);
            }
            catch (Exception e1) {
                logger.error((Object)"", (Throwable)e1);
            }
            this.prmtCostObejct.addDataChangeListener(this.prmtCostObjectChangeListener);
        }
    }

    private void updateModelAndPrecision(IRow newRow, String materialId) throws EASBizException, BOSException {
        if (materialId != null) {
            String model = "";
            int precision = 0;
            if (this.modelMap.containsKey(materialId) && this.precisionMap.containsKey(materialId)) {
                model = (String)this.modelMap.get(materialId);
                precision = (Integer)this.precisionMap.get(materialId);
            } else {
                Map modelAndPrecision = InputQtyBillFactory.getRemoteInstance().getMatModelAndPrecision(materialId);
                model = (String)modelAndPrecision.get(Col_Model);
                Integer prec = (Integer)modelAndPrecision.get("precision");
                precision = prec;
                this.modelMap.put(materialId, model);
                this.precisionMap.put(materialId, prec);
            }
            newRow.getCell(Col_Model).setValue((Object)model);
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)newRow.getCell("Qty"), (int)precision);
        } else {
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)newRow.getCell("Qty"), (int)4);
        }
    }

    private void fillDataAfterCostObjectSelect(int rowIndex, Object data) throws Exception {
        this.kdtEntries.getCell(rowIndex, Col_OrderNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Model).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Batch).setValue(null);
        this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(true);
        this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(Color.WHITE);
        if (data instanceof CostObjectInfo) {
            SelectorItemCollection selector;
            FilterInfo filter;
            EntityViewInfo view;
            CostObjectInfo costObject = (CostObjectInfo)data;
            this.kdtEntries.getCell(rowIndex, Col_CostObjectName).setValue((Object)costObject.getName());
            this.kdtEntries.getCell(rowIndex, Col_Batch).setValue((Object)costObject.getBatchNumber());
            if (CalculateModeEnum.BYORDER.equals((Object)costObject.getCalculateMode()) && costObject.getOrderID() != null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObject.getOrderID()));
                view.setFilter(filter);
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("project.id");
                selector.add(Col_ProjectNumber);
                selector.add("trackNumber.id");
                selector.add("trackNumber.number");
                view.setSelector(selector);
                ManufactureOrderCollection orderColl = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderCollection(view);
                if (orderColl.size() > 0) {
                    ManufactureOrderInfo orderInfo = orderColl.get(0);
                    this.kdtEntries.getCell(rowIndex, Col_OrderNumber).setValue((Object)orderInfo);
                    if (orderInfo.getProject() != null) {
                        this.kdtEntries.getCell(rowIndex, Col_ProjectNumber).setValue((Object)orderInfo.getProject().getNumber());
                    }
                    if (orderInfo.getTrackNumber() != null) {
                        this.kdtEntries.getCell(rowIndex, Col_TrackNumber).setValue((Object)orderInfo.getTrackNumber().getNumber());
                    }
                }
            }
            if (costObject.getStdProductID() != null) {
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)costObject.getStdProductID().getId().toString()));
                view.setFilter(filter);
                selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                selector.add(Col_Model);
                view.setSelector(selector);
                MaterialCollection matColl = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
                if (matColl.size() > 0) {
                    MaterialInfo materialInfo = matColl.get(0);
                    this.kdtEntries.getCell(rowIndex, Col_ProductNumber).setValue((Object)materialInfo);
                    this.kdtEntries.getCell(rowIndex, Col_ProductName).setValue((Object)materialInfo.getName());
                    this.kdtEntries.getCell(rowIndex, Col_Model).setValue((Object)materialInfo.getModel());
                }
            }
            if (CalculateModeEnum.BYBATCH.equals((Object)costObject.getCalculateMode())) {
                this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setLocked(false);
                this.kdtEntries.getCell(rowIndex, Col_Batch).getStyleAttributes().setBackground(new Color(252, 251, 223));
            }
        }
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell("Qty"), (int)4);
        super.loadLineFields(table, row, obj);
    }

    protected IRow insertRow(int rowIndex) {
        IRow irow = null;
        KDTable kdtEntries = this.getDetailTable();
        if (kdtEntries == null) {
            return irow;
        }
        IObjectValue detailData = this.createNewDetailData(kdtEntries);
        irow = kdtEntries.addRow(rowIndex);
        this.loadLineFields(kdtEntries, irow, detailData);
        this.afterInsertLine(kdtEntries, detailData);
        return irow;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        InputQtyBillEntryInfo entry = new InputQtyBillEntryInfo();
        entry.setQty(SysConstant.BIGZERO);
        return entry;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifySubmit();
        super.actionSubmit_actionPerformed(e);
        if (this.comboBillStatus.getSelectedItem() != null && this.comboBillStatus.getSelectedItem().toString().equals(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"157_InitBalanceEditUI_Audit"))) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        if (this.chkMenuItemSubmitAndAddNew.isSelected() && OprtState.ADDNEW.equals(this.getOprtState())) {
            super.addLine(this.kdtEntries);
        }
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("input_audit");
        }
        super.auditAction_actionPerformed(e);
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkAuditPermission("input_unaudit");
        super.unauditAction_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, (IObjectPK)new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId().toString()), (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    public void verifySubmit() throws Exception {
        NCMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCostCenterOrgUnit);
        NCMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTable)this.kdtEntry);
        int m = this.kdtEntry.getRowCount();
        boolean onlyone = false;
        while (m-- > 0) {
            IRow row = this.kdtEntry.getRow(m);
            if (row.getCell(Col_CostObjectNumber).getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"0_ActualHourEditUI"));
                SysUtil.abort();
            }
            if (row.getCell("Qty").getValue() != null && ((BigDecimal)row.getCell("Qty").getValue()).compareTo(SysConstant.BIGZERO) != 0) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"90_InputQtyBillEditUI"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        InputQtyBillInfo info = new InputQtyBillInfo();
        info.setImportType(InputQtyImportTypeEnum.manual);
        super.applyBillDefaultValue((IObjectValue)info);
        return info;
    }

    public void kdtEntries_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        this.oldValue = this.kdtEntries.getRow(rowIndex).getCell(colIndex).getValue();
    }

    @Override
    protected void kdtEntry_editStopped(KDTEditEvent e) throws Exception {
        super.kdtEntry_editStopped(e);
        int colOrderIndex = this.kdtEntries.getCell(e.getRowIndex(), Col_OrderNumber).getColumnIndex();
        if (e.getColIndex() == colOrderIndex && e.getValue() != this.oldValue) {
            this.fillDataAfterOrderSelect(e.getRowIndex());
        }
        int colProductIndex = this.kdtEntries.getCell(e.getRowIndex(), Col_ProductNumber).getColumnIndex();
        if (e.getColIndex() == colProductIndex && e.getValue() != this.oldValue) {
            if (e.getValue() instanceof MaterialInfo) {
                MaterialInfo materialInfo = (MaterialInfo)e.getValue();
                this.kdtEntries.getCell(e.getRowIndex(), Col_ProductName).setValue((Object)materialInfo.getName());
                this.actionSave.setEnabled(true);
            } else if (e.getValue() == null) {
                this.kdtEntries.getCell(e.getRowIndex(), Col_ProductName).setValue((Object)"");
            }
            this.fillDataAfterProductSelect(e.getRowIndex());
        }
        int colBatchIndex = this.kdtEntries.getCell(e.getRowIndex(), Col_Batch).getColumnIndex();
        if (!(e.getColIndex() != colBatchIndex || this.isValueEquals(e.getValue()) && this.kdtEntries.getCell(e.getRowIndex(), Col_CostObjectNumber).getValue() != null)) {
            this.fillDataAfterBatchSelect(e.getRowIndex());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InputQtyBillFactory.getRemoteInstance();
    }

    protected void fillCellAfterBillSelectedRelation() {
        IRow curRow;
        int i;
        int m = this.kdtEntry.getRowCount();
        HashSet<String> paramSet = new HashSet<String>();
        for (i = 0; i < m; ++i) {
            String materialId;
            CostObjectInfo info;
            curRow = this.kdtEntry.getRow(i);
            if (curRow.getCell(Col_CostObjectNumber).getValue() == null || (info = (CostObjectInfo)curRow.getCell(Col_CostObjectNumber).getValue()).getStdProductID() == null || this.precisionMap.containsKey(materialId = info.getStdProductID().getId().toString())) continue;
            paramSet.add(materialId);
        }
        if (paramSet.size() > 0) {
            try {
                Map precMap = InputQtyBillFactory.getRemoteInstance().getMatMultUnitPrecition(paramSet);
                if (precMap != null && precMap.size() > 0) {
                    this.precisionMap.putAll(precMap);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        for (i = 0; i < m; ++i) {
            String materialId;
            CostObjectInfo info;
            curRow = this.kdtEntry.getRow(i);
            int precision = 4;
            if (curRow.getCell(Col_CostObjectNumber).getValue() != null && (info = (CostObjectInfo)curRow.getCell(Col_CostObjectNumber).getValue()).getStdProductID() != null && CORelatedType.Product.equals((Object)info.getRelatedType()) && this.precisionMap.containsKey(materialId = info.getStdProductID().getId().toString())) {
                precision = Integer.parseInt(this.precisionMap.get(materialId).toString());
            }
            NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)curRow.getCell("Qty"), (int)precision);
        }
    }

    protected void initListener() {
        super.initListener();
        this.kdtEntry.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
        this.kdtEntry.addKeyListener(this.keyListener);
    }

    private boolean isValueEquals(Object newValue) {
        if (this.oldValue == null && newValue == null) {
            return true;
        }
        if (this.oldValue == null || newValue == null) {
            return false;
        }
        if (newValue instanceof String) {
            return ((String)newValue).trim().equals(this.oldValue.toString().trim());
        }
        return false;
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    protected String getResource(String resName) {
        return this.getResource(resName, null);
    }

    protected String getResource(String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(EASResource.getString((String)RES_CLASSNAME, (String)resName), params);
        }
        return EASResource.getString((String)RES_CLASSNAME, (String)resName);
    }

    public final class FillListener
    implements KDTDataFillListener {
        public void afterDataFill(KDTDataRequestEvent e) {
            InputQtyBillEditUI.this.kdtEntry.checkParsed();
            this.fillTable(InputQtyBillEditUI.this.kdtEntry, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                ICell cell = tblMain.getRow(i).getCell("Qty");
                if (cell != null) {
                    cell.setValue((Object)String.valueOf(false));
                }
                try {
                    NCMClientUtils.changeTableColPrecisionByCostObject((CostObjectInfo)((CostObjectInfo)tblMain.getRow(i).getCell(InputQtyBillEditUI.Col_CostObjectNumber).getValue()), (KDTable)tblMain, (String[])new String[]{"Qty"}, (int)i);
                    continue;
                }
                catch (EASBizException e1) {
                    logger.error((Object)"", (Throwable)e1);
                    continue;
                }
                catch (BOSException e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        }
    }
}

