/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.client.MaterialF7TreeListSelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.bill.InputQtyBillFilterParam;
import com.kingdee.eas.ncm.bill.InputQtyBillInfo;
import com.kingdee.eas.ncm.bill.client.AbstractActualHourFilterUI;
import com.kingdee.eas.ncm.bill.client.AbstractInputQtyBillFilterUI;
import com.kingdee.eas.ncm.bill.client.ActualHourFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class InputQtyBillFilterUI
extends AbstractActualHourFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ActualHourFilterUI.class);
    protected KDLabelContainer kDLabelContainer11;
    protected KDLabelContainer kDLabelContainer14;
    protected KDLabelContainer kDLabelContainer15;
    protected KDLabelContainer kDLabelContainer16;
    protected KDLabelContainer kDLabelContainer17;
    protected KDLabelContainer kDLabelContainer18;
    protected KDLabelContainer kDLabelContainer19;
    protected KDLabelContainer kDLabelContainer20;
    protected KDLabelContainer kDLabelContainer21;
    protected KDLabelContainer kDLabelContainer22;
    protected KDBizPromptBox prmtOrderFrom;
    protected KDBizPromptBox prmtProjectFrom;
    protected KDBizPromptBox prmtTrackFrom;
    protected KDBizPromptBox prmtProductFrom;
    protected KDBizPromptBox prmtOrderTo;
    protected KDBizPromptBox prmtProjectTo;
    protected KDBizPromptBox prmtTrackTo;
    protected KDBizPromptBox prmtProductTo;
    protected KDTextField tfBatchFrom;
    protected KDTextField tfBatchTo;
    private static final int PERIOD_MAX_MONTH = 12;
    private String InputQtyBillInfoFrom = "InputQtyBillInfoFrom";
    private String InputQtyBillInfoTo = "InputQtyBillInfoTo";
    private String BizDateFrom = "bizDateFrom";
    private String BizDateTo = "bizDateTo";
    private String PeriodFrom = "periodFrom";
    private String PeriodTo = "periodTo";
    private String CostCenterFrom = "costCenterFrom";
    private String CostCenterTo = "costCenterTo";
    private String CostObjectFrom = "costObjectFrom";
    private String CostObjectTo = "costObjectTo";
    private String orderFrom = "orderFrom";
    private String orderTo = "orderTo";
    private String projectFrom = "projectFrom";
    private String projectTo = "projectTo";
    private String trackFrom = "trackFrom";
    private String trackTo = "trackTo";
    private String productFrom = "productFrom";
    private String productTo = "productTo";
    private String batchFrom = "batchFrom";
    private String batchTo = "batchTo";
    private String BillSate = "billSate";
    private PeriodInfo periodStart;
    private PeriodInfo periodCur;

    public InputQtyBillFilterUI() throws Exception {
        this.jbInit();
        this.init();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.formatUI();
    }

    private void formatUI() throws Exception {
        CompanyOrgUnitInfo comp = this.getCompanyOrgInfoWithDefault();
        this.initCompany(comp);
        this.initBizDate(this.dpBizDateFrom);
        this.initBizDate(this.dpBizDateTo);
        this.initPeriod();
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prtCostObjectFrom, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, comp.getId().toString());
        this.prtCostObjectFrom.setSelector((KDPromptSelector)arg0);
        CostObjectF7UISelector arg1 = new CostObjectF7UISelector((Object)this, this.prtCostObjectTo, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, comp.getId().toString());
        this.prtCostObjectTo.setSelector((KDPromptSelector)arg1);
    }

    protected void init() {
        this.prmtOrderFrom.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrderFrom.setDisplayFormat("$number$");
        this.prmtOrderFrom.setEditFormat("$number$");
        this.prmtOrderFrom.setCommitFormat("$number$");
        this.prmtOrderTo.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtOrderTo.setDisplayFormat("$number$");
        this.prmtOrderTo.setEditFormat("$number$");
        this.prmtOrderTo.setCommitFormat("$number$");
        this.prmtProjectFrom.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
        this.prmtProjectFrom.setDisplayFormat("$number$");
        this.prmtProjectFrom.setEditFormat("$number$");
        this.prmtProjectFrom.setCommitFormat("$number$");
        this.prmtProjectTo.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
        this.prmtProjectTo.setDisplayFormat("$number$");
        this.prmtProjectTo.setEditFormat("$number$");
        this.prmtProjectTo.setCommitFormat("$number$");
        this.prmtTrackFrom.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        this.prmtTrackFrom.setDisplayFormat("$number$");
        this.prmtTrackFrom.setEditFormat("$number$");
        this.prmtTrackFrom.setCommitFormat("$number$");
        this.prmtTrackTo.setQueryInfo("com.kingdee.eas.mm.basedata.app.TrackNumberQuery");
        this.prmtTrackTo.setDisplayFormat("$number$");
        this.prmtTrackTo.setEditFormat("$number$");
        this.prmtTrackTo.setCommitFormat("$number$");
        this.prmtProductFrom.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        this.prmtProductFrom.setDisplayFormat("$number$");
        this.prmtProductFrom.setEditFormat("$number$");
        this.prmtProductFrom.setCommitFormat("$number$");
        this.prmtProductTo.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        this.prmtProductTo.setDisplayFormat("$number$");
        this.prmtProductTo.setEditFormat("$number$");
        this.prmtProductTo.setCommitFormat("$number$");
    }

    private void initPeriod() throws EASBizException, BOSException {
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        if (this.periodStart == null || this.periodCur == null) {
            return;
        }
        int minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initFromPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
    }

    public InputQtyBillFilterParam getFilterParam() {
        InputQtyBillFilterParam filterParam = (InputQtyBillFilterParam)this.createNewFilterParam();
        this.storeFilterParam((NCMIFilterParam)filterParam);
        return filterParam;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new InputQtyBillFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof InputQtyBillFilterParam)) {
            return;
        }
        InputQtyBillFilterParam fp = (InputQtyBillFilterParam)filterParam;
        InputQtyBillInfo bnFrom = null;
        InputQtyBillInfo bnTo = null;
        String inputQtyBillFromData = customerParams.getCustomerParam(this.InputQtyBillInfoFrom);
        String inputQtyBillToData = customerParams.getCustomerParam(this.InputQtyBillInfoTo);
        if (inputQtyBillFromData != null && inputQtyBillFromData.length() > 0) {
            bnFrom = new InputQtyBillInfo();
            bnFrom.setId(BOSUuid.read((String)inputQtyBillFromData));
        }
        if (inputQtyBillToData != null && inputQtyBillToData.length() > 0) {
            bnTo = new InputQtyBillInfo();
            bnTo.setId(BOSUuid.read((String)inputQtyBillToData));
        }
        fp.setInputQtyBillInfoFrom(bnFrom);
        fp.setInputQtyBillInfoTo(bnTo);
        String bizDateFromData = customerParams.getCustomerParam(this.BizDateFrom);
        String bizDateToData = customerParams.getCustomerParam(this.BizDateTo);
        fp.setBizDateFrom(Long.parseLong(bizDateFromData));
        fp.setBizDateTo(Long.parseLong(bizDateToData));
        String periodFromData = customerParams.getCustomerParam(this.PeriodFrom);
        String periodToData = customerParams.getCustomerParam(this.PeriodTo);
        fp.setPeriodFrom(periodFromData);
        fp.setPeriodTo(periodToData);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        String costCenterFromData = customerParams.getCustomerParam(this.CostCenterFrom);
        String costCenterToData = customerParams.getCustomerParam(this.CostCenterTo);
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            ccTo = new CostCenterOrgUnitInfo();
            ccTo.setId(BOSUuid.read((String)costCenterToData));
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
        CostObjectInfo cbFrom = null;
        CostObjectInfo cbTo = null;
        String costObjectFromData = customerParams.getCustomerParam(this.CostObjectFrom);
        String costObjectToData = customerParams.getCustomerParam(this.CostObjectTo);
        if (costObjectFromData != null && costObjectFromData.length() > 0) {
            cbFrom = new CostObjectInfo();
            cbFrom.setId(BOSUuid.read((String)costObjectFromData));
        }
        if (costObjectToData != null && costObjectToData.length() > 0) {
            cbTo = new CostObjectInfo();
            cbTo.setId(BOSUuid.read((String)costObjectToData));
        }
        fp.setCostObjectFrom(cbFrom);
        fp.setCostObjectTo(cbTo);
        ManufactureOrderInfo orderFromInfo = null;
        ManufactureOrderInfo orderToInfo = null;
        String orderFromData = customerParams.getCustomerParam(this.orderFrom);
        String orderToData = customerParams.getCustomerParam(this.orderTo);
        if (orderFromData != null && orderFromData.length() > 0) {
            orderFromInfo = new ManufactureOrderInfo();
            orderFromInfo.setId(BOSUuid.read((String)orderFromData));
        }
        if (orderToData != null && orderToData.length() > 0) {
            orderToInfo = new ManufactureOrderInfo();
            orderToInfo.setId(BOSUuid.read((String)orderToData));
        }
        fp.setOrderFrom(orderFromInfo);
        fp.setOrderTo(orderToInfo);
        ProjectInfo projectFromInfo = null;
        ProjectInfo projectToInfo = null;
        String projectFromData = customerParams.getCustomerParam(this.projectFrom);
        String projectToData = customerParams.getCustomerParam(this.projectTo);
        if (projectFromData != null && projectFromData.length() > 0) {
            projectFromInfo = new ProjectInfo();
            projectFromInfo.setId(BOSUuid.read((String)projectFromData));
        }
        if (projectToData != null && projectToData.length() > 0) {
            projectToInfo = new ProjectInfo();
            projectToInfo.setId(BOSUuid.read((String)projectToData));
        }
        fp.setProjectFrom(projectFromInfo);
        fp.setProjectTo(projectToInfo);
        TrackNumberInfo trackFromInfo = null;
        TrackNumberInfo trackToInfo = null;
        String trackFromData = customerParams.getCustomerParam(this.trackFrom);
        String trackToData = customerParams.getCustomerParam(this.trackTo);
        if (trackFromData != null && trackFromData.length() > 0) {
            trackFromInfo = new TrackNumberInfo();
            trackFromInfo.setId(BOSUuid.read((String)trackFromData));
        }
        if (trackToData != null && trackToData.length() > 0) {
            trackToInfo = new TrackNumberInfo();
            trackToInfo.setId(BOSUuid.read((String)trackToData));
        }
        fp.setTrackFrom(trackFromInfo);
        fp.setTrackTo(trackToInfo);
        MaterialInfo productFromInfo = null;
        MaterialInfo productToInfo = null;
        String productFromData = customerParams.getCustomerParam(this.productFrom);
        String productToData = customerParams.getCustomerParam(this.productTo);
        if (productFromData != null && productFromData.length() > 0) {
            productFromInfo = new MaterialInfo();
            productFromInfo.setId(BOSUuid.read((String)productFromData));
        }
        if (productToData != null && productToData.length() > 0) {
            productToInfo = new MaterialInfo();
            productToInfo.setId(BOSUuid.read((String)productToData));
        }
        fp.setProductFrom(productFromInfo);
        fp.setProductTo(productToInfo);
        String batchFromData = customerParams.getCustomerParam(this.batchFrom);
        String batchToData = customerParams.getCustomerParam(this.batchTo);
        fp.setBatchFrom(batchFromData);
        fp.setBatchTo(batchToData);
        String schemeState = customerParams.getCustomerParam(this.BillSate);
        if (schemeState != null && schemeState.length() > 0) {
            fp.setBillSate(schemeState);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        int temp;
        int minPeriod;
        if (!(filterParam instanceof InputQtyBillFilterParam)) {
            return;
        }
        InputQtyBillFilterParam fp = (InputQtyBillFilterParam)filterParam;
        this.prtBillNumFrom.setData((Object)fp.getInputQtyBillInfoFrom());
        this.prtBillNumTo.setData((Object)fp.getInputQtyBillInfoTo());
        if (fp.getBizDateFrom() == 0L) {
            this.dpBizDateFrom.setValue(null);
        } else {
            this.dpBizDateFrom.setValue((Object)new Date(fp.getBizDateFrom()));
        }
        if (fp.getBizDateTo() == 0L) {
            this.dpBizDateTo.setValue(null);
        } else {
            this.dpBizDateTo.setValue((Object)new Date(fp.getBizDateTo()));
        }
        int initFromPeriod = minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        if (fp.getPeriodFrom() != null && (temp = Integer.parseInt(fp.getPeriodFrom())) >= minPeriod) {
            initFromPeriod = temp;
        }
        if (fp.getPeriodTo() != null && (temp = Integer.parseInt(fp.getPeriodTo())) >= initFromPeriod) {
            initToPeriod = temp;
        }
        if (initToPeriod < initFromPeriod) {
            initToPeriod = initFromPeriod;
        }
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
        this.prtCostcenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prtCostcenterTo.setData((Object)fp.getCostCenterTo());
        this.prtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prtCostObjectTo.setData((Object)fp.getCostObjectTo());
        this.prmtOrderFrom.setData((Object)fp.getOrderFrom());
        this.prmtOrderTo.setData((Object)fp.getOrderTo());
        this.prmtProjectFrom.setData((Object)fp.getProjectFrom());
        this.prmtProjectTo.setData((Object)fp.getProjectTo());
        this.prmtTrackFrom.setData((Object)fp.getTrackFrom());
        this.prmtTrackTo.setData((Object)fp.getTrackTo());
        this.prmtProductFrom.setData((Object)fp.getProductFrom());
        this.prmtProductTo.setData((Object)fp.getProductTo());
        this.tfBatchFrom.setText(fp.getBatchFrom());
        this.tfBatchTo.setText(fp.getBatchTo());
        this.comBillSate.setSelectedIndex(Integer.parseInt(fp.getBillSate()));
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof InputQtyBillFilterParam)) {
            return;
        }
        InputQtyBillFilterParam fp = (InputQtyBillFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getInputQtyBillInfoFrom(), this.InputQtyBillInfoFrom);
        super.putIdByKey(customerParams, (Object)fp.getInputQtyBillInfoTo(), this.InputQtyBillInfoTo);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateFrom()).toString(), this.BizDateFrom);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateTo()).toString(), this.BizDateTo);
        super.putIdByKey(customerParams, (Object)fp.getPeriodFrom(), this.PeriodFrom);
        super.putIdByKey(customerParams, (Object)fp.getPeriodTo(), this.PeriodTo);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), this.CostCenterFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), this.CostCenterTo);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectFrom(), this.CostObjectFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectTo(), this.CostObjectTo);
        super.putIdByKey(customerParams, (Object)fp.getOrderFrom(), this.orderFrom);
        super.putIdByKey(customerParams, (Object)fp.getOrderTo(), this.orderTo);
        super.putIdByKey(customerParams, (Object)fp.getProjectFrom(), this.projectFrom);
        super.putIdByKey(customerParams, (Object)fp.getProjectTo(), this.projectTo);
        super.putIdByKey(customerParams, (Object)fp.getTrackFrom(), this.trackFrom);
        super.putIdByKey(customerParams, (Object)fp.getTrackTo(), this.trackTo);
        super.putIdByKey(customerParams, (Object)fp.getProductFrom(), this.productFrom);
        super.putIdByKey(customerParams, (Object)fp.getProductTo(), this.productTo);
        super.putIdByKey(customerParams, (Object)fp.getBatchFrom(), this.batchFrom);
        super.putIdByKey(customerParams, (Object)fp.getBatchTo(), this.batchTo);
        super.putIdByKey(customerParams, (Object)fp.getBillSate(), this.BillSate);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof InputQtyBillFilterParam)) {
            return;
        }
        InputQtyBillFilterParam fp = (InputQtyBillFilterParam)filterParam;
        Object temp = null;
        InputQtyBillInfo inputQtyBillInfoFrom = null;
        InputQtyBillInfo inputQtyBillInfoTo = null;
        temp = this.prtBillNumFrom.getData();
        if (temp != null && temp instanceof InputQtyBillInfo) {
            inputQtyBillInfoFrom = (InputQtyBillInfo)temp;
        }
        if ((temp = this.prtBillNumTo.getData()) != null && temp instanceof InputQtyBillInfo) {
            inputQtyBillInfoTo = (InputQtyBillInfo)temp;
        }
        fp.setInputQtyBillInfoFrom(inputQtyBillInfoFrom);
        fp.setInputQtyBillInfoTo(inputQtyBillInfoTo);
        long bizDateFrom = 0L;
        long bizDateTo = 0L;
        temp = this.dpBizDateFrom.getValue();
        if (temp != null && temp instanceof Date) {
            bizDateFrom = ((Date)temp).getTime();
        }
        if ((temp = this.dpBizDateTo.getValue()) != null && temp instanceof Date) {
            bizDateTo = ((Date)temp).getTime();
        }
        fp.setBizDateFrom(bizDateFrom);
        fp.setBizDateTo(bizDateTo);
        String periodFrom = null;
        String periodTo = null;
        temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = ((Integer)temp).toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = ((Integer)temp).toString();
        }
        fp.setPeriodFrom(periodFrom);
        fp.setPeriodTo(periodTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.prtCostcenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.prtCostcenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        temp = this.prtCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.prtCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)temp;
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        ManufactureOrderInfo orderFrom = null;
        ManufactureOrderInfo orderTo = null;
        temp = this.prmtOrderFrom.getData();
        if (temp != null && temp instanceof ManufactureOrderInfo) {
            orderFrom = (ManufactureOrderInfo)temp;
        }
        if ((temp = this.prmtOrderTo.getData()) != null && temp instanceof ManufactureOrderInfo) {
            orderTo = (ManufactureOrderInfo)temp;
        }
        fp.setOrderFrom(orderFrom);
        fp.setOrderTo(orderTo);
        ProjectInfo projectFrom = null;
        ProjectInfo projectTo = null;
        temp = this.prmtProjectFrom.getData();
        if (temp != null && temp instanceof ProjectInfo) {
            projectFrom = (ProjectInfo)temp;
        }
        if ((temp = this.prmtProjectTo.getData()) != null && temp instanceof ProjectInfo) {
            projectTo = (ProjectInfo)temp;
        }
        fp.setProjectFrom(projectFrom);
        fp.setProjectTo(projectTo);
        TrackNumberInfo trackFrom = null;
        TrackNumberInfo trackTo = null;
        temp = this.prmtTrackFrom.getData();
        if (temp != null && temp instanceof TrackNumberInfo) {
            trackFrom = (TrackNumberInfo)temp;
        }
        if ((temp = this.prmtTrackTo.getData()) != null && temp instanceof TrackNumberInfo) {
            trackTo = (TrackNumberInfo)temp;
        }
        fp.setTrackFrom(trackFrom);
        fp.setTrackTo(trackTo);
        MaterialInfo productFrom = null;
        MaterialInfo productTo = null;
        temp = this.prmtProductFrom.getData();
        if (temp != null && temp instanceof MaterialInfo) {
            productFrom = (MaterialInfo)temp;
        }
        if ((temp = this.prmtProductTo.getData()) != null && temp instanceof MaterialInfo) {
            productTo = (MaterialInfo)temp;
        }
        fp.setProductFrom(productFrom);
        fp.setProductTo(productTo);
        String batchFrom = this.tfBatchFrom.getText();
        String batchTo = this.tfBatchTo.getText();
        fp.setBatchFrom(batchFrom);
        fp.setBatchTo(batchTo);
        int selectIndex = this.comBillSate.getSelectedIndex();
        fp.setBillSate(String.valueOf(selectIndex));
    }

    public void clear() {
        super.clear();
        try {
            this.clearFilterData();
            this.formatUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        Date bizDateFrom = (Date)this.dpBizDateFrom.getValue();
        Date bizDateTo = (Date)this.dpBizDateTo.getValue();
        if (bizDateFrom != null && bizDateTo != null && bizDateFrom.equals(bizDateTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            bizDateTo.setHours(23);
            bizDateTo.setMinutes(59);
            bizDateTo.setSeconds(59);
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
        } else {
            if (bizDateFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            }
            if (bizDateTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
            }
        }
        int selectIndex = this.comBillSate.getSelectedIndex();
        String billStatus = String.valueOf(selectIndex + 1);
        if (selectIndex != 0) {
            filterBiz.getFilterItems().add(new FilterItemInfo("billStatus", (Object)billStatus, CompareType.EQUALS));
        }
        String periodFrom = null;
        String periodTo = null;
        Object temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = temp.toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = temp.toString();
        }
        if (periodFrom != null && periodTo != null && periodFrom.equals(periodTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.EQUALS));
        } else {
            if (periodFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
            }
            if (periodTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
            }
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prtCompany.setValue((Object)companyOrg);
    }

    private void initBizDate(KDDatePicker kdDate) {
        kdDate.setValue(null);
    }

    private void clearFilterData() {
        this.prtBillNumFrom.setValue(null);
        this.prtBillNumTo.setValue(null);
        this.prtCostcenterFrom.setValue(null);
        this.prtCostcenterTo.setValue(null);
        this.prtCostObjectFrom.setValue(null);
        this.prtCostObjectTo.setValue(null);
        this.prmtOrderFrom.setValue(null);
        this.prmtOrderTo.setValue(null);
        this.prmtProjectFrom.setValue(null);
        this.prmtProjectTo.setValue(null);
        this.prmtTrackFrom.setValue(null);
        this.prmtTrackTo.setValue(null);
        this.prmtProductFrom.setValue(null);
        this.prmtProductTo.setValue(null);
        this.tfBatchFrom.setText("");
        this.tfBatchTo.setText("");
        this.comBillSate.setSelectedIndex(0);
    }

    private void initPeriodSpinner(final JSpinner spFrom, final JSpinner spTo, int minPeriod, int initFromPeriod, int initToPeriod) {
        boolean argumentError = false;
        if (minPeriod <= 0) {
            argumentError = true;
        }
        String sMinPeriod = String.valueOf(minPeriod);
        if (!argumentError && sMinPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [minPeriod:" + minPeriod + "] error.");
        }
        argumentError = false;
        if (initFromPeriod <= 0 || initFromPeriod < minPeriod) {
            argumentError = true;
        }
        String sInitFromPeriod = String.valueOf(initFromPeriod);
        if (!argumentError && sInitFromPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initFromPeriod:" + initFromPeriod + "] error.");
        }
        argumentError = false;
        if (initToPeriod <= 0 || initToPeriod < minPeriod || initToPeriod < initFromPeriod) {
            argumentError = true;
        }
        String sInitToPeriod = String.valueOf(initToPeriod);
        if (!argumentError && sInitToPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initToPeriod:" + initToPeriod + "] error.");
        }
        final int minYear = Integer.parseInt(sMinPeriod.substring(0, 4));
        final int minMonth = Integer.parseInt(sMinPeriod.substring(4));
        SpinnerNumberModel modelFrom = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spTo.setValue(spFrom.getValue());
                }
            }
        };
        SpinnerNumberModel modelTo = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spFrom.setValue(spTo.getValue());
                }
            }
        };
        spFrom.setModel(modelFrom);
        spTo.setModel(modelTo);
        spFrom.setValue(initFromPeriod);
        spTo.setValue(initToPeriod);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        this.f7ContextManager.registerCostCenterF7(this.prtCostcenterFrom, new CostCenterType[]{CostCenterType.DirectProdDept});
        this.f7ContextManager.registerCostCenterF7(this.prtCostcenterTo, new CostCenterType[]{CostCenterType.DirectProdDept});
        this.f7ContextManager.registerCostObjectF7(this.prtCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.prtCostObjectTo, false);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtBillNumFrom, "com.kingdee.eas.ncm.bill.app.InputQtyForF7Query", "companyOrg.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtBillNumTo, "com.kingdee.eas.ncm.bill.app.InputQtyForF7Query", "companyOrg.id");
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> statuses = new HashSet<Integer>();
        statuses.add(5);
        statuses.add(8);
        statuses.add(7);
        statuses.add(11);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", statuses, CompareType.INCLUDE));
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderFrom, filter);
        this.f7ContextManager.registerManufactureOrderF7(this.prmtOrderTo, filter);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.calculateType", (Object)2));
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductFrom, filter);
        MaterialF7TreeListSelector selector = new MaterialF7TreeListSelector((Object)this, this.prmtProductFrom);
        this.prmtProductFrom.setSelector((KDPromptSelector)selector);
        this.f7ContextManager.registerMaterialTreeF7(this.prmtProductTo, filter);
        selector = new MaterialF7TreeListSelector((Object)this, this.prmtProductTo);
        this.prmtProductTo.setSelector((KDPromptSelector)selector);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prtCostcenterFrom.setData(null);
                this.prtCostcenterTo.setData(null);
                this.prtCostObjectFrom.setData(null);
                this.prtCostObjectTo.setData(null);
                this.prtBillNumFrom.setData(null);
                this.prtBillNumTo.setData(null);
                this.prmtOrderFrom.setData(null);
                this.prmtOrderTo.setData(null);
                this.prmtProductFrom.setData(null);
                this.prmtProductTo.setData(null);
                this.initPeriod();
                this.prtBillNumFrom.setDisplayFormat("$number$");
                this.prtBillNumTo.setDisplayFormat("$number$");
                this.prmtOrderFrom.setDisplayFormat("$number$");
                this.prmtOrderTo.setDisplayFormat("$number$");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void jbInit() throws Exception {
        this.resHelper = new ResourceBundleHelper(AbstractInputQtyBillFilterUI.class.getName());
        this.setUITitle(this.resHelper.getString("this.title"));
        this.kDLabelContainer11 = new KDLabelContainer();
        this.kDLabelContainer14 = new KDLabelContainer();
        this.kDLabelContainer15 = new KDLabelContainer();
        this.kDLabelContainer16 = new KDLabelContainer();
        this.kDLabelContainer17 = new KDLabelContainer();
        this.kDLabelContainer18 = new KDLabelContainer();
        this.kDLabelContainer19 = new KDLabelContainer();
        this.kDLabelContainer20 = new KDLabelContainer();
        this.kDLabelContainer21 = new KDLabelContainer();
        this.kDLabelContainer22 = new KDLabelContainer();
        this.prmtOrderFrom = new KDBizPromptBox();
        this.prmtProjectFrom = new KDBizPromptBox();
        this.prmtTrackFrom = new KDBizPromptBox();
        this.prmtProductFrom = new KDBizPromptBox();
        this.prmtOrderTo = new KDBizPromptBox();
        this.prmtProjectTo = new KDBizPromptBox();
        this.prmtTrackTo = new KDBizPromptBox();
        this.prmtProductTo = new KDBizPromptBox();
        this.tfBatchFrom = new KDTextField();
        this.tfBatchTo = new KDTextField();
        this.kDLabelContainer11.setName("kDLabelContainer11");
        this.kDLabelContainer14.setName("kDLabelContainer14");
        this.kDLabelContainer15.setName("kDLabelContainer15");
        this.kDLabelContainer16.setName("kDLabelContainer16");
        this.kDLabelContainer17.setName("kDLabelContainer17");
        this.kDLabelContainer18.setName("kDLabelContainer18");
        this.kDLabelContainer19.setName("kDLabelContainer19");
        this.kDLabelContainer20.setName("kDLabelContainer20");
        this.kDLabelContainer21.setName("kDLabelContainer21");
        this.kDLabelContainer22.setName("kDLabelContainer22");
        this.prmtOrderFrom.setName("prmtOrderFrom");
        this.prmtProjectFrom.setName("prmtProjectFrom");
        this.prmtTrackFrom.setName("prmtTrackFrom");
        this.prmtProductFrom.setName("prmtProductFrom");
        this.prmtOrderTo.setName("prmtOrderTo");
        this.prmtProjectTo.setName("prmtProjectTo");
        this.prmtTrackTo.setName("prmtTrackTo");
        this.prmtProductTo.setName("prmtProductTo");
        this.tfBatchFrom.setName("tfBatchFrom");
        this.tfBatchTo.setName("tfBatchTo");
        this.kDLabelContainer11.setBoundLabelText(this.resHelper.getString("kDLabelContainer11.boundLabelText"));
        this.kDLabelContainer11.setBoundLabelLength(65);
        this.kDLabelContainer11.setBoundLabelUnderline(true);
        this.kDLabelContainer14.setBoundLabelText(this.resHelper.getString("kDLabelContainer14.boundLabelText"));
        this.kDLabelContainer14.setBoundLabelLength(40);
        this.kDLabelContainer14.setBoundLabelUnderline(true);
        this.kDLabelContainer15.setBoundLabelText(this.resHelper.getString("kDLabelContainer15.boundLabelText"));
        this.kDLabelContainer15.setBoundLabelLength(65);
        this.kDLabelContainer15.setBoundLabelUnderline(true);
        this.kDLabelContainer16.setBoundLabelText(this.resHelper.getString("kDLabelContainer16.boundLabelText"));
        this.kDLabelContainer16.setBoundLabelLength(40);
        this.kDLabelContainer16.setBoundLabelUnderline(true);
        this.kDLabelContainer17.setBoundLabelText(this.resHelper.getString("kDLabelContainer17.boundLabelText"));
        this.kDLabelContainer17.setBoundLabelLength(65);
        this.kDLabelContainer17.setBoundLabelUnderline(true);
        this.kDLabelContainer18.setBoundLabelText(this.resHelper.getString("kDLabelContainer18.boundLabelText"));
        this.kDLabelContainer18.setBoundLabelLength(40);
        this.kDLabelContainer18.setBoundLabelUnderline(true);
        this.kDLabelContainer19.setBoundLabelText(this.resHelper.getString("kDLabelContainer19.boundLabelText"));
        this.kDLabelContainer19.setBoundLabelLength(65);
        this.kDLabelContainer19.setBoundLabelUnderline(true);
        this.kDLabelContainer20.setBoundLabelText(this.resHelper.getString("kDLabelContainer20.boundLabelText"));
        this.kDLabelContainer20.setBoundLabelLength(40);
        this.kDLabelContainer20.setBoundLabelUnderline(true);
        this.kDLabelContainer21.setBoundLabelText(this.resHelper.getString("kDLabelContainer21.boundLabelText"));
        this.kDLabelContainer21.setBoundLabelLength(65);
        this.kDLabelContainer21.setBoundLabelUnderline(true);
        this.kDLabelContainer22.setBoundLabelText(this.resHelper.getString("kDLabelContainer22.boundLabelText"));
        this.kDLabelContainer22.setBoundLabelLength(40);
        this.kDLabelContainer22.setBoundLabelUnderline(true);
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 540, 480));
        this.setLayout(null);
        this.kDSeparator1.setBounds(new Rectangle(0, 56, 540, 1));
        this.add((Component)this.kDSeparator1, null);
        this.kDLabelContainer1.setBounds(new Rectangle(13, 418, 185, 19));
        this.add((Component)this.kDLabelContainer1, null);
        this.kDLabelContainer2.setBounds(new Rectangle(208, 139, 175, 19));
        this.add((Component)this.kDLabelContainer2, null);
        this.kDLabelContainer3.setBounds(new Rectangle(13, 73, 187, 19));
        this.add((Component)this.kDLabelContainer3, null);
        this.kDLabelContainer4.setBounds(new Rectangle(13, 106, 186, 19));
        this.add((Component)this.kDLabelContainer4, null);
        this.kDLabelContainer5.setBounds(new Rectangle(14, 22, 370, 19));
        this.add((Component)this.kDLabelContainer5, null);
        this.kDLabelContainer6.setBounds(new Rectangle(13, 174, 185, 19));
        this.add((Component)this.kDLabelContainer6, null);
        this.kDLabelContainer7.setBounds(new Rectangle(13, 207, 184, 19));
        this.add((Component)this.kDLabelContainer7, null);
        this.kDSeparator2.setBounds(new Rectangle(0, 406, 540, 9));
        this.add((Component)this.kDSeparator2, null);
        this.kDLabelContainer8.setBounds(new Rectangle(13, 139, 187, 19));
        this.add((Component)this.kDLabelContainer8, null);
        this.kDLabelContainer9.setBounds(new Rectangle(208, 73, 175, 19));
        this.add((Component)this.kDLabelContainer9, null);
        this.kDLabelContainer10.setBounds(new Rectangle(208, 106, 174, 19));
        this.add((Component)this.kDLabelContainer10, null);
        this.kDLabelContainer12.setBounds(new Rectangle(208, 174, 175, 19));
        this.add((Component)this.kDLabelContainer12, null);
        this.kDLabelContainer13.setBounds(new Rectangle(208, 207, 175, 19));
        this.add((Component)this.kDLabelContainer13, null);
        this.kDLabelContainer1.setBoundEditor((JComponent)this.comBillSate);
        this.kDLabelContainer2.setBoundEditor((JComponent)this.prtBillNumTo);
        this.kDLabelContainer3.setBoundEditor((JComponent)this.dpBizDateFrom);
        this.kDLabelContainer4.setBoundEditor((JComponent)this.spPeriodFrom);
        this.kDLabelContainer5.setBoundEditor((JComponent)this.prtCompany);
        this.kDLabelContainer6.setBoundEditor((JComponent)this.prtCostcenterFrom);
        this.kDLabelContainer7.setBoundEditor((JComponent)this.prtCostObjectFrom);
        this.kDLabelContainer8.setBoundEditor((JComponent)this.prtBillNumFrom);
        this.kDLabelContainer9.setBoundEditor((JComponent)this.dpBizDateTo);
        this.kDLabelContainer10.setBoundEditor((JComponent)this.spPeriodTo);
        this.kDLabelContainer12.setBoundEditor((JComponent)this.prtCostcenterTo);
        this.kDLabelContainer13.setBoundEditor((JComponent)this.prtCostObjectTo);
        this.kDLabelContainer11.setBounds(new Rectangle(13, 242, 184, 19));
        this.add((Component)this.kDLabelContainer11, null);
        this.kDLabelContainer14.setBounds(new Rectangle(208, 242, 175, 19));
        this.add((Component)this.kDLabelContainer14, null);
        this.kDLabelContainer15.setBounds(new Rectangle(13, 276, 184, 19));
        this.add((Component)this.kDLabelContainer15, null);
        this.kDLabelContainer16.setBounds(new Rectangle(208, 276, 175, 19));
        this.add((Component)this.kDLabelContainer16, null);
        this.kDLabelContainer17.setBounds(new Rectangle(13, 309, 184, 19));
        this.add((Component)this.kDLabelContainer17, null);
        this.kDLabelContainer18.setBounds(new Rectangle(208, 309, 175, 19));
        this.add((Component)this.kDLabelContainer18, null);
        this.kDLabelContainer19.setBounds(new Rectangle(13, 342, 184, 19));
        this.add((Component)this.kDLabelContainer19, null);
        this.kDLabelContainer20.setBounds(new Rectangle(208, 342, 175, 19));
        this.add((Component)this.kDLabelContainer20, null);
        this.kDLabelContainer21.setBounds(new Rectangle(13, 374, 184, 19));
        this.add((Component)this.kDLabelContainer21, null);
        this.kDLabelContainer22.setBounds(new Rectangle(208, 374, 175, 19));
        this.add((Component)this.kDLabelContainer22, null);
        this.kDLabelContainer11.setBoundEditor((JComponent)this.prmtOrderFrom);
        this.kDLabelContainer14.setBoundEditor((JComponent)this.prmtOrderTo);
        this.kDLabelContainer15.setBoundEditor((JComponent)this.prmtProjectFrom);
        this.kDLabelContainer16.setBoundEditor((JComponent)this.prmtProjectTo);
        this.kDLabelContainer17.setBoundEditor((JComponent)this.prmtTrackFrom);
        this.kDLabelContainer18.setBoundEditor((JComponent)this.prmtTrackTo);
        this.kDLabelContainer19.setBoundEditor((JComponent)this.prmtProductFrom);
        this.kDLabelContainer20.setBoundEditor((JComponent)this.prmtProductTo);
        this.kDLabelContainer21.setBoundEditor((JComponent)this.tfBatchFrom);
        this.kDLabelContainer22.setBoundEditor((JComponent)this.tfBatchTo);
    }

    protected void filterProject(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = ProjectFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    protected void filterTrack(KDBizPromptBox prmt) throws Exception {
        FilterInfo filter = TrackNumberFactory.getRemoteInstance().getDatabaseDFilter(this.getBizCUPK(), "id", "CU.id");
        EntityViewInfo view = null;
        view = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        view.setFilter(filter);
        prmt.setEntityViewInfo(view);
    }

    private IObjectPK getBizCUPK() {
        Object object = this.getUIContext().get(OrgType.Company);
        CtrlUnitInfo currentBizOrg = object == null ? SysContext.getSysContext().getCurrentCtrlUnit() : (OrgUnitInfo)object;
        return new ObjectUuidPK(currentBizOrg.getCU().getId());
    }
}

