/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.InputQtyBillFactory;
import com.kingdee.eas.ncm.bill.client.AbstractInputQtyBillListUI;
import com.kingdee.eas.ncm.bill.client.InputQtyBillEditUI;
import com.kingdee.eas.ncm.bill.client.InputQtyBillFilterUI;
import com.kingdee.eas.ncm.bill.client.InputQtyImportUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class InputQtyBillListUI
extends AbstractInputQtyBillListUI {
    private final FillListener fillListener = new FillListener();
    private CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    private InputQtyBillFilterUI filterUI = null;

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.inputImportAction.setEnabled(true);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionEdit_actionPerformed(e);
    }

    public static int getSelectedRow(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        if (selectBlock == null) {
            return -1;
        }
        return selectBlock.getTop();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InputQtyBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return InputQtyBillEditUI.class.getName();
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        return new String[]{"id", "number", "calculatePeriod.periodNumber", "bizDate", "billStatus", "companyOrg.name", "IsImport", "costCenter.number", "costCenter.name", "creator.name", "createTime", "auditor.name", "auditTime", "lastUpdateUser.name", "lastUpdateTime"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inputImportAction_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=INPUTQTY_IMPORT" + this.currentCompany.getId().toString());
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"companyID", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InputQtyImportUI.class.getName(), (Map)uiContext, null);
            uiWindow.show();
            this.refresh(e);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            this.setOprtState("RELEASEALL");
            try {
                this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=INPUTQTY_IMPORT" + this.currentCompany.getId().toString());
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
    }

    protected PeriodInfo getPeriodByBizDate(Date date, CompanyOrgUnitInfo orgInfo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String myString = sdf.format(date);
        try {
            date = sdf.parse(myString);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        KDBizPromptBox prmt = new KDBizPromptBox();
        NCMClientUtils.filterCompanyOrgForPeriod((KDBizPromptBox)prmt, (CompanyOrgUnitInfo)orgInfo);
        FilterInfo filter = prmt.getEntityViewInfo().getFilter();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)date, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)date, CompareType.GREATER_EQUALS));
        PeriodCollection pc = null;
        try {
            prmt.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            IPeriod ipe = PeriodFactory.getRemoteInstance();
            pc = ipe.getPeriodCollection(prmt.getEntityViewInfo());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (pc != null && pc.size() > 0) {
            return pc.get(0);
        }
        return null;
    }

    protected void isStartSet(ItemAction[] actList) throws Exception {
        ItemAction[] actList1 = new ItemAction[]{this.inputImportAction};
        super.isStartSet(actList1);
    }

    protected CommonQueryProcessor getCustomerCommonQueryProcessor() {
        CommonQueryProcessor cmcq = super.getCustomerCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
        cmcq.set("DIALOG", null);
        cmcq.set("isDirectProdDept", (Object)Boolean.TRUE);
        return cmcq;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new InputQtyBillFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "InputQtyBill";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"92_InputQtyBillListUI");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        SorterItemCollection sorter = viewInfo.getSorter();
        if (viewInfo.getSorter() == null) {
            sorter = new SorterItemCollection();
        }
        if (sorter.size() == 1 && sorter.get(0).getPropertyName().equalsIgnoreCase("id")) {
            sorter = new SorterItemCollection();
            SorterItemInfo sorterItem = new SorterItemInfo("number");
            sorterItem.setSortType(SortType.ASCEND);
            sorter.add(sorterItem);
            viewInfo.setSorter(sorter);
        }
        IQueryExecutor qe = super.getQueryExecutor(queryPK, viewInfo);
        qe.option().isIgnoreOrder = true;
        return qe;
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected int getCommonQueryDialogWidth() {
        return 450;
    }

    protected int getCommonQueryDialogHeight() {
        return 480;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("input_audit");
        }
        super.auditAction_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    public final class FillListener
    implements KDTDataFillListener {
        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(InputQtyBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)tblMain.getRow(i).getCell("entry.Qty"), (int)Integer.parseInt(String.valueOf(tblMain.getRow(i).getCell("qtyPrecision").getValue())));
            }
        }
    }
}

