/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.MatAllocFilterParam;
import com.kingdee.eas.ncm.bill.client.AbstractMatAllocFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class MatAllocFilterUI
extends AbstractMatAllocFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MatAllocFilterUI.class);
    private static final int PERIOD_MAX_MONTH = 12;
    private String OtherFeeBillInfoFrom = "otherFeeBillInfoFrom";
    private String OtherFeeBillInfoTo = "otherFeeBillInfoTo";
    private String BizDateFrom = "bizDateFrom";
    private String BizDateTo = "bizDateTo";
    private String PeriodFrom = "periodFrom";
    private String PeriodTo = "periodTo";
    private String CostCenterFrom = "costCenterFrom";
    private String CostCenterTo = "costCenterTo";
    private String ExpenseFrom = "expenseFrom";
    private String ExpenseTo = "expenseTo";
    private String CostItemFrom = "costItemFrom";
    private String CostItemTo = "costItemTo";
    private String CostObjectFrom = "costObjectFrom";
    private String CostObjectTo = "costObjectTo";
    private String CostObjectSuiteFrom = "costObjectSuiteFrom";
    private String CostObjectSuiteTo = "costObjectSuiteTo";
    private String BillSate = "billSate";
    private PeriodInfo periodStart;
    private PeriodInfo periodCur;

    public void onLoad() throws Exception {
        super.onLoad();
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.spPeriodFrom.setEnabled(false);
        this.spPeriodTo.setEnabled(false);
        this.formatUI();
    }

    private void formatUI() throws Exception {
        this.initBizDate(this.dpBizDateFrom);
        this.initBizDate(this.dpBizDateTo);
        this.initPeriod();
        this.initCompany(this.getCompanyOrgInfoWithDefault());
    }

    private void initPeriod() throws EASBizException, BOSException {
        this.periodStart = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        this.periodCur = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        if (this.periodStart == null || this.periodCur == null) {
            return;
        }
        int minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initFromPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
    }

    private void initBizDate(KDDatePicker kdDate) {
        kdDate.setValue(null);
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.prtCompany.setValue((Object)companyOrg);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new MatAllocFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof MatAllocFilterParam)) {
            return;
        }
        MatAllocFilterParam fp = (MatAllocFilterParam)filterParam;
        MaterialReqBillInfo bnFrom = null;
        MaterialReqBillInfo bnTo = null;
        String OtherFeeBillFromData = customerParams.getCustomerParam(this.OtherFeeBillInfoFrom);
        String OtherFeeBillToData = customerParams.getCustomerParam(this.OtherFeeBillInfoTo);
        if (OtherFeeBillFromData != null && OtherFeeBillFromData.length() > 0) {
            bnFrom = new MaterialReqBillInfo();
            bnFrom.setId(BOSUuid.read((String)OtherFeeBillFromData));
        }
        if (OtherFeeBillToData != null && OtherFeeBillToData.length() > 0) {
            bnTo = new MaterialReqBillInfo();
            bnTo.setId(BOSUuid.read((String)OtherFeeBillToData));
        }
        fp.setOtherFeeBillInfoFrom(bnFrom);
        fp.setOtherFeeBillInfoTo(bnTo);
        String bizDateFromData = customerParams.getCustomerParam(this.BizDateFrom);
        String bizDateToData = customerParams.getCustomerParam(this.BizDateTo);
        fp.setBizDateFrom(Long.parseLong(bizDateFromData));
        fp.setBizDateTo(Long.parseLong(bizDateToData));
        String periodFromData = customerParams.getCustomerParam(this.PeriodFrom);
        String periodToData = customerParams.getCustomerParam(this.PeriodTo);
        fp.setPeriodFrom(periodFromData);
        fp.setPeriodTo(periodToData);
        CostCenterOrgUnitInfo ccFrom = null;
        CostCenterOrgUnitInfo ccTo = null;
        String costCenterFromData = customerParams.getCustomerParam(this.CostCenterFrom);
        String costCenterToData = customerParams.getCustomerParam(this.CostCenterTo);
        if (costCenterFromData != null && costCenterFromData.length() > 0) {
            ccFrom = new CostCenterOrgUnitInfo();
            ccFrom.setId(BOSUuid.read((String)costCenterFromData));
        }
        if (costCenterToData != null && costCenterToData.length() > 0) {
            ccTo = new CostCenterOrgUnitInfo();
            ccTo.setId(BOSUuid.read((String)costCenterToData));
        }
        fp.setCostCenterFrom(ccFrom);
        fp.setCostCenterTo(ccTo);
        ExpenseInfo expenseFrom = null;
        ExpenseInfo expenseTo = null;
        String expenseFromData = customerParams.getCustomerParam(this.ExpenseFrom);
        String expenseToData = customerParams.getCustomerParam(this.ExpenseTo);
        if (expenseFromData != null && expenseFromData.length() > 0) {
            expenseFrom = new ExpenseInfo();
            expenseFrom.setId(BOSUuid.read((String)expenseFromData));
        }
        if (expenseToData != null && expenseToData.length() > 0) {
            expenseTo = new ExpenseInfo();
            expenseTo.setId(BOSUuid.read((String)expenseToData));
        }
        CostItemInfo ciFrom = null;
        CostItemInfo ciTo = null;
        String costItemFromData = customerParams.getCustomerParam(this.CostItemFrom);
        String costItemctToData = customerParams.getCustomerParam(this.CostItemTo);
        if (costItemFromData != null && costItemFromData.length() > 0) {
            ciFrom = new CostItemInfo();
            ciFrom.setId(BOSUuid.read((String)costItemFromData));
        }
        if (costItemctToData != null && costItemctToData.length() > 0) {
            ciTo = new CostItemInfo();
            ciTo.setId(BOSUuid.read((String)costItemctToData));
        }
        fp.setCostItemFrom(ciFrom);
        fp.setCostItemTo(ciTo);
        CostObjectInfo cbFrom = null;
        CostObjectInfo cbTo = null;
        String costObjectFromData = customerParams.getCustomerParam(this.CostObjectFrom);
        String costObjectToData = customerParams.getCustomerParam(this.CostObjectTo);
        if (costObjectFromData != null && costObjectFromData.length() > 0) {
            cbFrom = new CostObjectInfo();
            cbFrom.setId(BOSUuid.read((String)costObjectFromData));
        }
        if (costObjectToData != null && costObjectToData.length() > 0) {
            cbTo = new CostObjectInfo();
            cbTo.setId(BOSUuid.read((String)costObjectToData));
        }
        fp.setCostObjectFrom(cbFrom);
        fp.setCostObjectTo(cbTo);
        CostObjectSuiteInfo cbSuiteFrom = null;
        CostObjectSuiteInfo cbSuiteTo = null;
        String costObjectSuiteFromData = customerParams.getCustomerParam(this.CostObjectSuiteFrom);
        String costObjectSuiteToData = customerParams.getCustomerParam(this.CostObjectSuiteTo);
        if (costObjectSuiteFromData != null && costObjectSuiteFromData.length() > 0) {
            cbSuiteFrom = new CostObjectSuiteInfo();
            cbSuiteFrom.setId(BOSUuid.read((String)costObjectSuiteFromData));
        }
        if (costObjectSuiteToData != null && costObjectSuiteToData.length() > 0) {
            cbSuiteTo = new CostObjectSuiteInfo();
            cbSuiteTo.setId(BOSUuid.read((String)costObjectSuiteToData));
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        int minPeriod;
        if (!(filterParam instanceof MatAllocFilterParam)) {
            return;
        }
        MatAllocFilterParam fp = (MatAllocFilterParam)filterParam;
        this.prtBillNumFrom.setData((Object)fp.getOtherFeeBillInfoFrom());
        this.prtBillNumTo.setData((Object)fp.getOtherFeeBillInfoTo());
        if (fp.getBizDateFrom() == 0L) {
            this.dpBizDateFrom.setValue(null);
        } else {
            this.dpBizDateFrom.setValue((Object)new Date(fp.getBizDateFrom()));
        }
        if (fp.getBizDateTo() == 0L) {
            this.dpBizDateTo.setValue(null);
        } else {
            this.dpBizDateTo.setValue((Object)new Date(fp.getBizDateTo()));
        }
        int initFromPeriod = minPeriod = this.periodStart.getPeriodYear() * 100 + this.periodStart.getPeriodNumber();
        int initToPeriod = this.periodCur.getPeriodYear() * 100 + this.periodCur.getPeriodNumber();
        if (fp.getPeriodFrom() != null) {
            initFromPeriod = Integer.parseInt(fp.getPeriodFrom());
        }
        if (fp.getPeriodTo() != null) {
            initToPeriod = Integer.parseInt(fp.getPeriodTo());
        }
        this.initPeriodSpinner((JSpinner)this.spPeriodFrom, (JSpinner)this.spPeriodTo, minPeriod, initFromPeriod, initToPeriod);
        this.prtCostcenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prtCostcenterTo.setData((Object)fp.getCostCenterTo());
        this.prtCostItemFrom.setData((Object)fp.getCostItemFrom());
        this.prtCostItemTo.setData((Object)fp.getCostItemTo());
        this.prtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prtCostObjectTo.setData((Object)fp.getCostObjectTo());
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof MatAllocFilterParam)) {
            return;
        }
        MatAllocFilterParam fp = (MatAllocFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getOtherFeeBillInfoFrom(), this.OtherFeeBillInfoFrom);
        super.putIdByKey(customerParams, (Object)fp.getOtherFeeBillInfoTo(), this.OtherFeeBillInfoTo);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateFrom()).toString(), this.BizDateFrom);
        super.putIdByKey(customerParams, (Object)Long.valueOf(fp.getBizDateTo()).toString(), this.BizDateTo);
        super.putIdByKey(customerParams, (Object)fp.getPeriodFrom(), this.PeriodFrom);
        super.putIdByKey(customerParams, (Object)fp.getPeriodTo(), this.PeriodTo);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterFrom(), this.CostCenterFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostCenterTo(), this.CostCenterTo);
        super.putIdByKey(customerParams, (Object)fp.getCostItemFrom(), this.CostItemFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostItemTo(), this.CostItemTo);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectFrom(), this.CostObjectFrom);
        super.putIdByKey(customerParams, (Object)fp.getCostObjectTo(), this.CostObjectTo);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof MatAllocFilterParam)) {
            return;
        }
        MatAllocFilterParam fp = (MatAllocFilterParam)filterParam;
        Object temp = null;
        MaterialReqBillInfo otherFeeBillInfoFrom = null;
        MaterialReqBillInfo otherFeeBillInfoTo = null;
        temp = this.prtBillNumFrom.getData();
        if (temp != null && temp instanceof MaterialReqBillInfo) {
            otherFeeBillInfoFrom = (MaterialReqBillInfo)temp;
        }
        if ((temp = this.prtBillNumTo.getData()) != null && temp instanceof MaterialReqBillInfo) {
            otherFeeBillInfoTo = (MaterialReqBillInfo)temp;
        }
        fp.setOtherFeeBillInfoFrom(otherFeeBillInfoFrom);
        fp.setOtherFeeBillInfoTo(otherFeeBillInfoTo);
        long bizDateFrom = 0L;
        long bizDateTo = 0L;
        temp = this.dpBizDateFrom.getValue();
        if (temp != null && temp instanceof Date) {
            bizDateFrom = ((Date)temp).getTime();
        }
        if ((temp = this.dpBizDateTo.getValue()) != null && temp instanceof Date) {
            bizDateTo = ((Date)temp).getTime();
        }
        fp.setBizDateFrom(bizDateFrom);
        fp.setBizDateTo(bizDateTo);
        String periodFrom = null;
        String periodTo = null;
        temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = ((Integer)temp).toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = ((Integer)temp).toString();
        }
        fp.setPeriodFrom(periodFrom);
        fp.setPeriodTo(periodTo);
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        temp = this.prtCostcenterFrom.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)temp;
        }
        if ((temp = this.prtCostcenterTo.getData()) != null && temp instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        Object expenseFrom = null;
        Object expenseTo = null;
        CostItemInfo costItemFrom = null;
        CostItemInfo costItemTo = null;
        temp = this.prtCostItemFrom.getData();
        if (temp != null && temp instanceof CostItemInfo) {
            costItemFrom = (CostItemInfo)temp;
        }
        if ((temp = this.prtCostItemTo.getData()) != null && temp instanceof CostItemInfo) {
            costItemTo = (CostItemInfo)temp;
        }
        fp.setCostItemFrom(costItemFrom);
        fp.setCostItemTo(costItemTo);
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        temp = this.prtCostObjectFrom.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)temp;
        }
        if ((temp = this.prtCostObjectTo.getData()) != null && temp instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)temp;
        }
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        Object costObjectSuiteFrom = null;
        Object costObjectSuiteTo = null;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo filterBiz = new FilterInfo();
        Date bizDateFrom = (Date)this.dpBizDateFrom.getValue();
        Date bizDateTo = (Date)this.dpBizDateTo.getValue();
        if (bizDateFrom != null && bizDateTo != null && bizDateFrom.equals(bizDateTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            bizDateTo.setHours(23);
            bizDateTo.setMinutes(59);
            bizDateTo.setSeconds(59);
            filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
        } else {
            if (bizDateFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateFrom, CompareType.GREATER_EQUALS));
            }
            if (bizDateTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("bizDate", (Object)bizDateTo, CompareType.LESS_EQUALS));
            }
        }
        String periodFrom = null;
        String periodTo = null;
        Object temp = this.spPeriodFrom.getValue();
        if (temp != null && temp instanceof Integer) {
            periodFrom = temp.toString();
        }
        if ((temp = this.spPeriodTo.getValue()) != null && temp instanceof Integer) {
            periodTo = temp.toString();
        }
        if (periodFrom != null && periodTo != null && periodFrom.equals(periodTo)) {
            filterBiz.getFilterItems().add(new FilterItemInfo("year", (Object)periodFrom.substring(0, 4), CompareType.EQUALS));
            filterBiz.getFilterItems().add(new FilterItemInfo("period", (Object)periodFrom.substring(4, 6), CompareType.EQUALS));
        } else {
            if (periodFrom != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("year", (Object)periodFrom.substring(0, 4), CompareType.GREATER_EQUALS));
                filterBiz.getFilterItems().add(new FilterItemInfo("period", (Object)periodFrom.substring(4, 6), CompareType.GREATER_EQUALS));
            }
            if (periodTo != null) {
                filterBiz.getFilterItems().add(new FilterItemInfo("year", (Object)periodTo.substring(0, 4), CompareType.GREATER_EQUALS));
                filterBiz.getFilterItems().add(new FilterItemInfo("period", (Object)periodTo.substring(4, 6), CompareType.GREATER_EQUALS));
            }
        }
        try {
            filterInfo.mergeFilter(filterBiz, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    public void clear() {
        super.clear();
        try {
            this.clearFilterData();
            this.formatUI();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void clearFilterData() {
        this.prtBillNumFrom.setValue(null);
        this.prtBillNumTo.setValue(null);
        this.prtCostcenterFrom.setValue(null);
        this.prtCostcenterTo.setValue(null);
        this.prtCostItemFrom.setValue(null);
        this.prtCostItemTo.setValue(null);
        this.prtCostObjectFrom.setValue(null);
        this.prtCostObjectTo.setValue(null);
    }

    private void initPeriodSpinner(final JSpinner spFrom, final JSpinner spTo, int minPeriod, int initFromPeriod, int initToPeriod) {
        boolean argumentError = false;
        if (minPeriod <= 0) {
            argumentError = true;
        }
        String sMinPeriod = String.valueOf(minPeriod);
        if (!argumentError && sMinPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [minPeriod:" + minPeriod + "] error.");
        }
        argumentError = false;
        if (initFromPeriod <= 0 || initFromPeriod < minPeriod) {
            argumentError = true;
        }
        String sInitFromPeriod = String.valueOf(initFromPeriod);
        if (!argumentError && sInitFromPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initFromPeriod:" + initFromPeriod + "] error.");
        }
        argumentError = false;
        if (initToPeriod <= 0 || initToPeriod < minPeriod || initToPeriod < initFromPeriod) {
            argumentError = true;
        }
        String sInitToPeriod = String.valueOf(initToPeriod);
        if (!argumentError && sInitToPeriod.length() != 6) {
            argumentError = true;
        }
        if (argumentError) {
            throw new IllegalArgumentException("Argument [initToPeriod:" + initToPeriod + "] error.");
        }
        final int minYear = Integer.parseInt(sMinPeriod.substring(0, 4));
        final int minMonth = Integer.parseInt(sMinPeriod.substring(4));
        SpinnerNumberModel modelFrom = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spFrom.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue > oldValue) {
                    this.syncPeriodTo();
                }
            }

            private void syncPeriodTo() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spTo.setValue(spFrom.getValue());
                }
            }
        };
        SpinnerNumberModel modelTo = new SpinnerNumberModel(){

            @Override
            public Object getNextValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month + 1 > 12 ? (year + 1) * 100 + 1 : iPeriod + 1;
                return value;
            }

            @Override
            public Object getPreviousValue() {
                int iPeriod = (Integer)this.getValue();
                String sPeriod = String.valueOf(iPeriod);
                if (sPeriod.length() != 6) {
                    return null;
                }
                int year = Integer.parseInt(sPeriod.substring(0, 4));
                int month = Integer.parseInt(sPeriod.substring(4));
                int value = month - 1 < 1 ? (year - 1) * 100 + 12 : iPeriod - 1;
                if (value < minYear * 100 + minMonth) {
                    return null;
                }
                return value;
            }

            @Override
            public Number getStepSize() {
                return 1;
            }

            @Override
            public void setValue(Object value) {
                int oldValue = (Integer)spTo.getValue();
                int newValue = (Integer)value;
                super.setValue(value);
                if (newValue < oldValue) {
                    this.syncPeriodFrom();
                }
            }

            private void syncPeriodFrom() {
                int toPeriod;
                int fromPeriod = (Integer)spFrom.getValue();
                if (fromPeriod > (toPeriod = ((Integer)spTo.getValue()).intValue())) {
                    spFrom.setValue(spTo.getValue());
                }
            }
        };
        spFrom.setModel(modelFrom);
        spTo.setModel(modelTo);
        spFrom.setValue(initFromPeriod);
        spTo.setValue(initToPeriod);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.prtCostcenterFrom);
        this.f7ContextManager.registerCostCenterF7(this.prtCostcenterTo);
        this.f7ContextManager.registerCostObjectF7(this.prtCostObjectFrom, false);
        this.f7ContextManager.registerCostObjectF7(this.prtCostObjectTo, false);
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtBillNumFrom, "com.kingdee.eas.ncm.bill.app.MaterialAllocFilterQuery", "companyOrgUnit.id");
        this.f7ContextManager.registerCompanyFilterOnlyF7(this.prtBillNumTo, "com.kingdee.eas.ncm.bill.app.MaterialAllocFilterQuery", "companyOrgUnit.id");
        this.prtBillNumFrom.setDisplayFormat("$number$");
        this.prtBillNumTo.setDisplayFormat("$number$");
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prtCostcenterFrom.setData(null);
                this.prtCostcenterTo.setData(null);
                this.prtCostObjectFrom.setData(null);
                this.prtCostObjectTo.setData(null);
                this.prtBillNumFrom.setData(null);
                this.prtBillNumTo.setData(null);
                this.initPeriod();
                this.prtBillNumFrom.setDisplayFormat("$number$");
                this.prtBillNumTo.setDisplayFormat("$number$");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

