/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.bill.IMatAllocWizardScheme;
import com.kingdee.eas.ncm.bill.MatAllocWizardSchemeEntryInfo;
import com.kingdee.eas.ncm.bill.MatAllocWizardSchemeFactory;
import com.kingdee.eas.ncm.bill.MatAllocWizardSchemeInfo;
import com.kingdee.eas.ncm.bill.client.AbstractMatAllocWizardStep2UI;
import com.kingdee.eas.ncm.common.NCMCostTypeEnum;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;

public class MatAllocWizardStep2UI
extends AbstractMatAllocWizardStep2UI {
    private static final long serialVersionUID = 7538895402916544420L;
    private static final String col_select = "select";
    private static final String col_ID = "ID";
    private static final String col_solution = "solution";
    private static final String col_allocStd = "allocStd";
    private static final String col_costItem = "costItem";
    private static final String col_onlyUnAlloc = "onlyUnAlloc";
    Map matAllocSchemeMap = new HashMap();
    public boolean isDynCost = false;

    public MatAllocWizardStep2UI() throws Exception {
        this.initUIContentLayout();
    }

    public void querySolusion() throws Exception {
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(2);
        this.table.removeRows();
        KDBizPromptBox allocStdBox = new KDBizPromptBox();
        allocStdBox.setQueryInfo("com.kingdee.eas.basedata.ncm.app.AllocStdQuery");
        allocStdBox.setVisible(true);
        allocStdBox.setEditable(true);
        allocStdBox.setDisplayFormat("$name$");
        allocStdBox.setEditFormat("$name$");
        allocStdBox.setCommitFormat("$number$");
        NCMClientUtils.filterF7((KDBizPromptBox)allocStdBox, (String)"allocStdType", (Object)String.valueOf(AllocStdTypeEnum.INNERPRD.getValue()));
        this.table.getColumn(col_allocStd).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)allocStdBox));
        KDBizPromptBox costItemBox = new KDBizPromptBox();
        costItemBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        costItemBox.setVisible(true);
        costItemBox.setEditable(true);
        costItemBox.setDisplayFormat("$name$");
        costItemBox.setEditFormat("$name$");
        costItemBox.setCommitFormat("$number$");
        this.table.getColumn(col_costItem).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)costItemBox));
        KDComboBox solutionBox = new KDComboBox();
        solutionBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.table.getColumn(col_solution).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)solutionBox));
        int costType = this.isDynCost ? 2 : 1;
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IMatAllocWizardScheme iMatWiz = MatAllocWizardSchemeFactory.getRemoteInstance();
        QuerySolutionCollection solutions = iMatWiz.query(companyID, userID, costType);
        if (solutions != null) {
            int size = solutions.size();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo solution = solutions.get(i);
                solutionBox.addItem((Object)solution);
                if (!(solution.get("isLastScheme") instanceof Boolean) || !((Boolean)solution.get("isLastScheme")).booleanValue()) continue;
                this.matAllocSchemeMap.put(solution.getId().toString(), solution);
                IRow row = this.table.addRow();
                this.setRowVale(row, solution);
            }
        }
        this.repaint();
    }

    private void setRowVale(IRow row, QuerySolutionInfo solution) {
        if (row == null || solution == null || solution.getId() == null) {
            return;
        }
        if (this.matAllocSchemeMap.get(solution.getId().toString()) instanceof QuerySolutionInfo) {
            QuerySolutionInfo sysSolution = (QuerySolutionInfo)this.matAllocSchemeMap.get(solution.getId().toString());
            row.getCell(col_solution).setValue(sysSolution.clone());
            String allocStdID = (String)solution.get("allocStdID");
            String allocStdNumber = (String)solution.get("allocStdNumber");
            String allocStdName = (String)solution.get("allocStdName");
            AllocStdInfo allocStdInfo = new AllocStdInfo();
            allocStdInfo.setId(BOSUuid.read((String)allocStdID));
            allocStdInfo.setNumber(allocStdNumber);
            allocStdInfo.setName(allocStdName);
            row.getCell(col_allocStd).setValue((Object)allocStdInfo);
            String costItemID = (String)solution.get("costItemID");
            String costItemNumber = (String)solution.get("costItemNumber");
            String costItemName = (String)solution.get("costItemName");
            CostItemInfo costItemInfo = new CostItemInfo();
            costItemInfo.setId(costItemID == null ? null : BOSUuid.read((String)costItemID));
            costItemInfo.setNumber(costItemNumber);
            costItemInfo.setName(costItemName);
            row.getCell(col_costItem).setValue((Object)costItemInfo);
            row.getCell(col_select).setValue((Object)Boolean.TRUE);
            row.getCell(col_onlyUnAlloc).setValue(sysSolution.get("isOnlyUnAlloc"));
            row.getCell(col_ID).setUserObject(sysSolution.clone());
        } else {
            row.getCell(col_allocStd).setValue((Object)"");
            row.getCell(col_costItem).setValue((Object)"");
            row.getCell(col_select).setValue((Object)Boolean.TRUE);
            row.getCell(col_onlyUnAlloc).setValue((Object)Boolean.TRUE);
            row.getCell(col_ID).setUserObject(solution.clone());
        }
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
        IRow row = this.table.addRow();
        row.getCell(col_solution).setValue((Object)"");
        row.getCell(col_select).setValue((Object)Boolean.TRUE);
        row.getCell(col_onlyUnAlloc).setValue((Object)Boolean.FALSE);
    }

    @Override
    protected void btnInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnInsertLine_actionPerformed(e);
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex > -1) {
            this.table.addRow(rowIndex);
        }
    }

    @Override
    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine_actionPerformed(e);
        if (this.table.getSelectManager().getActiveRowIndex() > -1) {
            this.table.removeRow(this.table.getSelectManager().getActiveRowIndex());
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"106_MatAllocWizardStep2UI"));
            return;
        }
        if (rowIndex == this.table.getRowCount() - 1) {
            return;
        }
        this.excheangeRow(this.table, this.table.getRow(rowIndex), false);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"106_MatAllocWizardStep2UI"));
            return;
        }
        if (rowIndex == 0) {
            return;
        }
        this.excheangeRow(this.table, this.table.getRow(rowIndex), true);
    }

    private void excheangeRow(KDTable _table, IRow currentRow, boolean isUp) {
        int fromIndex = currentRow.getRowIndex();
        int toIndex = 0;
        toIndex = isUp ? fromIndex - 1 : fromIndex + 1;
        IRow toRow = _table.getRow(toIndex);
        this.excheangeRowValue(currentRow, toRow, col_select, false);
        this.excheangeRowValue(currentRow, toRow, col_ID, true);
        this.excheangeRowValue(currentRow, toRow, col_solution, false);
        this.excheangeRowValue(currentRow, toRow, col_allocStd, false);
        this.excheangeRowValue(currentRow, toRow, col_costItem, false);
        this.excheangeRowValue(currentRow, toRow, col_onlyUnAlloc, false);
    }

    private void excheangeRowValue(IRow fromRow, IRow toRow, String colKey, boolean copyUserObject) {
        Object fromValue = fromRow.getCell(colKey).getValue();
        Object toValue = toRow.getCell(colKey).getValue();
        fromRow.getCell(colKey).setValue(toValue);
        toRow.getCell(colKey).setValue(fromValue);
        if (copyUserObject) {
            Object fromUserObjectValue = fromRow.getCell(colKey).getUserObject();
            Object toUserObjectValue = toRow.getCell(colKey).getUserObject();
            fromRow.getCell(colKey).setUserObject(toUserObjectValue);
            toRow.getCell(colKey).setUserObject(fromUserObjectValue);
        }
    }

    public void saveAllocScheme(String companyId) throws BOSException, EASBizException {
        MatAllocWizardSchemeInfo schemeInfo;
        if (companyId == null || "".equals(companyId)) {
            return;
        }
        if (!this.vertify()) {
            SysUtil.abort();
        }
        if ((schemeInfo = this.getInputSchemes()) != null) {
            schemeInfo.setCompany(companyId);
            if (this.isDynCost) {
                schemeInfo.setCostType(NCMCostTypeEnum.DYNAMIC);
            } else {
                schemeInfo.setCostType(NCMCostTypeEnum.NORMAL);
            }
            IMatAllocWizardScheme iMatAllocWizScheme = MatAllocWizardSchemeFactory.getRemoteInstance();
            iMatAllocWizScheme.save(schemeInfo);
        }
    }

    public MatAllocWizardSchemeInfo getInputSchemes() {
        MatAllocWizardSchemeInfo info = null;
        if (this.table.getRowCount() > 0) {
            info = new MatAllocWizardSchemeInfo();
            int size = this.table.getRowCount();
            for (int i = 0; i < size; ++i) {
                IRow row = this.table.getRow(i);
                boolean select = false;
                Object value = row.getCell(col_select).getValue();
                if (value instanceof Boolean) {
                    select = (Boolean)value;
                }
                if (!select) continue;
                MatAllocWizardSchemeEntryInfo entry = new MatAllocWizardSchemeEntryInfo();
                AllocStdInfo allocStd = (AllocStdInfo)row.getCell(col_allocStd).getValue();
                CostItemInfo costItem = (CostItemInfo)row.getCell(col_costItem).getValue();
                QuerySolutionInfo solution = (QuerySolutionInfo)row.getCell(col_solution).getValue();
                entry.put("QuerySolutionInfo", solution);
                entry.setSolution(solution.getId().toString());
                entry.setAllocStd(allocStd.getId().toString());
                entry.setCostItem(costItem == null || costItem.getId() == null ? null : costItem.getId().toString());
                entry.setIsOnlyUnAlloc((Boolean)row.getCell(col_onlyUnAlloc).getValue());
                info.getEntrys().add(entry);
            }
        }
        if (info == null || info.getEntrys() == null || info.getEntrys().size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"112_MatAllocWizardUI"));
            SysUtil.abort();
        }
        return info;
    }

    public boolean vertify() {
        if (this.table.getRowCount() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"107_MatAllocWizardStep2UI"));
            return false;
        }
        HashMap solutions = new HashMap();
        int size = this.table.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.table.getRow(i);
            if (row.getCell(col_solution).getValue() == null || "".equals(row.getCell(col_solution).getValue())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"108_MatAllocWizardStep2UI"));
                return false;
            }
            if (row.getCell(col_allocStd).getValue() == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"109_MatAllocWizardStep2UI"));
                return false;
            }
            if (!(row.getCell(col_solution).getValue() instanceof QuerySolutionInfo)) continue;
            QuerySolutionInfo solution = (QuerySolutionInfo)row.getCell(col_solution).getValue();
            if (solutions.containsKey(solution.getId().toString())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"110_MatAllocWizardStep2UI"));
                return false;
            }
            solutions.put(solution.getId().toString(), null);
        }
        return true;
    }
}

