/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.ncm.bill.client.AbstractMaterialAllocListUI;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.bill.client.MatAllocFilterUI;
import com.kingdee.eas.ncm.bill.client.MatAllocWizardUI;
import com.kingdee.eas.ncm.bill.client.MaterialAllocEditUI;
import com.kingdee.eas.ncm.bill.client.MaterialAllocLogReportUI;
import com.kingdee.eas.ncm.bill.client.MaterialReqBillInNCMWizardUI;
import com.kingdee.eas.ncm.bill.utils.CostAllocUtils;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.client.CMBillBaseFilterUI;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.MaterialReqBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class MaterialAllocListUI
extends AbstractMaterialAllocListUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialAllocListUI.class);
    private static final String Col_ID = "id";
    private static final String Col_EntryID = "entry.id";
    protected boolean isNormal = true;
    protected CompanyOrgUnitInfo _company;
    private PeriodInfo _period;
    private static final String QtyCol = "entry.baseQty";
    private static final String PriceCol = "entry.unitActualCost";
    private static final String AmtCol = "entry.actualCost";
    private static final String Qty = "entry.qty";
    protected FilterInfo _currFilterInfo = null;
    protected boolean bFilter_all = false;
    protected int isOnlyUnAlloced = -1;
    private MatAllocFilterUI filterUI;
    private String companyID = null;
    private int year = 0;
    private int period = 0;
    private IMaterialReqBill rpc = null;
    private CommonQueryDialog dialog = null;

    public MaterialAllocListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
    }

    public void onLoad() throws Exception {
        if (this.isNormal) {
            NCMClientUtils.checkIsStart();
        }
        this._company = this.getCompanyOrgInfoWithDefault();
        this._period = this.GetCurrentPeriod();
        super.onLoad();
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.menuEdit.setVisible(false);
        this.initFormatTable();
        this.initCheckData();
        this.actionBatchUpdate.setEnabled(true);
        this.refreshList();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.ncm.bill.client.MaterialAllocEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialReqBillFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuItemViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    private void initCheckData() throws EASBizException, BOSException {
        this.companyID = this._company.getId().toString();
        PeriodInfo periodInfo = NCMUtils.GetCurrentPeriod(null, (String)this.companyID);
        if (periodInfo != null) {
            this.year = periodInfo.getPeriodYear();
            this.period = periodInfo.getPeriodNumber();
        }
        this.rpc = MaterialReqBillFactory.getRemoteInstance();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionViewAlloc_actionPerformed(null);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(MaterialAllocListUI.this.btnViewAlloc, 0, "Enter");
                ItemAction actView = MaterialAllocListUI.this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        });
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(this._period.getPeriodYear())));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(this._period.getPeriodNumber())));
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
            Set ccoTypeSet = this.getCostCenterType();
            filter.getFilterItems().add(new FilterItemInfo("entry.costCenterOrgUnit.costCenterType", (Object)ccoTypeSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
            filter.getFilterItems().add(new FilterItemInfo("storeTypePre.isForwardAmt", (Object)String.valueOf(true)));
            filter.getFilterItems().add(new FilterItemInfo("entry.bizDate", (Object)this._period.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("entry.bizDate", (Object)this._period.getEndDate(), CompareType.LESS_EQUALS));
            if (ev.getFilter() == null) {
                ev.setFilter(new FilterInfo());
            }
            for (FilterItemInfo item : ev.getFilter().getFilterItems()) {
                if (!item.getPropertyName().equals("isAllocated")) continue;
                int isAllocated = item.getInt("compareValue");
                int idx = ev.getFilter().getFilterItems().indexOf((IObjectValue)item);
                FilterItemInfo newItem = null;
                if (isAllocated == 1) {
                    newItem = new FilterItemInfo("baseStatus", (Object)String.valueOf(4));
                    this.isOnlyUnAlloced = 0;
                } else if (isAllocated == 0) {
                    newItem = new FilterItemInfo("baseStatus", (Object)String.valueOf(4));
                    this.isOnlyUnAlloced = 1;
                }
                ev.getFilter().getFilterItems().set(idx, newItem);
                break;
            }
            try {
                ev.getFilter().mergeFilter(filter, "and");
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected Set getCostCenterType() {
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(0);
        ccoTypeSet.add(1);
        return ccoTypeSet;
    }

    private PeriodInfo GetCurrentPeriod() throws BOSException, EASBizException {
        return NCMUtils.GetCurrentPeriod(null, (String)this._company.getId().toString());
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        if (this.getFilterUI() != null) {
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor(this.getFilterUI());
        cmcq.set("companyOrg", (Object)this._company.getId().toString());
        cmcq.set("query", (Object)"MaterialAllocQuery");
        try {
            boolean isShowShareCostObject = NCMUtils.isCostObjectOfBillRequired(null, (String)this._company.getId().toString());
            cmcq.set("showShareCostObject", (Object)isShowShareCostObject);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    private void setMergeColumn() {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("number").setGroup(true);
        this.tblMain.getColumn("number").setMergeable(true);
        this.tblMain.getColumn("baseStatus").setGroup(true);
        this.tblMain.getColumn("baseStatus").setMergeable(true);
        this.tblMain.getColumn("transactionType.name").setGroup(true);
        this.tblMain.getColumn("transactionType.name").setMergeable(true);
        this.tblMain.getColumn("bizDate").setGroup(true);
        this.tblMain.getColumn("bizDate").setMergeable(true);
        this.tblMain.getColumn("costCenterOrgUnit.number").setGroup(true);
        this.tblMain.getColumn("costCenterOrgUnit.number").setMergeable(true);
        this.tblMain.getColumn("costCenterOrgUnit.name").setGroup(true);
        this.tblMain.getColumn("costCenterOrgUnit.name").setMergeable(true);
        this.getUIContext().put("innerMergeColumnKeyList", new ArrayList());
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amoutPre = 2;
        int priceprec = 8;
        int baseUnitprce = 8;
        int unitPrec = 8;
        int assistUnitprec = 8;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                priceprec = rowSet.getInt("material.pricePrecision");
                amoutPre = rowSet.getInt("baseCurrency.precision");
                NCMClientUtils.iniColumnsPrecision((int)baseUnitprce, (String[])new String[]{QtyCol}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)priceprec, (String[])new String[]{PriceCol}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)amoutPre, (String[])new String[]{AmtCol}, (IRowSet)rowSet);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void initFormatTable() throws Exception {
        this.tblMain.getColumn(QtyCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(PriceCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(AmtCol).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(Qty).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("entry.assistQty").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        String[] cols = new String[]{QtyCol, PriceCol, AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])cols, (String)"%{0.##########}f");
        this.setMergeColumn();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("costCenterOrgUnit.number").setWidth(100);
        this.tblMain.getColumn("costCenterOrgUnit.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entry.seq").setWidth(72);
        this.tblMain.getColumn("entry.seq").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("material.number").setWidth(100);
        this.tblMain.getColumn("material.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("costObjectSuite.number").setWidth(100);
        this.tblMain.getColumn("costObjectSuite.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("material.model").setWidth(100);
        this.tblMain.getColumn("material.model").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("costObject.number").setWidth(100);
        this.tblMain.getColumn("costObject.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entry.lot").setWidth(100);
        this.tblMain.getColumn("entry.lot").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("costItem.number").setWidth(100);
        this.tblMain.getColumn("costItem.number").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("baseUnit.name").setWidth(78);
        this.tblMain.getColumn("baseUnit.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entry.assistUnit").setWidth(100);
        this.tblMain.getColumn("entry.assistUnit").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entry.assistQty").setWidth(100);
        this.tblMain.getColumn("entry.assistQty").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("warehouse.name").setWidth(100);
        this.tblMain.getColumn("warehouse.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("entry.remark").setWidth(100);
        this.tblMain.getColumn("entry.remark").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("creator.name").setWidth(100);
        this.tblMain.getColumn("creator.name").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("createTime").setWidth(100);
        this.tblMain.getColumn("createTime").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("baseStatus").setWidth(61);
        this.tblMain.getColumn("bizDate").setWidth(76);
        this.tblMain.getColumn("entry.isAdmeasure").setWidth(64);
        this.tblMain.getColumn("Unit.name").setWidth(56);
        String[] a = new String[]{Qty, "entry.assistQty", QtyCol, PriceCol, AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])a, (String)"%{###,###,###.##########}f");
    }

    @Override
    public void actionAutoAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionAutoAlloc_actionPerformed(e);
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(this._company, this._period)) {
            return;
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("company", this._company);
        source.put("period", this._period);
        source.put("user", SysContext.getSysContext().getCurrentUserInfo());
        source.put("filterInfo", this._currFilterInfo);
        this.bFilter_all = true;
        HashSet<String> filterItems = new HashSet<String>();
        filterItems.add("companyOrgUnit.id");
        filterItems.add("year");
        filterItems.add("period");
        filterItems.add("baseStatus");
        filterItems.add("entry.costCenterOrgUnit.costCenterType");
        filterItems.add("transactionType.isManuCostCalculate");
        filterItems.add("entry.bizDate");
        Iterator it = this._currFilterInfo.getFilterItems().iterator();
        while (it.hasNext()) {
            String PropertyName = ((FilterItemInfo)it.next()).getPropertyName();
            if (filterItems.contains(PropertyName)) continue;
            this.bFilter_all = false;
            break;
        }
        source.put("bFilter_all", String.valueOf(this.bFilter_all));
        if (this.isOnlyUnAlloced != -1) {
            if (this.isOnlyUnAlloced == 1) {
                source.put("isOnlyUnAlloced", String.valueOf(true));
            } else {
                source.put("isOnlyUnAlloced", String.valueOf(false));
            }
        }
        Map param = CostAllocUtils.buildMatReqAllocParam(source);
        CostTaskClientUtils.execute((Map)param, (CoreUIObject)this, (boolean)false);
        this.setLogInfo("actionAutoAlloc", "MatAlloc_Auto");
    }

    @Override
    public void actionManuAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionManuAlloc_actionPerformed(e);
        this.requestMutex(this._company.getId().toString());
        try {
            this.checkSelected();
            this.showAllocEditUI("ADJUST");
        }
        finally {
            this.releaseMutex(this._company.getId().toString());
            this.refreshList();
        }
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    @Override
    public void actionWizAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionWizAlloc_actionPerformed(e);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("company", this._company);
        param.put("period", this._period);
        param.put("billType", "MF");
        param.put("parentUi", (Object)this);
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)"param", param);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MatAllocWizardUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAlloc_actionPerformed(e);
        String oprationName = AllocSourceBillEnum.MaterialReqBill.getName() + "Alloc_View";
        NCMUtils.addEASLogForAlloc(null, (String)"actionViewAlloc_actionPerformed", (String)(this._company.getNumber() + ' ' + this._company.getName()), (String)oprationName, (String)this._company.getId().toString(), (boolean)true);
        this.showAllocEditUI("VIEW");
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewLog_actionPerformed(e);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("periodId", this._period.getId().toString());
        param.put("companyName", this._company.getName().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
        param.put("logTblName", "T_NCM_LOG_Mat");
        this.setLogInfo("actionViewLog", "MatAlloc_Error");
        MaterialAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    @Override
    public void actionBatchUpdate_actionPerformed(ActionEvent e) throws Exception {
        Map param = this.getSelectItems();
        this.checkSelectRowPeriod(param, this._company.getId().toString());
        this.checkBatchSetPermission();
        param.put("storage", this.getStorageId());
        try {
            MaterialReqBillInNCMWizardUI.showBatchSetWizardUI((CoreUIObject)this, param);
            if (param.get("OK").equals(String.valueOf(true))) {
                this.refreshList();
            }
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
    }

    private void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this._company.getId().toString());
        param.put("companyName", this._company.getName().toString());
        this.setPeriodForDaily(param, operType);
        param.put("filterInfo", (String)this._currFilterInfo);
        param.put("bFilter_all", String.valueOf(this.bFilter_all));
        if (this.isOnlyUnAlloced != -1) {
            if (this.isOnlyUnAlloced == 1) {
                param.put("isOnlyUnAlloced", String.valueOf(true));
            } else {
                param.put("isOnlyUnAlloced", String.valueOf(false));
            }
        }
        MaterialAllocEditUI.showAllocEditUI((CoreUIObject)this, param, operType, this.tblMain);
    }

    protected void setPeriodForDaily(Map param, String operType) throws BOSException {
        param.put("periodId", this._period.getId().toString());
        param.put("periodNumber", String.valueOf(this._period.getNumber()));
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (rowSet == null || rowSet.size() == 0) {
            this.actionAutoAlloc.setEnabled(false);
            this.actionViewAlloc.setEnabled(false);
            this.actionViewLog.setEnabled(false);
            this.actionManuAlloc.setEnabled(false);
            this.actionWizAlloc.setEnabled(false);
            this.actionPrint.setEnabled(false);
            this.actionPrintPreview.setEnabled(false);
        } else {
            this.actionAutoAlloc.setEnabled(true);
            this.actionViewAlloc.setEnabled(true);
            this.actionViewLog.setEnabled(true);
            this.actionManuAlloc.setEnabled(true);
            this.actionWizAlloc.setEnabled(true);
            this.actionPrint.setEnabled(true);
            this.actionPrintPreview.setEnabled(true);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setLogInfo("actionRefresh", "MatAlloc_View");
    }

    private void setLogInfo(String methodName, String logItemName) {
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new MatAllocFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        this._company = this.getCompanyOrgInfoWithDefault();
        this._period = this.GetCurrentPeriod();
    }

    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected CompanyOrgUnitInfo getCompanyOrgInfoWithDefault() {
        CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
        if (filterUI != null && filterUI.getCompanyF7() != null && filterUI.getCompanyF7().getData() != null && filterUI.getCompanyF7().getData() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)filterUI.getCompanyF7().getData();
            if (!org.isLoaded() && org.getId().toString().trim().length() > 0) {
                try {
                    org = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()));
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            return org;
        }
        if (this.getUIContext().containsKey(OrgType.Company) && this.getUIContext().get(OrgType.Company) != null) {
            return (CompanyOrgUnitInfo)this.getUIContext().get(OrgType.Company);
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
            if (filterUI == null) {
                return null;
            }
            filterUI.setMetaDataPKForPemmission(this.mainQueryPK);
            filterUI.setMetaDataPKForPemmissionByUI(this.getMetaDataPK());
            return filterUI;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
        if (filterUI == null) {
            return null;
        }
        return filterUI.getCompanyF7();
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        ArrayList<String> list = new ArrayList<String>();
        if (solution != null) {
            OrgUnitInfo[] orgUnitInfos = this.getMainOrgFromSolution(solution);
            if (orgUnitInfos != null && orgUnitInfos.length >= 1) {
                CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
                if (filterUI != null) {
                    String permissionItem = filterUI.getPermissionItem();
                    try {
                        if (!SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(orgUnitInfos[0].getId().toString()), (String)permissionItem)) {
                            MsgBox.showInfo((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u7684\u6743\u9650");
                            SysUtil.abort();
                        }
                    }
                    catch (EASBizException e) {
                        this.handUIException(e);
                    }
                    catch (BOSException e) {
                        this.handUIException(e);
                    }
                }
                this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfos[0]);
                for (int i = 0; i < orgUnitInfos.length; ++i) {
                    if (orgUnitInfos[i] == null) continue;
                    list.add(orgUnitInfos[i].getId().toString());
                }
            } else {
                this.getUIContext().put(this.getMainBizOrgType(), null);
                if (this.getMainOrgContext() != null) {
                    FrameWorkUtils.setCurrentOrgUnit((Context)this.getMainOrgContext(), null);
                }
            }
        } else if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            list.add(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
        }
        return list;
    }

    private OrgUnitInfo[] getMainOrgFromSolution(QuerySolutionInfo solution) {
        String key = this.getPropertyOfBizOrg(this.getMainBizOrgType());
        if (solution != null && key != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonFilterPanel") || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonSorterPanel") || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                try {
                    ArrayList al = XMLBean.TransStrToAL((String)params);
                    Iterator j = al.iterator();
                    XMLBean xb = null;
                    while (j.hasNext()) {
                        xb = (XMLBean)j.next();
                        cp.addCustomerParam(xb.getName(), xb.getValue());
                    }
                    String orgs = cp.getCustomerParam(key);
                    if (orgs != null) {
                        return SCMGroupClientUtils.getOrgUnitInfos((String)orgs);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        return null;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "CompanyPick";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor test = super.getQueryExecutor(queryPK, viewInfo);
        return test;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private Map getSelectItems() {
        this.checkSelected();
        HashMap param = new HashMap();
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                boolean isVouchered = (Boolean)row.getCell("isVoucher").getValue();
                boolean isReversed = (Boolean)row.getCell("isOfSet").getValue();
                if (isVouchered) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"101_ManufactureRecBillInNCMListUI"));
                    SysUtil.abort();
                }
                if (isReversed) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"102_ManufactureRecBillInNCMListUI"));
                    SysUtil.abort();
                }
                String id = row.getCell(Col_ID).getValue().toString();
                String entryId = row.getCell(Col_EntryID).getValue().toString();
                List<String> entryList = null;
                if (!param.containsKey(id)) {
                    entryList = new ArrayList<String>();
                    entryList.add(entryId);
                    param.put(id, entryList);
                    continue;
                }
                entryList = (List)param.get(id);
                entryList.add(entryId);
            }
        }
        return param;
    }

    private void checkSelectRowPeriod(Map param, String companyID) {
        Iterator paramIterator = param.keySet().iterator();
        HashSet paramSet = new HashSet();
        while (paramIterator.hasNext()) {
            Object id = paramIterator.next();
            paramSet.add(id);
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(Col_ID, paramSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MaterialReqBillCollection coll = this.rpc.getMaterialReqBillCollection(view);
            MaterialReqBillInfo tempInfo = null;
            for (int i = 0; i < coll.size(); ++i) {
                tempInfo = coll.get(i);
                if (tempInfo.getYear() == this.year && tempInfo.getPeriod() >= this.period || tempInfo.getYear() > this.year) continue;
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"100_ManufactureRecBillInNCMListUI"));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private String getStorageId() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(0);
        String storageId = this.tblMain.getCell(selectBlock.getTop(), "storageOrgUnit.id").getValue().toString();
        return storageId;
    }

    private void checkBatchSetPermission() throws BOSException, EASBizException {
        ArrayList<String> storages = new ArrayList<String>();
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String id = row.getCell("storageOrgUnit.id").getValue().toString();
                if (storages.contains(id)) continue;
                storages.add(id);
            }
        }
        IObjectPK[] orgPk = new IObjectPK[storages.size()];
        for (int i = 0; i < storages.size(); ++i) {
            orgPk[i] = new ObjectUuidPK(BOSUuid.read((String)storages.get(i).toString()));
        }
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkBatchPermission(this.getUserPk(), orgPk, "materialReqRecBatchSet");
    }
}

