/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.bill.AllocatorFacadeFactory;
import com.kingdee.eas.ncm.bill.client.AbstractMaterialAllocLogReportUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialAllocLogReportUI
extends AbstractMaterialAllocLogReportUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialAllocLogReportUI.class);
    private Map _parentParam = null;
    private String _companyId = null;
    private String _periodId = null;
    private String _companyName = null;
    private String _periodNumber = null;
    private String _logTblName = null;
    private IRowSet _logData = null;

    public static void showAllocReportUI(CoreUIObject ui, Map param) throws Exception {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("logTblName"));
        Assert.that((boolean)param.containsKey("companyName"));
        Assert.that((boolean)param.containsKey("periodNumber"));
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MaterialAllocLogReportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        if (this._parentParam == null) {
            this._parentParam = (Map)this.getUIContext().get("key.cost.task.entry.param");
        }
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this._logTblName = (String)this._parentParam.get("logTblName");
        this._companyName = (String)this._parentParam.get("companyName");
        this._periodNumber = (String)this._parentParam.get("periodNumber");
        if (this._companyName == null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this._companyId));
            this._companyName = company.getName();
        }
        if (this._periodNumber == null) {
            PeriodInfo period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(this._periodId));
            this._periodNumber = String.valueOf(period.getNumber());
        }
        this._logData = this._parentParam.containsKey("logData") ? (IRowSet)this._parentParam.get("logData") : AllocatorFacadeFactory.getRemoteInstance().getLogData(this._companyId, this._periodId, this._logTblName);
        if ("T_NCM_LOG_Mat".equals(this._parentParam.get("logTblName"))) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"113_MaterialAllocLogReportUI"));
        } else if ("T_NCM_LOG_OtherInWH".equals(this._parentParam.get("logTblName"))) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"114_MaterialAllocLogReportUI"));
        } else if ("T_NCM_LOG_CostAdjust".equals(this._parentParam.get("logTblName"))) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"115_MaterialAllocLogReportUI"));
        }
        this.kDTable.checkParsed();
        this.kDTable.getStyleAttributes().setWrapText(true);
        this.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        int rowCount = this.kDTable.getBody().size();
        for (int i = 0; i < rowCount; ++i) {
            KDTableHelper.autoFitRowHeight((KDTable)this.kDTable, (int)i, (int)2, (boolean)false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.fillReportData();
    }

    private void fillReportData() {
        try {
            this.txtCompany.setText(this._companyName);
            this.txtPeriod.setText(this._periodNumber);
            boolean isHandle = false;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss");
            this._logData.first();
            while (this._logData.getRow() > 0 && !this._logData.isAfterLast()) {
                if (!isHandle) {
                    this.txtLogTime.setText(sdf.format(this._logData.getTime("FLogTime")));
                    isHandle = true;
                }
                IRow row = this.kDTable.addRow();
                row.getCell("errorInfo").setValue((Object)this._logData.getString("FErrorInfo"));
                row.getCell("possibleReason").setValue((Object)this._logData.getString("FPossibleReason"));
                row.getCell("adviceHandle").setValue((Object)this._logData.getString("FAdviceHandle"));
                this._logData.next();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }
}

