/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.client.MaterialReqBillInNCMFilterUI;
import com.kingdee.eas.ncm.bill.client.MaterialReqBillInNCMWizardUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.SCMProcessorInNCM;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.MaterialReqBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.client.MaterialReqBillListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialReqBillInNCMListUI
extends MaterialReqBillListUI {
    private static Logger logger = Logger.getLogger((String)MaterialReqBillInNCMListUI.class.getName());
    protected KDWorkButton btnBatchSet;
    MaterialReqBillInNCMFilterUI filterUI = null;
    CommonQueryDialog commonQueryDialog = null;
    boolean hasPermission = false;
    private String companyID = null;
    private int year = 0;
    private int period = 0;
    private IMaterialReqBill rpc = null;

    public MaterialReqBillInNCMListUI() throws Exception {
        this.initBtnBatchSet();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCreateTo.setEnabled(false);
        this.btnCreateTo.setVisible(false);
        this.btnVoucher.setEnabled(false);
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setEnabled(false);
        this.btnDelVoucher.setVisible(false);
        this.menuItemCreateTo.setEnabled(false);
        this.menuItemCreateTo.setVisible(false);
        this.menuItemVoucher.setEnabled(false);
        this.menuItemVoucher.setVisible(false);
        this.menuItemDelVoucher.setEnabled(false);
        this.menuItemDelVoucher.setVisible(false);
        this.initCheckData();
    }

    private void initCheckData() throws EASBizException, BOSException {
        this.companyID = ((CompanyOrgUnitInfo)this.getMainContext().get((Object)"CompanyInfo")).getId().toString();
        PeriodInfo periodInfo = NCMUtils.GetCurrentPeriod(null, (String)this.companyID);
        if (periodInfo != null) {
            this.year = periodInfo.getPeriodYear();
            this.period = periodInfo.getPeriodNumber();
        }
        this.rpc = MaterialReqBillFactory.getRemoteInstance();
    }

    private void initBtnBatchSet() {
        this.btnBatchSet = new KDWorkButton();
        this.btnBatchSet.setText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"99_ManufactureRecBillInNCMListUI"));
        this.btnBatchSet.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"99_ManufactureRecBillInNCMListUI"));
        this.btnBatchSet.setIcon(EASResource.getIcon((String)"imgTbtn_editbatch"));
        this.btnBatchSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterialReqBillInNCMListUI.this.beforeActionPerformed(e);
                try {
                    MaterialReqBillInNCMListUI.this.actionBatchSet_actionPerformed(e);
                }
                catch (Exception exc) {
                    MaterialReqBillInNCMListUI.this.handUIException(exc);
                }
                finally {
                    MaterialReqBillInNCMListUI.this.afterActionPerformed(e);
                }
            }
        });
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.toolBar.add((Component)this.btnBatchSet);
    }

    private void actionBatchSet_actionPerformed(ActionEvent e) throws BOSException, EASBizException {
        Map param = this.getSelectItems();
        this.checkSelectRowPeriod(param, this.companyID);
        this.checkBatchSetPermission();
        param.put("storage", this.getStorageId());
        try {
            MaterialReqBillInNCMWizardUI.showBatchSetWizardUI((CoreUIObject)this, param);
            if (param.get("OK").equals(String.valueOf(true))) {
                this.refreshList();
            }
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
    }

    private String getStorageId() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(0);
        String storageId = this.tblMain.getCell(selectBlock.getTop(), "storageOrgUnit.id").getValue().toString();
        return storageId;
    }

    private void checkSelectRowPeriod(Map param, String companyID) {
        Iterator paramIterator = param.keySet().iterator();
        HashSet paramSet = new HashSet();
        while (paramIterator.hasNext()) {
            Object id = paramIterator.next();
            paramSet.add(id);
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", paramSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MaterialReqBillCollection coll = this.rpc.getMaterialReqBillCollection(view);
            MaterialReqBillInfo tempInfo = null;
            for (int i = 0; i < coll.size(); ++i) {
                tempInfo = coll.get(i);
                if (tempInfo.getYear() == this.year && tempInfo.getPeriod() >= this.period || tempInfo.getYear() > this.year) continue;
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"100_ManufactureRecBillInNCMListUI"));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void checkBatchSetPermission() throws BOSException, EASBizException {
        ArrayList<String> storages = new ArrayList<String>();
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String id = row.getCell("storageOrgUnit.id").getValue().toString();
                if (storages.contains(id)) continue;
                storages.add(id);
            }
        }
        IObjectPK[] orgPk = new IObjectPK[storages.size()];
        for (int i = 0; i < storages.size(); ++i) {
            orgPk[i] = new ObjectUuidPK(BOSUuid.read((String)storages.get(i).toString()));
        }
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkBatchPermission(this.getUserPk(), orgPk, "materialReqRecBatchSet");
    }

    private Map getSelectItems() {
        this.checkSelected();
        HashMap param = new HashMap();
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                boolean isVouchered = (Boolean)row.getCell("isVoucher").getValue();
                boolean isReversed = (Boolean)row.getCell("isOfSet").getValue();
                if (isVouchered) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"101_ManufactureRecBillInNCMListUI"));
                    SysUtil.abort();
                }
                if (isReversed) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"102_ManufactureRecBillInNCMListUI"));
                    SysUtil.abort();
                }
                String id = row.getCell("id").getValue().toString();
                String entryId = row.getCell("entry.id").getValue().toString();
                List<String> entryList = null;
                if (!param.containsKey(id)) {
                    entryList = new ArrayList<String>();
                    entryList.add(entryId);
                    param.put(id, entryList);
                    continue;
                }
                entryList = (List)param.get(id);
                entryList.add(entryId);
            }
        }
        return param;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new MaterialReqBillInNCMFilterUI();
        }
        return this.filterUI;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasPermission) {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            String statusInTable = ((BizEnumValueDTO)this.tblMain.getRow(rowIndex).getCell("baseStatus").getValue()).getValue().toString();
            boolean status = String.valueOf(4).equals(statusInTable);
            if (status) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"103_ManufactureRecBillInNCMListUI"));
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        this.commonQueryDialog = super.initCommonQueryDialog();
        SCMProcessorInNCM cmcq = new SCMProcessorInNCM();
        cmcq.set("query", (Object)"MaterialReqBillInNCM");
        this.commonQueryDialog.setProcessor((IProcessor)cmcq);
        return this.commonQueryDialog;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        FilterInfo ncmFilter = new FilterInfo();
        ncmFilter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)Boolean.TRUE));
        FilterInfo filter = ev.getFilter();
        if (filter != null) {
            try {
                ncmFilter.mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        ev.setFilter(ncmFilter);
    }

    public boolean isPrepareInit() {
        return true;
    }
}

