/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ncm.bill.ISCMRecBillInNCMFacade;
import com.kingdee.eas.ncm.bill.SCMRecBillInNCMFacadeFactory;
import com.kingdee.eas.ncm.bill.client.AbstractMaterialReqBillInNCMWizardUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialReqBillInNCMWizardUI
extends AbstractMaterialReqBillInNCMWizardUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialReqBillInNCMWizardUI.class);
    private Map _parentParam = null;
    private static final int SELECT_COSTCENTER_INDEX = 0;
    private static final int SELECT_COSTOBJECT_INDEX = 1;
    private static final int SELECT_COSTOBJSUITE_INDEX = 2;
    private static final int SELECT_COSTITEM_INDEX = 3;
    private static final int SELECT_REMARK_INDEX = 4;
    private int selectIndex = 0;
    private String companyID = "";
    private String controlUnitID = "";

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this.initOrgUnitIdByStorage();
        this.setCostCenterFilter();
        this.setCostObjectFilter();
        this.setCostObjectSuiteFilter();
        this.setCostItemFilter();
    }

    public static void showBatchSetWizardUI(CoreUIObject ui, Map param) throws Exception {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"param", (Object)param);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MaterialReqBillInNCMWizardUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    @Override
    protected void combItemSelect_itemStateChanged(ItemEvent e) throws Exception {
        super.combItemSelect_itemStateChanged(e);
        this.setTheSetValueCompStatus(this.combItemSelect.getSelectedIndex());
    }

    private void setTheSetValueCompStatus(int selectIndex) {
        this.contItemSetCostCenter.setEnabled(selectIndex == 0);
        this.contItemSetCostCenter.setVisible(selectIndex == 0);
        this.promptItemSetCostCenter.setEnabled(selectIndex == 0);
        this.promptItemSetCostCenter.setVisible(selectIndex == 0);
        this.contItemSetCostObject.setEnabled(selectIndex == 1);
        this.contItemSetCostObject.setVisible(selectIndex == 1);
        this.promptItemSetCostObject.setEnabled(selectIndex == 1);
        this.promptItemSetCostObject.setVisible(selectIndex == 1);
        this.contItemSetCostObjectSuite.setEnabled(selectIndex == 2);
        this.contItemSetCostObjectSuite.setVisible(selectIndex == 2);
        this.promptItemSetCostObjectSuite.setEnabled(selectIndex == 2);
        this.promptItemSetCostObjectSuite.setVisible(selectIndex == 2);
        this.contItemSetCostItem.setEnabled(selectIndex == 3);
        this.contItemSetCostItem.setVisible(selectIndex == 3);
        this.promptItemSetCostItem.setEnabled(selectIndex == 3);
        this.promptItemSetCostItem.setVisible(selectIndex == 3);
        this.contItemSetRemark.setEnabled(selectIndex == 4);
        this.contItemSetRemark.setVisible(selectIndex == 4);
        this.textFeildItemSetRemark.setEnabled(selectIndex == 4);
        this.textFeildItemSetRemark.setVisible(selectIndex == 4);
        this.selectIndex = selectIndex;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.checkAndSaveData();
        this._parentParam.put("OK", String.valueOf(true));
        this.destroyWindow();
    }

    private void checkAndSaveData() throws BOSException, EASBizException {
        this.checkInputNull();
        ISCMRecBillInNCMFacade rpc = SCMRecBillInNCMFacadeFactory.getRemoteInstance();
        if (this.selectIndex == 0) {
            rpc.updateCostCenterForMaterialRecBill(this._parentParam, (CostCenterOrgUnitInfo)this.promptItemSetCostCenter.getValue());
        } else if (this.selectIndex == 1) {
            rpc.updateCostObjectForMaterialRecBill(this._parentParam, (CostObjectInfo)this.promptItemSetCostObject.getValue());
        } else if (this.selectIndex == 2) {
            rpc.updateCostObjectSuiteForMaterialRecBill(this._parentParam, (CostObjectSuiteInfo)this.promptItemSetCostObjectSuite.getValue());
        } else if (this.selectIndex == 3) {
            rpc.updateCostItemForMaterialRecBill(this._parentParam, (CostItemInfo)this.promptItemSetCostItem.getValue());
        } else {
            rpc.updateRemarkForMaterialRecBill(this._parentParam, this.textFeildItemSetRemark.getText());
        }
    }

    private void checkInputNull() {
        if (this.selectIndex == 0) {
            if (this.promptItemSetCostCenter.getValue() == null) {
                this.showError(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"104_ManufactureRecBillInNCMWizardUI"));
            }
        } else if (this.selectIndex == 4 && (this.textFeildItemSetRemark.getText() == null || "".equals(this.textFeildItemSetRemark.getText()))) {
            this.showError(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"105_ManufactureRecBillInNCMWizardUI"));
        }
        if (this.selectIndex == 4 && this.textFeildItemSetRemark.getText().length() > 200) {
            MsgBox.showWarning((String)"\u5907\u6ce8\u957f\u5ea6\u8fc7\u957f\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            this.textFeildItemSetRemark.setText(null);
            SysUtil.abort();
        }
    }

    private void showError(String msg) {
        MsgBox.showError((String)msg);
        SysUtil.abort();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this._parentParam.put("OK", String.valueOf(false));
        this.destroyWindow();
    }

    protected boolean checkBeforeWindowClosing() {
        if (!this._parentParam.containsKey("OK")) {
            this._parentParam.put("OK", String.valueOf(false));
        }
        return super.checkBeforeWindowClosing();
    }

    private void setCostCenterFilter() throws EASBizException, BOSException {
        HashSet set = InvClientUtils.getCostCenterOrgUnitSet((String)this.companyID);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.promptItemSetCostCenter.setEntityViewInfo(viewInfo);
    }

    private void setCostObjectFilter() throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(this.getCompanyFilter());
        filterInfo.getFilterItems().add(new FilterItemInfo("relatedType", (Object)3, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        this.promptItemSetCostObject.setEntityViewInfo(viewInfo);
    }

    private void setCostObjectSuiteFilter() throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(this.getCompanyFilter());
        viewInfo.setFilter(filterInfo);
        this.promptItemSetCostObjectSuite.setEntityViewInfo(viewInfo);
    }

    private FilterItemInfo getCompanyFilter() throws BOSException, EASBizException {
        FilterItemInfo filterItemInfo = new FilterItemInfo("company.id", (Object)this.companyID, CompareType.EQUALS);
        return filterItemInfo;
    }

    private void initOrgUnitIdByStorage() throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getToUnit((String)this._parentParam.get("storage"), 4, 1);
        if (ccColl != null && ccColl.size() > 0 && (companyInfo = (CompanyOrgUnitInfo)ccColl.get(0)) != null) {
            this.companyID = companyInfo.getId().toString();
            this.controlUnitID = companyInfo.getCU().getId().toString();
        }
    }

    public CompanyOrgUnitInfo getCompanyById(String id) throws BOSException {
        CompanyOrgUnitInfo company = null;
        try {
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection("where id='" + id + "'");
            if (coll != null && coll.size() > 0) {
                company = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return company;
    }

    private void setCostItemFilter() throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.testSetCostItemFilter());
        this.promptItemSetCostItem.setEntityViewInfo(viewInfo);
    }

    private FilterInfo testSetCostItemFilter() throws EASBizException, BOSException {
        BOSObjectType bosObjectType = new BOSObjectType("548C5A91");
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosObjectType);
        String businessInterface = entityObjectInfo.getBusinessInterface();
        Class<?> model = null;
        try {
            model = Class.forName(businessInterface);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        IDataBaseD idbd = (IDataBaseD)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, model);
        return idbd.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(this.controlUnitID), "id", "CU.id");
    }
}

