/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.Constant;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadFactory;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.bill.AdjustAllocDataInfo;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.AllocatorFacadeFactory;
import com.kingdee.eas.ncm.bill.client.AbstractOtherAllocEditUI;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.AllocClientDispatch;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.Allocator;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.bill.client.OtherAllocListUI;
import com.kingdee.eas.ncm.common.client.ProgressHintListener;
import com.kingdee.eas.ncm.common.client.ProgressHintUI;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.dynamic.bill.client.AllocBuilder.DynAllocClientDispatch;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OtherAllocEditUI
extends AbstractOtherAllocEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherAllocEditUI.class);
    private static final String Col_ID = "FID";
    private static final String Col_AllocStdData = "AllocStdData";
    private static final String Col_CostItem = "costItem";
    private static final String Col_Qty = "Qty";
    private static final String Col_Price = "Price";
    private static final String Col_Amount = "Amount";
    private static final String Col_QtyPrecision = "FQtyPrecision";
    private static final String Col_PricePrecision = "FPricePrecision";
    private static final String Col_AmountPrecision = "FAmountPrecision";
    private Map _parentParam = null;
    protected String _companyId = null;
    protected String _periodId = null;
    protected String _sourceBillId = null;
    protected String _sourceBillEntryId = null;
    private String _ExpenseId = null;
    private String _CostCenterId = null;
    private CoreUIObject _parentUI;
    private TblMainIterator _iterator;
    protected String _operType = null;
    private IRowSet _Data = null;
    private Task _task;
    private boolean _allocating = false;
    private boolean _updating = false;
    private boolean _isDirty = false;
    private BigDecimal _totalQty = null;
    private BigDecimal _totalAmount = null;
    private final KeyListener keyListener = new KeyListener(){

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127 && OtherAllocEditUI.this.kDTable.getSelectManager().getActiveColumnIndex() == OtherAllocEditUI.this.kDTable.getColumnIndex(OtherAllocEditUI.Col_AllocStdData)) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            } else if (arg0.getKeyCode() == 10) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
            if (arg0.getKeyCode() == 127 && OtherAllocEditUI.this.kDTable.getSelectManager().getActiveColumnIndex() == OtherAllocEditUI.this.kDTable.getColumnIndex(OtherAllocEditUI.Col_AllocStdData)) {
                arg0.setKeyChar('\u0000');
                arg0.setKeyCode(0);
            }
        }
    };

    public static void showAllocEditUI(CoreUIObject otherAllocListUI, Map param, String operType, KDTable tblMain) throws Exception {
        if (otherAllocListUI instanceof OtherAllocListUI) {
            String uiName = ((OtherAllocListUI)otherAllocListUI).getEditUIName();
            OtherAllocEditUI.showAllocEditUI(otherAllocListUI, uiName, param, operType, tblMain);
        }
    }

    public static void showAllocEditUI(CoreUIObject otherAllocListUI, String allocEditUIName, Map param, String operType, KDTable tblMain) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("filterInfo"));
        Assert.that((tblMain != null ? 1 : 0) != 0);
        Assert.that((operType.equals("VIEW") || operType.equals("ADJUST") ? 1 : 0) != 0);
        try {
            UIContext uiContext = new UIContext((Object)allocEditUIName);
            uiContext.put((Object)"param", (Object)param);
            uiContext.put((Object)"operType", (Object)operType);
            uiContext.put((Object)"tblMain", (Object)tblMain);
            uiContext.put((Object)"parentUI", (Object)otherAllocListUI);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(allocEditUIName, (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)otherAllocListUI, (Throwable)e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this._parentParam = (Map)this.getUIContext().get("param");
        this._operType = (String)this.getUIContext().get("operType");
        KDTable tbl = (KDTable)this.getUIContext().get("tblMain");
        this._parentUI = (CoreUIObject)this.getUIContext().get("parentUI");
        this._iterator = new TblMainIterator(tbl);
        this._companyId = (String)this._parentParam.get("companyId");
        this._periodId = (String)this._parentParam.get("periodId");
        this.formatControls();
        if (this._operType.equals("ADJUST")) {
            this.setUITitle(NCMClientUtils.getNcmBillResource((String)"OtherAllocListEditUI_Title_Adjust"));
        }
        this.fillData();
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this._operType.equals("ADJUST")) {
            this._task = new Task();
            this._task.start(100, 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doManuAlloc(AllocStdInfo allocStd, boolean isOnlyRangeChange) throws Exception {
        AllocClientDispatch disp;
        IRowSet rs = null;
        HashMap param = new HashMap();
        param.put("filterInfo", this._parentParam.get("filterInfo"));
        param.put("companyId", this._parentParam.get("companyId"));
        param.put("periodId", this._parentParam.get("periodId"));
        param.put("companyName", this._parentParam.get("companyName"));
        param.put("periodNumber", this._parentParam.get("periodNumber"));
        param.put("sourceBillId", this._sourceBillId);
        param.put("sourceBillEntryId", this._sourceBillEntryId);
        if (allocStd != null) {
            param.put("allocStd", allocStd);
        }
        if (this.btnOnlyNotZero.isSelected()) {
            param.put("isOnlyNotZero", String.valueOf(true));
        } else {
            param.put("isOnlyNotZero", String.valueOf(false));
        }
        if (isOnlyRangeChange) {
            param.put("isOnlyRangeChange", String.valueOf(true));
        } else {
            param.put("isOnlyRangeChange", String.valueOf(false));
        }
        this.kDTable.removeRows();
        this.set_isDirty(true);
        Allocator alloc = null;
        if ("41852138".equals(BOSUuid.read((String)param.get("periodId").toString()).getType().toString())) {
            param.put("isNormal", 1);
            disp = new DynAllocClientDispatch();
            alloc = disp.DoOtherAllocate(this._parentUI, AllocTypeEnum.MANU, param);
        } else {
            disp = new AllocClientDispatch();
            alloc = disp.DoOtherAllocate(this._parentUI, AllocTypeEnum.MANU, param);
        }
        if (alloc.getResultInfo().containsKey("AdjustData")) {
            AllocStdInfo std = (AllocStdInfo)alloc.getResultInfo().get("AllocStd");
            try {
                this._allocating = true;
                this.kdbpbAllocStd.setValue((Object)std);
            }
            finally {
                this._allocating = false;
            }
            this._Data = rs = (IRowSet)alloc.getResultInfo().get("AdjustData");
            this.initKDTable();
        }
    }

    private void formatControls() {
        this.kDTable.checkParsed();
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setVisible(true);
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$number$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        KDTDefaultCellEditor ceCostItem = new KDTDefaultCellEditor((IKDEditor)prmtCostItem);
        this.kDTable.getColumn(Col_CostItem).setEditor((ICellEditor)ceCostItem);
        ObjectValueRender ovrCostItem = new ObjectValueRender();
        ovrCostItem.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kDTable.getColumn(Col_CostItem).setRenderer((IBasicRender)ovrCostItem);
        this.kDTable.getColumn(Col_AllocStdData).setRequired(true);
        this.kDTable.getColumn(Col_CostItem).setRequired(true);
        KDFormattedTextField txtAllocStdData = new KDFormattedTextField();
        txtAllocStdData.setDataType(1);
        txtAllocStdData.setPrecision(8);
        txtAllocStdData.setHorizontalAlignment(4);
        txtAllocStdData.setDecimalSeparatorAlwaysShown(true);
        txtAllocStdData.setRemoveingZeroInDispaly(true);
        txtAllocStdData.setMinimumValue((Comparable)SysConstant.BIGZERO);
        this.kDTable.getColumn(Col_AllocStdData).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtAllocStdData));
        this.kDTable.getColumn(Col_AllocStdData).getStyleAttributes().setNumberFormat("%{0.##########}f");
        if (this._operType.equals("VIEW")) {
            this.kdbpbAllocStd.setEditable(false);
            this.kdbpbAllocStd.setEnabled(false);
            this.kDTable.getColumn(Col_AllocStdData).getStyleAttributes().setLocked(true);
            this.kDTable.getColumn(Col_CostItem).getStyleAttributes().setLocked(true);
            this.actionSave.setVisible(false);
            this.btnOnlyNotZero.setVisible(false);
        } else {
            this.kdbpbAllocStd.setEditable(true);
            this.kdbpbAllocStd.setEnabled(true);
            this.kDTable.getColumn(Col_AllocStdData).getStyleAttributes().setLocked(false);
            this.kDTable.getColumn(Col_CostItem).getStyleAttributes().setLocked(false);
            this.actionSave.setVisible(true);
            this.actionSave.setEnabled(false);
            this.btnOnlyNotZero.setVisible(true);
        }
        this.kDTable.getColumn(Col_Qty).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kDTable.getColumn(Col_Price).getStyleAttributes().setNumberFormat("%{0.##########}f");
        this.kDTable.getColumn(Col_Amount).getStyleAttributes().setNumberFormat("%{0.##########}f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initKDTable() throws BOSException, EASBizException, SQLException {
        if (this._Data != null) {
            IRow row;
            boolean isSetted = false;
            this.kDTable.removeRows();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            BigDecimal totalAllocStdData = BigDecimal.valueOf(0L);
            BigDecimal totalAmount = BigDecimal.valueOf(0L);
            BigDecimal totalPrice = BigDecimal.valueOf(0L);
            BigDecimal totalQty = BigDecimal.valueOf(0L);
            this._Data.first();
            while (this._Data.getRow() > 0 && !this._Data.isAfterLast()) {
                if (!isSetted) {
                    if (this._operType.equals("VIEW")) {
                        this.kdbpbAllocStd.setText(this._Data.getString("FAllocStdName"));
                    } else {
                        try {
                            this._allocating = true;
                            if (this._Data.getString("FAllocStdId") != null) {
                                ObjectUuidPK pk = new ObjectUuidPK(this._Data.getString("FAllocStdId"));
                                AllocStdInfo std = AllocStdFactory.getRemoteInstance().getAllocStdInfo((IObjectPK)pk);
                                this.kdbpbAllocStd.setValue((Object)std);
                            } else {
                                this.kdbpbAllocStd.setValue(null);
                            }
                        }
                        finally {
                            this._allocating = false;
                        }
                    }
                    this.txtCreater.setText(this._Data.getString("FCreatorName"));
                    this.txtAdjuster.setText(this._Data.getString("FAdjustUserName"));
                    this.txtCreateTime.setText(sdf.format(this._Data.getTime("FCreateTime")));
                    if (this._Data.getString("FAdjustUserName") != null) {
                        this.txtAdjustTime.setText(sdf.format(this._Data.getTime("FAdjustTime")));
                    } else {
                        this.txtAdjustTime.setText("");
                    }
                    isSetted = true;
                }
                row = this.kDTable.addRow();
                row.getCell("costObjectId").setValue((Object)this._Data.getString("FCostObjectID"));
                row.getCell("costObjectNumber").setValue((Object)this._Data.getString("FCostObjectNumber"));
                row.getCell("costObjectName").setValue((Object)this._Data.getString("FCostObjectName"));
                row.getCell("model").setValue((Object)this._Data.getString("FProdModel"));
                String costObjectID = this._Data.getString("FCostObjectID");
                if (costObjectID != null) {
                    AUXOverheadInfo auxInfo;
                    String trackID;
                    CostObjectInfo costObject = CostObjectFactory.getRemoteInstance().getCostObjectInfo((IObjectPK)new ObjectUuidPK(costObjectID));
                    String orderID = costObject.getOrderID();
                    if (orderID != null) {
                        ManufactureOrderInfo order = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(orderID));
                        row.getCell("order.number").setValue((Object)order.getNumber());
                    }
                    row.getCell("batchNumber").setValue((Object)costObject.getBatchNumber());
                    String projectID = costObject.getProjectID();
                    if (projectID != null) {
                        ProjectInfo project = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(projectID));
                        row.getCell("projectNumber").setValue((Object)project.getNumber());
                    }
                    if ((trackID = costObject.getTrackID()) != null) {
                        TrackNumberInfo track = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackID));
                        row.getCell("trackNumber").setValue((Object)track.getNumber());
                    }
                    if (costObject.getStdProductID() != null) {
                        String materialID = costObject.getStdProductID().getId().toString();
                        if (materialID != null) {
                            MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                            row.getCell("material.number").setValue((Object)material.getNumber());
                            row.getCell("material.name").setValue((Object)material.getName());
                        }
                    } else if (costObject.getRelatedType().equals((Object)CORelatedType.Overhead) && costObject.getRelatedId() != null && (auxInfo = AUXOverheadFactory.getRemoteInstance().getAUXOverheadInfo((IObjectPK)new ObjectUuidPK(costObject.getRelatedId().toString()))) != null) {
                        row.getCell("material.number").setValue((Object)auxInfo.getNumber());
                        row.getCell("material.name").setValue((Object)auxInfo.getName());
                    }
                }
                row.getCell(Col_AllocStdData).setValue((Object)this._Data.getBigDecimal("FAllocStdData"));
                totalAllocStdData = totalAllocStdData.add(UIRuleUtil.getBigDecimal((Object)this._Data.getBigDecimal("FAllocStdData")));
                row.getCell(Col_Qty).setValue((Object)this._Data.getBigDecimal("FQty"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Qty), (int)this._Data.getInt(Col_QtyPrecision));
                totalQty = this._Data.getBigDecimal("FQty") == null ? totalQty.add(Constant.DECIMAL_0) : totalQty.add(this._Data.getBigDecimal("FQty"));
                row.getCell(Col_Price).setValue((Object)this._Data.getBigDecimal("FPrice"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Price), (int)this._Data.getInt(Col_PricePrecision));
                totalPrice = this._Data.getBigDecimal("FPrice") == null ? totalPrice.add(Constant.DECIMAL_0) : totalPrice.add(this._Data.getBigDecimal("FPrice"));
                row.getCell(Col_Amount).setValue((Object)this._Data.getBigDecimal("FAmount"));
                NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(Col_Amount), (int)this._Data.getInt(Col_AmountPrecision));
                totalAmount = this._Data.getBigDecimal("FAmount") == null ? totalAmount.add(Constant.DECIMAL_0) : totalAmount.add(this._Data.getBigDecimal("FAmount"));
                row.getCell(Col_CostItem).setValue((Object)this._Data.getString("FCostItemName"));
                if (this.hasDepartment()) {
                    row.getCell("department").setValue((Object)this._Data.getString("Fdepartmentname"));
                }
                if (row.getCell("sourceCostCenter") != null) {
                    row.getCell("sourceCostCenter").setValue((Object)this._Data.getString("FSourceCostCenterName"));
                }
                if (this._operType.equals("ADJUST")) {
                    row.getCell(Col_ID).setValue((Object)this._Data.getString(Col_ID));
                    row.getCell(Col_QtyPrecision).setValue((Object)this._Data.getBigDecimal(Col_QtyPrecision));
                    row.getCell(Col_PricePrecision).setValue((Object)this._Data.getBigDecimal(Col_PricePrecision));
                    row.getCell(Col_AmountPrecision).setValue((Object)this._Data.getBigDecimal(Col_AmountPrecision));
                    row.getCell(Col_CostItem).setUserObject((Object)this._Data.getString("FCostItemID"));
                }
                this._Data.next();
            }
            if (!totalAllocStdData.equals(BigDecimal.valueOf(0L))) {
                row = this.kDTable.addRow();
                row.getCell("costObjectName").setValue((Object)NCMClientUtils.getNcmBillResource((String)"SubTotal"));
                row.getCell(Col_AllocStdData).setValue((Object)totalAllocStdData);
                row.getCell(Col_Amount).setValue((Object)totalAmount);
                row.getCell(Col_Qty).setValue((Object)totalQty);
                row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                row.getStyleAttributes().setLocked(true);
            }
        }
    }

    protected boolean hasDepartment() {
        return true;
    }

    protected IRowSet GetAdjustData() throws BOSException {
        boolean forAdjust = this._operType.equals("ADJUST");
        return AllocatorFacadeFactory.getRemoteInstance().getOtherAdjustData(this._companyId, this._periodId, this._sourceBillId, this._sourceBillEntryId, forAdjust);
    }

    protected IRow fillData() throws BOSException, EASBizException, SQLException {
        IRow row = this._iterator.CurrentRow();
        if (row == null) {
            return null;
        }
        this.checkMustToSave();
        this.txtNumber.setText((String)row.getCell("number").getValue());
        this.txtEntrySeq.setText(String.valueOf(row.getCell(this.getSeqCol()).getValue()));
        this.txtCostCenterNumber.setText((String)row.getCell(this.getCol_CostCenterNumber()).getValue());
        this.txtCostCenterName.setText((String)row.getCell(this.getCol_CostCenterName()).getValue());
        this.txtExpenseNumber.setText((String)row.getCell("expense.number").getValue());
        this.txtExpenseName.setText((String)row.getCell("expense.name").getValue());
        if (row.getCell("department.name") != null) {
            this.prmtDepartment.setText((String)row.getCell("department.name").getValue());
        }
        if (row.getCell("sourceCostCenter.name") != null) {
            this.prmtSourceCostCenter.setText((String)row.getCell("sourceCostCenter.name").getValue());
        }
        if (row.getCell(this.getQtyCol()).getValue() == null) {
            this.txtQty.setText("0");
            this._totalQty = BigDecimal.valueOf(0L);
        } else {
            this.txtQty.setText(row.getCell(this.getQtyCol()).getValue().toString());
            this._totalQty = (BigDecimal)row.getCell(this.getQtyCol()).getValue();
        }
        if (row.getCell(this.getAmtCol()).getValue() == null) {
            this.txtAmount.setText("0");
            this._totalAmount = BigDecimal.valueOf(0L);
        } else {
            this.txtAmount.setText(row.getCell(this.getAmtCol()).getValue().toString());
            this._totalAmount = (BigDecimal)row.getCell(this.getAmtCol()).getValue();
        }
        this._sourceBillId = (String)row.getCell("id").getValue();
        this._sourceBillEntryId = (String)row.getCell(this.getCol_EntryID()).getValue();
        this._CostCenterId = (String)row.getCell(this.getCol_CostCenterID()).getValue();
        this._ExpenseId = (String)row.getCell(this.getCol_ExpenseID()).getValue();
        this.kdbpbAllocStd.setText("");
        this.setAllicStdTypeFilterByCC(this._CostCenterId);
        this._Data = this.GetAdjustData();
        this.initKDTable();
        return row;
    }

    private void setAllicStdTypeFilterByCC(String id) throws EASBizException, BOSException {
        CostCenterType ccType = this.getCostCenterTypeById(id);
        Integer allocStdType = null;
        if (CostCenterType.DirectProdDept.equals((Object)ccType)) {
            allocStdType = 2;
        } else if (CostCenterType.AssistantProdDept.equals((Object)ccType)) {
            allocStdType = 5;
        }
        BDCMClientUtils.filterDataBaseDF7((String)"D9EA44BF", (KDBizPromptBox)this.kdbpbAllocStd, (String)"allocStdType", (Object)allocStdType, (CompareType)CompareType.EQUALS);
    }

    private CostCenterType getCostCenterTypeById(String id) throws BOSException {
        ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
        CostCenterOrgUnitInfo costCenter = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        CostCenterOrgUnitCollection coll = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(view);
        if (coll != null && coll.size() > 0) {
            costCenter = coll.get(0);
        }
        if (costCenter == null) {
            return null;
        }
        return costCenter.getCostCenterType();
    }

    @Override
    protected void btnOnlyNotZero_itemStateChanged(ItemEvent e) throws Exception {
        super.btnOnlyNotZero_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            this.btnOnlyNotZero.setText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_ALL"));
            this.btnOnlyNotZero.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_ALL_Hint"));
        } else {
            this.btnOnlyNotZero.setText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_Default"));
            this.btnOnlyNotZero.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ncm.bill.BillResource", (String)"Adjust_Range_Default_Hint"));
        }
        this.checkMustToSave();
        if (this._allocating) {
            return;
        }
        AllocStdInfo std = (AllocStdInfo)this.kdbpbAllocStd.getValue();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("allocStd", std);
        param.put("isOnlyRangeChange", String.valueOf(true));
        this.progressManuAlloc(param);
    }

    @Override
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this._iterator.First();
        this.fillData();
    }

    @Override
    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this._iterator.Last();
        this.fillData();
    }

    @Override
    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this._iterator.Next();
        this.fillData();
    }

    @Override
    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this._iterator.Pre();
        this.fillData();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.fillData();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnFirst.setIcon(EASResource.getIcon((String)"imgTbtn_first"));
        this.btnPre.setIcon(EASResource.getIcon((String)"imgTbtn_previous"));
        this.btnNext.setIcon(EASResource.getIcon((String)"imgTbtn_next"));
        this.btnLast.setIcon(EASResource.getIcon((String)"imgTbtn_last"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnOnlyNotZero.setIcon(EASResource.getIcon((String)"imgTbtn_entirely"));
        this.btnOnlyNotZero.setSelectedIcon(EASResource.getIcon((String)"imgTbtn_partshow"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
    }

    private void progressManuAlloc(Map param) throws Exception {
        Assert.that((boolean)param.containsKey("allocStd"));
        Assert.that((boolean)param.containsKey("isOnlyRangeChange"));
        allocProgressHintListener listener = new allocProgressHintListener();
        ProgressHintUI.showProgressHintUI((CoreUIObject)this, (ProgressHintListener)listener, (Map)param);
    }

    private boolean hasAllocData() throws SQLException {
        if (this._Data == null) {
            return false;
        }
        this._Data.first();
        return this._Data.getRow() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void kdbpbAllocStd_dataChanged(DataChangeEvent e) throws Exception {
        super.kdbpbAllocStd_dataChanged(e);
        if (this._allocating) {
            return;
        }
        try {
            this._allocating = true;
            this.btnOnlyNotZero.setSelected(true);
            AllocStdInfo std = (AllocStdInfo)e.getNewValue();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("allocStd", std);
            param.put("isOnlyRangeChange", String.valueOf(false));
            this.progressManuAlloc(param);
        }
        finally {
            this._allocating = false;
        }
    }

    private void checkMustToSave() throws EASBizException, BOSException, SQLException {
        if (this._isDirty) {
            int ret = MsgBox.showConfirm3((String)NCMClientUtils.getNcmBillResource((String)"CHECK_DIRTY"));
            if (ret == 0) {
                if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(null, null)) {
                    SysUtil.abort();
                }
                try {
                    this.updateManuAdjustData();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)e.getMessage(), (int)8188);
                    SysUtil.abort();
                }
            } else if (ret == 2) {
                SysUtil.abort();
            } else if (ret == 1) {
                this.set_isDirty(false);
            }
        }
    }

    private void updateManuAdjustData() throws BOSException, AllocateException, EASBizException, SQLException {
        int rowCount = this.kDTable.getRowCount();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("companyID", this._companyId);
        data.put("periodID", this._periodId);
        data.put("sourceBillId", this._sourceBillId);
        data.put("sourceBillEntryId", this._sourceBillEntryId);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        data.put("userId", user.getId().toString());
        String allocStdId = null;
        if (this.kdbpbAllocStd.getValue() instanceof AllocStdInfo) {
            AllocStdInfo std = (AllocStdInfo)this.kdbpbAllocStd.getValue();
            allocStdId = std.getId().toString();
        }
        data.put("allocStdID", allocStdId);
        if (rowCount > 0) {
            AdjustAllocDataInfo[] info = new AdjustAllocDataInfo[rowCount - 1];
            for (int i = 0; i < rowCount - 1; ++i) {
                IRow row = this.kDTable.getRow(i);
                ICell id = row.getCell(Col_ID);
                ICell allocStdData = row.getCell(Col_AllocStdData);
                ICell costItem = row.getCell(Col_CostItem);
                ICell qty = row.getCell(Col_Qty);
                ICell price = row.getCell(Col_Price);
                ICell amount = row.getCell(Col_Amount);
                String costItemId = costItem.getUserObject().toString();
                if (costItemId.trim().length() <= 0) {
                    throw new AllocateException(AllocateException.ITEM_MANUALLOC_NO_COSTITEM);
                }
                info[i] = new AdjustAllocDataInfo(id.getValue().toString(), costItemId, (BigDecimal)allocStdData.getValue(), (BigDecimal)qty.getValue(), (BigDecimal)price.getValue(), (BigDecimal)amount.getValue());
            }
            data.put("Info", info);
        } else {
            data.put("Info", null);
        }
        AllocatorFacadeFactory.getRemoteInstance().updateOtherAdjustData(data);
        this.set_isDirty(false);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.checkMustToSave();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }

    @Override
    protected void kDTable_editStopped(KDTEditEvent e) throws Exception {
        super.kDTable_editStopped(e);
        if (e.getColIndex() == this.kDTable.getColumnIndex(Col_AllocStdData)) {
            if (!e.getValue().equals(e.getOldValue())) {
                this.set_isDirty(true);
                if (!this._updating) {
                    try {
                        this._updating = true;
                        this.updateAlloc();
                    }
                    finally {
                        this._updating = false;
                    }
                }
            }
        } else if (e.getColIndex() == this.kDTable.getColumnIndex(Col_CostItem) && e.getOldValue() != e.getValue()) {
            this.set_isDirty(true);
            if (e.getValue() instanceof CostItemInfo) {
                String costItemId = ((CostItemInfo)e.getValue()).getId().toString();
                this.kDTable.getRow(e.getRowIndex()).getCell(Col_CostItem).setUserObject((Object)costItemId);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(null, null)) {
            return;
        }
        try {
            this.updateManuAdjustData();
            this.fillData();
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"SAVE_FAIL"), (String)ex.getMessage(), (int)8188);
            SysUtil.abort();
        }
        this.setLogInfo("actionManuAlloc", "OtherAlloc_Manu");
    }

    private void setLogInfo(String methodName, String logItemName) {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        IObjectPK pk = LogUtil.beginLog(null, (String)methodName, (BOSObjectType)new BOSObjectType("DE8319CC"), null, (String)(company.getNumber() + " " + company.getName()), (String)logItemName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    public void set_isDirty(boolean dirty) throws EASBizException, BOSException, SQLException {
        this._isDirty = dirty;
        this.actionSave.setEnabled(dirty);
        if (!dirty) {
            this.fillData();
        }
    }

    private void updateAlloc() {
        ICell allocStdData;
        IRow row;
        int i;
        BigDecimal totalAllocStdData = BigDecimal.valueOf(0L);
        BigDecimal totalAllocedQty = BigDecimal.valueOf(0L);
        BigDecimal totalAllocedAmount = BigDecimal.valueOf(0L);
        BigDecimal maxAllocStdData = BigDecimal.valueOf(0L);
        int maxRateRowIndex = 0;
        for (i = 0; i < this.kDTable.getRowCount() - 1; ++i) {
            row = this.kDTable.getRow(i);
            allocStdData = row.getCell(Col_AllocStdData);
            totalAllocStdData = totalAllocStdData.add((BigDecimal)allocStdData.getValue());
        }
        for (i = 0; i < this.kDTable.getRowCount() - 1; ++i) {
            row = this.kDTable.getRow(i);
            allocStdData = row.getCell(Col_AllocStdData);
            ICell qty = row.getCell(Col_Qty);
            ICell price = row.getCell(Col_Price);
            ICell amount = row.getCell(Col_Amount);
            int qtyPrec = ((BigDecimal)row.getCell(Col_QtyPrecision).getValue()).intValue();
            int pricePrec = ((BigDecimal)row.getCell(Col_PricePrecision).getValue()).intValue();
            int amountPrec = ((BigDecimal)row.getCell(Col_AmountPrecision).getValue()).intValue();
            BigDecimal value = (BigDecimal)allocStdData.getValue();
            if (value == null) {
                value = BigDecimal.valueOf(0L);
            }
            if (maxAllocStdData.compareTo(value) < 0) {
                maxAllocStdData = value;
                maxRateRowIndex = i;
            }
            BigDecimal rate = null;
            rate = totalAllocStdData.compareTo(BigDecimal.valueOf(0L)) <= 0 ? BigDecimal.valueOf(0L) : value.divide(totalAllocStdData, 12, 4);
            BigDecimal tempQty = this._totalQty.multiply(rate).setScale(qtyPrec, 4);
            totalAllocedQty = totalAllocedQty.add(tempQty);
            qty.setValue((Object)tempQty);
            BigDecimal tempAmount = this._totalAmount.multiply(rate).setScale(amountPrec, 4);
            totalAllocedAmount = totalAllocedAmount.add(tempAmount);
            amount.setValue((Object)tempAmount);
            BigDecimal tempPrice = null;
            tempPrice = tempQty.compareTo(BigDecimal.valueOf(0L)) == 0 ? BigDecimal.valueOf(0L) : tempAmount.divide(tempQty, pricePrec, 4);
            price.setValue((Object)tempPrice);
        }
        if (this._totalAmount.compareTo(totalAllocedAmount) != 0 && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row2 = this.kDTable.getRow(maxRateRowIndex);
            ICell amount = row2.getCell(Col_Amount);
            BigDecimal tempAmt = ((BigDecimal)amount.getValue()).add(this._totalAmount).subtract(totalAllocedAmount);
            totalAllocedAmount = totalAllocedAmount.add(this._totalAmount).subtract(totalAllocedAmount);
            amount.setValue((Object)tempAmt);
        }
        if (this._totalQty.compareTo(totalAllocedQty) != 0 && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row3 = this.kDTable.getRow(maxRateRowIndex);
            ICell qty = row3.getCell(Col_Qty);
            BigDecimal tempQty = ((BigDecimal)qty.getValue()).add(this._totalQty).subtract(totalAllocedQty);
            totalAllocedQty = totalAllocedQty.add(this._totalQty).subtract(totalAllocedQty);
            qty.setValue((Object)tempQty);
        }
        if ((this._totalAmount.compareTo(totalAllocedAmount) != 0 || this._totalQty.compareTo(totalAllocedQty) != 0) && maxAllocStdData.compareTo(BigDecimal.valueOf(0L)) > 0) {
            IRow row4 = this.kDTable.getRow(maxRateRowIndex);
            BigDecimal tempPrice = null;
            tempPrice = ((BigDecimal)row4.getCell(Col_Qty).getValue()).compareTo(BigDecimal.valueOf(0L)) == 0 ? BigDecimal.valueOf(0L) : ((BigDecimal)row4.getCell(Col_Amount).getValue()).divide((BigDecimal)row4.getCell(Col_Qty).getValue(), ((BigDecimal)row4.getCell(Col_AmountPrecision).getValue()).intValue(), 4);
            row4.getCell(Col_Price).setValue((Object)tempPrice);
        }
        this.kDTable.getRow(this.kDTable.getRowCount() - 1).getCell(Col_AllocStdData).setValue((Object)totalAllocStdData);
        this.kDTable.getRow(this.kDTable.getRowCount() - 1).getCell(Col_Qty).setValue((Object)totalAllocedQty);
        this.kDTable.getRow(this.kDTable.getRowCount() - 1).getCell(Col_Amount).setValue((Object)totalAllocedAmount);
    }

    protected void initListener() {
        super.initListener();
        this.kDTable.addKeyListener(this.keyListener);
    }

    public String getCol_ID() {
        return "id";
    }

    public String getCol_ExpenseID() {
        return "expense.id";
    }

    public String getCol_CostCenterID() {
        return "costCenter.id";
    }

    public String getCol_CostCenterNumber() {
        return "costCenter.number";
    }

    public String getCol_CostCenterName() {
        return "costCenter.name";
    }

    public String getCol_EntryID() {
        return "entries.id";
    }

    public String getSeqCol() {
        return "entries.seq";
    }

    public String getQtyCol() {
        return "entries.qty";
    }

    public String getPriceCol() {
        return "entries.price";
    }

    public String getAmtCol() {
        return "entries.amount";
    }

    private class Task {
        private Timer timer;
        private TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    Task.this.timer.cancel();
                    if (OtherAllocEditUI.this._operType.equals("ADJUST") && !OtherAllocEditUI.this.hasAllocData()) {
                        try {
                            HashMap<String, String> param = new HashMap<String, String>();
                            param.put("allocStd", null);
                            param.put("isOnlyRangeChange", String.valueOf(false));
                            OtherAllocEditUI.this.progressManuAlloc(param);
                        }
                        catch (Exception e) {
                            logger.error((Object)"", (Throwable)e);
                            OtherAllocEditUI.this.handUIException(e);
                        }
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        };

        public Task() {
            this.timer = new Timer(false);
        }

        public void start(int delay, int internal) {
            this.timer.schedule(this.task, delay, (long)internal);
        }
    }

    private class TblMainIterator {
        private KDTable _tblMain;
        private int _currentRowIndex = -1;

        public TblMainIterator(KDTable tblMain) {
            this._tblMain = tblMain;
            this._currentRowIndex = this._tblMain.getSelectManager().getActiveRowIndex();
        }

        public void First() {
            this._currentRowIndex = 0;
            OtherAllocEditUI.this.actionFirst.setEnabled(false);
            OtherAllocEditUI.this.actionPre.setEnabled(false);
            OtherAllocEditUI.this.actionNext.setEnabled(true);
            OtherAllocEditUI.this.actionLast.setEnabled(true);
        }

        public void Pre() {
            if (!this.IsFirst()) {
                --this._currentRowIndex;
                OtherAllocEditUI.this.actionFirst.setEnabled(true);
                OtherAllocEditUI.this.actionPre.setEnabled(true);
                OtherAllocEditUI.this.actionNext.setEnabled(true);
                OtherAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                OtherAllocEditUI.this.actionFirst.setEnabled(false);
                OtherAllocEditUI.this.actionPre.setEnabled(false);
                OtherAllocEditUI.this.actionNext.setEnabled(true);
                OtherAllocEditUI.this.actionLast.setEnabled(true);
            }
        }

        public void Next() {
            if (!this.IsLast()) {
                ++this._currentRowIndex;
                OtherAllocEditUI.this.actionFirst.setEnabled(true);
                OtherAllocEditUI.this.actionPre.setEnabled(true);
                OtherAllocEditUI.this.actionNext.setEnabled(true);
                OtherAllocEditUI.this.actionLast.setEnabled(true);
            } else {
                OtherAllocEditUI.this.actionFirst.setEnabled(true);
                OtherAllocEditUI.this.actionPre.setEnabled(true);
                OtherAllocEditUI.this.actionNext.setEnabled(false);
                OtherAllocEditUI.this.actionLast.setEnabled(false);
            }
        }

        public void Last() {
            this._currentRowIndex = this._tblMain.getRowCount() - 1;
            OtherAllocEditUI.this.actionFirst.setEnabled(true);
            OtherAllocEditUI.this.actionPre.setEnabled(true);
            OtherAllocEditUI.this.actionNext.setEnabled(false);
            OtherAllocEditUI.this.actionLast.setEnabled(false);
        }

        public boolean IsFirst() {
            return this._currentRowIndex == 0;
        }

        public boolean IsLast() {
            return this._tblMain.getRowCount() == this._currentRowIndex + 1;
        }

        public IRow CurrentRow() {
            return this._tblMain.getRow(this._currentRowIndex);
        }
    }

    private final class allocProgressHintListener
    implements ProgressHintListener {
        private allocProgressHintListener() {
        }

        public void doFunction(Map param) throws Exception {
            AllocStdInfo allocStd = (AllocStdInfo)param.get("allocStd");
            boolean isOnlyRangeChange = false;
            if (param.get("isOnlyRangeChange").equals(String.valueOf(true))) {
                isOnlyRangeChange = true;
            }
            OtherAllocEditUI.this.doManuAlloc(allocStd, isOnlyRangeChange);
        }
    }
}

