/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.client.AbstractOtherAllocListUI;
import com.kingdee.eas.ncm.bill.client.AllocBuilder.AllocClientDispatch;
import com.kingdee.eas.ncm.bill.client.FeeAllocClientUtils;
import com.kingdee.eas.ncm.bill.client.OtherAllocEditUI;
import com.kingdee.eas.ncm.bill.client.OtherAllocFilterUI;
import com.kingdee.eas.ncm.bill.client.OtherAllocLogReportUI;
import com.kingdee.eas.ncm.bill.utils.CostAllocUtils;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.client.CMBillBaseFilterUI;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMCommonQueryProcessor;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class OtherAllocListUI
extends AbstractOtherAllocListUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherAllocListUI.class);
    protected String Col_ID = "id";
    protected String Col_EntryID = "entries.id";
    protected boolean isNormal = true;
    protected CompanyOrgUnitInfo _company;
    protected PeriodInfo _period;
    protected String QtyCol = "entries.qty";
    protected String PriceCol = "entries.price";
    protected String AmtCol = "entries.amount";
    protected FilterInfo _currFilterInfo = null;
    protected boolean bFilter_all = false;
    private OtherAllocFilterUI filterUI;
    private CommonQueryDialog dialog = null;

    public OtherAllocListUI() throws Exception {
        NCMClientUtils.checkLoginCompanyOrgIsVirtual();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRowIndex = e.getFirstRow();
                int lastRowIndex = e.getLastRow();
                IRow row = null;
                int precision = 0;
                for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                    row = OtherAllocListUI.this.tblMain.getRow(i);
                    if (row.getCell(OtherAllocListUI.this.AmtCol) != null && row.getCell(OtherAllocListUI.this.AmtCol).getValue() != null) {
                        precision = ((BigDecimal)row.getCell(OtherAllocListUI.this.AmtCol).getValue()).scale();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(OtherAllocListUI.this.AmtCol), (int)precision);
                    }
                    if (row.getCell(OtherAllocListUI.this.QtyCol) != null && row.getCell(OtherAllocListUI.this.QtyCol).getValue() != null) {
                        precision = ((BigDecimal)row.getCell(OtherAllocListUI.this.QtyCol).getValue()).scale();
                        NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(OtherAllocListUI.this.QtyCol), (int)precision);
                    }
                    if (row.getCell(OtherAllocListUI.this.PriceCol) == null || row.getCell(OtherAllocListUI.this.PriceCol).getValue() == null) continue;
                    precision = ((BigDecimal)row.getCell(OtherAllocListUI.this.PriceCol).getValue()).scale();
                    NCMClientUtils.setBigDecimalFieldsPrecisionByCell((ICell)row.getCell(OtherAllocListUI.this.PriceCol), (int)precision);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        if (this.isNormal) {
            NCMClientUtils.checkIsStart();
        }
        this._company = this.getCompanyOrgInfoWithDefault();
        this._period = this.GetCurrentPeriod();
        super.onLoad();
        this.actionLocate.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionStartWorkFlow.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionWizAlloc.setVisible(false);
        this.menuEdit.setVisible(false);
        this.initFormatTable();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.ncm.bill.client.OtherAllocEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OtherFeeBillFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.btnViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemAutoAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemManuAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_flowexample"));
        this.menuItemViewAlloc.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemViewLog.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionViewAlloc_actionPerformed(null);
        }
    }

    protected void initKeyStroke() {
        this.tblMain.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "View_1");
        this.tblMain.getActionMap().put("View_1", new AbstractAction(){
            private static final long serialVersionUID = -5669325198048189263L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent evt = new ActionEvent(OtherAllocListUI.this.btnViewAlloc, 0, "Enter");
                ItemAction actView = OtherAllocListUI.this.getActionFromActionEvent(evt);
                actView.actionPerformed(evt);
            }
        });
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        this._company = this.getCompanyOrgInfoWithDefault();
        try {
            this._period = this.GetCurrentPeriod();
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.GetCurrentPeriod().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.getCompanyOrgInfoWithDefault().getId().toString()));
            HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
            ccoTypeSet.add(0);
            ccoTypeSet.add(1);
            filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", ccoTypeSet, CompareType.INCLUDE));
            for (FilterItemInfo item : ev.getFilter().getFilterItems()) {
                if (!item.getPropertyName().equals("isAllocated")) continue;
                String tblResult = this.getResultTblName();
                int isAllocated = item.getInt("compareValue");
                int idx = ev.getFilter().getFilterItems().indexOf((IObjectValue)item);
                FilterItemInfo newItem = null;
                if (isAllocated == 1) {
                    newItem = new FilterItemInfo("entries.id", (Object)("(Select FSourceBillEntryID from " + tblResult + ")"), CompareType.INNER, false);
                } else if (isAllocated == 0) {
                    newItem = new FilterItemInfo("entries.id", (Object)("(Select FSourceBillEntryID from " + tblResult + ")"), CompareType.NOTINNER, false);
                }
                ev.getFilter().getFilterItems().set(idx, newItem);
                break;
            }
            try {
                ev.getFilter().mergeFilter(filter, "and");
                this._currFilterInfo = (FilterInfo)ev.getFilter().clone();
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    protected String getResultTblName() throws BOSException {
        String tblResult = NCMCommonFacadeFactory.getRemoteInstance().getPhysicalTblName(this.getCompanyOrgInfoWithDefault().getId().toString(), "T_NCM_OtherAllocResult");
        return tblResult;
    }

    private PeriodInfo GetCurrentPeriod() throws BOSException, EASBizException {
        return NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog == null) {
            this.dialog = super.initCommonQueryDialog();
        }
        if (this.getFilterUI() != null) {
            this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        }
        NCMCommonQueryProcessor cmcq = new NCMCommonQueryProcessor(this.getFilterUI());
        cmcq.set("companyOrg", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
        cmcq.set("query", (Object)"OtherAllocQuery");
        try {
            boolean isShowShareCostObject = NCMUtils.isCostObjectOfBillRequired(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
            cmcq.set("showShareCostObject", (Object)isShowShareCostObject);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "bizDate", "companyOrg.name", "costCenter.number", "costCenter.name"};
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int amoutPre = 2;
        int priceprec = 8;
        int baseUnitprce = 8;
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                baseUnitprce = rowSet.getInt(this.getQtyColPricisionInQuery());
                priceprec = rowSet.getInt(this.getPriceColPricisionInQuery());
                amoutPre = rowSet.getInt(this.getAmtColPricisionInQuery());
                NCMClientUtils.iniColumnsPrecision((int)baseUnitprce, (String[])new String[]{this.getQtyCol()}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)priceprec, (String[])new String[]{this.getPriceCol()}, (IRowSet)rowSet);
                NCMClientUtils.iniColumnsPrecision((int)amoutPre, (String[])new String[]{this.getAmtCol()}, (IRowSet)rowSet);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void initFormatTable() throws Exception {
        this.tblMain.getColumn(this.getQtyCol()).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(this.getPriceCol()).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(this.getAmtCol()).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd HH:mm:ss");
        this.tblMain.getSelectManager().setSelectMode(2);
        String[] a = new String[]{this.QtyCol, this.PriceCol, this.AmtCol};
        NCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])a, (String)"%{###,###,###.##########}f");
    }

    @Override
    public void actionAutoAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionAutoAlloc_actionPerformed(e);
        if (!FeeAllocClientUtils.showCalHintBeforeFeeAlloc(this.getCompanyOrgInfoWithDefault(), this.GetCurrentPeriod())) {
            return;
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("company", this._company);
        source.put("period", this._period);
        source.put("user", SysContext.getSysContext().getCurrentUserInfo());
        source.put("filterInfo", this._currFilterInfo);
        this.bFilter_all = true;
        HashSet<String> filterItems = new HashSet<String>();
        filterItems.add("companyOrg.id");
        filterItems.add("calculatePeriod.id");
        filterItems.add("billStatus");
        filterItems.add("costCenter.costCenterType");
        filterItems.add("CU.id");
        Iterator it = this._currFilterInfo.getFilterItems().iterator();
        while (it.hasNext()) {
            String PropertyName = ((FilterItemInfo)it.next()).getPropertyName();
            if (filterItems.contains(PropertyName)) continue;
            this.bFilter_all = false;
            break;
        }
        source.put("bFilter_all", String.valueOf(this.bFilter_all));
        Map param = CostAllocUtils.buildOtherFeeAllocParam(source);
        CostTaskClientUtils.execute((Map)param, (CoreUIObject)this, (boolean)false);
        this.setLogInfo("actionAutoAlloc", "OtherAlloc_Auto");
    }

    @Override
    public void actionManuAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionManuAlloc_actionPerformed(e);
        this.requestMutex(this.getCompanyOrgInfoWithDefault().getId().toString());
        try {
            this.checkSelected();
            this.showAllocEditUI("ADJUST");
        }
        finally {
            this.releaseMutex(this.getCompanyOrgInfoWithDefault().getId().toString());
        }
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    private FilterInfo GetManuFilter(FilterInfo filter) {
        int top = this.tblMain.getSelectManager().get(0).getBeginRow();
        String id = this.tblMain.getRow(top).getCell(this.getCol_ID()).getValue().toString();
        String entryId = this.tblMain.getRow(top).getCell(this.getCol_EntryID()).getValue().toString();
        FilterInfo ret = new FilterInfo();
        try {
            FilterInfo addfilter = new FilterInfo();
            addfilter.getFilterItems().add(new FilterItemInfo(this.getCol_ID(), (Object)id));
            addfilter.getFilterItems().add(new FilterItemInfo(this.getCol_EntryID(), (Object)entryId));
            try {
                ret.mergeFilter(filter, "and ");
                ret.mergeFilter(addfilter, "and");
                return ret;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void actionWizAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionWizAlloc_actionPerformed(e);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("filterInfo", this._currFilterInfo);
        param.put("bFilter_all", String.valueOf(this.bFilter_all));
        param.put("companyId", this.getCompanyOrgInfoWithDefault().getId().toString());
        param.put("periodId", this.GetCurrentPeriod().getId().toString());
        param.put("parentUi", (Object)this);
        param.put("companyName", this.getCompanyOrgInfoWithDefault().getName().toString());
        param.put("periodNumber", String.valueOf(this.GetCurrentPeriod().getNumber()));
        AllocClientDispatch disp = new AllocClientDispatch();
        disp.DoOtherAllocate((CoreUIObject)this, AllocTypeEnum.WIZ, param);
    }

    @Override
    public void actionViewAlloc_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewAlloc_actionPerformed(e);
        String oprationName = AllocSourceBillEnum.OtherFeeBill.getName() + "Alloc_View";
        NCMUtils.addEASLogForAlloc(null, (String)"actionViewAlloc_actionPerformed", (String)(this.getCompanyOrgInfoWithDefault().getNumber() + ' ' + this.getCompanyOrgInfoWithDefault().getName()), (String)oprationName, (String)this.getCompanyOrgInfoWithDefault().getId().toString(), (boolean)true);
        this.showAllocEditUI("VIEW");
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewLog_actionPerformed(e);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.getCompanyOrgInfoWithDefault().getId().toString());
        param.put("periodId", this.GetCurrentPeriod().getId().toString());
        param.put("companyName", this.getCompanyOrgInfoWithDefault().getName().toString());
        param.put("periodNumber", String.valueOf(this.GetCurrentPeriod().getNumber()));
        param.put("logTblName", "T_NCM_LOG_Other");
        this.setLogInfo("actionViewLog", "OtherAlloc_Error");
        OtherAllocLogReportUI.showAllocReportUI((CoreUIObject)this, param);
    }

    protected void showAllocEditUI(String operType) throws Exception {
        this.checkSelected();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", this.getCompanyOrgInfoWithDefault().getId().toString());
        this.setPeriodForDaily(param, operType);
        param.put("companyName", this.getCompanyOrgInfoWithDefault().getName().toString());
        param.put("filterInfo", (String)this.GetManuFilter(this._currFilterInfo));
        param.put("bFilter_all", String.valueOf(this.bFilter_all));
        OtherAllocEditUI.showAllocEditUI((CoreUIObject)this, param, operType, this.tblMain);
    }

    protected void setPeriodForDaily(Map param, String operType) throws BOSException {
        try {
            param.put("periodId", this.GetCurrentPeriod().getId().toString());
            param.put("periodNumber", String.valueOf(this.GetCurrentPeriod().getNumber()));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (rowSet == null || rowSet.size() == 0) {
            this.actionAutoAlloc.setEnabled(false);
            this.actionViewAlloc.setEnabled(false);
            this.actionViewLog.setEnabled(false);
            this.actionManuAlloc.setEnabled(false);
            this.actionWizAlloc.setEnabled(false);
            this.actionPrint.setEnabled(false);
            this.actionPrintPreview.setEnabled(false);
        } else {
            this.actionAutoAlloc.setEnabled(true);
            this.actionViewAlloc.setEnabled(true);
            this.actionViewLog.setEnabled(true);
            this.actionManuAlloc.setEnabled(true);
            this.actionWizAlloc.setEnabled(true);
            this.actionPrint.setEnabled(true);
            this.actionPrintPreview.setEnabled(true);
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setLogInfo("actionRefresh", "OtherAlloc_View");
    }

    protected void setLogInfo(String methodName, String logItemName) {
    }

    public void setCol_ID(String col_ID) {
        this.Col_ID = col_ID;
    }

    public String getCol_ID() {
        return this.Col_ID;
    }

    public void setCol_EntryID(String col_EntryID) {
        this.Col_EntryID = col_EntryID;
    }

    public String getCol_EntryID() {
        return this.Col_EntryID;
    }

    public void setQtyCol(String qtyCol) {
        this.QtyCol = qtyCol;
    }

    public String getQtyCol() {
        return this.QtyCol;
    }

    public void setPriceCol(String priceCol) {
        this.PriceCol = priceCol;
    }

    public String getPriceCol() {
        return this.PriceCol;
    }

    public void setAmtCol(String amtCol) {
        this.AmtCol = amtCol;
    }

    public String getAmtCol() {
        return this.AmtCol;
    }

    public String getQtyColPricisionInQuery() {
        return "unit.qtyPrecision";
    }

    public String getPriceColPricisionInQuery() {
        return "expense.pricePrecision";
    }

    public String getAmtColPricisionInQuery() {
        return "baseCurrency.precision";
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new OtherAllocFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected CompanyOrgUnitInfo getCompanyOrgInfoWithDefault() {
        CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
        if (filterUI != null && filterUI.getCompanyF7() != null && filterUI.getCompanyF7().getData() != null && filterUI.getCompanyF7().getData() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)filterUI.getCompanyF7().getData();
            if (!org.isLoaded() && org.getId().toString().trim().length() > 0) {
                try {
                    org = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()));
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            return org;
        }
        if (this.getUIContext().containsKey(OrgType.Company) && this.getUIContext().get(OrgType.Company) != null) {
            return (CompanyOrgUnitInfo)this.getUIContext().get(OrgType.Company);
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
            if (filterUI == null) {
                return null;
            }
            filterUI.setMetaDataPKForPemmission(this.mainQueryPK);
            filterUI.setMetaDataPKForPemmissionByUI(this.getMetaDataPK());
            return filterUI;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
        if (filterUI == null) {
            return null;
        }
        return filterUI.getCompanyF7();
    }

    protected List getMainBizOrgs(QuerySolutionInfo solution) {
        ArrayList<String> list = new ArrayList<String>();
        if (solution != null) {
            OrgUnitInfo[] orgUnitInfos = this.getMainOrgFromSolution(solution);
            if (orgUnitInfos != null && orgUnitInfos.length >= 1) {
                CMBillBaseFilterUI filterUI = (CMBillBaseFilterUI)this.getFilterUI();
                if (filterUI != null) {
                    String permissionItem = filterUI.getPermissionItem();
                    try {
                        if (!SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)OrgType.Company, (IObjectPK)new ObjectStringPK(orgUnitInfos[0].getId().toString()), (String)permissionItem)) {
                            MsgBox.showInfo((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u6240\u9009\u8d22\u52a1\u7ec4\u7ec7\u7684\u6743\u9650");
                            SysUtil.abort();
                        }
                    }
                    catch (EASBizException e) {
                        this.handUIException(e);
                    }
                    catch (BOSException e) {
                        this.handUIException(e);
                    }
                }
                this.getUIContext().put(this.getMainBizOrgType(), orgUnitInfos[0]);
                for (int i = 0; i < orgUnitInfos.length; ++i) {
                    if (orgUnitInfos[i] == null) continue;
                    list.add(orgUnitInfos[i].getId().toString());
                }
            } else {
                this.getUIContext().put(this.getMainBizOrgType(), null);
                if (this.getMainOrgContext() != null) {
                    FrameWorkUtils.setCurrentOrgUnit((Context)this.getMainOrgContext(), null);
                }
            }
        } else if (this.getUIContext().get(this.getMainBizOrgType()) != null) {
            list.add(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId().toString());
        }
        return list;
    }

    private OrgUnitInfo[] getMainOrgFromSolution(QuerySolutionInfo solution) {
        String key = this.getPropertyOfBizOrg(this.getMainBizOrgType());
        if (solution != null && key != null) {
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            int size = queryPanelCollection.size();
            for (int i = 0; i < size; ++i) {
                String params;
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
                if (queryPanelInfo.getPanelClassName() == null || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonFilterPanel") || queryPanelInfo.getPanelClassName().equalsIgnoreCase("com.kingdee.eas.base.commonquery.client.CommonSorterPanel") || (params = queryPanelInfo.getCustomerParams()) == null) continue;
                CustomerParams cp = new CustomerParams();
                try {
                    ArrayList al = XMLBean.TransStrToAL((String)params);
                    Iterator j = al.iterator();
                    XMLBean xb = null;
                    while (j.hasNext()) {
                        xb = (XMLBean)j.next();
                        cp.addCustomerParam(xb.getName(), xb.getValue());
                    }
                    String orgs = cp.getCustomerParam(key);
                    if (orgs != null) {
                        return SCMGroupClientUtils.getOrgUnitInfos((String)orgs);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        return null;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "CompanyPick";
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }
}

