/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.bill.OtherFeeBillEntryInfo;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.bill.client.AbstractOtherFeeBillEditUI;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;
import com.kingdee.eas.ncm.common.utils.CostObjectUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class OtherFeeBillEditUI
extends AbstractOtherFeeBillEditUI {
    private static final long serialVersionUID = -6581874329790803826L;
    private static final Logger logger = CoreUIObject.getLogger(OtherFeeBillEditUI.class);
    private static final String TB_MODEL = "material.model";
    private int costObjectOfBillRequired = -1;
    private KDBizPromptBox prmtCostObject = null;
    private KDBizPromptBox prmtMnaufacture = null;
    private KDBizPromptBox prmtMaterial = null;
    private KDBizPromptBox prmtExpense = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuWorkflow.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        String companyOrgID = null;
        if (this.prmtCompanyOrg.getData() != null) {
            CompanyOrgUnitInfo comOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getData();
            companyOrgID = comOrg.getId().toString();
            try {
                BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenter, (String)companyOrgID);
                EntityViewInfo entityViewInfo = this.prmtCostCenter.getEntityViewInfo();
                if (entityViewInfo == null) {
                    entityViewInfo = new EntityViewInfo();
                }
                FilterInfo filterInfo = entityViewInfo.getFilter();
                FilterInfo isSealUpFilter = new FilterInfo();
                if (filterInfo == null) {
                    filterInfo = new FilterInfo();
                }
                isSealUpFilter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
                filterInfo.mergeFilter(isSealUpFilter, "and");
                CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(comOrg.getBaseCurrency().getId()));
                NCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currency, (KDTable)this.kdtEntries, (String[])new String[]{"amount"});
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        try {
            BDCMClientUtils.filterAdminAndCostCenterF7((KDBizPromptBox)this.prmtDepartment, companyOrgID);
            BDCMClientUtils.filterCostCenterByCompanyOrgF7((KDBizPromptBox)this.prmtSourceCostCenter, (String)companyOrgID);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        try {
            this.formatEntryTable(companyOrgID);
            this.initOrderInfo();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initOrderInfo() throws Exception {
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            CostObjectInfo costObject;
            this.kdtEntries.getCell(rowIndex, "batchNumber").getStyleAttributes().setLocked(true);
            this.kdtEntries.getCell(rowIndex, "batchNumber").getStyleAttributes().setBackground(Color.WHITE);
            Object value = this.kdtEntries.getRow(rowIndex).getCell("costObject.number").getValue();
            if (!(value instanceof CostObjectInfo) || !CalculateModeEnum.BYBATCH.equals((Object)(costObject = (CostObjectInfo)value).getCalculateMode())) continue;
            this.kdtEntries.getCell(rowIndex, "batchNumber").getStyleAttributes().setLocked(false);
            this.kdtEntries.getCell(rowIndex, "batchNumber").getStyleAttributes().setBackground(new Color(252, 251, 223));
        }
    }

    private void formatEntryTable(String companyOrgID) throws Exception {
        this.prmtCostObject = new KDBizPromptBox();
        this.prmtCostObject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.prmtCostObject, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObject.setSelector((KDPromptSelector)arg0);
        this.prmtCostObject.setEditable(true);
        this.prmtCostObject.setDisplayFormat("$number$");
        this.prmtCostObject.setEditFormat("$number$");
        this.prmtCostObject.setCommitFormat("$number$");
        this.prmtCostObject.setRequired(true);
        BDCMClientUtils.filterF7((KDBizPromptBox)this.prmtCostObject, (String)"company.id", (Object)companyOrgID);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtCostObject);
        this.kdtEntries.getColumn("costObject.number").setEditor((ICellEditor)itemEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("costObject.number").setRenderer((IBasicRender)avr);
        this.prmtCostObject.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OtherFeeBillEditUI.this.fillCostObjectAfterDo2(eventObj);
            }
        });
        if (this.isCostObjectOfBillRequired()) {
            this.kdtEntries.getColumn("costObject.number").setRequired(true);
        }
        this.prmtMnaufacture = new KDBizPromptBox();
        this.prmtMnaufacture.setQueryInfo("com.kingdee.eas.mm.mo.app.F7ManufactureOrderQuery");
        this.prmtMnaufacture.setEditable(true);
        this.prmtMnaufacture.setDisplayFormat("$number$");
        this.prmtMnaufacture.setEditFormat("$number$");
        this.prmtMnaufacture.setCommitFormat("$number$");
        BillBaseStatusEnum[] status = new BillBaseStatusEnum[]{BillBaseStatusEnum.COMPLETE, BillBaseStatusEnum.RELEASED, BillBaseStatusEnum.CLOSED};
        BDCMClientUtils.filterOrderF7((KDBizPromptBox)this.prmtMnaufacture, (String)companyOrgID, (BillBaseStatusEnum[])status);
        ObjectValueRender avrMnaufacture = new ObjectValueRender();
        avrMnaufacture.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("order.number").setRenderer((IBasicRender)avrMnaufacture);
        this.kdtEntries.getColumn("order.number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtMnaufacture));
        this.prmtMnaufacture.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OtherFeeBillEditUI.this.fillManufactureAfterDo2(eventObj);
            }
        });
        this.prmtMaterial = new KDBizPromptBox();
        NCMClientUtils.setMaterialF7((KDBizPromptBox)this.prmtMaterial, (String)companyOrgID);
        ObjectValueRender avrMat = new ObjectValueRender();
        avrMat.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("productNumber").setRenderer((IBasicRender)avrMat);
        this.kdtEntries.getColumn("productNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtMaterial));
        this.prmtMaterial.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OtherFeeBillEditUI.this.fillMaterialAfterDo2(eventObj);
            }
        });
        KDBizPromptBox prmtCostObjectSuite = new KDBizPromptBox();
        prmtCostObjectSuite.setQueryInfo("com.kingdee.eas.basedata.assistant.F7CostObjectSuiteQuery");
        prmtCostObjectSuite.setEditable(true);
        prmtCostObjectSuite.setDisplayFormat("$name$");
        prmtCostObjectSuite.setEditFormat("$number$");
        prmtCostObjectSuite.setCommitFormat("$number$");
        prmtCostObjectSuite.setRequired(true);
        BDCMClientUtils.filterF7((KDBizPromptBox)prmtCostObjectSuite, (String)"company.id", (Object)companyOrgID);
        KDTDefaultCellEditor itemEditor2 = new KDTDefaultCellEditor((IKDEditor)prmtCostObjectSuite);
        this.kdtEntries.getColumn("costObjectSuite.number").setEditor((ICellEditor)itemEditor2);
        ObjectValueRender avr2 = new ObjectValueRender();
        avr2.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("costObjectSuite.number").setRenderer((IBasicRender)avr2);
        KDBizPromptBox prmtCostItem = new KDBizPromptBox();
        prmtCostItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        prmtCostItem.setEditable(true);
        prmtCostItem.setDisplayFormat("$name$");
        prmtCostItem.setEditFormat("$number$");
        prmtCostItem.setCommitFormat("$number$");
        prmtCostItem.setRequired(true);
        EntityViewInfo costItemview = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ItemType", (Object)"1", CompareType.NOTEQUALS));
        costItemview.setFilter(filter);
        prmtCostItem.setEntityViewInfo(costItemview);
        KDTDefaultCellEditor itemEditor3 = new KDTDefaultCellEditor((IKDEditor)prmtCostItem);
        this.kdtEntries.getColumn("costItem.number").setEditor((ICellEditor)itemEditor3);
        ObjectValueRender avr3 = new ObjectValueRender();
        avr3.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("costItem.number").setRenderer((IBasicRender)avr3);
        KDTDefaultCellEditor obj = (KDTDefaultCellEditor)this.kdtEntries.getColumn("amount").getEditor();
        KDFormattedTextField txtField = (KDFormattedTextField)obj.getComponent();
        txtField.setDataType(1);
        txtField.setRemoveingZeroInDispaly(false);
        txtField.setNegatived(true);
        this.prmtExpense = new KDBizPromptBox();
        this.prmtExpense.setQueryInfo("com.kingdee.eas.basedata.ncm.app.ExpenseF7Query");
        this.prmtExpense.setEditable(true);
        this.prmtExpense.setDisplayFormat("$name$");
        this.prmtExpense.setEditFormat("$number$");
        this.prmtExpense.setCommitFormat("$number$");
        this.prmtExpense.setRequired(true);
        this.prmtExpense.setEnabledMultiSelection(true);
        KDTDefaultCellEditor expenseEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtExpense);
        this.kdtEntries.getColumn("expense").setEditor((ICellEditor)expenseEditor);
        ObjectValueRender expenseAvr = new ObjectValueRender();
        expenseAvr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn("expense").setRenderer((IBasicRender)expenseAvr);
        EntityViewInfo view = this.prmtExpense.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
            this.prmtExpense.setEntityViewInfo(view);
        }
        HashSet<Integer> extypes = new HashSet<Integer>();
        extypes.add(2);
        extypes.add(30);
        extypes.add(40);
        extypes.add(50);
        extypes.add(60);
        BDCMClientUtils.filterExpenseF7((EntityViewInfo)view, (String)companyOrgID, extypes);
        this.kdtEntries.getColumn("costObject.name").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("costObjectSuite.name").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("costItem.name").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_MODEL).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("expense").setRequired(true);
        this.kdtEntries.getColumn("unit").getStyleAttributes().setLocked(true);
        this.setQtyPriceColumnPrecision();
        this.onShow();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuTable1.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.kdtEntries.getColumn("batchNumber").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("projectNumber").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("trackNumber").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("productName").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("expense.name").getStyleAttributes().setLocked(true);
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            String trackID;
            String projectID;
            IRow row = this.kdtEntries.getRow(i);
            CostObjectInfo costObject = (CostObjectInfo)row.getCell("costObject.number").getValue();
            if (costObject == null) continue;
            String orderID = costObject.getOrderID();
            if (orderID != null) {
                ManufactureOrderInfo order = ManufactureOrderFactory.getRemoteInstance().getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(orderID));
                row.getCell("order.number").setValue((Object)order);
            }
            if ((projectID = costObject.getProjectID()) != null) {
                ProjectInfo project = ProjectFactory.getRemoteInstance().getProjectInfo((IObjectPK)new ObjectUuidPK(projectID));
                row.getCell("projectNumber").setValue((Object)project.getNumber());
            }
            if ((trackID = costObject.getTrackID()) != null) {
                TrackNumberInfo track = TrackNumberFactory.getRemoteInstance().getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackID));
                row.getCell("trackNumber").setValue((Object)track.getNumber());
            }
            if (costObject.getStdProductID() == null) continue;
            String materialID = costObject.getStdProductID().getId().toString();
            MaterialInfo materialInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
            row.getCell("productNumber").setValue((Object)materialInfo);
        }
    }

    protected void prmtExpense_dataChanged(KDTEditEvent e) throws Exception {
        int i;
        int rowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        IRow row = this.kdtEntries.getRow(rowIndex);
        Object newValue = this.prmtExpense.getData();
        ArrayList<Object> expenses = new ArrayList<Object>();
        if (newValue instanceof ExpenseInfo) {
            expenses.add(newValue);
        } else if (newValue instanceof Object[]) {
            Object[] temp = (Object[])newValue;
            for (i = 0; i < temp.length; ++i) {
                if (temp[i] == null || !(temp[i] instanceof ExpenseInfo)) continue;
                expenses.add(temp[i]);
            }
        } else {
            row.getCell("expense").setValue(null);
            return;
        }
        try {
            int newIndex = -1;
            for (i = 0; i < expenses.size(); ++i) {
                IRow newRow = null;
                if (i == 0) {
                    newIndex = rowIndex;
                    newRow = row;
                } else {
                    newRow = this.insertRow(newIndex);
                }
                ExpenseInfo info = (ExpenseInfo)expenses.get(i);
                newRow.getCell("expense").setValue((Object)info);
                newRow.getCell("expense.name").setValue((Object)info.getName());
                CostItemInfo ci = NCMUtils.getCostItemByExpense(null, (String)info.getId().toString(), (String)((CompanyOrgUnitInfo)this.prmtCompanyOrg.getData()).getId().toString());
                if (ci != null) {
                    this.kdtEntries.getCell(newIndex, "costItem.number").setValue((Object)ci);
                    this.kdtEntries.getCell(newIndex, "costItem.name").setValue((Object)ci.getName());
                } else {
                    this.kdtEntries.getCell(newIndex, "costItem.number").setValue(null);
                    this.kdtEntries.getCell(newIndex, "costItem.name").setValue(null);
                }
                int pricePrecision = info.getPricePrecision();
                boolean isAllocQty = info.isIsAllocateQty();
                this.kdtEntries.getRow(newIndex).getCell("qty").getStyleAttributes().setLocked(!isAllocQty);
                this.kdtEntries.getRow(newIndex).getCell("price").getStyleAttributes().setLocked(!isAllocQty);
                String pricePrecisionStr = PrecisionUtil.getFormatString((int)pricePrecision);
                this.kdtEntries.getCell(newIndex, "qty").getStyleAttributes().setNumberFormat("%r-[=]{#,###.##########}f");
                this.kdtEntries.getCell(newIndex, "price").getStyleAttributes().setNumberFormat(pricePrecisionStr);
                ++newIndex;
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
        }
    }

    protected void addLine(KDTable arg0) {
        super.addLine(arg0);
        try {
            this.setQtyPriceColumnPrecision();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected IRow insertRow(int rowIndex) {
        IRow irow = null;
        KDTable kdtEntries = this.getDetailTable();
        if (kdtEntries == null) {
            return irow;
        }
        IObjectValue detailData = this.createNewDetailData(kdtEntries);
        irow = kdtEntries.addRow(rowIndex);
        this.loadLineFields(kdtEntries, irow, detailData);
        this.afterInsertLine(kdtEntries, detailData);
        return irow;
    }

    private void setQtyPriceColumnPrecision() throws EASBizException, BOSException {
        ExpenseInfo expense = null;
        int pricePrecision = 0;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            if (row.getCell("expense").getValue() instanceof ExpenseInfo) {
                expense = (ExpenseInfo)row.getCell("expense").getValue();
                pricePrecision = expense.getPricePrecision();
                boolean isAllocQty = expense.isIsAllocateQty();
                row.getCell("qty").getStyleAttributes().setLocked(!isAllocQty);
                row.getCell("price").getStyleAttributes().setLocked(!isAllocQty);
            }
            row.getCell("qty").getStyleAttributes().setNumberFormat("%r-[=]{#,###.##########}f");
            row.getCell("price").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)pricePrecision));
        }
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        CostObjectInfo info;
        int row = e.getRowIndex();
        if (e.getValue() instanceof CostObjectInfo) {
            CostObjectInfo co = (CostObjectInfo)e.getValue();
            this.kdtEntries.getCell(row, "costObject.name").setValue((Object)co.getName());
            if (co.getStdProductID() != null && co.getStdProductID().getId() != null) {
                String materialID = co.getStdProductID().getId().toString();
                MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)materialID)));
                this.kdtEntries.getCell(row, TB_MODEL).setValue((Object)material.getModel());
            } else {
                this.kdtEntries.getCell(row, TB_MODEL).setValue(null);
            }
        } else if (e.getValue() instanceof CostObjectSuiteInfo) {
            CostObjectSuiteInfo cos = (CostObjectSuiteInfo)e.getValue();
            this.kdtEntries.getCell(row, "costObjectSuite.name").setValue((Object)cos.getName());
        } else if (e.getValue() instanceof CostItemInfo) {
            CostItemInfo ci = (CostItemInfo)e.getValue();
            this.kdtEntries.getCell(row, "costItem.name").setValue((Object)ci.getName());
        } else if (e.getOldValue() instanceof CostObjectInfo) {
            this.kdtEntries.getCell(row, "costObject.name").setValue(null);
        } else if (e.getOldValue() instanceof CostObjectSuiteInfo) {
            this.kdtEntries.getCell(row, "costObjectSuite.name").setValue(null);
        } else if (e.getOldValue() instanceof CostItemInfo) {
            this.kdtEntries.getCell(row, "costItem.name").setValue(null);
        }
        if (e.getValue() instanceof Object[]) {
            this.prmtExpense_dataChanged(e);
        }
        String column = this.kdtEntries.getColumnKey(e.getColIndex());
        BigDecimal qty = SysConstant.BIGZERO;
        BigDecimal price = SysConstant.BIGZERO;
        BigDecimal amount = SysConstant.BIGZERO;
        if ("batchNumber".equalsIgnoreCase(column)) {
            IRow row2 = this.kdtEntries.getRow(row);
            Object o = e.getValue();
            if (o instanceof String) {
                CostObjectRelatedInfo costObjectRelatedInfo;
                String batchNumber = (String)o;
                MaterialInfo materialInfo = null;
                if (row2.getCell("productNumber").getValue() instanceof MaterialInfo) {
                    materialInfo = (MaterialInfo)row2.getCell("productNumber").getValue();
                }
                if ((costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat(materialInfo, (String)batchNumber, (boolean)true)) != null) {
                    row2.getCell("costObject.number").setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                    row2.getCell("costObject.name").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getName());
                } else {
                    row2.getCell("batchNumber").setValue(null);
                    throw new NcmBillException(NcmBillException.MATANDBATCH_NO_COSTOBJECT);
                }
            }
        }
        if (!"EDIT".equals(this.getOprtState())) {
            if ("qty".equals(column) || "price".equals(column)) {
                qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"qty");
                price = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"price");
                amount = qty.multiply(price);
                this.kdtEntries.getCell(row, "amount").setValue((Object)amount);
            } else if ("amount".equals(column)) {
                amount = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"amount");
                qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"qty");
                if (qty.compareTo(SysConstant.BIGZERO) != 0) {
                    price = amount.divide(qty, 8, 4);
                }
                this.kdtEntries.getCell(row, "price").setValue((Object)price);
            }
        } else if ("qty".equals(column) || "amount".equals(column)) {
            qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"qty");
            amount = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"amount");
            if (SysConstant.BIGZERO.compareTo(qty) != 0) {
                price = amount.divide(qty, 8, 4);
            }
            this.kdtEntries.getCell(row, "price").setValue((Object)price);
        } else if ("price".equals(column)) {
            qty = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"qty");
            price = BDCMClientUtils.castToBigDecimal((KDTable)this.kdtEntries, (int)row, (String)"price");
            amount = qty.multiply(price);
            this.kdtEntries.getCell(row, "amount").setValue((Object)amount);
        }
        if (e.getValue() instanceof CostObjectInfo && (info = (CostObjectInfo)e.getValue()) != null && info.isIsForbiden()) {
            this.kdtEntries.getCell(row, "costObject.number").setValue(null);
            this.kdtEntries.getCell(row, "costObject.name").setValue(null);
            this.kdtEntries.getCell(row, "productNumber").setValue(null);
            this.kdtEntries.getCell(row, "productName").setValue(null);
        }
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.kdtEntries, new String[]{"qty", "amount"});
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OtherFeeBillFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        OtherFeeBillInfo objectValue = new OtherFeeBillInfo();
        super.applyBillDefaultValue((IObjectValue)objectValue);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        OtherFeeBillEntryInfo entry = new OtherFeeBillEntryInfo();
        entry.setAmount(SysConstant.BIGZERO);
        return entry;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected String[] getValidateColumns() {
        if (this.isCostObjectOfBillRequired()) {
            return new String[]{"costItem.number", "costObject.number"};
        }
        return new String[]{"costItem.number"};
    }

    protected void checkValidDataForSubmit() throws Exception {
        super.checkValidDataForSubmit();
        BDCMClientUtils.checkIsNull((JComponent)this.prmtCostCenter, (String)this.contCostCenter.getBoundLabelText());
        int rowCount = this.kdtEntries.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object val = this.kdtEntries.getCell(i, "expense").getValue();
            if (val != null && !"".equals(val)) continue;
            MsgBox.showInfo((String)"\u8981\u7d20\u8d39\u7528\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            SysUtil.abort();
        }
    }

    protected void isStart() throws Exception {
    }

    private boolean isCostObjectOfBillRequired() {
        try {
            if (this.costObjectOfBillRequired < 0) {
                this.costObjectOfBillRequired = 0;
                if (NCMUtils.isCostObjectOfBillRequired(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
                    this.costObjectOfBillRequired = 1;
                }
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            this.abort();
        }
        return this.costObjectOfBillRequired == 1;
    }

    private void fillCostObjectAfterDo2(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        if (newValue != null && newValue instanceof CostObjectInfo) {
            int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
            IRow row = this.kdtEntries.getRow(selectRowIndex);
            CostObjectInfo oldCO = (CostObjectInfo)row.getCell("costObject.number").getValue();
            if (oldCO != null && oldCO.getId().toString().equals(((CostObjectInfo)newValue).getId().toString())) {
                return;
            }
            try {
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByCO((CostObjectInfo)((CostObjectInfo)newValue));
                row.getCell("order.number").setValue((Object)costObjectRelatedInfo.getManufactureOrderInfo());
                row.getCell("productNumber").setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                if (costObjectRelatedInfo.getMaterialInfo() != null) {
                    row.getCell("productName").setValue((Object)costObjectRelatedInfo.getMaterialInfo().getName());
                } else {
                    row.getCell("productName").setValue(null);
                }
                row.getCell("projectNumber").setValue((Object)costObjectRelatedInfo.getProjectNumber());
                row.getCell("trackNumber").setValue((Object)costObjectRelatedInfo.getTrackNumber());
                row.getCell("batchNumber").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                row.getCell("batchNumber").getStyleAttributes().setLocked(true);
                row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 255));
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void fillManufactureAfterDo2(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        if (newValue != null && newValue instanceof ManufactureOrderInfo) {
            int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
            IRow row = this.kdtEntries.getRow(selectRowIndex);
            ManufactureOrderInfo oldOrder = null;
            if (row.getCell("order.number").getValue() instanceof ManufactureOrderInfo) {
                oldOrder = (ManufactureOrderInfo)row.getCell("order.number").getValue();
            }
            if (oldOrder != null && oldOrder.getId().toString().equals(((ManufactureOrderInfo)newValue).getId().toString())) {
                return;
            }
            try {
                CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByOrder((ManufactureOrderInfo)((ManufactureOrderInfo)newValue), (String)((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString());
                if (costObjectRelatedInfo != null) {
                    if (costObjectRelatedInfo.getCostObjectInfo() != null) {
                        row.getCell("costObject.number").setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                        row.getCell("costObject.name").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getName());
                        row.getCell("batchNumber").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                        row.getCell("batchNumber").getStyleAttributes().setLocked(true);
                        row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 255));
                    } else {
                        row.getCell("batchNumber").getStyleAttributes().setLocked(false);
                    }
                    row.getCell("productNumber").setValue((Object)costObjectRelatedInfo.getMaterialInfo());
                    row.getCell("productName").setValue((Object)costObjectRelatedInfo.getMaterialInfo().getName());
                    row.getCell("projectNumber").setValue((Object)costObjectRelatedInfo.getProjectNumber());
                    row.getCell("trackNumber").setValue((Object)costObjectRelatedInfo.getTrackNumber());
                } else {
                    row.getCell("costObject.number").setValue(null);
                    String materialID = ((ManufactureOrderInfo)newValue).getMaterial().getId().toString();
                    MaterialInfo material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                    row.getCell("productNumber").setValue((Object)material);
                    row.getCell("productName").setValue((Object)material.getName());
                    row.getCell("costObject.name").setValue(null);
                    row.getCell("projectNumber").setValue(null);
                    row.getCell("trackNumber").setValue(null);
                    row.getCell("batchNumber").setValue(null);
                    row.getCell("batchNumber").getStyleAttributes().setLocked(false);
                    row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 204));
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void fillMaterialAfterDo2(DataChangeEvent eventObj) {
        block11: {
            Object newValue = eventObj.getNewValue();
            int selectRowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
            IRow row = this.kdtEntries.getRow(selectRowIndex);
            if (newValue != null && newValue instanceof MaterialInfo) {
                MaterialInfo oldMat = null;
                if (row.getCell("productNumber").getValue() instanceof MaterialInfo) {
                    oldMat = (MaterialInfo)row.getCell("productNumber").getValue();
                }
                if (oldMat != null && oldMat.getNumber().equals(((MaterialInfo)newValue).getNumber())) {
                    return;
                }
                try {
                    CostObjectRelatedInfo costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((MaterialInfo)((MaterialInfo)newValue));
                    row.getCell("productName").setValue((Object)((MaterialInfo)newValue).getName());
                    row.getCell(TB_MODEL).setValue((Object)((MaterialInfo)newValue).getModel());
                    if (costObjectRelatedInfo != null) {
                        if (costObjectRelatedInfo.getCostObjectInfo() != null) {
                            row.getCell("costObject.number").setValue((Object)costObjectRelatedInfo.getCostObjectInfo());
                            row.getCell("costObject.name").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getName());
                            row.getCell("batchNumber").setValue((Object)costObjectRelatedInfo.getCostObjectInfo().getBatchNumber());
                            if (costObjectRelatedInfo.getCostObjectInfo().getBatchNumber() == null || costObjectRelatedInfo.getCostObjectInfo().getBatchNumber().length() <= 0) {
                                row.getCell("batchNumber").getStyleAttributes().setLocked(true);
                                row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 255));
                            }
                        } else {
                            row.getCell("batchNumber").getStyleAttributes().setLocked(false);
                        }
                        row.getCell("order.number").setValue((Object)costObjectRelatedInfo.getManufactureOrderInfo());
                        row.getCell("projectNumber").setValue((Object)costObjectRelatedInfo.getProjectNumber());
                        row.getCell("trackNumber").setValue((Object)costObjectRelatedInfo.getTrackNumber());
                        break block11;
                    }
                    row.getCell("batchNumber").getStyleAttributes().setLocked(false);
                    row.getCell("batchNumber").getStyleAttributes().setBackground(new Color(255, 255, 204));
                    row.getCell("costObject.number").setValue(null);
                    row.getCell("costObject.name").setValue(null);
                    row.getCell("order.number").setValue(null);
                    row.getCell("projectNumber").setValue(null);
                    row.getCell("trackNumber").setValue(null);
                    row.getCell("batchNumber").setValue(null);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                    row.getCell("costObject.number").setValue(null);
                    row.getCell("costObject.name").setValue(null);
                    row.getCell("productName").setValue(null);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                row.getCell("order.number").getStyleAttributes().setLocked(false);
                row.getCell("productName").setValue(null);
                row.getCell("costObject.number").setValue(null);
                row.getCell("costObject.name").setValue(null);
            }
        }
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.comboBillStatus.getSelectedItem() != null && this.comboBillStatus.getSelectedItem().toString().equals(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"157_InitBalanceEditUI_Audit"))) {
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            this.menuItemunAudit.setEnabled(true);
            this.btnAudit.setEnabled(false);
            this.btnUnaudit.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("OtherFeeBill_audit");
        }
        super.auditAction_actionPerformed(e);
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        super.unauditAction_actionPerformed(e);
        this.setQtyColumLock();
        this.setOprtState("EDIT");
        this.unLockUI();
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    private void setQtyColumLock() {
        ExpenseInfo expense = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            IRow row = this.kdtEntries.getRow(i);
            if (row.getCell("expense").getValue() instanceof ExpenseInfo) {
                expense = (ExpenseInfo)row.getCell("expense").getValue();
            }
            boolean isAllocQty = expense != null && expense.isIsAllocateQty();
            row.getCell("qty").getStyleAttributes().setLocked(!isAllocQty);
            row.getCell("price").getStyleAttributes().setLocked(!isAllocQty);
        }
    }
}

