/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.OtherFeeBillFactory;
import com.kingdee.eas.ncm.bill.OtherFeeBillInfo;
import com.kingdee.eas.ncm.bill.client.AbstractOtherFeeBillListUI;
import com.kingdee.eas.ncm.bill.client.OtherFeeBillEditUI;
import com.kingdee.eas.ncm.bill.client.OtherFeeBillFilterUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class OtherFeeBillListUI
extends AbstractOtherFeeBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherFeeBillListUI.class);
    private CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
    CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
    protected OtherFeeBillFilterUI filterUI = null;

    public OtherFeeBillListUI() throws Exception {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int firstRowIndex = e.getFirstRow();
                int lastRowIndex = e.getLastRow();
                IRow row = null;
                int precision = 0;
                for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                    row = OtherFeeBillListUI.this.tblMain.getRow(i);
                    if (row.getCell("entries.amount") != null && row.getCell("entries.amount").getValue() != null) {
                        precision = ((BigDecimal)row.getCell("entries.amount").getValue()).scale();
                        OtherFeeBillListUI.this.setBigDecimalFieldsPrecisionByCell(row.getCell("entries.amount"), precision);
                    }
                    if (row.getCell("entries.qty") != null && row.getCell("entries.qty").getValue() != null) {
                        precision = ((BigDecimal)row.getCell("entries.qty").getValue()).scale();
                        OtherFeeBillListUI.this.setBigDecimalFieldsPrecisionByCell(row.getCell("entries.qty"), precision);
                    }
                    if (row.getCell("entries.price") == null || row.getCell("entries.price").getValue() == null) continue;
                    precision = ((BigDecimal)row.getCell("entries.price").getValue()).scale();
                    OtherFeeBillListUI.this.setBigDecimalFieldsPrecisionByCell(row.getCell("entries.price"), precision);
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnImportFromGL.setVisible(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionVoucher.setVisible(true);
        this.actionVoucher.setEnabled(true);
        this.actionDelVoucher.setVisible(true);
        this.actionDelVoucher.setEnabled(true);
        this.actionTraceUp.setVisible(true);
        this.actionTraceDown.setVisible(true);
        this.menuBiz.setVisible(true);
        this.tblMain.getColumn("fiVouchered").setGroup(true);
        this.tblMain.getColumn("fiVouchered").setMergeable(true);
    }

    @Override
    public void actionImportFromGL_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportFromGL_actionPerformed(e);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            while (rowSet.next()) {
                int precision = rowSet.getInt("baseCurrency.precision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.amount", (IRowSet)rowSet);
                precision = rowSet.getInt("unit.qtyPrecision");
                precision = rowSet.getInt("expense.pricePrecision");
                BDCMUtils.iniColumnsPrecision((int)precision, (String)"entries.price", (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"number", "billStatus", "bizDate", "calculatePeriod.number", "companyOrg.name", "costCenter.number", "costCenter.name", "description", "creator.name", "createTime", "auditor.name", "auditTime", "lastUpdateUser.name", "lastUpdateTime", "sourceFunction", "expense.number", "expense.name", "unit.name", "department.number", "department.name"};
    }

    protected CommonQueryProcessor getCustomerCommonQueryProcessor() {
        CommonQueryProcessor cmcq = super.getCustomerCommonQueryProcessor();
        cmcq.set("companyOrg", (Object)this.getCompanyOrgInfoWithDefault().getId().toString());
        cmcq.set("query", (Object)"OtherFeeBillQuery");
        try {
            boolean isShowShareCostObject = NCMUtils.isCostObjectOfBillRequired(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
            cmcq.set("showShareCostObject", (Object)isShowShareCostObject);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        return cmcq;
    }

    @Override
    protected String getEditUIName() {
        return OtherFeeBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return OtherFeeBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        OtherFeeBillInfo objectValue = new OtherFeeBillInfo();
        return objectValue;
    }

    protected boolean isVoucherVisible() {
        return true;
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "otherFeeBill";
        param.alias = EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"120_OtherFeeBillListUI");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            Object state = this.tblMain.getRow(selectRows[i]).getCell("fiVouchered").getValue();
            if (!Boolean.TRUE.equals(state)) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"121_OtherFeeBillListUI"));
            SysUtil.abort();
        }
        super.unauditAction_actionPerformed(e);
    }

    protected CustomerQueryPanel getFilterUI() {
        if (this.filterUI == null) {
            try {
                this.filterUI = new OtherFeeBillFilterUI();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isEnableSubmit() {
        return true;
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
    }

    protected boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected boolean isBillSupportAuditAfterSubmit() {
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                Object fetchSource;
                IRow row = this.tblMain.getRow(i);
                if ((BizEnumValueDTO)row.getCell("FetchSource").getValue() == null || !"3".equals(fetchSource = ((BizEnumValueDTO)row.getCell("FetchSource").getValue()).getValue())) continue;
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"OtherFeebillByCCO_Edit_WaringMessage"));
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        if (NCMUtils.isAuditAfterSubmit(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString())) {
            this.checkAuditPermission("OtherFeeBill_audit");
        }
        super.auditAction_actionPerformed(e);
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, (IObjectPK)new ObjectUuidPK(this.getCompanyOrgInfoWithDefault().getId().toString()), (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }

    private void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision) {
        if (cell != null) {
            cell.getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatString((int)precision));
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

