/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.OtherInWarehsAllocFilterParam;
import com.kingdee.eas.ncm.bill.client.AbstractOtherInWarehsAllocFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class OtherInWarehsAllocFilterUI
extends AbstractOtherInWarehsAllocFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherInWarehsAllocFilterUI.class);
    private static final String BEGIN_DATE = "BeginDate";
    private static final String END_DATE = "EndDate";
    private static final String COSTCENTER_IDS = "CostCenterIds";
    private static final String MATIERL_IDS = "MaterialIds";
    private static final String COSTOBJECT_IDS = "CostObjectIds";

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.kDDatePickerFrom.setEnabled(false);
        this.kDDatePickerTo.setEnabled(false);
    }

    private void init() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = this.getCompanyOrgInfoWithDefault();
        PeriodInfo period = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
        this.initCompanyAndPeriod(company, period);
        this.initCostObject(company);
    }

    private void initCompanyAndPeriod(CompanyOrgUnitInfo company, PeriodInfo period) {
        this.kDBizPromptCompany.setValue((Object)company);
        if (this.isNormal) {
            Date beginDate = period.getBeginDate();
            this.kDDatePickerFrom.setValue((Object)beginDate);
            Timestamp endDate = period.getEndDate();
            this.kDDatePickerTo.setValue((Object)endDate);
        }
    }

    private void initPeriod(PeriodInfo period) {
        if (this.isNormal) {
            Date beginDate = period.getBeginDate();
            this.kDDatePickerFrom.setValue((Object)beginDate);
            Timestamp endDate = period.getEndDate();
            this.kDDatePickerTo.setValue((Object)endDate);
        }
    }

    public void initCostCenterForCostAdjust() throws EASBizException, BOSException {
        if (this.kDBizPromptCostCenter.getEntityViewInfo() != null) {
            this.kDBizPromptCostCenter.getEntityViewInfo().setFilter(new FilterInfo());
        }
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.kDBizPromptCostCenter, (String)company.getId().toString());
    }

    private void initCostObject(CompanyOrgUnitInfo company) {
        this.kDBizPromptCostObject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
        CostObjectF7UISelector f7UIselector = new CostObjectF7UISelector((Object)this, this.kDBizPromptCostObject, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, this.getCompanyOrgInfoWithDefault().getId().toString());
        HashSet<Integer> relatedTypeSet = new HashSet<Integer>();
        relatedTypeSet.add(0);
        f7UIselector.setRelatedTypeSet(relatedTypeSet);
        this.kDBizPromptCostObject.setSelector((KDPromptSelector)f7UIselector);
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new OtherInWarehsAllocFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof OtherInWarehsAllocFilterParam)) {
            return;
        }
        OtherInWarehsAllocFilterParam _filterParam = (OtherInWarehsAllocFilterParam)filterParam;
        String beginDate = customerParams.getCustomerParam(BEGIN_DATE);
        if (!StringUtils.isEmpty((String)beginDate)) {
            GregorianCalendar beginCalendar = new GregorianCalendar();
            beginCalendar.setTimeInMillis(Long.parseLong(beginDate));
            _filterParam.setBeginDate(beginCalendar.getTime());
        } else {
            _filterParam.setBeginDate(null);
        }
        String endDate = customerParams.getCustomerParam(END_DATE);
        if (!StringUtils.isEmpty((String)endDate)) {
            GregorianCalendar endCalendar = new GregorianCalendar();
            endCalendar.setTimeInMillis(Long.parseLong(endDate));
            _filterParam.setEndDate(endCalendar.getTime());
        } else {
            _filterParam.setEndDate(null);
        }
        List costCenterIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(COSTCENTER_IDS)));
        if (costCenterIds != null) {
            CostCenterOrgUnitInfo[] CCO = new CostCenterOrgUnitInfo[costCenterIds.size()];
            String id = null;
            int in = costCenterIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)costCenterIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                CostCenterOrgUnitInfo costCenterOrgUnitInfo = new CostCenterOrgUnitInfo();
                costCenterOrgUnitInfo.setId(BOSUuid.read((String)id));
                CCO[i] = costCenterOrgUnitInfo;
            }
            _filterParam.setCostCenters(CCO);
        } else {
            _filterParam.setCostCenters(null);
        }
        List materialIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(MATIERL_IDS)));
        if (materialIds != null) {
            MaterialInfo[] mat = new MaterialInfo[materialIds.size()];
            String id = null;
            int in = materialIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)materialIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                MaterialInfo materialInfo = new MaterialInfo();
                materialInfo.setId(BOSUuid.read((String)id));
                mat[i] = materialInfo;
            }
            _filterParam.setMaterials(mat);
        } else {
            _filterParam.setMaterials(null);
        }
        List costObjcetIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(COSTOBJECT_IDS)));
        if (costObjcetIds != null) {
            CostObjectInfo[] CO = new CostObjectInfo[costObjcetIds.size()];
            String id = null;
            int in = costObjcetIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)costObjcetIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                CostObjectInfo costObjectInfo = new CostObjectInfo();
                costObjectInfo.setId(BOSUuid.read((String)id));
                CO[i] = costObjectInfo;
            }
            _filterParam.setCostObject(CO);
        } else {
            _filterParam.setCostObject(null);
        }
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof OtherInWarehsAllocFilterParam)) {
            return;
        }
        OtherInWarehsAllocFilterParam _filterParam = (OtherInWarehsAllocFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getBeginDate(), BEGIN_DATE);
        super.putIdByKey(customerParams, (Object)_filterParam.getEndDate(), END_DATE);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostCenters(), COSTCENTER_IDS);
        super.putIdByKey(customerParams, (Object)_filterParam.getMaterials(), MATIERL_IDS);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostObject(), COSTOBJECT_IDS);
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof OtherInWarehsAllocFilterParam) {
            OtherInWarehsAllocFilterParam _filterParam = (OtherInWarehsAllocFilterParam)filterParam;
            if (_filterParam.getBeginDate() != null) {
                this.kDDatePickerFrom.setValue((Object)_filterParam.getBeginDate());
            } else {
                this.kDDatePickerFrom.setValue(null);
            }
            if (_filterParam.getEndDate() != null) {
                this.kDDatePickerTo.setValue((Object)_filterParam.getEndDate());
            } else {
                this.kDDatePickerTo.setValue(null);
            }
            this.kDBizPromptCostCenter.setValue((Object)_filterParam.getCostCenters());
            this.kDBizPromptMaterial.setValue((Object)_filterParam.getMaterials());
            this.kDBizPromptCostObject.setValue((Object)_filterParam.getCostObject());
        }
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof OtherInWarehsAllocFilterParam)) {
            return;
        }
        OtherInWarehsAllocFilterParam _filterParam = (OtherInWarehsAllocFilterParam)filterParam;
        Object beginDateObject = this.kDDatePickerFrom.getValue();
        if (beginDateObject instanceof Date) {
            _filterParam.setBeginDate((Date)beginDateObject);
        } else {
            _filterParam.setBeginDate(null);
        }
        Object endDateObject = this.kDDatePickerTo.getValue();
        if (endDateObject instanceof Date) {
            _filterParam.setEndDate((Date)endDateObject);
        } else {
            _filterParam.setEndDate(null);
        }
        CostCenterOrgUnitInfo[] costCenters = null;
        Object costCenterObject = this.kDBizPromptCostCenter.getData();
        if (costCenterObject instanceof CostCenterOrgUnitInfo) {
            costCenters = new CostCenterOrgUnitInfo[]{(CostCenterOrgUnitInfo)costCenterObject};
        } else if (costCenterObject instanceof Object[]) {
            costCenters = new CostCenterOrgUnitInfo[((Object[])costCenterObject).length];
            System.arraycopy(costCenterObject, 0, costCenters, 0, ((Object[])costCenterObject).length);
        }
        _filterParam.setCostCenters(costCenters);
        MaterialInfo[] materils = null;
        Object material = this.kDBizPromptMaterial.getData();
        if (material instanceof MaterialInfo) {
            materils = new MaterialInfo[]{(MaterialInfo)material};
        } else if (material instanceof Object[]) {
            materils = new MaterialInfo[((Object[])material).length];
            System.arraycopy(material, 0, materils, 0, ((Object[])material).length);
        }
        _filterParam.setMaterials(materils);
        CostObjectInfo[] costObjects = null;
        Object costObject = this.kDBizPromptCostObject.getData();
        if (costObject instanceof CostObjectInfo) {
            costObjects = new CostObjectInfo[]{(CostObjectInfo)costObject};
        } else if (costObject instanceof Object[]) {
            costObjects = new CostObjectInfo[((Object[])costObject).length];
            System.arraycopy(costObject, 0, costObjects, 0, ((Object[])costObject).length);
        }
        _filterParam.setCostObject(costObjects);
    }

    public KDBizPromptBox getCompanyF7() {
        return this.kDBizPromptCompany;
    }

    public void clear() {
        super.clear();
        this.kDBizPromptCostObject.setValue(null);
        this.kDBizPromptCostCenter.setValue(null);
        this.kDBizPromptMaterial.setValue(null);
        try {
            CompanyOrgUnitInfo company = this.getCompanyOrgInfoWithDefault();
            PeriodInfo period = NCMUtils.GetCurrentPeriod(null, (String)company.getId().toString());
            this.initCompanyAndPeriod(company, period);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        super.registerF7();
        this.f7ContextManager.registerCostCenterF7(this.kDBizPromptCostCenter, new CostCenterType[]{CostCenterType.DirectProdDept});
        this.f7ContextManager.registerMaterialF7(this.kDBizPromptMaterial);
        this.f7ContextManager.registerCostObjectF7(this.kDBizPromptCostObject, false);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.kDBizPromptCostCenter.setData(null);
                this.kDBizPromptMaterial.setData(null);
                this.kDBizPromptCostObject.setData(null);
                PeriodInfo period = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
                this.initPeriod(period);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

