/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.SproducetsBillFactory;
import com.kingdee.eas.ncm.bill.SproducetsBillInfo;
import com.kingdee.eas.ncm.bill.SproducetsEntryBillInfo;
import com.kingdee.eas.ncm.bill.client.AbstractSproducetsBillEditUI;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.ICMBillBase;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SproducetsBillEditUI
extends AbstractSproducetsBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SproducetsBillEditUI.class);
    private static final String TB_OUTCOSTCENTER = "outCostCenter";
    private static final String TB_INCOSTCENTER = "inCostCenter";
    private static final String TB_MATERIAL = "material";
    private static final String TB_OUTWAREHOUSER = "outwarehouse";
    private static final String TB_INWAREHOUSER = "inwarehouse";
    private static final String TB_MODEL = "material.model";
    private static final String TB_NAME = "material.name";
    private static final String TB_OUTQTY = "outQty";
    private static final String TB_INQTY = "inQty";
    private static final String TB_COSTOBJECT = "costObject";
    private static final String TB_COSTNAME = "costObject.name";
    private static final String TB_BASEUNIT = "unit";
    private static final String TB_OUTLOCATION = "outlocation";
    private static final String TB_LOT = "lot";
    private static final String TB_INLOCATION = "inlocation";
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.company.getId().toString();
    private SelectorListener prmtSelectorListener;
    KDBizPromptBox outlocationbox = new KDBizPromptBox();
    KDBizPromptBox inlocationbox = new KDBizPromptBox();
    private int precision = 4;
    private static Map costCenterMap = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompany.setValue((Object)this.company);
        this.formatEntryTable();
    }

    protected void setAutoNumberForOrg() throws EASBizException, BOSException {
        this.setAutoNumberForOrg("Storage");
    }

    @Override
    public void loadFields() {
        EventListener[] prmtStorageOrgUnitListners = this.prmtStorageOrgUnit.getListeners(DataChangeListener.class);
        EventListener[] kdtEntriesListners = this.kdtEntries.getListeners(KDTEditListener.class);
        BDCMClientUtils.removeDataChangeListeners((JComponent)this.prmtStorageOrgUnit);
        BDCMClientUtils.removeKDTEditListeners((KDTable)this.kdtEntries);
        super.loadFields();
        BDCMClientUtils.addDataChangeListeners((JComponent)this.prmtStorageOrgUnit, (EventListener[])prmtStorageOrgUnitListners);
        BDCMClientUtils.addKDTEditListeners((KDTable)this.kdtEntries, (EventListener[])kdtEntriesListners);
        this.removeListener();
        try {
            this.initStorageOrgUnitF7();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTraceDown.setVisible(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionTraceDown.setVisible(true);
    }

    protected void addLine(KDTable arg0) {
        super.addLine(arg0);
        NCMClientUtils.changeTableColPrecision((int)this.precision, (KDTable)this.kdtEntries, (String[])new String[]{TB_OUTQTY, TB_INQTY});
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        SproducetsEntryBillInfo sproducetsEntryBillInfo = new SproducetsEntryBillInfo();
        sproducetsEntryBillInfo.setInQty(SysConstant.BIGZERO);
        sproducetsEntryBillInfo.setOutQty(SysConstant.BIGZERO);
        return sproducetsEntryBillInfo;
    }

    protected IObjectValue createNewData() {
        SproducetsBillInfo sproducetsBillInfo = new SproducetsBillInfo();
        sproducetsBillInfo.setBillStatus(BillBaseStatusEnum.ADD);
        sproducetsBillInfo.setBizDate(new Date());
        sproducetsBillInfo.setCompanyOrg(this.company);
        Date newDate = (Date)this.pkBizDate.getValue();
        sproducetsBillInfo.setCalculatePeriod(this.getPeriodByBizDate(newDate, this.company));
        return sproducetsBillInfo;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SproducetsBillFactory.getRemoteInstance();
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.kdtEntries, new String[]{TB_OUTQTY, TB_INQTY});
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        boolean isExistCodingRule = codingRuleManager.isExist((IObjectValue)this.editData, this.companyID);
        if (!isExistCodingRule) {
            BDCMClientUtils.checkIsNull((JComponent)this.txtNumber, (String)this.contNumber.getBoundLabelText());
        }
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"StorageOrgUnit_NotNull"));
            SysUtil.abort();
        }
        if (UIRuleUtil.isNull((Object)this.pkBizDate.getValue())) {
            this.pkBizDate.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.contBizDate.getBoundLabelText()});
        }
    }

    protected void verifySubmit(ActionEvent e) throws Exception {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"StorageOrgUnit_NotNull"));
            SysUtil.abort();
        }
        if (UIRuleUtil.isNull((Object)this.pkBizDate.getValue())) {
            this.pkBizDate.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.contBizDate.getBoundLabelText()});
        }
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object material;
            WarehouseInfo inwarehouseInfo;
            Object inwarehouser;
            Object outwarehouser;
            if (UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_OUTCOSTCENTER).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"OutCostCenter_NotNull"));
                SysUtil.abort();
            }
            if (UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_INCOSTCENTER).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"InCostCenter_NotNull"));
                SysUtil.abort();
            }
            if (UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_MATERIAL).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"Material_NotNull"));
                SysUtil.abort();
            }
            if (UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_BASEUNIT).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"Unit_NotNull"));
                SysUtil.abort();
            }
            if (UIRuleUtil.getIntValue((Object)this.kdtEntries.getRow(i).getCell(TB_OUTQTY).getValue()) <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"OutQty_NotNull"));
                SysUtil.abort();
            }
            if (UIRuleUtil.getIntValue((Object)this.kdtEntries.getRow(i).getCell(TB_INQTY).getValue()) <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"InQty_NotNull"));
                SysUtil.abort();
            }
            if (UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_OUTWAREHOUSER).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"OutWarehouse_NotNull"));
                SysUtil.abort();
            }
            if (UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_INWAREHOUSER).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"InWarehouse_NotNull"));
                SysUtil.abort();
            }
            if ((outwarehouser = this.kdtEntries.getRow(i).getCell(TB_OUTWAREHOUSER).getValue()) == null) continue;
            WarehouseInfo outwarehouseInfo = (WarehouseInfo)outwarehouser;
            if (outwarehouseInfo.isHasLocation() && UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_OUTLOCATION).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"OutLocation_NotNull"));
                SysUtil.abort();
            }
            if ((inwarehouser = this.kdtEntries.getRow(i).getCell(TB_INWAREHOUSER).getValue()) != null && (inwarehouseInfo = (WarehouseInfo)inwarehouser).isHasLocation() && UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_INLOCATION).getValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"InLocation_NotNull"));
                SysUtil.abort();
            }
            if ((material = this.kdtEntries.getRow(i).getCell(TB_MATERIAL).getValue()) != null) {
                MaterialInfo materialInfo = (MaterialInfo)material;
                if (this.isLotNumber((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue(), materialInfo) && UIRuleUtil.isNull((Object)this.kdtEntries.getRow(i).getCell(TB_LOT).getValue())) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"LOT_NotNull"));
                    SysUtil.abort();
                }
            }
            CostCenterOrgUnitInfo outCostInfo = (CostCenterOrgUnitInfo)this.kdtEntries.getRow(i).getCell(TB_OUTCOSTCENTER).getValue();
            CostCenterOrgUnitInfo inCostInfo = (CostCenterOrgUnitInfo)this.kdtEntries.getRow(i).getCell(TB_INCOSTCENTER).getValue();
            if (!outCostInfo.getId().equals((Object)inCostInfo.getId())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"Line") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"OutCostCenter_InCostCenter_IsEquals")));
            SysUtil.abort();
        }
    }

    private void initStorageOrgUnitF7() throws EASBizException, BOSException {
        BDCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)this.prmtStorageOrgUnit, (String)"isBizUnit", (Object)Boolean.TRUE, (String)this.company.getId().toString(), (String)"id");
        this.prmtSelectorListener = new SelectorListener(){

            public void willShow(SelectorEvent e) {
                int flag;
                if (SproducetsBillEditUI.this.prmtStorageOrgUnit.getValue() != null && ((flag = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"StorageOrgUnit_Update"))) == 1 || flag == 2)) {
                    SysUtil.abort();
                }
            }
        };
        this.prmtStorageOrgUnit.addSelectorListener(this.prmtSelectorListener);
    }

    private void initMaterialF7() throws EASBizException, BOSException {
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        bizMaterialBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MaterialInventoryCompanyForNCMQuery");
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setDisplayFormat("$number$");
        bizMaterialBox.setCommitFormat("$number$");
        bizMaterialBox.setEditable(true);
        bizMaterialBox.setRequired(true);
        this.filterDirectMaterialF7(bizMaterialBox, (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        this.kdtEntries.getColumn(TB_MATERIAL).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMaterialBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(TB_MATERIAL).setRenderer((IBasicRender)avr);
    }

    private void initBaseUnitF7(MaterialInfo info) {
        KDBizPromptBox bizBaseUnitBox = new KDBizPromptBox();
        bizBaseUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizBaseUnitBox.setEditFormat("$name$");
        bizBaseUnitBox.setDisplayFormat("$number$");
        bizBaseUnitBox.setCommitFormat("$number$");
        bizBaseUnitBox.setEditable(true);
        bizBaseUnitBox.setRequired(true);
        this.filterDirectBaseUnitF7(bizBaseUnitBox, info);
        this.kdtEntries.getColumn(TB_BASEUNIT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBaseUnitBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(TB_BASEUNIT).setRenderer((IBasicRender)avr);
    }

    private void initOutWareHouseboxF7() throws EASBizException, BOSException {
        KDBizPromptBox OutwareHousebox = new KDBizPromptBox();
        OutwareHousebox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        OutwareHousebox.setEditFormat("$name$");
        OutwareHousebox.setDisplayFormat("$number$");
        OutwareHousebox.setCommitFormat("$number$");
        OutwareHousebox.setEditable(true);
        OutwareHousebox.setRequired(true);
        this.filterDirectWareHouseF7(OutwareHousebox, (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        this.kdtEntries.getColumn(TB_OUTWAREHOUSER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)OutwareHousebox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(TB_OUTWAREHOUSER).setRenderer((IBasicRender)avr);
    }

    private void initInWareHouseboxF7() throws EASBizException, BOSException {
        KDBizPromptBox InwareHousebox = new KDBizPromptBox();
        InwareHousebox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        InwareHousebox.setEditFormat("$name$");
        InwareHousebox.setDisplayFormat("$number$");
        InwareHousebox.setCommitFormat("$number$");
        InwareHousebox.setEditable(true);
        InwareHousebox.setRequired(true);
        this.filterDirectWareHouseF7(InwareHousebox, (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue());
        this.kdtEntries.getColumn(TB_INWAREHOUSER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)InwareHousebox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(TB_INWAREHOUSER).setRenderer((IBasicRender)avr);
    }

    private void initOutCostCenterboxF7(StorageOrgUnitInfo info) throws EASBizException, BOSException {
        KDBizPromptBox outCostCenterbox = new KDBizPromptBox();
        outCostCenterbox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery");
        outCostCenterbox.setEditFormat("$number$");
        outCostCenterbox.setDisplayFormat("$number$");
        outCostCenterbox.setCommitFormat("$number$");
        outCostCenterbox.setEditable(true);
        outCostCenterbox.setRequired(true);
        this.getCostCenterF7(outCostCenterbox, info);
        this.kdtEntries.getColumn(TB_OUTCOSTCENTER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)outCostCenterbox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(TB_OUTCOSTCENTER).setRenderer((IBasicRender)avr);
    }

    private void initInCostCenterboxF7(StorageOrgUnitInfo info) throws EASBizException, BOSException {
        KDBizPromptBox inCostCenterbox = new KDBizPromptBox();
        inCostCenterbox.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery");
        inCostCenterbox.setEditFormat("$number$");
        inCostCenterbox.setDisplayFormat("$number$");
        inCostCenterbox.setCommitFormat("$number$");
        inCostCenterbox.setEditable(true);
        inCostCenterbox.setRequired(true);
        this.getCostCenterF7(inCostCenterbox, info);
        this.kdtEntries.getColumn(TB_INCOSTCENTER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)inCostCenterbox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(TB_INCOSTCENTER).setRenderer((IBasicRender)avr);
    }

    private void initCostObjectboxF7(StorageOrgUnitInfo info) throws EASBizException, BOSException {
        KDBizPromptBox costObjectbox = new KDBizPromptBox();
        costObjectbox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
        costObjectbox.setEditFormat("name");
        costObjectbox.setDisplayFormat("$number$");
        costObjectbox.setCommitFormat("$name$");
        costObjectbox.setEditable(true);
        costObjectbox.setRequired(true);
        this.filterCostObjectF7(costObjectbox, info);
        this.kdtEntries.getColumn(TB_COSTOBJECT).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)costObjectbox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(TB_COSTOBJECT).setRenderer((IBasicRender)avr);
    }

    private void initOutLocationboxF7() throws EASBizException, BOSException {
        this.outlocationbox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
        this.outlocationbox.setEditFormat("name");
        this.outlocationbox.setDisplayFormat("$number$");
        this.outlocationbox.setCommitFormat("$number$");
        this.outlocationbox.setEditable(true);
        this.outlocationbox.setRequired(true);
        this.outlocationbox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    SproducetsBillEditUI.this.bizBaseUnitBox_willShow(e);
                }
                catch (Exception exc) {
                    SproducetsBillEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.getColumn(TB_OUTLOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.outlocationbox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(TB_OUTLOCATION).setRenderer((IBasicRender)avr);
    }

    private void initInLocationboxF7() throws EASBizException, BOSException {
        this.inlocationbox.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
        this.inlocationbox.setEditFormat("name");
        this.inlocationbox.setDisplayFormat("$number$");
        this.inlocationbox.setCommitFormat("$number$");
        this.inlocationbox.setEditable(true);
        this.inlocationbox.setRequired(true);
        this.inlocationbox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    SproducetsBillEditUI.this.bizBaseUnitBox_willShow(e);
                }
                catch (Exception exc) {
                    SproducetsBillEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.getColumn(TB_INLOCATION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.inlocationbox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(TB_INLOCATION).setRenderer((IBasicRender)avr);
    }

    private void bizBaseUnitBox_willShow(SelectorEvent e) throws EASBizException, BOSException {
        IRow row;
        int rowIndex = this.kdtEntries.getSelectManager().getActiveRowIndex();
        int colIndex = this.kdtEntries.getSelectManager().getActiveColumnIndex();
        if (this.kdtEntries.getColumn(TB_OUTLOCATION).getColumnIndex() == colIndex) {
            row = this.kdtEntries.getRow(rowIndex);
            Object outwareHouse = row.getCell(TB_OUTWAREHOUSER).getValue();
            if (outwareHouse != null) {
                WarehouseInfo outwarehouseInfo = (WarehouseInfo)outwareHouse;
                if (outwarehouseInfo.isHasLocation()) {
                    this.filterLactionF7(this.outlocationbox, outwarehouseInfo);
                } else {
                    row.getCell(TB_OUTLOCATION).getStyleAttributes().setLocked(true);
                }
            } else {
                row.getCell(TB_OUTLOCATION).setValue(null);
            }
        }
        if (this.kdtEntries.getColumn(TB_INLOCATION).getColumnIndex() == colIndex) {
            row = this.kdtEntries.getRow(rowIndex);
            Object inwareHouse = row.getCell(TB_INWAREHOUSER).getValue();
            if (inwareHouse != null) {
                row.getCell(TB_INLOCATION).setValue(null);
                WarehouseInfo inwarehouseInfo = (WarehouseInfo)inwareHouse;
                if (inwarehouseInfo.isHasLocation()) {
                    this.filterLactionF7(this.inlocationbox, inwarehouseInfo);
                } else {
                    row.getCell(TB_INLOCATION).getStyleAttributes().setLocked(true);
                }
            } else {
                row.getCell(TB_INLOCATION).setValue(null);
            }
        }
    }

    private void formatEntryTable() throws EASBizException, BOSException {
        this.kdtEntries.getColumn(TB_COSTOBJECT).setWidth(150);
        this.kdtEntries.getColumn(TB_COSTNAME).setWidth(150);
        this.kdtEntries.getColumn(TB_NAME).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_MODEL).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_COSTNAME).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_OUTLOCATION).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_INLOCATION).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_BASEUNIT).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_LOT).getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn(TB_OUTQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn(TB_INQTY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.initOutCostCenterboxF7(info);
        this.initInCostCenterboxF7(info);
        this.initMaterialF7();
        this.initOutWareHouseboxF7();
        this.initInWareHouseboxF7();
        this.initCostObjectboxF7(info);
        this.initOutLocationboxF7();
        this.initInLocationboxF7();
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            WarehouseInfo inwarehouseInfo;
            WarehouseInfo outwarehouseInfo;
            Object material = this.kdtEntries.getRow(i).getCell(TB_MATERIAL).getValue();
            Object Outwarehouse = this.kdtEntries.getRow(i).getCell(TB_OUTWAREHOUSER).getValue();
            Object Inwarehouse = this.kdtEntries.getRow(i).getCell(TB_INWAREHOUSER).getValue();
            if (material != null) {
                MaterialInfo materialInfo = (MaterialInfo)material;
                this.initBaseUnitF7(materialInfo);
                IMeasureUnit measureUnit = MeasureUnitFactory.getRemoteInstance();
                MeasureUnitInfo measureUnitInfo = measureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
                this.precision = measureUnitInfo.getQtyPrecision();
                NCMClientUtils.changeTableColPrecision((int)this.precision, (KDTable)this.kdtEntries, (String[])new String[]{TB_OUTQTY});
                NCMClientUtils.changeTableColPrecision((int)this.precision, (KDTable)this.kdtEntries, (String[])new String[]{TB_INQTY});
                if (this.isLotNumber((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue(), materialInfo)) {
                    this.kdtEntries.getRow(i).getCell(TB_LOT).getStyleAttributes().setLocked(false);
                }
            } else {
                this.initBaseUnitF7(null);
            }
            if (Outwarehouse != null && (outwarehouseInfo = (WarehouseInfo)Outwarehouse).isHasLocation()) {
                this.kdtEntries.getColumn(TB_OUTLOCATION).getStyleAttributes().setLocked(false);
            }
            if (Inwarehouse != null && (inwarehouseInfo = (WarehouseInfo)Inwarehouse).isHasLocation()) {
                this.kdtEntries.getColumn(TB_INLOCATION).getStyleAttributes().setLocked(false);
            }
            KDTextField tfRemark = new KDTextField();
            tfRemark.setMaxLength(200);
            this.kdtEntries.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)tfRemark));
        }
    }

    @Override
    protected void prmtStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object nValue = e.getNewValue();
        if (nValue == null || nValue.equals(e.getOldValue())) {
            return;
        }
        this.kdtEntries.removeRows();
        this.kdtEntries.addRows(1);
        this.initOutCostCenterboxF7((StorageOrgUnitInfo)nValue);
        this.initInCostCenterboxF7((StorageOrgUnitInfo)nValue);
        this.initMaterialF7();
        this.initOutWareHouseboxF7();
        this.initInWareHouseboxF7();
        this.initCostObjectboxF7((StorageOrgUnitInfo)nValue);
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"EDIT");
    }

    @Override
    public void kdtEntries_editStarted(KDTEditEvent e) throws Exception {
    }

    @Override
    public void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        Object obj;
        IRow row;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtEntries.getColumn(TB_MATERIAL).getColumnIndex() == colIndex) {
            row = this.kdtEntries.getRow(rowIndex);
            Object material = row.getCell(TB_MATERIAL).getValue();
            row.getCell(TB_LOT).setValue(null);
            if (material != null) {
                MaterialInfo materialInfo = (MaterialInfo)material;
                IMeasureUnit measureUnit = MeasureUnitFactory.getRemoteInstance();
                MeasureUnitInfo measureUnitInfo = measureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
                if (this.isLotNumber((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue(), materialInfo)) {
                    row.getCell(TB_LOT).getStyleAttributes().setLocked(false);
                } else {
                    row.getCell(TB_LOT).getStyleAttributes().setLocked(true);
                }
                if (row.getCell(TB_OUTQTY).getValue() != null || row.getCell(TB_INQTY).getValue() != null) {
                    row.getCell(TB_OUTQTY).setValue((Object)SysConstant.BIGZERO);
                    row.getCell(TB_INQTY).setValue((Object)SysConstant.BIGZERO);
                }
                this.precision = measureUnitInfo.getQtyPrecision();
                NCMClientUtils.changeTableColPrecision((int)this.precision, (KDTable)this.kdtEntries, (String[])new String[]{TB_OUTQTY, TB_INQTY});
                this.initBaseUnitF7(materialInfo);
                row.getCell(TB_NAME).setValue((Object)materialInfo.getName());
                row.getCell(TB_MODEL).setValue((Object)materialInfo.getModel());
                row.getCell(TB_BASEUNIT).setValue((Object)measureUnitInfo);
            } else {
                row.getCell(TB_NAME).setValue(null);
                row.getCell(TB_MODEL).setValue(null);
                row.getCell(TB_BASEUNIT).setValue(null);
            }
        }
        if (this.kdtEntries.getColumn(TB_COSTOBJECT).getColumnIndex() == colIndex) {
            row = this.kdtEntries.getRow(rowIndex);
            Object costObject = row.getCell(TB_COSTOBJECT).getValue();
            if (costObject != null) {
                CostObjectInfo costObjectInfo = (CostObjectInfo)costObject;
                row.getCell(TB_COSTNAME).setValue((Object)costObjectInfo.getName());
            } else {
                row.getCell(TB_COSTNAME).setValue(null);
            }
        }
        if (this.kdtEntries.getColumn(TB_OUTWAREHOUSER).getColumnIndex() == colIndex) {
            row = this.kdtEntries.getRow(rowIndex);
            Object outwareHouse = row.getCell(TB_OUTWAREHOUSER).getValue();
            if (outwareHouse != null) {
                row.getCell(TB_OUTLOCATION).setValue(null);
                row.getCell(TB_INLOCATION).setValue(null);
                row.getCell(TB_INWAREHOUSER).setValue(outwareHouse);
                WarehouseInfo outwarehouseInfo = (WarehouseInfo)outwareHouse;
                if (outwarehouseInfo.isHasLocation()) {
                    row.getCell(TB_OUTLOCATION).getStyleAttributes().setLocked(false);
                    row.getCell(TB_INLOCATION).getStyleAttributes().setLocked(false);
                    this.filterLactionF7(this.outlocationbox, outwarehouseInfo);
                } else {
                    row.getCell(TB_OUTLOCATION).getStyleAttributes().setLocked(true);
                    row.getCell(TB_INLOCATION).getStyleAttributes().setLocked(true);
                }
            } else {
                row.getCell(TB_OUTLOCATION).setValue(null);
            }
        }
        if (this.kdtEntries.getColumn(TB_INWAREHOUSER).getColumnIndex() == colIndex) {
            row = this.kdtEntries.getRow(rowIndex);
            Object inwareHouse = row.getCell(TB_INWAREHOUSER).getValue();
            if (inwareHouse != null) {
                row.getCell(TB_INLOCATION).setValue(null);
                WarehouseInfo inwarehouseInfo = (WarehouseInfo)inwareHouse;
                if (inwarehouseInfo.isHasLocation()) {
                    row.getCell(TB_INLOCATION).getStyleAttributes().setLocked(false);
                    this.filterLactionF7(this.inlocationbox, inwarehouseInfo);
                } else {
                    row.getCell(TB_INLOCATION).getStyleAttributes().setLocked(true);
                }
            } else {
                row.getCell(TB_OUTLOCATION).setValue(null);
            }
        }
        if (this.kdtEntries.getColumn(TB_OUTQTY).getColumnIndex() == colIndex && (obj = (row = this.kdtEntries.getRow(rowIndex)).getCell(TB_OUTQTY).getValue()) != null) {
            row.getCell(TB_INQTY).setValue(obj);
        }
    }

    private boolean isLotNumber(StorageOrgUnitInfo orgUnitInfo, MaterialInfo materialInfo) {
        String osql = "SELECT isLotNumber WHERE material.id = '" + materialInfo.getId().toString() + "' and orgUnit.id = '" + orgUnitInfo.getId().toString() + "' ";
        MaterialInventoryInfo inventoryInfo = null;
        try {
            inventoryInfo = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryInfo(osql);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (inventoryInfo == null) {
            return false;
        }
        return inventoryInfo.isIsLotNumber();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.eventEnd();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifySubmit(e);
        super.actionSubmit_actionPerformed(e);
        this.eventEnd();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateFrom_actionPerformed(e);
    }

    public void actionCopyFrom_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyFrom_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionViewSubmitProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSubmitProccess_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendingMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actionViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewSignature_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void auditAction_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntries.getEditManager().stopEditing();
        if (this.editData.getBillStatus() == BillBaseStatusEnum.TEMPORARILYSAVED) {
            String msg = EASResource.getString((String)"com.kingdee.eas.ncm.common.CommonResource.NotAudit");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                this.actionSubmit.actionPerformed(event);
                if (this.actionSubmit.isInvokeFailed()) {
                    SysUtil.abort();
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
        String[] selIDs = new String[1];
        if (this.editData.getId() == null) {
            return;
        }
        selIDs[0] = this.editData.getId().toString();
        ICMBillBase iCMBill = (ICMBillBase)this.getBizInterface();
        try {
            int num = selIDs.length;
            for (int i = 0; i < num; ++i) {
                this.pubFireVOChangeListener(selIDs[i]);
            }
            iCMBill.audit(NCMUtils.convertStringToObjectPK((String[])selIDs));
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"AUDITED_SUCCESS"));
            this.refreshCurPage();
            this.setOprtStateForAUDIT(4);
        }
        catch (EASBizException ex) {
            this.handleException((Exception)((Object)ex));
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
        finally {
            try {
                int num = selIDs.length;
                for (int i = 0; i < num; ++i) {
                    this.pubFireVOChangeListener(selIDs[i]);
                }
            }
            catch (Throwable t) {
                this.handUIException(t);
            }
        }
        this.lockUIForViewStatus();
        this.storeFields();
        super.initOldData((IObjectValue)this.editData);
        this.eventEnd();
    }

    public void unauditAction_actionPerformed(ActionEvent e) throws Exception {
        super.unauditAction_actionPerformed(e);
        this.eventEnd();
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public void filterDirectWareHouseF7(KDBizPromptBox f7, StorageOrgUnitInfo info) throws BOSException, EASBizException {
        if (info != null) {
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"StorageOrgUnit.id", (Object)info.getId().toString());
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"whState", (Object)"1");
        } else {
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"StorageOrgUnit.id", (Object)"0");
        }
    }

    public void filterDirectMaterialF7(KDBizPromptBox f7, StorageOrgUnitInfo info) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)info.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CompanyInfo.status", (Object)"1", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CompanyInfo.calculateType", (Object)"2", CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 ");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"0", CompareType.EQUALS));
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public void filterDirectBaseUnitF7(KDBizPromptBox f7, MaterialInfo info) {
        if (info != null) {
            MaterialClientTools.setF7MeasureUnit((KDBizPromptBox)f7, (String)info.getId().toString());
        } else {
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"id", (Object)"0");
        }
    }

    public void filterLactionF7(KDBizPromptBox f7, WarehouseInfo info) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        f7.getQueryAgent().resetRuntimeEntityView();
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)info.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("TransState", (Object)"1", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)"0", CompareType.EQUALS));
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public void filterCostObjectF7(KDBizPromptBox f7, StorageOrgUnitInfo info) throws BOSException, EASBizException {
        if (info != null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = SproducetsBillEditUI.getCompanyInfo(info.getId());
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"company.id", (Object)companyOrgUnitInfo.getId().toString());
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"relatedType", (Object)"0");
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"isForbiden", (Object)"0");
        } else {
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"id", (Object)"0");
        }
    }

    public void getCostCenterF7(KDBizPromptBox f7, StorageOrgUnitInfo info) throws BOSException, EASBizException {
        if (info != null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = SproducetsBillEditUI.getCompanyInfo(info.getId());
            SproducetsBillEditUI.filterDirectCostCenterF7(f7, companyOrgUnitInfo.getId().toString());
        } else {
            BDCMClientUtils.filterF7((KDBizPromptBox)f7, (String)"id", (Object)"0");
        }
    }

    private static Set getCostCenterSet(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        if (costCenterMap.containsKey(companyOrgID)) {
            Object costCenterSet = costCenterMap.get(companyOrgID);
            if ("".equals(costCenterSet)) {
                return null;
            }
            return (Set)costCenterSet;
        }
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 5);
        int ccSize = ccColl.size();
        if (ccSize != 0) {
            HashSet<String> ccIDSet = new HashSet<String>(ccSize);
            for (int i = 0; i < ccSize; ++i) {
                ccIDSet.add(ccColl.get(i).getId().toString());
            }
            costCenterMap.put(companyOrgID, ccIDSet);
            return ccIDSet;
        }
        costCenterMap.put(companyOrgID, "");
        return null;
    }

    public static void filterDirectCostCenterF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        Set ccIDSet = SproducetsBillEditUI.getCostCenterSet(f7, companyOrgID);
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (ccIDSet != null) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ccIDSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
            filter.mergeFilter(view.getFilter(), "AND");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"0", CompareType.EQUALS));
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static CompanyOrgUnitInfo getCompanyInfo(BOSUuid souId) throws EASBizException, BOSException {
        if (souId == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(souId.toString(), 4, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(souId.toString(), 4, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    private void removeListener() {
        if (this.prmtStorageOrgUnit != null) {
            this.prmtStorageOrgUnit.removeSelectorListener(this.prmtSelectorListener);
        }
    }

    private void eventEnd() {
        if (this.kdtEntries.getRowCount() == 0) {
            this.addLine(this.kdtEntries);
        } else {
            NCMClientUtils.changeTableColPrecision((int)this.precision, (KDTable)this.kdtEntries, (String[])new String[]{TB_OUTQTY, TB_INQTY});
        }
    }
}

