/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.bill.SproducetsBillInfo;
import com.kingdee.eas.ncm.bill.SproducetsBillParam;
import com.kingdee.eas.ncm.bill.client.AbstractSproducetsBillFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class SproducetsBillFilterUI
extends AbstractSproducetsBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(SproducetsBillFilterUI.class);
    private static final String BIZDATE_FROM = "BizDateFrom";
    private static final String BIZDATE_TO = "BizDateTo";
    private static final String BILLNUMBER_IDS = "BillNumberIds";
    private static final String STORAGEORGUNIT_IDS = "StorageOrgUnitIds";
    private static final String COSTCENTER_IDS = "CostCenterIds";
    private static final String MATIERL_IDS = "MaterialIds";
    private CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new SproducetsBillParam();
    }

    private void init() throws EASBizException, BOSException {
        this.initStorageOrgUnit();
        this.initCostCenter();
        this.initBizDateFrom();
        this.initMaterial(null);
    }

    private void initBizDateFrom() {
        GregorianCalendar beginCalendar = new GregorianCalendar();
        beginCalendar.setTimeInMillis(System.currentTimeMillis());
        ((Calendar)beginCalendar).add(2, -1);
        Date date = beginCalendar.getTime();
        this.bizDateFrom.setValue((Object)date);
    }

    private void initStorageOrgUnit() throws EASBizException, BOSException {
        BDCMClientUtils.filterStorageFromCompanyF7((KDBizPromptBox)this.kDBizPromptStorageOrgUnit, (String)"isBizUnit", (Object)Boolean.TRUE, (String)this.company.getId().toString(), (String)"id");
    }

    private void initCostCenter() throws EASBizException, BOSException {
        BDCMClientUtils.filterDirectCostCenterF7((KDBizPromptBox)this.kDBizPromptCostCenter, (String)this.company.getId().toString());
    }

    private void initMaterial(String id) throws EASBizException, BOSException {
        this.filterDirectMaterialF7(this.kDBizPromptMaterial, id);
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof SproducetsBillParam)) {
            return;
        }
        SproducetsBillParam _filterParam = (SproducetsBillParam)filterParam;
        String beginDate = customerParams.getCustomerParam(BIZDATE_FROM);
        if (!StringUtils.isEmpty((String)beginDate)) {
            GregorianCalendar beginCalendar = new GregorianCalendar();
            beginCalendar.setTimeInMillis(Long.parseLong(beginDate));
            _filterParam.setBizDateFrom(beginCalendar.getTime());
        } else {
            _filterParam.setBizDateFrom(null);
        }
        String endDate = customerParams.getCustomerParam(BIZDATE_TO);
        if (!StringUtils.isEmpty((String)endDate)) {
            GregorianCalendar endCalendar = new GregorianCalendar();
            endCalendar.setTimeInMillis(Long.parseLong(endDate));
            _filterParam.setBizDateTo(endCalendar.getTime());
        } else {
            _filterParam.setBizDateTo(null);
        }
        List billNumberIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(BILLNUMBER_IDS)));
        if (billNumberIds != null) {
            _filterParam.setBillNumbers(new SproducetsBillInfo[billNumberIds.size()]);
            String id = null;
            int in = billNumberIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)billNumberIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                _filterParam.getBillNumbers()[i] = new SproducetsBillInfo();
                _filterParam.getBillNumbers()[i].setId(BOSUuid.read((String)id));
            }
        } else {
            _filterParam.setBillNumbers(null);
        }
        List storageOrgUnitIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(STORAGEORGUNIT_IDS)));
        if (storageOrgUnitIds != null) {
            _filterParam.setStorageOrg(new StorageOrgUnitInfo[storageOrgUnitIds.size()]);
            String id = null;
            int in = storageOrgUnitIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)storageOrgUnitIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                _filterParam.getStorageOrg()[i] = new StorageOrgUnitInfo();
                _filterParam.getStorageOrg()[i].setId(BOSUuid.read((String)id));
            }
        } else {
            _filterParam.setStorageOrg(null);
        }
        List costCenterIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(COSTCENTER_IDS)));
        if (costCenterIds != null) {
            _filterParam.setCostCenters(new CostCenterOrgUnitInfo[costCenterIds.size()]);
            String id = null;
            int in = costCenterIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)costCenterIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                _filterParam.getCostCenters()[i] = new CostCenterOrgUnitInfo();
                _filterParam.getCostCenters()[i].setId(BOSUuid.read((String)id));
            }
        } else {
            _filterParam.setCostCenters(null);
        }
        List materialIds = (List)this.getObject(this.decode(customerParams.getCustomerParam(MATIERL_IDS)));
        if (materialIds != null) {
            _filterParam.setMaterials(new MaterialInfo[materialIds.size()]);
            String id = null;
            int in = materialIds.size();
            for (int i = 0; i < in; ++i) {
                id = (String)materialIds.get(i);
                if (StringUtils.isEmpty((String)id)) continue;
                _filterParam.getMaterials()[i] = new MaterialInfo();
                _filterParam.getMaterials()[i].setId(BOSUuid.read((String)id));
            }
        } else {
            _filterParam.setMaterials(null);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof SproducetsBillParam) {
            SproducetsBillParam _filterParam = (SproducetsBillParam)filterParam;
            if (_filterParam.getBizDateFrom() != null) {
                this.bizDateFrom.setValue((Object)_filterParam.getBizDateFrom());
            } else {
                this.bizDateFrom.setValue(null);
            }
            if (_filterParam.getBizDateTo() != null) {
                this.bizDateTo.setValue((Object)_filterParam.getBizDateTo());
            } else {
                this.bizDateTo.setValue(null);
            }
            this.kDBizPromptNumber.setValue((Object)_filterParam.getBillNumbers());
            this.kDBizPromptStorageOrgUnit.setValue((Object)_filterParam.getStorageOrg()[0]);
            this.kDBizPromptCostCenter.setValue((Object)_filterParam.getCostCenters());
            this.kDBizPromptMaterial.setValue((Object)_filterParam.getMaterials());
        }
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof SproducetsBillParam)) {
            return;
        }
        SproducetsBillParam _filterParam = (SproducetsBillParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getBizDateFrom(), BIZDATE_FROM);
        super.putIdByKey(customerParams, (Object)_filterParam.getBizDateTo(), BIZDATE_TO);
        super.putIdByKey(customerParams, (Object)_filterParam.getBillNumbers(), BILLNUMBER_IDS);
        super.putIdByKey(customerParams, (Object)_filterParam.getStorageOrg(), STORAGEORGUNIT_IDS);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostCenters(), COSTCENTER_IDS);
        super.putIdByKey(customerParams, (Object)_filterParam.getMaterials(), MATIERL_IDS);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof SproducetsBillParam)) {
            return;
        }
        SproducetsBillParam _filterParam = (SproducetsBillParam)filterParam;
        Object beginDateObject = this.bizDateFrom.getValue();
        if (beginDateObject instanceof Date) {
            _filterParam.setBizDateFrom((Date)beginDateObject);
        } else {
            _filterParam.setBizDateFrom(null);
        }
        Object endDateObject = this.bizDateTo.getValue();
        if (endDateObject instanceof Date) {
            _filterParam.setBizDateTo((Date)endDateObject);
        } else {
            _filterParam.setBizDateTo(null);
        }
        SproducetsBillInfo[] sproducetsBillInfos = null;
        Object sproducetsBillObject = this.kDBizPromptNumber.getData();
        if (sproducetsBillObject instanceof SproducetsBillInfo) {
            sproducetsBillInfos = new SproducetsBillInfo[]{(SproducetsBillInfo)sproducetsBillObject};
        } else if (sproducetsBillObject instanceof Object[]) {
            sproducetsBillInfos = new SproducetsBillInfo[((Object[])sproducetsBillObject).length];
            System.arraycopy(sproducetsBillObject, 0, sproducetsBillInfos, 0, ((Object[])sproducetsBillObject).length);
        }
        _filterParam.setBillNumbers(sproducetsBillInfos);
        StorageOrgUnitInfo[] storageOrgUnitInfos = null;
        Object storageOrgUnitObject = this.kDBizPromptStorageOrgUnit.getData();
        if (storageOrgUnitObject instanceof StorageOrgUnitInfo) {
            storageOrgUnitInfos = new StorageOrgUnitInfo[]{(StorageOrgUnitInfo)storageOrgUnitObject};
        } else if (storageOrgUnitObject instanceof Object[]) {
            storageOrgUnitInfos = new StorageOrgUnitInfo[((Object[])storageOrgUnitObject).length];
            System.arraycopy(storageOrgUnitObject, 0, storageOrgUnitInfos, 0, ((Object[])storageOrgUnitObject).length);
        }
        _filterParam.setStorageOrg(storageOrgUnitInfos);
        CostCenterOrgUnitInfo[] costCenters = null;
        Object costCenterObject = this.kDBizPromptCostCenter.getData();
        if (costCenterObject instanceof CostCenterOrgUnitInfo) {
            costCenters = new CostCenterOrgUnitInfo[]{(CostCenterOrgUnitInfo)costCenterObject};
        } else if (costCenterObject instanceof Object[]) {
            costCenters = new CostCenterOrgUnitInfo[((Object[])costCenterObject).length];
            System.arraycopy(costCenterObject, 0, costCenters, 0, ((Object[])costCenterObject).length);
        }
        _filterParam.setCostCenters(costCenters);
        MaterialInfo[] materials = null;
        Object material = this.kDBizPromptMaterial.getData();
        if (material instanceof MaterialInfo) {
            materials = new MaterialInfo[]{(MaterialInfo)material};
        } else if (material instanceof Object[]) {
            materials = new MaterialInfo[((Object[])material).length];
            System.arraycopy(material, 0, materials, 0, ((Object[])material).length);
        }
        _filterParam.setMaterials(materials);
    }

    public boolean verify() {
        if (this.kDBizPromptStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)NCMUtils.getMainOrgNullMsg((OrgType)OrgType.Storage));
            this.kDBizPromptStorageOrgUnit.requestFocus();
            return false;
        }
        Calendar c1 = Calendar.getInstance();
        if (this.bizDateFrom.getValue() != null) {
            c1.setTime((Date)this.bizDateFrom.getValue());
        }
        Calendar c2 = Calendar.getInstance();
        if (this.bizDateTo.getValue() != null) {
            c2.setTime((Date)this.bizDateTo.getValue());
        }
        if (!c1.before(c2) && this.bizDateFrom.getValue() != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"StarTime_less_EndTime"));
            return false;
        }
        return true;
    }

    @Override
    protected void kDBizPromptStorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object nValue = e.getNewValue();
        if (nValue == null || nValue.equals(e.getOldValue())) {
            return;
        }
        this.kDBizPromptMaterial.setValue(null);
        this.initMaterial(((StorageOrgUnitInfo)nValue).getId().toString());
    }

    public void filterDirectMaterialF7(KDBizPromptBox f7, String id) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (id != null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)id, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CompanyInfo.status", (Object)"1", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CompanyInfo.calculateType", (Object)"2", CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 ");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"0", CompareType.EQUALS));
        }
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.ncm.bill.SproducetsBillResource", (String)"FILTER");
    }
}

