/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.bill.UnitStandardHourFilterParam;
import com.kingdee.eas.ncm.bill.client.AbstractUnitStandardHourDataFilterUI;
import com.kingdee.eas.ncm.cal.report.client.ReportSpinnerUtil;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class UnitStandardHourDataFilterUI
extends AbstractUnitStandardHourDataFilterUI {
    private static final long serialVersionUID = 2030147379614711010L;
    private static final String COMPANY_ORG_UNIT_ID = "companyId";
    private static final String COST_ORG_UNIT_FROM_ID = "costCenterFromID";
    private static final String COST_ORG_UNIT_TO_ID = "costCenterToID";
    private static final String YEAR_FROM = "yearFrom";
    private static final String YEAR_TO = "yearTo";
    private static final String MONTH_FROM = "monthFrom";
    private static final String MONTH_TO = "monthTo";
    private static final String IS_History = "isHistory";
    CompanyOrgUnitInfo currCompany = null;
    PeriodInfo currPeriod = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.currCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.currPeriod = NCMUtils.GetCurrentPeriod(null, (String)this.currCompany.getId().toString());
        if (this.kDBizPromptCompany.getValue() == null) {
            this.kDBizPromptCompany.setValue((Object)this.currCompany);
        }
        this.kDBizPromptCompany.setEnabled(false);
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterFrom, (String)this.currCompany.getId().toString());
        BDCMClientUtils.filterCostCenterF7((KDBizPromptBox)this.prmtCostCenterTo, (String)this.currCompany.getId().toString());
        try {
            ReportSpinnerUtil.setPeriodRange((CompanyOrgUnitInfo)this.currCompany, (KDSpinner)this.spYearFrom, (KDSpinner)this.spPeriodFrom, (KDSpinner)this.spYearTo, (KDSpinner)this.spPeriodTo, (boolean)true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (!this.kDCBHistory.isSelected()) {
            this.spYearFrom.setEnabled(false);
            this.spYearTo.setEnabled(false);
            this.spPeriodFrom.setEnabled(false);
            this.spPeriodTo.setEnabled(false);
        }
    }

    @Override
    protected void kDCBHistory_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDCBHistory.isSelected()) {
            this.spYearFrom.setEnabled(true);
            this.spYearTo.setEnabled(true);
            this.spPeriodFrom.setEnabled(true);
            this.spPeriodTo.setEnabled(true);
        } else {
            this.spYearFrom.setEnabled(false);
            this.spYearTo.setEnabled(false);
            this.spPeriodFrom.setEnabled(false);
            this.spPeriodTo.setEnabled(false);
            this.spYearFrom.setValue((Object)this.currPeriod.getPeriodYear());
            this.spYearTo.setValue((Object)this.currPeriod.getPeriodYear());
            this.spPeriodFrom.setValue((Object)this.currPeriod.getPeriodNumber());
            this.spPeriodTo.setValue((Object)this.currPeriod.getPeriodNumber());
        }
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new UnitStandardHourFilterParam();
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof UnitStandardHourFilterParam)) {
            return;
        }
        UnitStandardHourFilterParam _filterParam = (UnitStandardHourFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)_filterParam.getCompany(), COMPANY_ORG_UNIT_ID);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostCenterFrom(), COST_ORG_UNIT_FROM_ID);
        super.putIdByKey(customerParams, (Object)_filterParam.getCostCenterTo(), COST_ORG_UNIT_TO_ID);
        customerParams.addCustomerParam(YEAR_FROM, String.valueOf(_filterParam.getYearFrom()));
        customerParams.addCustomerParam(YEAR_TO, String.valueOf(_filterParam.getYearTo()));
        customerParams.addCustomerParam(MONTH_FROM, String.valueOf(_filterParam.getMonthFrom()));
        customerParams.addCustomerParam(MONTH_TO, String.valueOf(_filterParam.getMonthTo()));
        customerParams.addCustomerParam(IS_History, String.valueOf(_filterParam.getIsHistory()));
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof UnitStandardHourFilterParam)) {
            return;
        }
        UnitStandardHourFilterParam _filterParam = (UnitStandardHourFilterParam)filterParam;
        if (this.kDBizPromptCompany.getData() instanceof CompanyOrgUnitInfo) {
            _filterParam.setCompany((CompanyOrgUnitInfo)this.kDBizPromptCompany.getData());
        }
        if (this.prmtCostCenterFrom.getData() instanceof CostCenterOrgUnitInfo) {
            _filterParam.setCostCenterFrom((CostCenterOrgUnitInfo)this.prmtCostCenterFrom.getData());
        }
        if (this.prmtCostCenterTo.getData() instanceof CostCenterOrgUnitInfo) {
            _filterParam.setCostCenterTo((CostCenterOrgUnitInfo)this.prmtCostCenterTo.getData());
        }
        if (this.spYearFrom.getValue() instanceof Integer) {
            _filterParam.setYearFrom((Integer)this.spYearFrom.getValue());
        }
        if (this.spYearTo.getValue() instanceof Integer) {
            _filterParam.setYearTo((Integer)this.spYearTo.getValue());
        }
        if (this.spPeriodFrom.getValue() instanceof Integer) {
            _filterParam.setMonthFrom((Integer)this.spPeriodFrom.getValue());
        }
        if (this.spPeriodTo.getValue() instanceof Integer) {
            _filterParam.setMonthTo((Integer)this.spPeriodTo.getValue());
        }
        _filterParam.setIsHistory(this.kDCBHistory.isSelected());
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof UnitStandardHourFilterParam)) {
            return;
        }
        UnitStandardHourFilterParam _filterParam = (UnitStandardHourFilterParam)filterParam;
        try {
            String isHistory;
            String monthTo;
            String monthFrom;
            String yearTo;
            String companyId = customerParams.getCustomerParam(COMPANY_ORG_UNIT_ID);
            if (!StringUtils.isEmpty((String)companyId)) {
                CompanyOrgUnitInfo companyOrgUnit = new CompanyOrgUnitInfo();
                companyOrgUnit.setId(BOSUuid.read((String)companyId));
                _filterParam.setCompany(companyOrgUnit);
            } else {
                _filterParam.setCompany(null);
            }
            String costCenterFromId = customerParams.getCustomerParam(COST_ORG_UNIT_FROM_ID);
            if (!StringUtils.isEmpty((String)costCenterFromId)) {
                CostCenterOrgUnitInfo costCenterFrom = new CostCenterOrgUnitInfo();
                costCenterFrom.setId(BOSUuid.read((String)costCenterFromId));
                _filterParam.setCostCenterFrom(costCenterFrom);
            } else {
                _filterParam.setCostCenterFrom(null);
            }
            String costCenterToId = customerParams.getCustomerParam(COST_ORG_UNIT_TO_ID);
            if (!StringUtils.isEmpty((String)costCenterToId)) {
                CostCenterOrgUnitInfo costCenterTo = new CostCenterOrgUnitInfo();
                costCenterTo.setId(BOSUuid.read((String)costCenterToId));
                _filterParam.setCostCenterTo(costCenterTo);
            } else {
                _filterParam.setCostCenterTo(null);
            }
            String yearFrom = customerParams.getCustomerParam(YEAR_FROM);
            if (!StringUtils.isEmpty((String)yearFrom)) {
                _filterParam.setYearFrom(Integer.valueOf(yearFrom));
            }
            if (!StringUtils.isEmpty((String)(yearTo = customerParams.getCustomerParam(YEAR_TO)))) {
                _filterParam.setYearTo(Integer.valueOf(yearTo));
            }
            if (!StringUtils.isEmpty((String)(monthFrom = customerParams.getCustomerParam(MONTH_FROM)))) {
                _filterParam.setMonthFrom(Integer.valueOf(monthFrom));
            }
            if (!StringUtils.isEmpty((String)(monthTo = customerParams.getCustomerParam(MONTH_TO)))) {
                _filterParam.setMonthTo(Integer.valueOf(monthTo));
            }
            if (!StringUtils.isEmpty((String)(isHistory = customerParams.getCustomerParam(IS_History)))) {
                _filterParam.setIsHistory(Boolean.valueOf(isHistory));
            } else {
                _filterParam.setIsHistory(Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (filterParam != null && filterParam instanceof UnitStandardHourFilterParam) {
            UnitStandardHourFilterParam _filterParam = (UnitStandardHourFilterParam)filterParam;
            if (_filterParam.getCompany() != null) {
                this.kDBizPromptCompany.setValue((Object)_filterParam.getCompany());
            } else {
                this.kDBizPromptCompany.setValue((Object)this.currCompany);
            }
            if (_filterParam.getCostCenterFrom() != null) {
                this.prmtCostCenterFrom.setValue((Object)_filterParam.getCostCenterFrom());
            } else {
                this.prmtCostCenterFrom.setValue(null);
            }
            if (_filterParam.getCostCenterTo() != null) {
                this.prmtCostCenterTo.setValue((Object)_filterParam.getCostCenterTo());
            } else {
                this.prmtCostCenterTo.setValue(null);
            }
            if (_filterParam.getYearFrom() != null) {
                this.spYearFrom.setValue((Object)_filterParam.getYearFrom());
            }
            if (_filterParam.getYearTo() != null) {
                this.spYearTo.setValue((Object)_filterParam.getYearTo());
            }
            if (_filterParam.getMonthFrom() != null) {
                this.spPeriodFrom.setValue((Object)_filterParam.getMonthFrom());
            }
            if (_filterParam.getMonthTo() != null) {
                this.spPeriodTo.setValue((Object)_filterParam.getMonthTo());
            }
            this.kDCBHistory.setSelected(_filterParam.getIsHistory().booleanValue());
        }
    }

    public boolean verify() {
        return true;
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }
}

