/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.framework.client.DEditClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.IControlModeEditUIProxy;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AllocStdUnitInfo;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.IUserDefinedDataD;
import com.kingdee.eas.ncm.bill.UserDefinedDataDCollection;
import com.kingdee.eas.ncm.bill.UserDefinedDataDFactory;
import com.kingdee.eas.ncm.bill.UserDefinedDataDInfo;
import com.kingdee.eas.ncm.bill.client.AbstractUserDefinedDataDEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class UserDefinedDataDEditUI
extends AbstractUserDefinedDataDEditUI {
    private static final Logger logger = CoreUIObject.getLogger(UserDefinedDataDEditUI.class);
    private static final String TB_ID = "id";
    private static final String TB_Material = "materialNumber";
    private static final String TB_MaterialName = "materialName";
    private static final String TB_MaterialModel = "materialModel";
    private static final String TB_Unit = "measureUnit";
    private static final String TB_StandardQty = "standardQty";
    private static final String TB_Creater = "creater";
    private static final String TB_CreateTime = "createTime";
    private static final String TB_Updater = "lastUpdater";
    private static final String TB_UpdaterTime = "lastUpdateTime";
    private static final String TB_Auditor = "auditor";
    private static final String TB_AuditTime = "auditTime";
    private static final String TB_AuditStatus = "auditStatus";
    private static final String TB_CU = "CU";
    DEditClientControlStrategy cStrategy = new DEditClientControlStrategy((IControlModeEditUIProxy)this);

    public void onLoad() throws Exception {
        this.initIcon();
        this.initBtnStatus();
        this.initAllocStdUnitByCU();
        this.formatTable();
        this.initCtrlListener();
        if ("ADDNEW".equals(this.oprtState)) {
            this.setAddNewCompStatus();
        }
        super.onLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void initBtnStatus() {
        if ("VIEW".equals(this.oprtState)) {
            this.initBtnStatus(false);
        } else {
            this.initBtnStatus(true);
        }
    }

    private void initBtnStatus(boolean status) {
        this.btnAddLine.setEnabled(status);
        this.btnRemoveLine.setEnabled(status);
    }

    private void initIcon() {
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initAllocStdUnitByCU() {
        EntityViewInfo view;
        if (!this.oprtState.equalsIgnoreCase("ADDNEW")) {
            this.prmtAllocStdUnitD.setEnabled(false);
        }
        if ((view = this.prmtAllocStdUnitD.getEntityViewInfo()) == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("allocStdType", (Object)2, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isByCU", (Object)new Boolean(true), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtAllocStdUnitD.setEntityViewInfo(view);
    }

    private void formatTable() {
        this.kDTable.checkParsed();
        IRow row = null;
        for (int i = 0; i < 20; ++i) {
            row = this.kDTable.addRow();
            row.getCell(TB_AuditStatus).setValue((Object)new Boolean(false));
        }
        KDTableHelper.updateEnterWithTab((KDTable)this.kDTable, (boolean)true);
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        bizMaterialBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery");
        bizMaterialBox.setEditFormat("$name$");
        bizMaterialBox.setDisplayFormat("$number$");
        bizMaterialBox.setCommitFormat("$number$");
        bizMaterialBox.setEditable(true);
        bizMaterialBox.setRequired(true);
        CtrlUnitInfo pInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        BDCMClientUtils.filterF7((KDBizPromptBox)bizMaterialBox, (String)"adminCu.id", (Object)pInfo.getId().toString());
        this.kDTable.getColumn(TB_Material).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMaterialBox));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kDTable.getColumn(TB_Material).setRenderer((IBasicRender)avr);
        KDFormattedTextField textField = new KDFormattedTextField(1);
        textField.setNegatived(false);
        textField.setRequired(true);
        textField.setPrecision(10);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)textField);
        this.kDTable.getColumn(TB_StandardQty).setEditor((ICellEditor)editor);
        this.kDTable.getColumn(TB_StandardQty).getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000");
        this.kDTable.getColumn(TB_StandardQty).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void initCtrlListener() {
        this.kDTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    UserDefinedDataDEditUI.this.kDTable_EditChanged(e);
                }
                catch (Exception exc) {
                    UserDefinedDataDEditUI.this.handUIException(exc);
                }
            }
        });
        this.kDTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                UserDefinedDataDEditUI.this.reFreshFooter(e);
            }
        });
        this.prmtAllocStdUnitD.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    UserDefinedDataDEditUI.this.prmtAllocStdUnitD_dataChange();
                }
                catch (Exception exc) {
                    UserDefinedDataDEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void kDTable_EditChanged(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (TB_Material.equalsIgnoreCase(this.kDTable.getColumnKey(colIndex)) && this.kDTable.getColumn(colIndex).getEditor().getComponent() instanceof KDBizPromptBox) {
            this.MaterialDataChanged((KDBizPromptBox)this.kDTable.getColumn(colIndex).getEditor().getComponent());
        }
    }

    private void reFreshFooter(KDTSelectEvent e) {
        if ("ADDNEW".equals(this.oprtState)) {
            return;
        }
        IRow row = this.kDTable.getRow(e.getSelectBlock().getBeginRow());
        ICell tmpCell = row.getCell(TB_Creater);
        this.prmtCreator.setValue(tmpCell.getValue());
        tmpCell = row.getCell(TB_CreateTime);
        this.pkCreateTime.setValue(tmpCell.getValue());
        tmpCell = row.getCell(TB_Updater);
        this.prmtLastUpdateUser.setValue(tmpCell.getValue());
        tmpCell = row.getCell(TB_UpdaterTime);
        this.pkLastUpdateTime.setValue(tmpCell.getValue());
        tmpCell = row.getCell(TB_Auditor);
        this.prmtAuditor.setValue(tmpCell.getValue());
        tmpCell = row.getCell(TB_AuditTime);
        this.pkAuditDate.setValue(tmpCell.getValue());
    }

    protected void MaterialDataChanged(KDBizPromptBox bizMaterialBox) throws Exception {
        KDTSelectBlock ksb = this.kDTable.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        Object[] obj = null;
        if (bizMaterialBox.getValue() instanceof Object[]) {
            obj = (Object[])bizMaterialBox.getValue();
            if (obj.length == 1 && obj[0] instanceof MaterialInfo) {
                this.materialChange((MaterialInfo)obj[0], beginRow);
            } else {
                IRow curRow2 = null;
                MaterialInfo mi = null;
                boolean needInsert = false;
                int insertedRowCount = 0;
                for (int i = 0; i < obj.length; ++i) {
                    if (needInsert) {
                        this.insertRow(beginRow + insertedRowCount);
                        needInsert = false;
                    }
                    if (!(obj[i] instanceof MaterialInfo)) {
                        return;
                    }
                    mi = (MaterialInfo)obj[i];
                    curRow2 = this.kDTable.getRow(beginRow + insertedRowCount);
                    int curCol = this.kDTable.getColumnIndex(TB_Material);
                    curRow2.getCell(curCol).setValue(null);
                    curRow2.getCell(curCol).setValue((Object)mi);
                    try {
                        this.handleMaterialChange(beginRow + insertedRowCount);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    needInsert = true;
                    ++insertedRowCount;
                }
            }
        } else if (bizMaterialBox.getValue() instanceof MaterialInfo) {
            this.materialChange((MaterialInfo)bizMaterialBox.getValue(), beginRow);
        } else if (bizMaterialBox.getValue() == null) {
            this.kDTable.getRow(beginRow).getCell(TB_MaterialName).setValue(null);
            this.kDTable.getRow(beginRow).getCell(TB_MaterialModel).setValue(null);
            this.kDTable.getRow(beginRow).getCell(TB_Unit).setValue(null);
            this.kDTable.getRow(beginRow).getCell(TB_StandardQty).setValue(null);
        }
    }

    private void insertRow(int row) {
        IRow newRow = null;
        newRow = this.kDTable.addRow(row);
        newRow.getCell(TB_AuditStatus).setValue((Object)new Boolean(false));
    }

    private void handleMaterialChange(int rowIndex) throws Exception {
        ICell cell = this.kDTable.getRow(rowIndex).getCell(TB_Material);
        Object value = cell.getValue();
        this.materialChange((MaterialInfo)value, rowIndex);
    }

    private void materialChange(MaterialInfo materialInfo, int rowIndex) throws BOSException, EASBizException {
        if (materialInfo != null) {
            this.kDTable.getRow(rowIndex).getCell(TB_Material).setValue((Object)materialInfo);
            this.kDTable.getRow(rowIndex).getCell(TB_MaterialName).setValue((Object)materialInfo.getName());
            this.kDTable.getRow(rowIndex).getCell(TB_MaterialModel).setValue((Object)materialInfo.getModel());
            this.kDTable.getRow(rowIndex).getCell(TB_StandardQty).setValue((Object)new BigDecimal(0));
            IMeasureUnit im = MeasureUnitFactory.getRemoteInstance();
            if (materialInfo.getBaseUnit() != null) {
                MeasureUnitInfo mUnitInfo = im.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
                this.kDTable.getRow(rowIndex).getCell(TB_Unit).setValue((Object)mUnitInfo);
            }
        } else {
            this.kDTable.getRow(rowIndex).getCell(TB_MaterialName).setValue(null);
            this.kDTable.getRow(rowIndex).getCell(TB_MaterialModel).setValue(null);
            this.kDTable.getRow(rowIndex).getCell(TB_Unit).setValue(null);
        }
    }

    private void prmtAllocStdUnitD_dataChange() {
        if (this.prmtAllocStdUnitD.getData() != null && this.prmtAllocStdUnitD.getData() instanceof AllocStdUnitInfo) {
            AllocStdUnitInfo pInfo = (AllocStdUnitInfo)this.prmtAllocStdUnitD.getData();
            this.txtAllocStdUnitDName.setText(pInfo.getName());
        } else {
            this.txtAllocStdUnitDName.setText(null);
            this.prmtAllocStdUnitD.setData(null);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getUIContext().get("List") == null && this.getServiceContext().get("List") == null) {
            if (this.editData != null && !this.oprtState.equalsIgnoreCase("ADDNEW")) {
                this.setEditBody(this.editData, 0);
                this.prmtCreator.setValue((Object)this.editData.getCreator());
                this.pkCreateTime.setValue((Object)this.editData.getCreateTime());
                this.prmtAuditor.setValue((Object)this.editData.getAuditor());
                this.pkAuditDate.setValue((Object)this.editData.getAuditDate());
                this.prmtLastUpdateUser.setValue((Object)this.editData.getLastUpdateUser());
                this.pkLastUpdateTime.setValue((Object)this.editData.getLastUpdateTime());
                this.prmtAdminCU.setData((Object)this.editData.getAdminCU());
            }
        } else {
            List list = (List)this.getUIContext().get("List");
            int size = list.size();
            if (size > 20) {
                IRow row = null;
                for (int i = 0; i < size - 20; ++i) {
                    row = this.kDTable.addRow();
                }
            }
            try {
                for (int i = 0; i < size; ++i) {
                    ObjectUuidPK pk = null;
                    UserDefinedDataDInfo dInfo = null;
                    pk = new ObjectUuidPK(BOSUuid.read((String)list.get(i).toString()));
                    dInfo = (UserDefinedDataDInfo)this.getValue((IObjectPK)pk);
                    this.setEditBody(dInfo, i);
                    if (i != 0) continue;
                    this.setEditHead(dInfo);
                }
            }
            catch (Exception exc) {
                this.handleException(exc);
            }
        }
    }

    private void setEditBody(UserDefinedDataDInfo dataInfo, int i) {
        this.kDTable.getRow(i).getCell(TB_ID).setValue((Object)dataInfo.getId());
        this.kDTable.getRow(i).getCell(TB_Material).setValue((Object)dataInfo.getMaterial());
        this.kDTable.getRow(i).getCell(TB_MaterialName).setValue((Object)dataInfo.getMaterial().getName());
        this.kDTable.getRow(i).getCell(TB_MaterialModel).setValue((Object)dataInfo.getMaterial().getModel());
        this.kDTable.getRow(i).getCell(TB_Unit).setValue((Object)dataInfo.getUnit());
        this.kDTable.getRow(i).getCell(TB_StandardQty).setValue((Object)dataInfo.getStandardQty());
        this.kDTable.getRow(i).getCell(TB_AuditStatus).setValue((Object)new Boolean(dataInfo.isAuditStatus()));
        this.kDTable.getRow(i).getCell(TB_Creater).setValue((Object)dataInfo.getCreator());
        this.kDTable.getRow(i).getCell(TB_CreateTime).setValue((Object)dataInfo.getCreateTime());
        this.kDTable.getRow(i).getCell(TB_Updater).setValue((Object)dataInfo.getLastUpdateUser());
        this.kDTable.getRow(i).getCell(TB_UpdaterTime).setValue((Object)dataInfo.getLastUpdateTime());
        this.kDTable.getRow(i).getCell(TB_Auditor).setValue((Object)dataInfo.getAuditor());
        this.kDTable.getRow(i).getCell(TB_AuditTime).setValue((Object)dataInfo.getAuditDate());
        this.kDTable.getRow(i).getCell(TB_CU).setValue((Object)dataInfo.getCU());
        if (dataInfo.isAuditStatus()) {
            this.kDTable.getRow(i).getStyleAttributes().setLocked(true);
        }
    }

    private void setEditHead(UserDefinedDataDInfo dataInfo) {
        this.prmtAllocStdUnitD.setValue((Object)dataInfo.getAllocStdUnitD());
        this.txtAllocStdUnitDName.setText(dataInfo.getAllocStdUnitD().getName().toString());
        this.prmtCreator.setValue(null);
        this.pkCreateTime.setValue(null);
        this.prmtLastUpdateUser.setValue(null);
        this.pkLastUpdateTime.setValue(null);
        this.prmtAuditor.setValue(null);
        this.pkAuditDate.setValue(null);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.COPYADDNEW.equals(this.getOprtState())) {
            this.cStrategy.checkCanAdd();
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.cStrategy.checkCanUpdateByAdminCUID(this.editData.getAdminCU().getId().toString());
        }
        this.checkData();
        Object[] fullDatas = this.bpStoreFieldsWithRow();
        List rowNumber = (List)fullDatas[1];
        IObjectCollection dInfoCollection = (IObjectCollection)fullDatas[0];
        if (rowNumber.size() > 0) {
            IUserDefinedDataD iuddd = (IUserDefinedDataD)this.getBizInterface();
            UserDefinedDataDInfo dInfo = null;
            int size = rowNumber.size();
            for (int i = 0; i < size; ++i) {
                dInfo = (UserDefinedDataDInfo)dInfoCollection.getObject(i);
                int actualRowNumber = Long.valueOf(rowNumber.get(i).toString()).intValue();
                this.checkDuplicate(dInfo, actualRowNumber);
                if (dInfo.getId() != null) {
                    iuddd.update((IObjectPK)new ObjectUuidPK(dInfo.getId()), (CoreBaseInfo)dInfo);
                    if (i != size - 1) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"124_UserDefinedDataDEditUI"));
                    continue;
                }
                IObjectPK pk = iuddd.submit((CoreBaseInfo)dInfo);
                this.kDTable.getRow(actualRowNumber).getCell(TB_ID).setValue((Object)pk);
                if (i != size - 1) continue;
                this.showSubmitSuccess();
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private void checkData() throws Exception {
        if (this.prmtAllocStdUnitD.getData() == null) {
            this.prmtAllocStdUnitD.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"125_UserDefinedDataDEditUI"));
            SysUtil.abort();
        }
        boolean exsitData = false;
        if (this.kDTable.getRowCount() > 0) {
            IRow row = null;
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                row = this.kDTable.getRow(i);
                if (row.getCell(TB_Material).getValue() == null && row.getCell(TB_Unit).getValue() == null && row.getCell(TB_StandardQty).getValue() == null) continue;
                if (row.getCell(TB_Material).getValue() == null) {
                    this.kDTable.getSelectManager().select(i, 1);
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"126_UserDefinedDataDEditUI"));
                    SysUtil.abort();
                }
                if (row.getCell(TB_Unit).getValue() == null) {
                    this.kDTable.getSelectManager().select(i, 4);
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"127_UserDefinedDataDEditUI"));
                    SysUtil.abort();
                }
                if (row.getCell(TB_StandardQty).getValue() == null) {
                    this.kDTable.getSelectManager().select(i, 5);
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"128_UserDefinedDataDEditUI"));
                    SysUtil.abort();
                } else {
                    Double d = new Double(row.getCell(TB_StandardQty).getValue().toString());
                    if (d <= 0.0) {
                        this.kDTable.getSelectManager().select(i, 5);
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"129_UserDefinedDataDEditUI"));
                        SysUtil.abort();
                    }
                }
                exsitData = true;
            }
            if (!exsitData) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"130_UserDefinedDataDEditUI"));
                SysUtil.abort();
            }
        }
    }

    private Object[] bpStoreFieldsWithRow() {
        ArrayList<Long> rowNumber = new ArrayList<Long>();
        UserDefinedDataDCollection dInfoCollection = new UserDefinedDataDCollection();
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            if (row.getCell(TB_Material).getValue() == null) continue;
            UserDefinedDataDInfo dInfo = new UserDefinedDataDInfo();
            if (row.getCell(TB_ID).getValue() != null) {
                dInfo.setId(BOSUuid.read((String)row.getCell(TB_ID).getValue().toString()));
            }
            if (row.getCell(TB_Material).getValue() instanceof MaterialInfo) {
                dInfo.setMaterial((MaterialInfo)row.getCell(TB_Material).getValue());
            } else if (row.getCell(TB_Material).getValue() instanceof Object[]) {
                Object[] o = (Object[])row.getCell(TB_Material).getValue();
                dInfo.setMaterial((MaterialInfo)o[0]);
            }
            dInfo.setUnit((MeasureUnitInfo)row.getCell(TB_Unit).getValue());
            dInfo.setAllocStdUnitD((AllocStdUnitInfo)this.prmtAllocStdUnitD.getData());
            if (row.getCell(TB_ID).getValue() == null) {
                dInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                dInfo.setAdminCU(SysContext.getSysContext().getCurrentCtrlUnit());
            } else {
                dInfo.setCU(this.editData.getCU());
                dInfo.setAdminCU(this.editData.getAdminCU());
            }
            if (row.getCell(TB_StandardQty).getValue() != null) {
                dInfo.setStandardQty(new BigDecimal(row.getCell(TB_StandardQty).getValue().toString()));
            } else {
                dInfo.setStandardQty(null);
            }
            dInfoCollection.addObject((IObjectValue)dInfo);
            rowNumber.add(Long.valueOf(i));
        }
        return new Object[]{dInfoCollection, rowNumber};
    }

    private void checkDuplicate(UserDefinedDataDInfo info, int i) throws Exception {
        boolean isexists = ((IUserDefinedDataD)this.getBizInterface()).exsitDataInDB((IObjectValue)info);
        if (isexists) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"146_GLFetchDataEditUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"147_InputQtyImportFilterUI") + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"131_UserDefinedDataDEditUI") + info.getMaterial().getNumber() + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"132_UserDefinedDataDEditUI") + info.getUnit().getName() + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"133_UserDefinedDataDEditUI") + info.getAllocStdUnitD().getName() + EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"134_UserDefinedDataDEditUI")));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanAdd();
        IRow row = this.kDTable.addRow();
        row.setUserObject((Object)this.createNewData());
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int index = this.kDTable.getSelectManager().getActiveRowIndex();
        if (index > -1) {
            if (this.kDTable.getCell(index, TB_ID).getValue() != null) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"135_UserDefinedDataDEditUI")))) {
                    ((IUserDefinedDataD)this.getBizInterface()).delete((IObjectPK)new ObjectUuidPK(this.kDTable.getCell(index, TB_ID).getValue().toString()));
                    this.kDTable.removeRow(index);
                    this.kDTable.addRow();
                }
            } else {
                this.kDTable.removeRow(index);
                this.kDTable.addRow();
            }
        } else {
            AssistantClientUtils.plsSelectRowFirst((Component)((Object)this));
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanAdd();
        this.initBtnStatus(true);
        this.setDataObject(this.createNewData());
        this.btnSubmit.setEnabled(true);
        if (this.kDTable.getRowCount() > 0) {
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                IRow row = this.kDTable.getRow(i);
                if (row.getCell(TB_ID).getValue() == null) continue;
                this.kDTable.removeRow(i);
                this.kDTable.addRow(i);
            }
            this.setAddNewCompStatus();
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.checkModified();
        this.setOprtState("ADDNEW");
        this.unLockUI();
        this.setDefaultFocused();
        this.prmtAllocStdUnitD.setEnabled(true);
    }

    private void setAddNewCompStatus() {
        this.prmtAllocStdUnitD.setValue(null);
        this.txtAllocStdUnitDName.setText("");
        this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        this.pkCreateTime.setValue((Object)new Timestamp(System.currentTimeMillis()));
        this.prmtAuditor.setValue(null);
        this.pkAuditDate.setValue(null);
        this.prmtLastUpdateUser.setValue(null);
        this.pkLastUpdateTime.setValue(null);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkViewToEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkViewToEdit() {
        if (this.kDTable.getRowCount() > 0) {
            IRow row = null;
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                row = this.kDTable.getRow(i);
                if (row.getCell(TB_AuditStatus).getValue() == null || !((Boolean)row.getCell(TB_AuditStatus).getValue()).booleanValue()) continue;
                this.kDTable.getSelectManager().select(i, 6);
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.client.BILLCLIENTAutoGenerateResource", (String)"136_UserDefinedDataDEditUI"));
                SysUtil.abort();
            }
            this.initBtnStatus(true);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("unit.*"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    protected IObjectValue createNewData() {
        UserDefinedDataDInfo userDefinedDataDInfo = new UserDefinedDataDInfo();
        userDefinedDataDInfo.setLastUpdateTime(null);
        userDefinedDataDInfo.setAuditDate(null);
        userDefinedDataDInfo.setCreateTime(null);
        userDefinedDataDInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        userDefinedDataDInfo.setAdminCU(SysContext.getSysContext().getCurrentCtrlUnit());
        userDefinedDataDInfo.setAuditStatus(false);
        return userDefinedDataDInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserDefinedDataDFactory.getRemoteInstance();
    }
}

