/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.WIPCountingBillFilterParam;
import com.kingdee.eas.ncm.bill.client.AbstractWIPCountingBillFilterUI;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.common.NCMIFilterParam;

public class WIPCountingBillFilterUI
extends AbstractWIPCountingBillFilterUI {
    private String Period = "period";
    private String CostCenter = "costCenter";
    private String CostObject = "costObject";

    public WIPCountingBillFilterUI() throws Exception {
    }

    public WIPCountingBillFilterUI(PeriodInfo currentPeriod) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.formatUI();
    }

    public void clear() {
        super.clear();
        this.clearFilterData();
        this.formatUI();
    }

    private void clearFilterData() {
        this.prmtCostCenter.setValue(null);
        this.PrmtCostObject.setValue(null);
    }

    private void formatUI() {
        try {
            this.initCompany(this.getCompanyOrgInfoWithDefault());
            this.initPeriod();
            this.PrmtCostObject.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostObjectQuery");
            CostObjectF7UISelector arg0 = new CostObjectF7UISelector((Object)this, this.PrmtCostObject, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
            this.PrmtCostObject.setSelector((KDPromptSelector)arg0);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new WIPCountingBillFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof WIPCountingBillFilterParam)) {
            return;
        }
        WIPCountingBillFilterParam fp = (WIPCountingBillFilterParam)filterParam;
        PeriodInfo period = null;
        String sPeriod = customerParams.getCustomerParam(this.Period);
        if (sPeriod != null && sPeriod.length() > 0) {
            period = new PeriodInfo();
            period.setId(BOSUuid.read((String)sPeriod));
        }
        fp.setPeriod(period);
        CostCenterOrgUnitInfo cc = null;
        String sCostCenterData = customerParams.getCustomerParam(this.CostCenter);
        if (sCostCenterData != null && sCostCenterData.length() > 0) {
            cc = new CostCenterOrgUnitInfo();
            cc.setId(BOSUuid.read((String)sCostCenterData));
        }
        fp.setCostCenter(cc);
        CostObjectInfo cb = null;
        String sCostObjectData = customerParams.getCustomerParam(this.CostObject);
        if (sCostObjectData != null && sCostObjectData.length() > 0) {
            cb = new CostObjectInfo();
            cb.setId(BOSUuid.read((String)sCostObjectData));
        }
        fp.setCostObject(cb);
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof WIPCountingBillFilterParam)) {
            return;
        }
        WIPCountingBillFilterParam fp = (WIPCountingBillFilterParam)filterParam;
        PeriodInfo period = fp.getPeriod();
        if (period != null && !period.isLoaded() && period.getId().toString().trim().length() > 0) {
            try {
                period = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.PrmtPeriod.setData((Object)period);
        this.prmtCostCenter.setData((Object)fp.getCostCenter());
        this.PrmtCostObject.setData((Object)fp.getCostObject());
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof WIPCountingBillFilterParam)) {
            return;
        }
        WIPCountingBillFilterParam fp = (WIPCountingBillFilterParam)filterParam;
        super.putIdByKey(customerParams, (Object)fp.getPeriod(), this.Period);
        super.putIdByKey(customerParams, (Object)fp.getCostCenter(), this.CostCenter);
        super.putIdByKey(customerParams, (Object)fp.getCostObject(), this.CostObject);
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof WIPCountingBillFilterParam)) {
            return;
        }
        WIPCountingBillFilterParam fp = (WIPCountingBillFilterParam)filterParam;
        Object temp = null;
        PeriodInfo period = null;
        temp = this.PrmtPeriod.getData();
        if (temp != null && temp instanceof PeriodInfo) {
            period = (PeriodInfo)temp;
        }
        fp.setPeriod(period);
        CostCenterOrgUnitInfo cc = null;
        temp = this.prmtCostCenter.getData();
        if (temp != null && temp instanceof CostCenterOrgUnitInfo) {
            cc = (CostCenterOrgUnitInfo)temp;
        }
        fp.setCostCenter(cc);
        CostObjectInfo cb = null;
        temp = this.PrmtCostObject.getData();
        if (temp != null && temp instanceof CostObjectInfo) {
            cb = (CostObjectInfo)temp;
        }
        fp.setCostObject(cb);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        return filterInfo;
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenter, new CostCenterType[]{CostCenterType.DirectProdDept});
        this.f7ContextManager.registerCostObjectF7(this.PrmtCostObject, false);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.initPeriod();
                this.prmtCostCenter.setData(null);
                this.PrmtCostObject.setData(null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void initCompany(CompanyOrgUnitInfo companyOrg) {
        this.prmtCompany.setValue((Object)companyOrg);
    }

    private void initPeriod() throws EASBizException, BOSException {
        if (this.prmtCompany.getData() != null) {
            this.PrmtPeriod.setData(null);
            CalculateUtil.setDefaultPeriod((CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtCompany.getData()), (KDBizPromptBox)this.PrmtPeriod);
        }
    }
}

