/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.client.CostObjectF7UISelector;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.ncm.bill.WIPCountingMaterialFilterParam;
import com.kingdee.eas.ncm.bill.client.AbstractWIPCountingMaterialFilterUI;
import com.kingdee.eas.ncm.common.NCMIFilterParam;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import org.apache.log4j.Logger;

public class WIPCountingMaterialFilterUI
extends AbstractWIPCountingMaterialFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(WIPCountingMaterialFilterUI.class);
    private static final String CPKEY_PERIOD_FROM = "periodFrom";
    private static final String CPKEY_PERIOD_TO = "periodTo";
    private static final String CPKEY_CC_FROM = "costCenterFrom";
    private static final String CPKEY_CC_TO = "costCenterTo";
    private static final String CPKEY_MAT_FROM = "materialFrom";
    private static final String CPKEY_MAT_TO = "materialTo";
    private static final String CPKEY_CO_FROM = "costObjectFrom";
    private static final String CPKEY_CO_TO = "costObjectTo";
    private static final String CPKEY_COS_FROM = "costObjectSuiteFrom";
    private static final String CPKEY_COS_TO = "costObjectSuiteTo";
    private static final String CPKEY_CI_FROM = "costItemFrom";
    private static final String CPKEY_CI_TO = "costItemTo";
    private static final String CPKEY_HISTORY = "history";
    private PeriodInfo currentPeriod = null;
    private PeriodInfo startPeriod = null;
    private ArrayList periods = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComponent();
        this.initPeriod(false, null, null);
        this.initCBHistory();
    }

    private void initComponent() throws EASBizException, BOSException {
        this.prmtCompany.setValue((Object)this.getCompanyOrgInfoWithDefault());
        this.prmtMaterialFrom.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        this.prmtMaterialFrom.setDisplayFormat("$name$");
        this.prmtMaterialFrom.setEditFormat("$number$");
        this.prmtMaterialFrom.setCommitFormat("$number$");
        this.prmtMaterialTo.setQueryInfo("com.kingdee.eas.basedata.ncm.app.MaterialF7TreeQuery");
        this.prmtMaterialTo.setDisplayFormat("$name$");
        this.prmtMaterialTo.setEditFormat("$number$");
        this.prmtMaterialTo.setCommitFormat("$number$");
        this.prmtCostObjectFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
        this.prmtCostObjectFrom.setDisplayFormat("$name$");
        this.prmtCostObjectFrom.setEditFormat("$number$");
        this.prmtCostObjectFrom.setCommitFormat("$number$");
        CostObjectF7UISelector selector = new CostObjectF7UISelector((Object)this, this.prmtCostObjectFrom, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObjectFrom.setSelector((KDPromptSelector)selector);
        this.prmtCostObjectTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CostObjectQuery");
        this.prmtCostObjectTo.setDisplayFormat("$name$");
        this.prmtCostObjectTo.setEditFormat("$number$");
        this.prmtCostObjectTo.setCommitFormat("$number$");
        CostObjectF7UISelector selectorTo = new CostObjectF7UISelector((Object)this, this.prmtCostObjectTo, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, this.getCompanyOrgInfoWithDefault().getId().toString());
        this.prmtCostObjectTo.setSelector((KDPromptSelector)selectorTo);
        this.prmtCostObjectSuiteFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.F7CostObjectSuiteQuery");
        this.prmtCostObjectSuiteFrom.setDisplayFormat("$name$");
        this.prmtCostObjectSuiteFrom.setEditFormat("$number$");
        this.prmtCostObjectSuiteFrom.setCommitFormat("$number$");
        this.prmtCostObjectSuiteTo.setQueryInfo("com.kingdee.eas.basedata.assistant.F7CostObjectSuiteQuery");
        this.prmtCostObjectSuiteTo.setDisplayFormat("$name$");
        this.prmtCostObjectSuiteTo.setEditFormat("$number$");
        this.prmtCostObjectSuiteTo.setCommitFormat("$number$");
        this.prmtCostItemFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        this.prmtCostItemFrom.setDisplayFormat("$name$");
        this.prmtCostItemFrom.setEditFormat("$number$");
        this.prmtCostItemFrom.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)"1"));
        this.prmtCostItemFrom.setEntityViewInfo(evi);
        this.prmtCostItemTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        this.prmtCostItemTo.setDisplayFormat("$name$");
        this.prmtCostItemTo.setEditFormat("$number$");
        this.prmtCostItemTo.setCommitFormat("$number$");
        evi = new EntityViewInfo();
        filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)"1"));
        this.prmtCostItemTo.setEntityViewInfo(evi);
    }

    private void initPeriod(boolean history, String periodFrom, String periodTo) {
        ArrayList<String> periods = null;
        PeriodInfo currentPeriod = this.getCurrentPeriod();
        PeriodInfo startPeriod = this.getStartPeriod();
        if (!history) {
            periods = new ArrayList<String>();
            periods.add(String.valueOf(currentPeriod.getNumber()));
        } else if (startPeriod.getNumber() == currentPeriod.getNumber()) {
            periods = new ArrayList<String>();
            periods.add(String.valueOf(currentPeriod.getNumber()));
            history = false;
        } else {
            periods = this.getPeriods();
        }
        SpinnerListModel dataModelFrom = new SpinnerListModel(periods);
        this.spPeriodFrom.setModel((SpinnerModel)dataModelFrom);
        if (periodFrom != null && periodFrom.length() > 0 && periods.contains(periodFrom)) {
            this.spPeriodFrom.setValue((Object)periodFrom);
        } else {
            this.spPeriodFrom.setValue(periods.get(periods.size() - 1));
        }
        SpinnerListModel dataModelTo = new SpinnerListModel(periods);
        this.spPeriodTo.setModel((SpinnerModel)dataModelTo);
        if (periodTo != null && periodTo.length() > 0 && periods.contains(periodTo)) {
            this.spPeriodTo.setValue((Object)periodTo);
        } else {
            this.spPeriodTo.setValue(periods.get(periods.size() - 1));
        }
        this.kDCBHistory.setSelected(history);
        this.spPeriodFrom.setEnabled(history);
        this.spPeriodTo.setEnabled(history);
    }

    private void initCBHistory() {
        this.kDCBHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WIPCountingMaterialFilterUI.this.initPeriod(WIPCountingMaterialFilterUI.this.kDCBHistory.isSelected(), null, null);
            }
        });
    }

    private PeriodInfo getCurrentPeriod() {
        if (this.currentPeriod != null) {
            return this.currentPeriod;
        }
        try {
            this.currentPeriod = NCMUtils.GetCurrentPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.currentPeriod;
    }

    private PeriodInfo getStartPeriod() {
        if (this.startPeriod != null) {
            return this.startPeriod;
        }
        try {
            this.startPeriod = NCMUtils.GetStartPeriod(null, (String)this.getCompanyOrgInfoWithDefault().getId().toString());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.startPeriod;
    }

    private ArrayList getPeriods() {
        if (this.periods != null) {
            return this.periods;
        }
        this.periods = new ArrayList();
        PeriodInfo startPeriod = this.getStartPeriod();
        PeriodInfo currentPeriod = this.getCurrentPeriod();
        if (startPeriod.getNumber() == currentPeriod.getNumber()) {
            return this.periods;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)this.getCompanyOrgInfoWithDefault().getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)String.valueOf(startPeriod.getNumber()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)String.valueOf(currentPeriod.getNumber()), CompareType.LESS));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        evi.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        evi.setSorter(sorter);
        try {
            PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(evi);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                this.periods.add(String.valueOf(((PeriodInfo)it.next()).getNumber()));
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return this.periods;
    }

    protected NCMIFilterParam createNewFilterParam() {
        return new WIPCountingMaterialFilterParam();
    }

    protected void loadBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        if (customerParams == null || filterParam == null || !(filterParam instanceof WIPCountingMaterialFilterParam)) {
            return;
        }
        WIPCountingMaterialFilterParam fp = (WIPCountingMaterialFilterParam)filterParam;
        String periodFrom = customerParams.getCustomerParam(CPKEY_PERIOD_FROM);
        String periodTo = customerParams.getCustomerParam(CPKEY_PERIOD_FROM);
        CostCenterOrgUnitInfo costCenterFrom = null;
        String costCenterIDFrom = customerParams.getCustomerParam(CPKEY_CC_FROM);
        if (costCenterIDFrom != null && costCenterIDFrom.length() > 0) {
            costCenterFrom = new CostCenterOrgUnitInfo();
            costCenterFrom.setId(BOSUuid.read((String)costCenterIDFrom));
        }
        CostCenterOrgUnitInfo costCenterTo = null;
        String costCenterIDTo = customerParams.getCustomerParam(CPKEY_CC_TO);
        if (costCenterIDTo != null && costCenterIDTo.length() > 0) {
            costCenterTo = new CostCenterOrgUnitInfo();
            costCenterTo.setId(BOSUuid.read((String)costCenterIDTo));
        }
        MaterialInfo materialFrom = null;
        String materialIDFrom = customerParams.getCustomerParam(CPKEY_MAT_FROM);
        if (materialIDFrom != null && materialIDFrom.length() > 0) {
            materialFrom = new MaterialInfo();
            materialFrom.setId(BOSUuid.read((String)materialIDFrom));
        }
        MaterialInfo materialTo = null;
        String materialIDTo = customerParams.getCustomerParam(CPKEY_MAT_TO);
        if (materialIDTo != null && materialIDTo.length() > 0) {
            materialTo = new MaterialInfo();
            materialTo.setId(BOSUuid.read((String)materialIDTo));
        }
        CostObjectInfo costObjectFrom = null;
        String costObjectIDFrom = customerParams.getCustomerParam(CPKEY_CO_FROM);
        if (costObjectIDFrom != null && costObjectIDFrom.length() > 0) {
            costObjectFrom = new CostObjectInfo();
            costObjectFrom.setId(BOSUuid.read((String)costObjectIDFrom));
        }
        CostObjectInfo costObjectTo = null;
        String costObjectIDTo = customerParams.getCustomerParam(CPKEY_CO_TO);
        if (costObjectIDTo != null && costObjectIDTo.length() > 0) {
            costObjectTo = new CostObjectInfo();
            costObjectTo.setId(BOSUuid.read((String)costObjectIDTo));
        }
        CostObjectSuiteInfo costObjectSuiteFrom = null;
        String costObjectSuiteIDFrom = customerParams.getCustomerParam(CPKEY_COS_FROM);
        if (costObjectSuiteIDFrom != null && costObjectSuiteIDFrom.length() > 0) {
            costObjectSuiteFrom = new CostObjectSuiteInfo();
            costObjectSuiteFrom.setId(BOSUuid.read((String)costObjectSuiteIDFrom));
        }
        CostObjectSuiteInfo costObjectSuiteTo = null;
        String costObjectSuiteIDTo = customerParams.getCustomerParam(CPKEY_COS_TO);
        if (costObjectSuiteIDTo != null && costObjectSuiteIDTo.length() > 0) {
            costObjectSuiteTo = new CostObjectSuiteInfo();
            costObjectSuiteTo.setId(BOSUuid.read((String)costObjectSuiteIDTo));
        }
        CostItemInfo costItemFrom = null;
        String costItemIDFrom = customerParams.getCustomerParam(CPKEY_CI_FROM);
        if (costItemIDFrom != null && costItemIDFrom.length() > 0) {
            costItemFrom = new CostItemInfo();
            costItemFrom.setId(BOSUuid.read((String)costItemIDFrom));
        }
        CostItemInfo costItemTo = null;
        String costItemIDTo = customerParams.getCustomerParam(CPKEY_CI_TO);
        if (costItemIDTo != null && costItemIDTo.length() > 0) {
            costItemTo = new CostItemInfo();
            costItemTo.setId(BOSUuid.read((String)costItemIDTo));
        }
        fp.setPeriodFrom(periodFrom);
        fp.setPeriodTo(periodTo);
        fp.setCostCenterFrom(costCenterFrom);
        fp.setCostCenterTo(costCenterTo);
        fp.setMaterialFrom(materialFrom);
        fp.setMaterialTo(materialTo);
        fp.setCostObjectFrom(costObjectFrom);
        fp.setCostObjectTo(costObjectTo);
        fp.setCostObjectSuiteFrom(costObjectSuiteFrom);
        fp.setCostObjectSuiteTo(costObjectSuiteTo);
        fp.setCostItemFrom(costItemFrom);
        fp.setCostItemTo(costItemTo);
        String history = customerParams.getCustomerParam(CPKEY_HISTORY);
        if ("true".equals(history)) {
            fp.setHistory("true");
        } else {
            fp.setHistory("false");
        }
    }

    protected void loadFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof WIPCountingMaterialFilterParam)) {
            return;
        }
        WIPCountingMaterialFilterParam fp = (WIPCountingMaterialFilterParam)filterParam;
        this.initPeriod("true".equals(fp.getHistory()), fp.getPeriodFrom(), fp.getPeriodTo());
        this.prmtCostCenterFrom.setData((Object)fp.getCostCenterFrom());
        this.prmtCostCenterTo.setData((Object)fp.getCostCenterTo());
        this.prmtMaterialFrom.setData((Object)fp.getMaterialFrom());
        this.prmtMaterialTo.setData((Object)fp.getMaterialTo());
        this.prmtCostObjectFrom.setData((Object)fp.getCostObjectFrom());
        this.prmtCostObjectTo.setData((Object)fp.getCostObjectTo());
        this.prmtCostObjectSuiteFrom.setData((Object)fp.getCostObjectSuiteFrom());
        this.prmtCostObjectSuiteTo.setData((Object)fp.getCostObjectSuiteTo());
        this.prmtCostItemFrom.setData((Object)fp.getCostItemFrom());
        this.prmtCostItemTo.setData((Object)fp.getCostItemTo());
    }

    protected void storeFilterParam(NCMIFilterParam filterParam) {
        if (!(filterParam instanceof WIPCountingMaterialFilterParam)) {
            return;
        }
        WIPCountingMaterialFilterParam fp = (WIPCountingMaterialFilterParam)filterParam;
        if (this.kDCBHistory.isSelected()) {
            fp.setHistory("true");
        } else {
            fp.setHistory("false");
        }
    }

    protected void storeBaseCustomerParams(CustomerParams customerParams, NCMIFilterParam filterParam) {
        String history = "false";
        if (this.kDCBHistory.isSelected()) {
            history = "true";
        }
        this.putIdByKey(customerParams, history, CPKEY_HISTORY);
        if ("true".equals(history)) {
            this.putIdByKey(customerParams, this.spPeriodFrom.getValue(), CPKEY_PERIOD_FROM);
            this.putIdByKey(customerParams, this.spPeriodFrom.getValue(), CPKEY_PERIOD_TO);
        } else {
            this.putIdByKey(customerParams, null, CPKEY_PERIOD_FROM);
            this.putIdByKey(customerParams, null, CPKEY_PERIOD_TO);
        }
        this.putIdByKey(customerParams, this.prmtCostCenterFrom.getValue(), CPKEY_CC_FROM);
        this.putIdByKey(customerParams, this.prmtCostCenterTo.getValue(), CPKEY_CC_TO);
        this.putIdByKey(customerParams, this.prmtMaterialFrom.getValue(), CPKEY_MAT_FROM);
        this.putIdByKey(customerParams, this.prmtMaterialTo.getValue(), CPKEY_MAT_TO);
        this.putIdByKey(customerParams, this.prmtCostObjectFrom.getValue(), CPKEY_CO_FROM);
        this.putIdByKey(customerParams, this.prmtCostObjectTo.getValue(), CPKEY_CO_TO);
        this.putIdByKey(customerParams, this.prmtCostObjectSuiteFrom.getValue(), CPKEY_COS_FROM);
        this.putIdByKey(customerParams, this.prmtCostObjectSuiteTo.getValue(), CPKEY_COS_TO);
        this.putIdByKey(customerParams, this.prmtCostItemFrom.getValue(), CPKEY_CI_FROM);
        this.putIdByKey(customerParams, this.prmtCostItemTo.getValue(), CPKEY_CI_TO);
    }

    public WIPCountingMaterialFilterParam getFilterParam() {
        WIPCountingMaterialFilterParam filterParam = (WIPCountingMaterialFilterParam)this.createNewFilterParam();
        this.storeFilterParam((NCMIFilterParam)filterParam);
        return filterParam;
    }

    public void clear() {
        super.clear();
        this.initPeriod(false, null, null);
        this.prmtCostCenterFrom.setData(null);
        this.prmtCostCenterTo.setData(null);
        this.prmtMaterialFrom.setData(null);
        this.prmtMaterialTo.setData(null);
        this.prmtCostObjectFrom.setData(null);
        this.prmtCostObjectTo.setData(null);
        this.prmtCostObjectSuiteFrom.setData(null);
        this.prmtCostObjectSuiteTo.setData(null);
        this.prmtCostItemFrom.setData(null);
        this.prmtCostItemTo.setData(null);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        CompanyOrgUnitInfo companyOrg = null;
        Object value = this.prmtCompany.getValue();
        if (value != null && value instanceof CompanyOrgUnitInfo) {
            companyOrg = (CompanyOrgUnitInfo)value;
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)companyOrg.getId().toString(), CompareType.EQUALS));
        }
        CostCenterOrgUnitInfo costCenterFrom = null;
        CostCenterOrgUnitInfo costCenterTo = null;
        value = this.prmtCostCenterFrom.getValue();
        if (value != null && value instanceof CostCenterOrgUnitInfo) {
            costCenterFrom = (CostCenterOrgUnitInfo)value;
        }
        if ((value = this.prmtCostCenterTo.getValue()) != null && value instanceof CostCenterOrgUnitInfo) {
            costCenterTo = (CostCenterOrgUnitInfo)value;
        }
        if (costCenterFrom != null && costCenterTo != null && costCenterFrom.getNumber().equals(costCenterTo.getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("costCenter.number", (Object)costCenterFrom.getNumber(), CompareType.EQUALS));
        } else {
            if (costCenterFrom != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("costCenter.number", (Object)costCenterFrom.getNumber(), CompareType.GREATER_EQUALS));
            }
            if (costCenterTo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("costCenter.number", (Object)costCenterTo.getNumber(), CompareType.LESS_EQUALS));
            }
        }
        MaterialInfo materialFrom = null;
        MaterialInfo materialTo = null;
        value = this.prmtMaterialFrom.getValue();
        if (value != null && value instanceof MaterialInfo) {
            materialFrom = (MaterialInfo)value;
        }
        if ((value = this.prmtMaterialTo.getValue()) != null && value instanceof MaterialInfo) {
            materialTo = (MaterialInfo)value;
        }
        if (materialFrom != null && materialTo != null && materialFrom.getNumber().equals(materialTo.getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialFrom.getNumber(), CompareType.EQUALS));
        } else {
            if (materialFrom != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialFrom.getNumber(), CompareType.GREATER_EQUALS));
            }
            if (materialTo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialTo.getNumber(), CompareType.LESS_EQUALS));
            }
        }
        CostObjectInfo costObjectFrom = null;
        CostObjectInfo costObjectTo = null;
        value = this.prmtCostObjectFrom.getValue();
        if (value != null && value instanceof CostObjectInfo) {
            costObjectFrom = (CostObjectInfo)value;
        }
        if ((value = this.prmtCostObjectTo.getValue()) != null && value instanceof CostObjectInfo) {
            costObjectTo = (CostObjectInfo)value;
        }
        if (costObjectFrom != null && costObjectTo != null && costObjectFrom.getNumber().equals(costObjectTo.getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)costObjectFrom.getNumber(), CompareType.EQUALS));
        } else {
            if (costObjectFrom != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)costObjectFrom.getNumber(), CompareType.GREATER_EQUALS));
            }
            if (costObjectTo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)costObjectTo.getNumber(), CompareType.LESS_EQUALS));
            }
        }
        CostObjectSuiteInfo costObjectSuiteFrom = null;
        CostObjectSuiteInfo costObjectSuiteTo = null;
        value = this.prmtCostObjectSuiteFrom.getValue();
        if (value != null && value instanceof CostObjectSuiteInfo) {
            costObjectSuiteFrom = (CostObjectSuiteInfo)value;
        }
        if ((value = this.prmtCostObjectSuiteTo.getValue()) != null && value instanceof CostObjectSuiteInfo) {
            costObjectSuiteTo = (CostObjectSuiteInfo)value;
        }
        if (costObjectSuiteFrom != null && costObjectSuiteTo != null && costObjectSuiteFrom.getNumber().equals(costObjectSuiteTo.getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)costObjectSuiteFrom.getNumber(), CompareType.EQUALS));
        } else {
            if (costObjectSuiteFrom != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)costObjectSuiteFrom.getNumber(), CompareType.GREATER_EQUALS));
            }
            if (costObjectSuiteTo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("costObject.number", (Object)costObjectSuiteTo.getNumber(), CompareType.LESS_EQUALS));
            }
        }
        CostItemInfo costItemFrom = null;
        CostItemInfo costItemTo = null;
        value = this.prmtCostItemFrom.getValue();
        if (value != null && value instanceof CostItemInfo) {
            costItemFrom = (CostItemInfo)value;
        }
        if ((value = this.prmtCostItemTo.getValue()) != null && value instanceof CostItemInfo) {
            costItemTo = (CostItemInfo)value;
        }
        if (costItemFrom != null && costItemTo != null && costItemFrom.getNumber().equals(costItemTo.getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("costItem.number", (Object)costItemFrom.getNumber(), CompareType.EQUALS));
        } else {
            if (costItemFrom != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("costItem.number", (Object)costItemFrom.getNumber(), CompareType.GREATER_EQUALS));
            }
            if (costItemTo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("costItem.number", (Object)costItemTo.getNumber(), CompareType.LESS_EQUALS));
            }
        }
        if (this.kDCBHistory.isSelected()) {
            String periodFrom = null;
            String periodTo = null;
            value = this.spPeriodFrom.getValue();
            if (value != null && value instanceof String) {
                periodFrom = (String)value;
            }
            if ((value = this.spPeriodTo.getValue()) != null && value instanceof String) {
                periodTo = (String)value;
            }
            if (periodFrom != null && periodTo != null && periodFrom.equals(periodTo)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.EQUALS));
            } else {
                if (periodFrom != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodFrom, CompareType.GREATER_EQUALS));
                }
                if (periodTo != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)periodTo, CompareType.LESS_EQUALS));
                }
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("calculatePeriod.number", (Object)String.valueOf(this.getCurrentPeriod().getNumber()), CompareType.EQUALS));
        }
        return filterInfo;
    }

    public KDBizPromptBox getCompanyF7() {
        return this.prmtCompany;
    }

    public boolean isEnableMultiOrgSupport() {
        return true;
    }

    protected void registerF7() throws Exception {
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterFrom, new CostCenterType[]{CostCenterType.DirectProdDept});
        this.f7ContextManager.registerCostCenterF7(this.prmtCostCenterTo, new CostCenterType[]{CostCenterType.DirectProdDept});
        this.f7ContextManager.registerMaterialF7(this.prmtMaterialFrom);
        this.prmtMaterialFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialFrom, this.prmtMaterialFrom.getEntityViewInfo() == null ? null : this.prmtMaterialFrom.getEntityViewInfo().getFilter());
        this.f7ContextManager.registerMaterialF7(this.prmtMaterialTo);
        this.prmtMaterialTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialTo, this.prmtMaterialTo.getEntityViewInfo() == null ? null : this.prmtMaterialTo.getEntityViewInfo().getFilter());
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectFrom, true);
        this.f7ContextManager.registerCostObjectF7(this.prmtCostObjectTo, true);
        this.f7ContextManager.registerCostObjectSuiteF7(this.prmtCostObjectSuiteFrom);
        this.f7ContextManager.registerCostObjectSuiteF7(this.prmtCostObjectSuiteTo);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            try {
                this.prmtCostCenterFrom.setData(null);
                this.prmtCostCenterTo.setData(null);
                this.prmtMaterialFrom.setData(null);
                this.prmtMaterialTo.setData(null);
                this.prmtCostObjectFrom.setData(null);
                this.prmtCostObjectTo.setData(null);
                this.prmtCostObjectSuiteFrom.setData(null);
                this.prmtCostObjectSuiteTo.setData(null);
                this.currentPeriod = null;
                this.getCurrentPeriod();
                this.startPeriod = null;
                this.getStartPeriod();
                this.initPeriod(false, null, null);
                this.prmtMaterialFrom = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialFrom, this.prmtMaterialFrom.getEntityViewInfo() == null ? null : this.prmtMaterialFrom.getEntityViewInfo().getFilter());
                this.prmtMaterialTo = NCMUtils.materialTreeDisplay((Object)((Object)this), (KDBizPromptBox)this.prmtMaterialTo, this.prmtMaterialTo.getEntityViewInfo() == null ? null : this.prmtMaterialTo.getEntityViewInfo().getFilter());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

