/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.client.BDCMClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.cal.AccountClosingFacadeFactory;
import com.kingdee.eas.ncm.cal.IAccountClosingFacade;
import com.kingdee.eas.ncm.cal.client.AbstractAccountClosingUI;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.client.NCMClientUtils;
import com.kingdee.eas.ncm.common.utils.client.OrgUnitClientUtils;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class AccountClosingUI
extends AbstractAccountClosingUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountClosingUI.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.ncm.bill.BillResource";
    private static final String opertPermItemName = "";
    private Context mainOrgContext;
    private UserInfo curUser;
    private IAccountClosingFacade periodEndCtrl;
    private int iSuccess = 0;
    private String permissionItem_Close = "AccountClosing_close";
    private String permissionItem_UnClose = "AccountClosing_anticlose";
    private volatile boolean isRunning = false;
    private Uuid mutexUuid = null;
    private String txtUnClose = "\u53cd\u7ed3\u8d26\u5c06\u4ece\u5f53\u524d\u671f\u95f4\u8fd4\u56de\u4e0a\u4e00\u671f\u95f4\uff0c\u5c06\u5220\u9664\u672c\u671f\u8d39\u7528\u5206\u914d\u548c\u6210\u672c\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\uff0c\u518d\u6b21\u7ed3\u8d26\u540e\u9700\u8981\u91cd\u65b0\u8ba1\u7b97\u6210\u672c\uff0c\u8bf7\u614e\u91cd\u5904\u7406\uff01\u662f\u5426\u786e\u5b9a\u8fdb\u884c\u53cd\u7ed3\u8d26\u5904\u7406\uff1f";
    private String txtClose = "\u6267\u884c\u7ed3\u8d26\u529f\u80fd\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u5c06\u672c\u671f\u5728\u4ea7\u6210\u672c\u4f59\u989d\u7ed3\u8f6c\u5230\u4e0b\u671f\u671f\u521d\uff0c\u540c\u65f6\u5c06\u5206\u914d\u6807\u51c6\u8bbe\u7f6e\u3001\u7ea6\u5f53\u7cfb\u6570\u3001\u81ea\u5b9a\u4e49\u5206\u914d\u6807\u51c6\u6570\u636e\u7b49\u81ea\u52a8\u7ed3\u8f6c\u5230\u4e0b\u671f\uff0c\u5e76\u66f4\u65b0\u671f\u95f4\u8bbe\u7f6e\uff0c\u7ed3\u8d26\u524d\u671f\u95f4\u7684\u4e1a\u52a1\u5355\u636e\u5c06\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002";

    public AccountClosingUI() throws Exception {
        BDCMClientUtils.checkLoginCompanyOrgIsVirtual();
        NCMClientUtils.checkIsStart();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kdlblPic.setIcon(EASResource.getIcon((String)"imgGuide_pic260"));
        this.prmtCompanyOrg.setLabelVisible(true);
        this.prmtCompanyOrg.setEnabled(true);
        this.kDTextArea1.setEditable(false);
        this.kDTextArea1.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
    }

    public boolean destroyWindow() {
        if (this.getCompanyOrg() != null) {
            this.releaseMutex(this.getCompanyOrg());
        }
        return super.destroyWindow();
    }

    public void requestMutex(CompanyOrgUnitInfo company) {
        try {
            MutexParameter mutexParam = new MutexParameter();
            this.mutexUuid = Uuid.create();
            mutexParam.setRequestId(this.mutexUuid);
            mutexParam.setMutexName("d3T+lgEaEADgAAobwKgRj53UGuM=" + company.getId().toString());
            mutexParam.setActionName(EASResource.getString((String)"com.kingdee.eas.ncm.cal.task.CostCloseResource", (String)"COST_CLOSE"));
            mutexParam.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
            mutexParam.setOrgUnitID(company.getId());
            mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
            mutexParam.setDcName(SysContext.getSysContext().getDcName());
            IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
            boolean ok = mutex.requestMutex(mutexParam);
            if (!ok) {
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
            SysUtil.abort();
        }
    }

    public void releaseMutex(CompanyOrgUnitInfo company) {
        try {
            if (this.mutexUuid != null) {
                IMutexServiceControl mutex = MutexServiceControlFactory.getRemoteInstance();
                mutex.releaseMutex(this.mutexUuid);
                this.mutexUuid = null;
            }
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    protected boolean checkBeforeWindowClosing() {
        return !this.isRunning;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.ChangePermissionItem();
        this.prmtCompanyOrg.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        this.curUser = SysContext.getSysContext().getCurrentUserInfo();
    }

    private void ChangePermissionItem() {
        if (this.rbUnClosePeriod.isSelected()) {
            OrgUnitClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company, (String[])new String[]{this.permissionItem_UnClose});
            this.kDTextArea2.setText(this.txtUnClose);
        } else if (this.rbClosePeriod.isSelected()) {
            OrgUnitClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtCompanyOrg, (OrgType)OrgType.Company, (String[])new String[]{this.permissionItem_Close});
            this.kDTextArea2.setText(this.txtClose);
        }
    }

    @Override
    public void prmtCompanyOrg_dataChanged(DataChangeEvent e) {
        try {
            CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getValue();
            if (curCompany != null && this.getCurrPeriod() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CalResource.COMPANY_PERIOD_ISNULL"));
                this.kDTextArea1.setText(opertPermItemName);
                SysUtil.abort();
            }
            if (this.getCurrPeriod() != null) {
                this.kDTextArea1.setText(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"0_AccountClosingUI") + this.getCurrPeriod().getNumber());
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private void startClosingThread() throws Exception {
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrg();
        if (companyOrg == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CalResource.COMPANY_PERIOD_ISNULL"));
            SysUtil.abort();
        }
        BDCMClientUtils.checkIsNull((JComponent)this.prmtCompanyOrg, (String)this.kDLabelContainer1.getBoundLabelText());
        if (this.getCurrPeriod() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CalResource.COMPANY_PERIOD_ISNULL"));
            this.kDTextArea1.setText(opertPermItemName);
            SysUtil.abort();
        }
        this.requestMutex(companyOrg);
        try {
            if (this.rbUnClosePeriod.isSelected()) {
                this.checkForAntiClosing();
            } else if (this.rbClosePeriod.isSelected() && NCMUtils.isMustCalCost(null, (String)companyOrg.getId().toString())) {
                this.checkForClosing();
            }
        }
        catch (AbortException e) {
            this.releaseMutex(companyOrg);
            throw e;
        }
        if (this.iSuccess == 0) {
            this.runClosingThread();
        } else {
            this.destroyWindow();
        }
    }

    private void checkForClosing() throws BOSException, EASBizException {
        if (!this.getBizInterface().isCal(this.getCompanyOrg().getId().toString(), this.getCurrPeriod().getId().toString())) {
            MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"1_AccountClosingUI") + this.getCompanyOrg().getName() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"2_AccountClosingUI") + this.getCurrPeriod().getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"18_AccountClosingUI") + this.getCurrPeriod().getPeriodNumber() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"3_AccountClosingUI")));
            this.destroyWindow();
            SysUtil.abort();
        }
    }

    private void checkForAntiClosing() throws BOSException, EASBizException {
        int answer;
        int checkFlag;
        Object checkStatus;
        if (SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, this.getCompanyOrg().getId().toString()).equals((Object)SystemStatusCtrolFactory.getRemoteInstance().getStartPeriod(1001, this.getCompanyOrg().getId().toString()))) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"AntiAccountClosingPeriodTip"));
            this.destroyWindow();
            SysUtil.abort();
        }
        if ((checkStatus = this.getBizInterface().checkInitBalanceAdjust(this.getCompanyOrg().getId().toString(), this.getCurrPeriod().getId().toString())) instanceof List) {
            List voucherNumberSet = (List)checkStatus;
            StringBuffer numbers = new StringBuffer();
            int size = voucherNumberSet.size();
            for (int i = 0; i < size; ++i) {
                numbers.append(voucherNumberSet.get(i)).append("\u3001");
            }
            numbers.setLength(numbers.length() - 1);
            MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"1_AccountClosingUI") + this.getCompanyOrg().getName() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"4_AccountClosingUI") + this.getCurrPeriod().getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"18_AccountClosingUI") + this.getCurrPeriod().getPeriodNumber() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"5_AccountClosingUI") + numbers.toString() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"6_AccountClosingUI")));
            this.destroyWindow();
            SysUtil.abort();
        }
        if ((checkFlag = ((Integer)checkStatus).intValue()) == -1) {
            MsgBox.showError((String)NCMClientUtils.getNcmBillResource((String)"ExistAuditInitBalanceAdjust"));
            SysUtil.abort();
        } else if (checkFlag == 1 && (2 == (answer = MsgBox.showConfirm2((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"ExistNotAuditInitBalanceAdjust"))) || 1 == answer)) {
            SysUtil.abort();
        }
        answer = MsgBox.showConfirm2((Component)((Object)this), (String)NCMClientUtils.getNcmBillResource((String)"AntiAccountClosingDataTip"));
        if (2 == answer || 1 == answer) {
            SysUtil.abort();
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.startClosingThread();
    }

    @Override
    public void actionOK2_actionPerformed(ActionEvent e) throws Exception {
        this.startClosingThread();
    }

    @Override
    public void actionYearOk_actionPerformed(ActionEvent e) throws Exception {
        this.startClosingThread();
    }

    @Override
    public void actionYearOk2_actionPerformed(ActionEvent e) throws Exception {
        this.startClosingThread();
    }

    @Override
    protected void rbClosePeriod_actionPerformed(ActionEvent e) throws Exception {
        this.btnOK2.setVisible(false);
        this.btnOK.setVisible(true);
        this.btnOK.setEnabled(true);
        this.btnyearOK.setVisible(false);
        this.btnyearOK2.setVisible(false);
        this.ChangePermissionItem();
    }

    @Override
    protected void rbUnClosePeriod_actionPerformed(ActionEvent e) throws Exception {
        this.btnOK.setVisible(false);
        this.btnOK2.setVisible(true);
        this.btnOK2.setEnabled(true);
        this.ChangePermissionItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAccountClosing() throws Exception {
        this.isRunning = true;
        this.btnOK.setEnabled(false);
        this.btnOK2.setEnabled(false);
        this.setCursorOfWair();
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        ComponentUtil.setWindowsCursorOfWair((Window)window);
        LowTimer st = new LowTimer();
        long endTime = 0L;
        String getcalcHMSString = opertPermItemName;
        try {
            this.kDProgressBar1.setIndeterminate(true);
            boolean isClose = this.rbClosePeriod.isSelected();
            this.closingORantiClosing(isClose, true);
            this.setCloseFinishTips(isClose);
        }
        finally {
            this.setCursorOfDefault();
            ComponentUtil.setWindowCursorOfDefault((Window)window);
            this.kDProgressBar1.setIndeterminate(false);
            this.kDProgressBar1.setValue(this.kDProgressBar1.getMaximum());
            this.kDProgressBar1.setStringPainted(true);
            String costTime = EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CalResource", (String)"COSTIME");
            endTime = st.msValue();
            getcalcHMSString = NCMUtils.getcalcHMSString((int)((int)endTime));
            this.kDProgressBar1.setString(costTime + getcalcHMSString);
            this.isRunning = false;
        }
        this.setBtnOKOK();
    }

    private void closingORantiClosing(boolean isClose, boolean isMonth) throws Exception {
        if (isClose) {
            this.getBizInterface().doMonth(this.getCompanyOrg().getId().toString(), this.getCurrPeriod().getId().toString(), this.curUser.getId().toString());
        } else {
            this.getBizInterface().unDoMonth(this.getCompanyOrg().getId().toString(), this.getCurrPeriod().getId().toString(), this.curUser.getId().toString());
        }
    }

    protected IAccountClosingFacade getBizInterface() throws BOSException {
        this.periodEndCtrl = AccountClosingFacadeFactory.getRemoteInstance();
        return this.periodEndCtrl;
    }

    private void setBtnOKOK() {
        this.iSuccess = 1;
        this.btnOK.setEnabled(false);
        this.btnOK2.setEnabled(false);
        this.btnyearOK.setEnabled(false);
        this.btnyearOK2.setEnabled(false);
        this.rbClosePeriod.setEnabled(false);
        this.rbUnClosePeriod.setEnabled(false);
    }

    private void setDefault() {
        this.rbClosePeriod.setEnabled(true);
        this.rbUnClosePeriod.setEnabled(true);
        this.btnOK.setText(EASResource.getString((String)RESOURCE_PATH, (String)"btnOKFinish"));
        this.btnOK2.setText(EASResource.getString((String)RESOURCE_PATH, (String)"btnOKFinish"));
    }

    protected OrgUnitInfo getBizOrgUnitInfo() {
        OrgType orgType = OrgType.Company;
        this.mainOrgContext = new Context();
        this.getUIContext().put(orgType, SysContext.getSysContext().getCurrentOrgUnit(orgType));
        OrgUnitInfo org = SysContext.getSysContext().getCurrentOrgUnit(orgType);
        if (org != null && org.getId() != null) {
            this.initUIMainOrgContext(org.getId().toString());
        }
        return OrgUnitClientUtils.getBizOrgUnitInfo((String)opertPermItemName, (OrgType)orgType, (Context)this.mainOrgContext);
    }

    private void setCloseFinishTips(boolean isClose) throws Exception {
        PeriodInfo info = this.getCurrPeriod();
        int nextPeriodNumber = 0;
        int lastPeriodNumber = 0;
        int nextPeriodYear = 0;
        int lastPeriodYear = 0;
        String message = opertPermItemName;
        if (this.getCurrPeriod().getPeriodNumber() == 1) {
            lastPeriodNumber = 12;
            lastPeriodYear = this.getCurrPeriod().getPeriodYear() - 1;
        } else {
            lastPeriodNumber = this.getCurrPeriod().getPeriodNumber() - 1;
            lastPeriodYear = this.getCurrPeriod().getPeriodYear();
        }
        message = lastPeriodYear + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"7_AccountClosingUI") + lastPeriodNumber + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"8_AccountClosingUI") + info.getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"7_AccountClosingUI") + info.getPeriodNumber();
        if (isClose) {
            message = message + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"9_AccountClosingUI") + info.getNumber();
        } else {
            if (this.getCurrPeriod().getPeriodNumber() == 12) {
                nextPeriodNumber = 1;
                nextPeriodYear = this.getCurrPeriod().getPeriodYear() + 1;
            } else {
                nextPeriodNumber = this.getCurrPeriod().getPeriodNumber() + 1;
                nextPeriodYear = this.getCurrPeriod().getPeriodYear();
            }
            message = nextPeriodYear + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"7_AccountClosingUI") + nextPeriodNumber + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"8_AccountClosingUI") + info.getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"7_AccountClosingUI") + info.getPeriodNumber();
            message = message + EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"10_AccountClosingUI") + info.getNumber();
        }
        this.kDTextArea1.setText(message);
    }

    protected void runClosingThread() throws Exception {
        RunClosingThread runClosingThread = new RunClosingThread();
        runClosingThread.start();
        Date nowEnd = new Date();
        logger.debug((Object)("RunClosingThread end at : " + nowEnd));
    }

    private CompanyOrgUnitInfo getCompanyOrg() {
        CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)this.prmtCompanyOrg.getValue();
        return companyOrg;
    }

    private PeriodInfo getCurrPeriod() {
        PeriodInfo currPeriod = null;
        CompanyOrgUnitInfo companyOrg = this.getCompanyOrg();
        if (companyOrg == null) {
            return null;
        }
        try {
            currPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1001, this.getCompanyOrg().getId().toString());
            if (currPeriod != null) {
                this.kDTextArea1.setText(EASResource.getString((String)"com.kingdee.eas.ncm.cal.client.CALCLIENTAutoGenerateResource", (String)"0_AccountClosingUI") + currPeriod.getNumber());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return currPeriod;
    }

    class RunClosingThread
    extends SwingWorker {
        public Object construct() {
            try {
                AccountClosingUI.this.doAccountClosing();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                AccountClosingUI.this.handUIException((Throwable)new BOSException(NCMUtils.getNcmCheckResource((String)"CostCheckErrReason"), (Throwable)ex));
            }
            return null;
        }
    }
}

