/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.cal.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.cal.client.AbstractCostCalBaseUI;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.ncm.common.task.CostTaskCollection;
import com.kingdee.eas.ncm.common.task.CostTaskFactory;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.client.CostTaskClientUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class CostCalBaseUI
extends AbstractCostCalBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(CostCalBaseUI.class);
    private FilterInfo permissionFilter = null;
    protected CompanyOrgUnitInfo company = null;
    protected ProgressAdapter progressAdapter = new ProgressAdapter();

    public void onLoad() throws Exception {
        super.onLoad();
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        this.prmtCompany.setFilterInfoProducer(this.getPermissionProducer());
        this.prmtCompany.setEnabledMultiSelection(true);
        this.prmtCompany.setDisplayFormat("$name$");
        this.prmtCompany.setEditFormat("$number$");
        this.prmtCompany.setCommitFormat("$number$");
        this.prmtCompany.setValue((Object)this.company);
        this.lbProcessing.setForeground(new Color(26, 163, 27));
    }

    public void onShow() throws Exception {
        super.onShow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CostCalBaseUI.this.loadCurrentTasks();
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        });
    }

    protected List getSelectedCompanys() {
        ArrayList<Object> companys = new ArrayList<Object>();
        Object value = this.prmtCompany.getValue();
        if (value == null) {
            return companys;
        }
        if (value instanceof CompanyOrgUnitInfo) {
            companys.add(value);
            return companys;
        }
        if (value instanceof Object[]) {
            Object[] objs = (Object[])value;
            for (int i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof CompanyOrgUnitInfo)) continue;
                companys.add(objs[i]);
            }
        }
        return companys;
    }

    protected Set getSelectedCompanyIds() {
        HashSet<String> ids = new HashSet<String>();
        List companys = this.getSelectedCompanys();
        for (int i = 0; i < companys.size(); ++i) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companys.get(i);
            ids.add(company.getId().toString());
        }
        return ids;
    }

    protected String getCostTaskNumber() {
        return null;
    }

    private void loadCurrentTasks() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.getCostTaskNumber()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)9, CompareType.NOTEQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("company.id");
        selector.add("company.name");
        selector.add("period.id");
        selector.add("status");
        view.setSelector(selector);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("createTime"));
        view.setSorter(sorter);
        CostTaskCollection costTasks = CostTaskFactory.getRemoteInstance().getCostTaskCollection(view);
        this.lbProcessing.setText("\u6b63\u5728\u8fd0\u884c\u4efb\u52a1(" + costTasks.size() + ")");
        this.spCostTasks.setViewportView(null);
        Box boxContent = Box.createVerticalBox();
        for (int i = 0; i < costTasks.size(); ++i) {
            Box box = this.buildCostTaskItemUI(costTasks.get(i));
            boxContent.add(box);
            boxContent.add(Box.createVerticalStrut(4));
        }
        boxContent.add(Box.createVerticalGlue());
        this.spCostTasks.setViewportView((Component)boxContent);
    }

    private Box buildCostTaskItemUI(CostTaskInfo costTask) {
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        KDLabel lbCompany = new KDLabel(" " + costTask.getCompany().getName() + " ");
        lbCompany.setForeground(Color.RED);
        Font oldFont = lbCompany.getFont();
        Font font = new Font(oldFont.getName(), 1, 12);
        lbCompany.setFont(font);
        box.add((Component)lbCompany);
        KDLabel lbTask = new KDLabel(costTask.getName());
        box.add((Component)lbTask);
        box.add(Box.createHorizontalStrut(5));
        KDLabel lbBeing = 1 == costTask.getStatus().getValue() ? new KDLabel("\u6b63\u5728\u6392\u961f... ") : new KDLabel("\u6b63\u5728\u8fdb\u884c... ");
        box.add((Component)lbBeing);
        box.add(Box.createHorizontalGlue());
        KDLabelContainer lbProgress = new KDLabelContainer();
        lbProgress.setBoundLabelUnderline(true);
        lbProgress.setBoundLabelText("\u67e5\u770b\u8fdb\u5ea6...");
        lbProgress.getBoundLabel().putClientProperty("costTask", costTask);
        lbProgress.getBoundLabel().setForeground(Color.BLUE);
        lbProgress.setUnderlineColor(Color.BLUE);
        lbProgress.setCursor(new Cursor(12));
        lbProgress.getBoundLabel().addMouseListener(this.progressAdapter);
        lbProgress.setMaximumSize(new Dimension(400, 19));
        box.add((Component)lbProgress);
        return box;
    }

    public FilterInfo getPermissionFilter() throws EASBizException, BOSException {
        return this.getPermissionProducer().getFilterInfo();
    }

    public IFilterInfoProducer getPermissionProducer() throws EASBizException, BOSException {
        String permissionItem = this.getPermissionItem();
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, permissionItem);
        iProducer.getModel().setShowVirtual(false);
        return iProducer;
    }

    public String getPermissionItem() throws EASBizException, BOSException {
        MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
        return NCMCommonFacadeFactory.getRemoteInstance().getUIPermissiionItem(this.getMetaDataPK(), (IMetaDataPK)actionPK);
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    class ProgressAdapter
    extends MouseAdapter {
        ProgressAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            KDLabel source = (KDLabel)e.getSource();
            CostTaskInfo costTask = (CostTaskInfo)source.getClientProperty((Object)"costTask");
            if (costTask != null) {
                try {
                    CostTaskClientUtils.showProgress((CostTaskInfo)costTask, (CoreUIObject)CostCalBaseUI.this, (boolean)false);
                }
                catch (Exception exc) {
                    CostCalBaseUI.this.handUIException(exc);
                }
            }
        }
    }
}

